/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.jndi.ThreadLocalMap;
import weblogic.management.remote.common.InvocationContextProxyHandler;
import weblogic.management.remote.common.RMIConnectionWrapper;

class RMIServerWrapper
implements RMIServer {
    private RMIServer rmiServer;
    private Subject subject;
    private Locale locale;
    private final List<WeakReference<RMIConnectionWrapper>> connectionReferenceList = new ArrayList<WeakReference<RMIConnectionWrapper>>();
    private Hashtable<String, Object> env;
    private ComponentInvocationContext cic;

    public RMIServerWrapper(RMIServer rmiServer, Subject subject, Hashtable<String, Object> env, Locale locale) {
        this(rmiServer, subject, env, locale, null);
    }

    public RMIServerWrapper(RMIServer rmiServer, Subject subject, Hashtable<String, Object> env, Locale locale, ComponentInvocationContext cic) {
        this.rmiServer = rmiServer;
        this.subject = subject;
        this.env = env;
        this.locale = locale;
        this.cic = cic;
    }

    @Override
    public String getVersion() throws RemoteException {
        return this.rmiServer.getVersion();
    }

    Iterable<RMIConnectionWrapper> getConnections() {
        ArrayList<RMIConnectionWrapper> connections = new ArrayList<RMIConnectionWrapper>();
        for (WeakReference<RMIConnectionWrapper> reference : this.connectionReferenceList) {
            this.addNonNullWrapper(connections, (RMIConnectionWrapper)reference.get());
        }
        return connections;
    }

    private void addNonNullWrapper(ArrayList<RMIConnectionWrapper> collection, RMIConnectionWrapper wrapper) {
        if (wrapper != null) {
            collection.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMIConnection newClient(Object credentials) throws IOException {
        this.clearClientConnection(null);
        Hashtable origThreadInstance = RMIConnectionWrapper.pushEnvironment(this.env);
        try {
            RMIConnection connection = this.rmiServer.newClient(credentials);
            RMIConnectionWrapper connectionWrapper = new RMIConnectionWrapper(connection, this.subject, this.locale, this, this.env);
            InvocationContextProxyHandler handler = this.cic != null ? new InvocationContextProxyHandler(connectionWrapper, this.cic) : new InvocationContextProxyHandler(connectionWrapper);
            RMIConnection rmiConnectionWrapperProxy = (RMIConnection)Proxy.newProxyInstance(RMIConnection.class.getClassLoader(), new Class[]{RMIConnection.class}, (InvocationHandler)handler);
            Object object = this.connectionReferenceList;
            synchronized (object) {
                this.connectionReferenceList.add(new WeakReference<RMIConnectionWrapper>(connectionWrapper));
            }
            object = rmiConnectionWrapperProxy;
            return object;
        }
        finally {
            RMIConnectionWrapper.popEnvironment(origThreadInstance, this.env);
        }
    }

    boolean setEnvOnThreadContext() {
        if (this.env == null) {
            return false;
        }
        if (this.env.size() > 0) {
            ThreadLocalMap.push(this.env);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        List<WeakReference<RMIConnectionWrapper>> list = this.connectionReferenceList;
        synchronized (list) {
            for (WeakReference<RMIConnectionWrapper> aConnectionList : this.connectionReferenceList) {
                RMIConnectionWrapper rmiConnectionWrapper = (RMIConnectionWrapper)aConnectionList.get();
                if (rmiConnectionWrapper == null) continue;
                rmiConnectionWrapper.disconnected();
            }
            this.connectionReferenceList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientConnection(RMIConnectionWrapper clientConnection) {
        List<WeakReference<RMIConnectionWrapper>> list = this.connectionReferenceList;
        synchronized (list) {
            Iterator<WeakReference<RMIConnectionWrapper>> iterator = this.connectionReferenceList.iterator();
            while (iterator.hasNext()) {
                RMIConnectionWrapper rmiConnectionWrapper = (RMIConnectionWrapper)iterator.next().get();
                if (rmiConnectionWrapper != null && !rmiConnectionWrapper.equals(clientConnection)) continue;
                iterator.remove();
            }
        }
    }

    public void clearTimeouts() {
        if (this.env != null) {
            this.env.clear();
        }
    }
}

