/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class InvocationContextProxyHandler
implements InvocationHandler {
    private Object connectionWrapper;
    private ComponentInvocationContext cic;

    public InvocationContextProxyHandler(Object connectionWrapper) {
        this(connectionWrapper, null);
    }

    public InvocationContextProxyHandler(Object connectionWrapper, ComponentInvocationContext cic) {
        this.connectionWrapper = connectionWrapper;
        this.cic = cic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "hashCode": {
                return this.connectionWrapper.hashCode();
            }
            case "equals": {
                boolean bl;
                if (proxy == args[0]) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            case "toString": {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append(this.connectionWrapper.toString()).append(" for partition ");
                if (this.cic == null) {
                    string = "DOMAIN";
                    return stringBuilder.append(string).toString();
                }
                string = this.cic.getPartitionName();
                return stringBuilder.append(string).toString();
            }
        }
        try {
            if (this.cic == null) {
                return method.invoke(this.connectionWrapper, args);
            }
            AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            ComponentInvocationContextManager cicm = ComponentInvocationContextManager.getInstance(KERNEL_ID);
            try (ManagedInvocationContext mic = cicm.setCurrentComponentInvocationContext(this.cic);){
                Object object = method.invoke(this.connectionWrapper, args);
                return object;
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (IllegalAccessException iae) {
            throw iae.getCause();
        }
    }
}

