/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.common;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.security.auth.Subject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.PartitionTable;
import weblogic.kernel.KernelStatus;
import weblogic.logging.NonCatalogLogger;
import weblogic.management.remote.common.RMIServerWrapper;
import weblogic.management.remote.common.WLSRMIConnector;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.Security;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.auth.callback.IdentityDomainNamesEncoder;
import weblogic.security.service.PrivilegedActions;

public class ClientProviderBase
implements JMXConnectorProvider {
    public static final String LOCALE_KEY = "weblogic.management.remote.locale";
    public static final String IDENTITY_DOMAIN = "weblogic.management.remote.identitydomain";
    public static final String PARTITION_NAME_KEY = "weblogic.partitionName";
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger("DebugJMXCoreConcise");
    private static final NonCatalogLogger logger = new NonCatalogLogger("ClientProvierBase");
    private ClassLoader jmxLoader;

    private static boolean isRemoteStub(Object objref) {
        Remote remote = (Remote)Remote.class.cast(objref);
        return ServerHelper.isWLSStub(remote) && !ServerHelper.isLocal(remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environmentIn) throws IOException {
        String wlsClientEnabled;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Create new JMX connector for " + serviceURL);
        }
        HashMap environment = new HashMap(environmentIn);
        environment.putAll(environmentIn);
        environment.put("jmx.remote.x.notification.fetch.timeout", new Long(1000L));
        boolean disableChecker = true;
        if (serviceURL.getProtocol().startsWith("iiop") && (wlsClientEnabled = System.getProperty("weblogic.system.iiop.enableClient")) != null && wlsClientEnabled.equals("false")) {
            disableChecker = false;
        }
        if (disableChecker && !environment.containsKey("jmx.remote.x.client.connection.check.period")) {
            environment.put("jmx.remote.x.client.connection.check.period", new Long(0L));
        }
        String providerUrl = this.buildProviderUrl(serviceURL);
        environment.put("java.naming.provider.url", providerUrl);
        this.jmxLoader = (ClassLoader)environment.get("jmx.remote.protocol.provider.class.loader");
        ClassLoader old = this.pushJMXClassLoader();
        try {
            RMIConnector rMIConnector = this.makeConnection(serviceURL, environment);
            return rMIConnector;
        }
        finally {
            this.popJMXClassLoader(old);
        }
    }

    String buildProviderUrl(JMXServiceURL serviceURL) {
        String partitionPath = null;
        String urlPath = serviceURL.getURLPath();
        if (urlPath.contains("/jndi/") && !urlPath.startsWith("/jndi/")) {
            partitionPath = urlPath.substring(1, urlPath.indexOf("/jndi/"));
        }
        String providerUrl = serviceURL.getProtocol() + "://" + serviceURL.getHost() + ":" + serviceURL.getPort();
        if (partitionPath != null) {
            providerUrl = providerUrl + "/" + partitionPath;
        }
        return providerUrl;
    }

    private RMIConnector makeConnection(JMXServiceURL directoryURL, Map environment) throws IOException {
        Object objref;
        Locale locale;
        long retryInterval;
        int retryTime;
        String[] jmxCreds;
        Object jmxCredentials;
        String path;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("makeConnection");
        }
        if (!(path = directoryURL.getURLPath()).contains("/jndi/")) {
            throw new MalformedURLException("URL path must contain /jndi/");
        }
        String idd = null;
        Object val = environment.get(IDENTITY_DOMAIN);
        if (val != null && val instanceof String && !((String)val).isEmpty()) {
            idd = (String)val;
        }
        if (!environment.containsKey("java.naming.provider.url") && System.getProperty("java.naming.provider.url") == null) {
            String host = directoryURL.getHost();
            boolean ipV6NumericAddr = host.indexOf(58) >= 0;
            String providerURL = directoryURL.getProtocol() + "://" + (ipV6NumericAddr ? "[" : "") + directoryURL.getHost() + (ipV6NumericAddr ? "]" : "") + ":" + directoryURL.getPort();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Constructing an internal Context.PROVIDER_URL " + providerURL + " because the system property Context.PROVIDER_URL is not set.");
            }
            environment.put("java.naming.provider.url", providerURL);
        } else if (debugLogger.isDebugEnabled()) {
            if (System.getProperty("java.naming.provider.url") != null) {
                logger.notice("NOTE: The Context.PROVIDER_URL was set via the system property Context.PROVIDER_URL: " + System.getProperty("java.naming.provider.url") + " this value is overriding the internally generated PROVIDER_URL.   Unset the Context.PROVIDER_URL system property if you wish to use the internally generated PROVIDER_URL");
            }
            if (environment.containsKey("java.naming.provider.url")) {
                debugLogger.debug("The Context.PROVIDER_URL was set via environment variable Context.PROVIDER_URL: " + environment.get("java.naming.provider.url"));
            }
        }
        if (!environment.containsKey("java.naming.factory.initial")) {
            environment.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        }
        if (!environment.containsKey("jmx.remote.credentials") && environment.containsKey("java.naming.security.principal") && environment.containsKey("java.naming.security.credentials")) {
            Object principal = environment.get("java.naming.security.principal");
            Object credential = environment.get("java.naming.security.credentials");
            if (principal instanceof String && credential instanceof String) {
                String username = (String)principal;
                if (idd != null) {
                    username = IdentityDomainNamesEncoder.encodeNames(username, idd);
                }
                String[] jmxCredentials2 = new String[]{username, (String)credential};
                environment.put("jmx.remote.credentials", jmxCredentials2);
            }
        }
        if (!environment.containsKey("java.naming.security.principal") && environment.containsKey("jmx.remote.credentials") && (jmxCredentials = environment.get("jmx.remote.credentials")) != null && jmxCredentials instanceof String[] && (jmxCreds = (String[])String[].class.cast(jmxCredentials)).length == 2) {
            environment.put("java.naming.security.principal", jmxCreds[0]);
            environment.put("java.naming.security.credentials", jmxCreds[1]);
        }
        int timeout = 0;
        Hashtable<String, Object> requiredEnv = new Hashtable<String, Object>();
        String timeoutKey = "jmx.remote.x.request.waiting.timeout";
        if (environment.containsKey(timeoutKey) && (val = environment.get(timeoutKey)) instanceof Long) {
            timeout = ((Long)val).intValue();
            if (timeout > 0) {
                environment.put("weblogic.jndi.connectTimeout", val);
                environment.put("weblogic.jndi.responseReadTimeout", val);
                requiredEnv.put("weblogic.jndi.connectTimeout", val);
                requiredEnv.put("weblogic.jndi.responseReadTimeout", val);
            } else {
                timeout = Integer.MAX_VALUE;
                environment.put("weblogic.jndi.responseReadTimeout", new Long(timeout));
                requiredEnv.put("weblogic.jndi.responseReadTimeout", Long.valueOf(timeout));
            }
        }
        if (environment.containsKey("weblogic.jndi.createContextRetry.time") && environment.get("weblogic.jndi.createContextRetry.time") instanceof Integer && (retryTime = ((Integer)environment.get("weblogic.jndi.createContextRetry.time")).intValue()) > 0) {
            requiredEnv.put("weblogic.jndi.createContextRetry.time", retryTime);
        }
        if (environment.containsKey("weblogic.jndi.createContextRetry.interval") && environment.get("weblogic.jndi.createContextRetry.interval") instanceof Long && (retryInterval = ((Long)environment.get("weblogic.jndi.createContextRetry.interval")).longValue()) > 0L) {
            requiredEnv.put("weblogic.jndi.createContextRetry.interval", retryInterval);
        }
        requiredEnv.put("java.naming.provider.url", environment.get("java.naming.provider.url"));
        if (idd != null) {
            environment.put("weblogic.jndi.identityDomain", idd);
            requiredEnv.put("weblogic.jndi.identityDomain", idd);
        }
        if ((locale = (Locale)environment.remove(LOCALE_KEY)) == null) {
            locale = ClientProviderBase.getSystemPropertyLocale();
        }
        Hashtable ht = ClientProviderBase.mapToHashtable(environment);
        InitialContext ctx = null;
        Subject subject = null;
        try {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("makeConnection, caling to InitialContext");
            }
            ctx = new InitialContext(ht);
            String lookupObjectName = path.substring(path.indexOf("/jndi/") + 6);
            objref = ctx.lookup(lookupObjectName);
            subject = Security.getCurrentSubject();
            String partition = "DOMAIN";
            try {
                partition = (String)ctx.lookup(PARTITION_NAME_KEY);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            requiredEnv.put(PARTITION_NAME_KEY, partition);
        }
        catch (NamingException ne) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("makeConnection failed, with NamingException");
            }
            if (ne instanceof AuthenticationException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("makeConnection failed, with AuthenticationException");
                }
                if (ne.getCause() != null && ne.getCause() instanceof SecurityException) {
                    throw (SecurityException)ne.getCause();
                }
                throw new SecurityException(ne.getCause());
            }
            if (ne instanceof NoPermissionException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("makeConnection failed, with NoPermissionException");
                }
                throw new SecurityException("Anonymous attempt to get to a JNDI resource");
            }
            IOException ioe = new IOException(ne.getMessage());
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("makeConnection failed, with IOException stacktrace");
                ne.printStackTrace();
            }
            ioe.initCause(ne);
            throw ioe;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("makeConnection failed, IOException with stack trace");
                    e.printStackTrace();
                }
                throw (IOException)e;
            }
            IOException ioe = new IOException(e.getMessage());
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("makeConnection failed, create new IOException with stacktrace");
                e.printStackTrace();
            }
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
                ctx = null;
            }
        }
        if (KernelStatus.isServer() && !ClientProviderBase.isRemoteStub(objref)) {
            AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            ComponentInvocationContextManager securedCICM = ComponentInvocationContextManager.getInstance(KERNEL_ID);
            ComponentInvocationContext cic = this.createInvocationContext((String)environment.get("java.naming.provider.url"), securedCICM);
            RMIServerWrapper rmiServer = new RMIServerWrapper(ClientProviderBase.narrowServer(objref), subject, requiredEnv, locale, cic);
            return new WLSRMIConnector(rmiServer, environment, subject, this.jmxLoader, cic, securedCICM);
        }
        RMIServerWrapper rmiServer = new RMIServerWrapper(ClientProviderBase.narrowServer(objref), subject, requiredEnv, locale);
        return new WLSRMIConnector(rmiServer, environment, subject, this.jmxLoader);
    }

    private ComponentInvocationContext createInvocationContext(String providerURL, ComponentInvocationContextManager cicm) {
        try {
            return cicm.createComponentInvocationContext(PartitionTable.getInstance().lookup(providerURL).getPartitionName());
        }
        catch (URISyntaxException se) {
            throw new RuntimeException(se);
        }
    }

    private static RMIServer narrowServer(Object objectReference) {
        try {
            return (RMIServer)PortableRemoteObject.narrow(objectReference, RMIServer.class);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static Hashtable mapToHashtable(Map map) {
        Hashtable env = new Hashtable(map.size());
        for (Map.Entry e : map.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (key == null || value == null || !(value instanceof Serializable)) continue;
            env.put(key, value);
        }
        return env;
    }

    protected static Locale getSystemPropertyLocale() throws IllegalArgumentException {
        String clientLocale = System.getProperty(LOCALE_KEY);
        if (clientLocale == null) {
            return null;
        }
        String[] localeComponents = clientLocale.split("-");
        if (localeComponents.length == 1) {
            return new Locale(localeComponents[0]);
        }
        if (localeComponents.length == 2) {
            return new Locale(localeComponents[0], localeComponents[1]);
        }
        if (localeComponents.length == 3) {
            return new Locale(localeComponents[0], localeComponents[1], localeComponents[2]);
        }
        throw new IllegalArgumentException("Invalid value for -Dweblogic.management.remote.locale: " + clientLocale + " Valid values are of the form lowercase two-letter ISO-639 code or (lowercase two-letter ISO-639 code)-(upper-case, two-letter codes ISO-3166) or (lowercase two-letter ISO-639 code)-(upper-case, two-letter codes ISO-3166)-(variant code) For instance es or es-ES or es-ES-Traditional_WIN");
    }

    private ClassLoader pushJMXClassLoader() {
        final Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        if (this.jmxLoader != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    t.setContextClassLoader(ClientProviderBase.this.jmxLoader);
                    return null;
                }
            });
        }
        return old;
    }

    private void popJMXClassLoader(final ClassLoader old) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(old);
                return null;
            }
        });
    }
}

