/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ProductionModeHelper {
    private static String globalProductionMode = new String();
    private static final String localProductionMode = System.getProperty("weblogic.ProductionModeEnabled");

    static void exportProductionMode(ObjectOutput out) throws IOException {
        out.writeObject(localProductionMode != null ? localProductionMode : globalProductionMode);
    }

    static void importProductionMode(ObjectInput in) throws IOException {
        try {
            globalProductionMode = (String)in.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean getGlobalProductionMode() {
        if (ProductionModeHelper.isGlobalProductionModeSet()) {
            return Boolean.parseBoolean(globalProductionMode);
        }
        return false;
    }

    public static boolean isGlobalProductionModeSet() {
        return globalProductionMode != null && globalProductionMode.length() != 0;
    }

    public static boolean getProductionModeProperty() {
        if (ProductionModeHelper.isProductionModePropertySet()) {
            return Boolean.parseBoolean(localProductionMode);
        }
        return false;
    }

    public static boolean isProductionModePropertySet() {
        return localProductionMode != null && localProductionMode.length() != 0;
    }
}

