/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.context;

import java.io.IOException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextImpl;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.SerializableWorkContext;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public class JMXContextHelper {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger("DebugJMXContext");
    private static final JMXContextAccess DEFAULT_JMXCONTEXTACCESS;
    private static JMXContextAccess SINGLETON;

    public static JMXContext getJMXContext(boolean create) {
        return SINGLETON.getJMXContext(create);
    }

    public static void putJMXContext(JMXContext jmxContext) {
        SINGLETON.putJMXContext(jmxContext);
    }

    public static void removeJMXContext() {
        SINGLETON.removeJMXContext();
    }

    public static synchronized void setJMXContextAccess(JMXContextAccess jmxContextAccess) {
        if (!KernelStatus.isServer() || SINGLETON != DEFAULT_JMXCONTEXTACCESS || jmxContextAccess == null) {
            return;
        }
        SINGLETON = jmxContextAccess;
    }

    static {
        SINGLETON = DEFAULT_JMXCONTEXTACCESS = new DefaultJMXContextAccessImpl();
    }

    private static class DefaultJMXContextAccessImpl
    implements JMXContextAccess {
        private DefaultJMXContextAccessImpl() {
        }

        @Override
        public JMXContext getJMXContext(boolean create) {
            WorkContextMap map = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
            SerializableWorkContext workContext = (SerializableWorkContext)map.get("weblogic.management.JMXContext");
            JMXContext jmxContext = null;
            if (workContext != null) {
                jmxContext = (JMXContext)workContext.get();
            }
            if (create && jmxContext == null) {
                jmxContext = new JMXContextImpl();
            }
            return jmxContext;
        }

        @Override
        public void putJMXContext(JMXContext jmxContext) {
            block4: {
                WorkContextMap map = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                try {
                    map.put("weblogic.management.JMXContext", PrimitiveContextFactory.create(jmxContext));
                }
                catch (PropertyReadOnlyException e) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.getJMXContext(): WorkContext property is read-only: " + e.getStackTrace());
                    }
                }
                catch (IOException e) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block4;
                    DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.getJMXContext(): IOException: " + e.getStackTrace());
                }
            }
        }

        @Override
        public void removeJMXContext() {
            block5: {
                try {
                    WorkContextMap map = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                    WorkContext workContext = map.get("weblogic.management.JMXContext");
                    if (workContext != null) {
                        map.remove("weblogic.management.JMXContext");
                    }
                }
                catch (NoWorkContextException e) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.removeJMXContext(): No WorkContext is available: " + e.getMessage());
                    }
                }
                catch (PropertyReadOnlyException e) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block5;
                    DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.removeJMXContext(): WorkContext property is read-only: " + e.getMessage());
                }
            }
        }
    }

    public static interface JMXContextAccess {
        public JMXContext getJMXContext(boolean var1);

        public void putJMXContext(JMXContext var1);

        public void removeJMXContext();
    }
}

