/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.EmptyStackException;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.utils.collections.Stack;

public final class ThreadLocalStack {
    private final AuditableThreadLocal tlstack;

    public ThreadLocalStack() {
        this.tlstack = AuditableThreadLocalFactory.createThreadLocal(new StackInitialValue());
    }

    public ThreadLocalStack(boolean inherit) {
        this.tlstack = AuditableThreadLocalFactory.createThreadLocal(new StackInitialValue(inherit));
    }

    public int getSize() {
        return ((Stack)this.tlstack.get()).size();
    }

    public Object get() {
        return this.peek();
    }

    public Object get(AuditableThread thr) {
        return this.peek(thr);
    }

    public void set(Object value) {
        Stack stack = (Stack)this.tlstack.get();
        stack.clear();
        stack.push(value);
    }

    public Object peek() {
        Stack stack = (Stack)this.tlstack.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public Object peek(AuditableThread thr) {
        Stack stack = (Stack)this.tlstack.get(thr);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public void push(Object value) {
        ((Stack)this.tlstack.get()).push(value);
    }

    public Object pop() {
        try {
            return ((Stack)this.tlstack.get()).pop();
        }
        catch (EmptyStackException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Object popAndPeek() {
        try {
            Stack stack = (Stack)this.tlstack.get();
            stack.pop();
            if (stack.isEmpty()) {
                return null;
            }
            return stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    private static final class StackInitialValue
    extends ThreadLocalInitialValue {
        private StackInitialValue() {
            this(false);
        }

        private StackInitialValue(boolean inherit) {
            super(inherit);
        }

        @Override
        protected Object initialValue() {
            return new Stack();
        }

        @Override
        protected Object resetValue(Object o) {
            ((Stack)o).clear();
            return o;
        }

        @Override
        protected Object childValue(Object parentValue) {
            Stack parentStack = (Stack)parentValue;
            if (this.inherit && !parentStack.isEmpty()) {
                Stack newStack = (Stack)this.initialValue();
                newStack.push(parentStack.peek());
                return newStack;
            }
            return this.initialValue();
        }
    }
}

