/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.ExecuteThread;
import weblogic.kernel.ExecuteThreadManager;

final class ServerExecuteThread
extends ExecuteThread {
    private ClassLoader contextClassLoader;
    private ClassLoader defaultContextClassLoader;

    ServerExecuteThread(int which, ExecuteThreadManager etm) {
        super(which, etm);
    }

    ServerExecuteThread(int which, ExecuteThreadManager etm, ThreadGroup tg) {
        super(which, etm, tg);
    }

    @Override
    protected void init(ExecuteThreadManager e) {
        super.init(e);
        this.defaultContextClassLoader = super.getContextClassLoader();
        this.setContextClassLoader(this.defaultContextClassLoader);
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Override
    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl != null ? cl : ClassLoader.getSystemClassLoader();
    }

    @Override
    protected final void reset() {
        super.reset();
        this.setContextClassLoader(this.defaultContextClassLoader);
    }

    @Override
    public ClassLoader getDefaultContextClassLoader() {
        return this.defaultContextClassLoader;
    }
}

