/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.rmi.RemoteException;
import weblogic.kernel.KernelLogger;
import weblogic.kernel.KernelStatus;
import weblogic.work.ExecuteThread;

public class QueueThrottleException
extends RemoteException {
    private static final long serialVersionUID = 9045249449980529886L;
    private static final boolean DEBUG = true;

    public QueueThrottleException() {
        this.log(null, null);
    }

    public QueueThrottleException(String msg) {
        super(msg);
        this.log(msg, null);
    }

    public QueueThrottleException(String msg, Throwable throable) {
        super(msg, throable);
        this.log(msg, throable);
    }

    private void log(String msg, Throwable th) {
        if (!KernelStatus.isServer()) {
            return;
        }
        Thread thread = Thread.currentThread();
        String wmName = null;
        try {
            if (thread instanceof ExecuteThread) {
                wmName = ((ExecuteThread)thread).getWorkManager().getName();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        KernelLogger.logDebugQueueThrottle(wmName, thread.getName(), msg, th);
    }
}

