/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.io.File;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import weblogic.kernel.MBeanStub;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.LogMBean;

final class LogMBeanStub
extends MBeanStub
implements LogMBean {
    private static final String TRACE = "Trace";
    private static final String INFO = "Info";
    private String fname = null;
    private String rotationType = "none";
    private boolean filesLtd = false;
    private int fileCount = 7;
    private int timeSpan = 24;
    private int fileSize = 500;
    private String logRotationTime;
    private boolean rotateLogOnStartup = false;
    private String rotationDir = null;
    private boolean log4jLoggingEnabled = false;
    private int memoryBufferSize = 500;
    private String stdoutSeverty = "Info";
    private String logFileSeverity = "Trace";
    private String domainLogBroadcastSeverity;
    private String memoryBufferSeverity;
    private LogFilterMBean stdoutFilter;
    private LogFilterMBean logFileFilter;
    private LogFilterMBean domainLogBroadcastFilter;
    private LogFilterMBean memoryBufferFilter;
    private boolean redirectStdoutToServerLogEnabled = false;
    private boolean redirectStderrToServerLogEnabled = false;
    private String stdoutFormat = "standard";
    private boolean stdoutLogStack = true;
    private int stacktraceDepth = 5;
    private String dateFormatPattern;
    private int triggerTruncationStackFrameTriggerDepth = 500;
    private int triggerTruncationStackFrameDepthAfterTrigger = 5;

    LogMBeanStub() {
        this.initializeFromSystemProperties("weblogic.log.");
    }

    @Override
    public String getFileName() {
        return this.fname;
    }

    @Override
    public void setFileName(String fileName) {
        this.fname = fileName;
    }

    @Override
    public String getRotationType() {
        return this.rotationType;
    }

    @Override
    public void setRotationType(String rotationType) {
        this.rotationType = rotationType;
    }

    @Override
    public boolean isNumberOfFilesLimited() {
        return this.filesLtd;
    }

    @Override
    public void setNumberOfFilesLimited(boolean value) {
        this.filesLtd = value;
    }

    @Override
    public int getFileCount() {
        return this.fileCount;
    }

    @Override
    public void setFileCount(int numberOfFiles) {
        this.fileCount = numberOfFiles;
    }

    @Override
    public int getFileTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public void setFileTimeSpan(int hours) {
        this.timeSpan = hours;
    }

    @Override
    public int getFileMinSize() {
        return this.fileSize;
    }

    @Override
    public void setFileMinSize(int kBytes) {
        this.fileSize = kBytes;
    }

    @Override
    public String getRotationTime() {
        return this.logRotationTime;
    }

    @Override
    public void setRotationTime(String logRotationTime) {
        this.logRotationTime = logRotationTime;
    }

    @Override
    public boolean getRotateLogOnStartup() {
        return this.rotateLogOnStartup;
    }

    @Override
    public void setRotateLogOnStartup(boolean value) {
        this.rotateLogOnStartup = value;
    }

    @Override
    public String getLogFileRotationDir() {
        return this.rotationDir;
    }

    @Override
    public void setLogFileRotationDir(String dirPath) {
        this.rotationDir = dirPath;
    }

    @Override
    public LogFilterMBean getLogFileFilter() {
        return this.logFileFilter;
    }

    @Override
    public void setLogFileFilter(LogFilterMBean filter) {
        this.logFileFilter = filter;
    }

    @Override
    public LogFilterMBean getStdoutFilter() {
        return this.stdoutFilter;
    }

    @Override
    public void setStdoutFilter(LogFilterMBean filter) {
        this.stdoutFilter = filter;
    }

    @Override
    public LogFilterMBean getMemoryBufferFilter() {
        return this.memoryBufferFilter;
    }

    @Override
    public void setMemoryBufferFilter(LogFilterMBean filter) {
        this.memoryBufferFilter = filter;
    }

    @Override
    public LogFilterMBean getDomainLogBroadcastFilter() {
        return this.domainLogBroadcastFilter;
    }

    @Override
    public void setDomainLogBroadcastFilter(LogFilterMBean filter) {
        this.domainLogBroadcastFilter = filter;
    }

    @Override
    public boolean isLog4jLoggingEnabled() {
        return this.log4jLoggingEnabled;
    }

    @Override
    public void setLog4jLoggingEnabled(boolean enabled) {
        this.log4jLoggingEnabled = enabled;
    }

    @Override
    public int getMemoryBufferSize() {
        return this.memoryBufferSize;
    }

    @Override
    public void setMemoryBufferSize(int mem) {
        this.memoryBufferSize = mem;
    }

    @Override
    public String getStdoutSeverity() {
        return this.stdoutSeverty;
    }

    @Override
    public void setStdoutSeverity(String stdoutSeverity) {
        this.stdoutSeverty = stdoutSeverity;
    }

    @Override
    public String getLogFileSeverity() {
        return this.logFileSeverity;
    }

    @Override
    public void setLogFileSeverity(String logFileSeverity) {
        this.logFileSeverity = logFileSeverity;
    }

    @Override
    public String getMemoryBufferSeverity() {
        return this.memoryBufferSeverity;
    }

    @Override
    public void setMemoryBufferSeverity(String severity) {
        this.memoryBufferSeverity = severity;
    }

    @Override
    public String getDomainLogBroadcastSeverity() {
        return this.domainLogBroadcastSeverity;
    }

    @Override
    public void setDomainLogBroadcastSeverity(String severity) {
        this.domainLogBroadcastSeverity = severity;
    }

    @Override
    public boolean isRedirectStdoutToServerLogEnabled() {
        return this.redirectStdoutToServerLogEnabled;
    }

    @Override
    public void setRedirectStdoutToServerLogEnabled(boolean captureStdout) {
        this.redirectStdoutToServerLogEnabled = captureStdout;
    }

    @Override
    public boolean isRedirectStderrToServerLogEnabled() {
        return this.redirectStderrToServerLogEnabled;
    }

    @Override
    public void setRedirectStderrToServerLogEnabled(boolean captureStderr) {
        this.redirectStderrToServerLogEnabled = captureStderr;
    }

    @Override
    public int getDomainLogBroadcasterBufferSize() {
        return 0;
    }

    @Override
    public void setDomainLogBroadcasterBufferSize(int bufferSize) {
    }

    @Override
    public String computeLogFilePath() {
        return this.getLogFilePath();
    }

    @Override
    public String getLogFilePath() {
        return new File(this.getFileName()).getAbsolutePath();
    }

    @Override
    public String getStdoutFormat() {
        return this.stdoutFormat;
    }

    @Override
    public void setStdoutFormat(String format) {
        this.stdoutFormat = format;
    }

    @Override
    public boolean isStdoutLogStack() {
        return this.stdoutLogStack;
    }

    @Override
    public void setStdoutLogStack(boolean stack) {
        this.stdoutLogStack = stack;
    }

    @Override
    public int getStacktraceDepth() {
        return this.stacktraceDepth;
    }

    @Override
    public void setStacktraceDepth(int depth) {
        this.stacktraceDepth = depth;
    }

    @Override
    public int getTriggerTruncationStackFrameTriggerDepth() {
        return this.triggerTruncationStackFrameTriggerDepth;
    }

    @Override
    public void setTriggerTruncationStackFrameTriggerDepth(int depth) {
        this.triggerTruncationStackFrameTriggerDepth = depth;
    }

    @Override
    public int getTriggerTruncationStackFrameDepthAfterTrigger() {
        return this.triggerTruncationStackFrameDepthAfterTrigger;
    }

    @Override
    public void setTriggerTruncationStackFrameDepthAfterTrigger(int depth) {
        this.triggerTruncationStackFrameDepthAfterTrigger = depth;
    }

    @Override
    public long getFileTimeSpanFactor() {
        return 3600000L;
    }

    @Override
    public void setFileTimeSpanFactor(long factor) {
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public void setOutputStream(OutputStream os) {
    }

    @Override
    public int getBufferSizeKB() {
        return 8;
    }

    @Override
    public void setBufferSizeKB(int size) {
    }

    @Override
    public String getDateFormatPattern() {
        if (this.dateFormatPattern == null) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 0);
            this.dateFormatPattern = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : "MMM d, yyyy h:mm:ss a z";
        }
        return this.dateFormatPattern;
    }

    @Override
    public void setDateFormatPattern(String df) {
    }

    @Override
    public String getLoggerSeverity() {
        return TRACE;
    }

    @Override
    public void setLoggerSeverity(String severity) {
    }

    @Override
    public Properties getLoggerSeverityProperties() {
        return null;
    }

    @Override
    public void setLoggerSeverityProperties(Properties props) {
    }

    @Override
    public boolean isServerLoggingBridgeUseParentLoggersEnabled() {
        return false;
    }

    @Override
    public void setServerLoggingBridgeUseParentLoggersEnabled(boolean value) {
    }

    @Override
    public Properties getPlatformLoggerLevels() {
        return null;
    }

    @Override
    public void setPlatformLoggerLevels(Properties props) {
    }

    @Override
    public boolean isServerLoggingBridgeAtRootLoggerEnabled() {
        return false;
    }

    @Override
    public void setServerLoggingBridgeAtRootLoggerEnabled(boolean value) {
    }

    @Override
    public String getLogRotationDirPath() {
        return this.getLogFileRotationDir();
    }

    @Override
    public boolean isLogMonitoringEnabled() {
        return false;
    }

    @Override
    public void setLogMonitoringEnabled(boolean enabled) {
    }

    @Override
    public int getLogMonitoringIntervalSecs() {
        return 0;
    }

    @Override
    public void setLogMonitoringIntervalSecs(int interval) {
    }

    @Override
    public int getLogMonitoringThrottleThreshold() {
        return 0;
    }

    @Override
    public void setLogMonitoringThrottleThreshold(int threshold) {
    }

    @Override
    public int getLogMonitoringThrottleMessageLength() {
        return 0;
    }

    @Override
    public void setLogMonitoringThrottleMessageLength(int length) {
    }

    @Override
    public int getLogMonitoringMaxThrottleMessageSignatureCount() {
        return 0;
    }

    @Override
    public void setLogMonitoringMaxThrottleMessageSignatureCount(int length) {
    }
}

