/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.AuditableThread;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.KernelLogger;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.kernel.ThreadStorage;

final class FinalThreadLocal
implements AuditableThreadLocal {
    private static volatile boolean finalized = false;
    private final int index = FinalThreadStorage.newSlot(this);
    private final ThreadLocalInitialValue initial;
    private static final String CONTINUAL_LOG_PROP = "weblogic.kernel.debug.JavaThreadAccess";
    private static final boolean keepLogging = FinalThreadLocal.getContinueLoggingProperty();
    private static boolean loggedWarning = true;
    private static final InheritableThreadLocal threadLocals = new InheritableThreadLocal(){

        @Override
        protected Object initialValue() {
            return new FinalThreadStorage();
        }

        protected Object childValue(Object parentValue) {
            Thread thread = Thread.currentThread();
            if (thread instanceof AuditableThread) {
                return new FinalThreadStorage(((AuditableThread)thread).finalThreadStorage);
            }
            if (!loggedWarning) {
                KernelLogger.logWarnSwitchToWorkManagerAPI();
                loggedWarning = true;
            } else if (keepLogging) {
                KernelLogger.logDebugSwitchToWorkManagerAPI(thread.toString());
            }
            if (parentValue != null) {
                return new FinalThreadStorage((FinalThreadStorage)parentValue);
            }
            return null;
        }
    };

    private static boolean getContinueLoggingProperty() {
        return !KernelStatus.isApplet() && "true".equals(System.getProperty(CONTINUAL_LOG_PROP));
    }

    FinalThreadLocal() {
        this.initial = new ThreadLocalInitialValue();
    }

    FinalThreadLocal(ThreadLocalInitialValue d) {
        this.initial = d;
    }

    @Override
    public Object get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof AuditableThread) {
            return ((AuditableThread)thread).finalThreadStorage.get(this.index);
        }
        return this.get((ThreadStorage)threadLocals.get());
    }

    @Override
    public Object get(AuditableThread thread) {
        if (thread == null) {
            return null;
        }
        return thread.finalThreadStorage.get(this.index);
    }

    private Object get(ThreadStorage storage) {
        if (storage == null) {
            return null;
        }
        return storage.get(this.index);
    }

    @Override
    public void set(Object value) {
        Thread thread = Thread.currentThread();
        if (thread instanceof AuditableThread) {
            ((AuditableThread)thread).finalThreadStorage.set(this.index, value);
        } else {
            this.set((ThreadStorage)threadLocals.get(), value);
        }
    }

    private void set(ThreadStorage storage, Object value) {
        if (storage == null) {
            return;
        }
        storage.set(this.index, value);
    }

    static boolean isFinalized() {
        return finalized;
    }

    static final void resetJavaThreadStorage() {
        threadLocals.set(null);
    }

    static final class FinalThreadStorage
    implements ThreadStorage {
        private static FinalThreadLocal[] varList = new FinalThreadLocal[0];
        private final Object[] storage;
        private final int NUM_SLOTS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int newSlot(FinalThreadLocal var) {
            if (finalized) {
                throw new AssertionError((Object)"A FinalThreadLocal was allocated after thread creation.");
            }
            Class<FinalThreadStorage> clazz = FinalThreadStorage.class;
            synchronized (FinalThreadStorage.class) {
                int newIdx = varList.length;
                FinalThreadLocal[] newList = new FinalThreadLocal[newIdx + 1];
                System.arraycopy(varList, 0, newList, 0, newIdx);
                newList[newIdx] = var;
                varList = newList;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return newIdx;
            }
        }

        public FinalThreadStorage() {
            finalized = true;
            this.NUM_SLOTS = varList.length;
            this.storage = new Object[this.NUM_SLOTS];
            for (int i = 0; i < this.NUM_SLOTS; ++i) {
                this.storage[i] = varList[i].initial.initialValue();
            }
        }

        protected FinalThreadStorage(FinalThreadStorage parent) {
            this.NUM_SLOTS = varList.length;
            this.storage = new Object[this.NUM_SLOTS];
            for (int i = 0; i < this.NUM_SLOTS; ++i) {
                this.storage[i] = parent != null ? varList[i].initial.childValue(parent.storage[i]) : varList[i].initial.initialValue();
            }
        }

        @Override
        public void set(int idx, Object o) {
            this.storage[idx] = o;
        }

        @Override
        public Object get(int idx) {
            return this.storage[idx];
        }

        @Override
        public final void reset() {
            Object[] localStorage = this.storage;
            int size = localStorage.length;
            for (int i = 0; i < size; ++i) {
                Object o = localStorage[i];
                localStorage[i] = varList[i].initial.resetValue(o);
            }
        }
    }
}

