/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.lang.reflect.Method;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelLogger;

public class ExecuteThread
extends AuditableThread {
    private static final Throwable REQUEST_DEATH = new RequestDeath();
    private ExecuteThreadManager em;
    private int hashcode;
    private ExecuteRequest req = null;
    private boolean printStuckMessage = false;
    private boolean started = false;
    private int executeCount = 0;
    private long timeStamp = 0L;
    private boolean systemThread = false;
    private static final Method PANIC = ExecuteThread.getPanicMethod();

    ExecuteThread(int which, ExecuteThreadManager e) {
        super("ExecuteThread: '" + which + "' for queue: '" + e.getName() + "'");
        this.init(e);
    }

    ExecuteThread(int which, ExecuteThreadManager e, ThreadGroup tg) {
        super(tg, "ExecuteThread: '" + which + "' for queue: '" + e.getName() + "'");
        this.init(e);
    }

    protected void init(ExecuteThreadManager e) {
        this.em = e;
        this.hashcode = this.getName().hashCode();
    }

    public int hashCode() {
        return this.hashcode;
    }

    boolean isStarted() {
        return this.started;
    }

    public ExecuteRequest getCurrentRequest() {
        return this.req;
    }

    int getExecuteCount() {
        return this.executeCount;
    }

    public void setTimeStamp(long time) {
        this.timeStamp = time;
    }

    long getTimeStamp() {
        return this.timeStamp;
    }

    void setPrintStuckThreadMessage(boolean prtMsg) {
        this.printStuckMessage = prtMsg;
    }

    boolean getPrintStuckThreadMessage() {
        return this.printStuckMessage;
    }

    public void setSystemThread(boolean flag) {
        this.systemThread = flag;
    }

    boolean getSystemThread() {
        return this.systemThread;
    }

    public ExecuteThreadManager getExecuteThreadManager() {
        return this.em;
    }

    synchronized void notifyRequest(ExecuteRequest r) {
        this.setTimeStamp(System.currentTimeMillis());
        this.req = r;
        this.notify();
    }

    void setRequest(ExecuteRequest r) {
        this.req = r;
    }

    private synchronized void waitForRequest() {
        while (this.req == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected synchronized void readyToRun() {
        this.started = true;
        super.readyToRun();
        this.notify();
    }

    @Override
    public void run() {
        this.readyToRun();
        while (true) {
            try {
                while (true) {
                    this.reset();
                    this.em.registerIdle(this);
                    if (this.req == null) {
                        this.waitForRequest();
                    }
                    this.execute(this.req);
                }
            }
            catch (ExecuteThreadManager.ShutdownError se) {
            }
            catch (ThreadDeath td) {
                if (!Kernel.isServer()) continue;
                if (!Kernel.isIntentionalShutdown()) {
                    KernelLogger.logStopped(this.getName());
                }
                throw td;
            }
            break;
        }
        if (Kernel.isServer() && !Kernel.isIntentionalShutdown()) {
            KernelLogger.logStopped(this.getName());
        }
    }

    void execute(ExecuteRequest er) {
        try {
            ++this.executeCount;
            this.setTimeStamp(System.currentTimeMillis());
            er.execute(this);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (ExecuteThreadManager.ShutdownError se) {
            throw se;
        }
        catch (RequestDeath rd) {
            KernelLogger.logExecuteCancelled(er.toString());
        }
        catch (OutOfMemoryError oome) {
            KernelLogger.logExecuteFailed(oome);
            ExecuteThread.notifyOOME(oome);
        }
        catch (Throwable t) {
            if (!Kernel.isApplet()) {
                KernelLogger.logExecuteFailed(t);
            }
            t.printStackTrace();
        }
    }

    private static void notifyOOME(OutOfMemoryError oome) {
        if (PANIC != null) {
            try {
                PANIC.invoke(null, oome);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Method getPanicMethod() {
        try {
            return Class.forName("weblogic.health.HealthMonitorService").getMethod("panic", Class.forName("java.lang.Throwable"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.req = null;
    }

    private static final class RequestDeath
    extends Error {
        private RequestDeath() {
        }
    }
}

