/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jndi.Environment;
import weblogic.jndi.ObjectCopier;
import weblogic.jndi.internal.SSL.SSLProxy;
import weblogic.protocol.ServerIdentity;
import weblogic.rjvm.RJVMManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.internal.encryption.EncryptionServiceException;

public abstract class JNDIEnvironment {
    private ConcurrentHashMap<Context, ServerIdentity> contextRJVMHolder = new ConcurrentHashMap();
    private ConcurrentSkipListSet<ObjectCopier> objectCopiers = new ConcurrentSkipListSet<ObjectCopier>(new ObjectCopierComparator());
    private static ObjectCopier DEFAULT_COPIER = new DefaultObjectCopier();

    public void addCopier(ObjectCopier copier) {
        this.objectCopiers.add(copier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object copyObject(Object object) throws RemoteException {
        ComponentInvocationContextManager mgr = ComponentInvocationContextManager.getInstance();
        ComponentInvocationContext cic = mgr.getCurrentComponentInvocationContext();
        if (cic.getApplicationName() == null) {
            cic = mgr.createComponentInvocationContext(cic.getPartitionName(), "_JNDI_ENVIRONMENT_", cic.getApplicationVersion(), cic.getModuleName(), cic.getComponentName());
        }
        try (ManagedInvocationContext mic = mgr.setCurrentComponentInvocationContext(cic);){
            Object object2 = this.getCopierFor(object).copyObject(object);
            return object2;
        }
        catch (IOException | ClassNotFoundException ioe) {
            throw new RemoteException(ioe.getMessage(), ioe);
        }
    }

    private ObjectCopier getCopierFor(Object objectToCopy) {
        for (ObjectCopier copier : this.objectCopiers) {
            if (!copier.mayCopy(objectToCopy)) continue;
            return copier;
        }
        return DEFAULT_COPIER;
    }

    private static JNDIEnvironment newInstance() {
        JNDIEnvironment singleton;
        try {
            singleton = (JNDIEnvironment)Class.forName("weblogic.jndi.WLSJNDIEnvironmentImpl").newInstance();
        }
        catch (Exception ig1) {
            try {
                singleton = (JNDIEnvironment)Class.forName("weblogic.jndi.WLSClientJNDIEnvironmentImpl").newInstance();
            }
            catch (Exception ig2) {
                throw new IllegalArgumentException(ig2.toString());
            }
        }
        return singleton;
    }

    public static JNDIEnvironment getJNDIEnvironment() {
        return LazyHolder.INSTANCE;
    }

    static void setJNDIEnvironment(JNDIEnvironment helper) {
        LazyHolder.INSTANCE = helper;
    }

    protected JNDIEnvironment() {
        this.addCopier(new ProxyCopier());
        this.addCopier(new SerializableObjectCopier());
    }

    public abstract SSLProxy getSSLProxy();

    public abstract Object copyObjectViaSerialization(Object var1) throws IOException, ClassNotFoundException;

    public abstract void prepareKernel();

    public abstract void nullSSLClientCertificate();

    public abstract void loadTransportableFactories(List var1) throws ConfigurationException;

    public abstract Context getDelegateContext(ServerIdentity var1, Environment var2, String var3) throws RemoteException, NamingException;

    public abstract void prepareSubjectManager();

    public abstract void activateTransactionHelper();

    public abstract void deactivateTransactionHelper();

    public abstract void pushThreadEnvironment(Environment var1);

    public abstract Environment popThreadEnvironment();

    public abstract void pushSubject(AuthenticatedSubject var1, AuthenticatedSubject var2);

    public abstract void popSubject(AuthenticatedSubject var1);

    public abstract AuthenticatedSubject getCurrentSubject(AuthenticatedSubject var1);

    public abstract AuthenticatedSubject getASFromAU(AuthenticatedUser var1);

    public abstract ObjectOutput getReplacerObjectOutputStream(ObjectOutput var1) throws IOException;

    public abstract ObjectInput getReplacerObjectInputStream(ObjectInput var1) throws IOException;

    public void storeConnectionTimeout(Context ctx, ServerIdentity rjvm, long connectionTimeout) {
        if (rjvm != null) {
            this.contextRJVMHolder.put(ctx, rjvm);
            RJVMManager.getRJVMManager().storeConnectionTimeout(rjvm, connectionTimeout);
        }
    }

    public void removeConnectionTimeout(Context ctx) {
        ServerIdentity id = this.contextRJVMHolder.remove(ctx);
        if (id != null) {
            RJVMManager.getRJVMManager().removeConnectionTimeout(id);
        }
    }

    public abstract byte[] encryptionHelperDecrypt(byte[] var1, AuthenticatedSubject var2) throws EncryptionServiceException;

    public abstract byte[] encryptionHelperClear(byte[] var1);

    static /* synthetic */ JNDIEnvironment access$200() {
        return JNDIEnvironment.newInstance();
    }

    private static class DefaultObjectCopier
    implements ObjectCopier {
        private DefaultObjectCopier() {
        }

        @Override
        public boolean mayCopy(Object objectToCopy) {
            return true;
        }

        @Override
        public Object copyObject(Object objectToCopy) throws IOException, ClassNotFoundException {
            return objectToCopy;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    private class SerializableObjectCopier
    implements ObjectCopier {
        private SerializableObjectCopier() {
        }

        @Override
        public boolean mayCopy(Object objectToCopy) {
            return objectToCopy instanceof Serializable;
        }

        @Override
        public Object copyObject(Object objectToCopy) throws IOException, ClassNotFoundException {
            return JNDIEnvironment.this.copyObjectViaSerialization(objectToCopy);
        }

        @Override
        public int getPriority() {
            return 40;
        }
    }

    private class ProxyCopier
    implements ObjectCopier {
        private ProxyCopier() {
        }

        @Override
        public boolean mayCopy(Object objectToCopy) {
            return objectToCopy instanceof Proxy;
        }

        @Override
        public Object copyObject(Object objectToCopy) throws IOException, ClassNotFoundException {
            return JNDIEnvironment.this.copyObjectViaSerialization(objectToCopy);
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }

    private static class ObjectCopierComparator
    implements Comparator<ObjectCopier> {
        private ObjectCopierComparator() {
        }

        @Override
        public int compare(ObjectCopier o1, ObjectCopier o2) {
            return Integer.compare(o2.getPriority(), o1.getPriority());
        }
    }

    private static class LazyHolder {
        private static JNDIEnvironment INSTANCE = JNDIEnvironment.access$200();

        private LazyHolder() {
        }
    }
}

