/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.xml.stax.bin;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.jms.utils.xml.stax.bin.BinaryXMLConstants;
import weblogic.jms.utils.xml.stax.utils.NamespaceContextImpl;

public final class BinaryXMLStreamReader
implements XMLStreamReader {
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private final boolean v1;
    private int currentKind;
    private int currentEvent;
    private int nextKind;
    private final DataInput dis;
    private String version;
    private String encoding;
    private final ArrayList dict = new ArrayList();
    private NamespaceContextImpl context;
    private String localName;
    private String namespaceURI;
    private String strVal;
    private final ArrayList attributes = new ArrayList();
    private int numAttrs;
    private final ArrayList namespaces = new ArrayList();
    private int numNamespaces;
    private char[] tmpCharBuf = new char[0];
    private byte[] tmpByteBuf = new byte[0];

    public BinaryXMLStreamReader(InputStream is) throws XMLStreamException {
        this.dis = is instanceof DataInput ? (DataInput)((Object)is) : new DataInputStream(is);
        byte[] arr = new byte[BinaryXMLConstants.HEADERV2_BYTES.length];
        try {
            is.read(arr);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (Arrays.equals(BinaryXMLConstants.HEADERV2_BYTES, arr)) {
            this.v1 = false;
        } else if (Arrays.equals(BinaryXMLConstants.HEADERV1_BYTES, arr)) {
            this.v1 = true;
        } else {
            throw new XMLStreamException("Invalid token stream");
        }
        this.advance();
    }

    @Override
    public int next() throws XMLStreamException {
        this.consumeDictionaryOps();
        switch (this.nextKind) {
            case 3: {
                this.version = this.readString();
                this.encoding = this.readString();
                this.advance();
                this.currentEvent = 7;
                return 7;
            }
            case 1: {
                if (this.context != null) {
                    this.context.openScope();
                }
                this.readQName();
                this.advance();
                this.consumeAttributesAndNamespaces();
                this.currentEvent = 1;
                return 1;
            }
            case 4: {
                if (this.context != null) {
                    this.context.closeScope(false);
                }
                this.advance();
                this.currentEvent = 2;
                return 2;
            }
            case 6: {
                this.advance();
                this.currentEvent = 8;
                return 8;
            }
            case 7: {
                this.strVal = this.readString();
                this.advance();
                this.currentEvent = 5;
                return 5;
            }
            case 10: {
                this.strVal = this.readString();
                this.advance();
                this.currentEvent = 4;
                return 4;
            }
            case 9: {
                this.readQName();
                this.strVal = this.readString();
                this.advance();
                this.currentEvent = 3;
                return 3;
            }
            case 50: {
                this.strVal = this.readString();
                this.readString();
                this.readString();
                this.advance();
                this.currentEvent = 11;
                return 11;
            }
            case 62: 
            case 1002: {
                this.currentEvent = 8;
                this.currentEvent = 8;
                return 8;
            }
        }
        throw new XMLStreamException("Unexpected token: " + this.nextKind);
    }

    @Override
    public Object getProperty(String s) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (this.currentEvent == type && namespaceURI != null && namespaceURI.equals(this.getNamespaceURI()) && localName != null && localName.equals(this.getLocalName())) {
            return;
        }
        throw new XMLStreamException();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (!this.isStartElement()) {
            throw new XMLStreamException("getElementText can only be called for START_ELEMENT");
        }
        StringBuffer ret = new StringBuffer();
        while (this.isCharacters()) {
            ret.append(this.getText());
        }
        return ret.toString();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return BinaryXMLStreamReader.convert(this.nextKind);
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.currentEvent != 8;
    }

    @Override
    public String getNamespaceURI(String s) {
        if (this.context != null) {
            return this.context.getNamespaceURI(s);
        }
        return null;
    }

    @Override
    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.currentEvent == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        if (!this.isCharacters()) {
            return false;
        }
        block3: for (int i = 0; i < this.strVal.length(); ++i) {
            switch (this.strVal.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getAttributeValue(String uri, String localName) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        for (int i = 0; i < this.numAttrs; ++i) {
            Attribute attr = (Attribute)this.attributes.get(i);
            if ((attr.uri != null || uri != null) && (attr.uri == null || !attr.uri.equals(uri)) || (attr.localName != null || localName != null) && (attr.localName == null || !attr.localName.equals(localName))) continue;
            return attr.val;
        }
        return "";
    }

    @Override
    public void close() throws XMLStreamException {
        this.dict.clear();
    }

    @Override
    public int getAttributeCount() {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        return this.numAttrs;
    }

    @Override
    public QName getAttributeName(int index) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        return new QName(this.getAttributeNamespace(index), this.getAttributeLocalName(index), this.getAttributePrefix(index));
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        Attribute attr = (Attribute)this.attributes.get(index);
        return attr.uri;
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        Attribute attr = (Attribute)this.attributes.get(index);
        return attr.localName;
    }

    @Override
    public String getAttributePrefix(int index) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        if (this.context == null) {
            return null;
        }
        return this.context.getPrefix(this.getAttributeNamespace(index));
    }

    @Override
    public String getAttributeType(int index) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int index) {
        Attribute attr = (Attribute)this.attributes.get(index);
        return attr.val;
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.encoding;
    }

    @Override
    public int getNamespaceCount() {
        return this.numNamespaces;
    }

    @Override
    public String getNamespacePrefix(int index) {
        Namespace namespace = (Namespace)this.namespaces.get(index);
        return namespace.prefix;
    }

    @Override
    public String getNamespaceURI(int index) {
        Namespace namespace = (Namespace)this.namespaces.get(index);
        return namespace.uri;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    @Override
    public int getEventType() {
        return this.currentEvent;
    }

    @Override
    public String getText() {
        switch (this.currentEvent) {
            case 3: 
            case 4: 
            case 5: {
                return this.strVal;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public char[] getTextCharacters() {
        switch (this.currentEvent) {
            case 3: 
            case 4: 
            case 5: {
                return this.strVal.toCharArray();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.getTextCharacters().length;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean hasText() {
        switch (this.currentKind) {
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public int getColumnNumber() {
                return -1;
            }

            @Override
            public int getCharacterOffset() {
                return -1;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
    }

    @Override
    public String getLocalName() {
        switch (this.currentKind) {
            case 1: 
            case 2: {
                return this.localName;
            }
        }
        return null;
    }

    @Override
    public boolean hasName() {
        switch (this.currentEvent) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getNamespaceURI() {
        switch (this.currentKind) {
            case 1: 
            case 4: {
                return this.namespaceURI;
            }
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.context == null) {
            return null;
        }
        return this.context.getPrefix(this.getNamespaceURI());
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getPITarget() {
        if (this.currentEvent != 3) {
            throw new IllegalStateException("Current state must be XMLStreamConstants.PROCESSING_INSTRUCTION");
        }
        return this.localName;
    }

    @Override
    public String getPIData() {
        if (this.currentEvent != 3) {
            throw new IllegalStateException("Current state must be XMLStreamConstants.PROCESSING_INSTRUCTION");
        }
        return this.strVal;
    }

    private void consumeDictionaryOps() throws XMLStreamException {
        while (true) {
            switch (this.nextKind) {
                case 60: 
                case 1000: {
                    String str = this.readString();
                    this.dict.add(str);
                    break;
                }
                case 61: 
                case 1001: {
                    this.dict.clear();
                    break;
                }
                default: {
                    return;
                }
            }
            this.nextKind = this.readInt();
        }
    }

    private void consumeAttributesAndNamespaces() throws XMLStreamException {
        this.numAttrs = 0;
        this.numNamespaces = 0;
        while (true) {
            this.consumeDictionaryOps();
            switch (this.nextKind) {
                case 2: {
                    this.consumeAttribute();
                    break;
                }
                case 8: {
                    this.consumeNamespace();
                    break;
                }
                default: {
                    return;
                }
            }
            this.nextKind = this.readInt();
        }
    }

    private void consumeNamespace() throws XMLStreamException {
        Namespace namespace;
        if (this.numNamespaces + 1 > this.namespaces.size()) {
            namespace = new Namespace();
            this.namespaces.add(namespace);
        } else {
            namespace = (Namespace)this.namespaces.get(this.numNamespaces);
        }
        ++this.numNamespaces;
        this.readNamespace(namespace);
    }

    private void readNamespace(Namespace namespace) throws XMLStreamException {
        namespace.prefix = this.readAbbrevString();
        namespace.uri = this.readAbbrevString();
        if (this.context == null) {
            this.context = new NamespaceContextImpl();
            this.context.bindNamespace("xmlns", XMLNS_NS);
        }
        this.context.bindNamespace(namespace.prefix, namespace.uri);
    }

    private void consumeAttribute() throws XMLStreamException {
        Attribute attr;
        if (this.numAttrs + 1 > this.attributes.size()) {
            attr = new Attribute();
            this.attributes.add(attr);
        } else {
            attr = (Attribute)this.attributes.get(this.numAttrs);
        }
        ++this.numAttrs;
        this.readAttribute(attr);
    }

    private void readAttribute(Attribute attr) throws XMLStreamException {
        attr.localName = this.readAbbrevString();
        attr.uri = this.readAbbrevString();
        this.nextKind = this.readInt();
        this.consumeDictionaryOps();
        if (this.nextKind == 5) {
            attr.val = "";
            this.nextKind = this.readInt();
            return;
        }
        attr.val = this.readPCDataString();
        this.nextKind = this.readInt();
        this.consumeDictionaryOps();
        if (this.nextKind != 5) {
            throw new XMLStreamException("Expected END_ATTRIBUTE");
        }
    }

    private static final int convert(int kind) throws XMLStreamException {
        switch (kind) {
            case 10: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 50: {
                return 11;
            }
            case 6: {
                return 8;
            }
            case 4: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 1: {
                return 1;
            }
        }
        throw new XMLStreamException("Unexpected kind: " + kind);
    }

    private void advance() throws XMLStreamException {
        this.currentKind = this.nextKind;
        this.nextKind = (short)this.readInt();
    }

    private String readPCDataString() throws XMLStreamException {
        switch (this.nextKind) {
            case 83: {
                return this.readAbbrevString();
            }
            case 19: {
                return this.readString();
            }
        }
        throw new XMLStreamException("Expected PCDATA");
    }

    private void readQName() throws XMLStreamException {
        this.localName = this.readAbbrevString();
        this.namespaceURI = this.readAbbrevString();
    }

    private String readAbbrevString() throws XMLStreamException {
        int abbrev = this.readInt();
        if (abbrev == 0) {
            return null;
        }
        return (String)this.dict.get(abbrev - 1);
    }

    private String readString() throws XMLStreamException {
        int len;
        if (this.v1) {
            try {
                len = this.dis.readChar();
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        } else {
            len = this.readInt();
        }
        if (len > this.tmpByteBuf.length) {
            this.tmpByteBuf = new byte[len];
        }
        try {
            this.dis.readFully(this.tmpByteBuf, 0, len);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (len > this.tmpCharBuf.length) {
            this.tmpCharBuf = new char[len];
        }
        int pos = 0;
        int outBufLen = 0;
        block9: while (pos < len) {
            int c = this.tmpByteBuf[pos] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++pos;
                    this.tmpCharBuf[outBufLen++] = (char)c;
                    continue block9;
                }
                case 12: 
                case 13: {
                    if ((pos += 2) > len) {
                        throw new XMLStreamException("Malformed UTF data");
                    }
                    byte c2 = this.tmpByteBuf[pos - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new XMLStreamException("Malformed UTF data");
                    }
                    this.tmpCharBuf[outBufLen++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block9;
                }
                case 14: {
                    if ((pos += 3) > len) {
                        throw new XMLStreamException("Malformed UTF data");
                    }
                    byte c2 = this.tmpByteBuf[pos - 2];
                    byte c3 = this.tmpByteBuf[pos - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new XMLStreamException();
                    }
                    this.tmpCharBuf[outBufLen++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block9;
                }
            }
            throw new XMLStreamException("Malformed UTF data");
        }
        return new String(this.tmpCharBuf, 0, outBufLen);
    }

    private int readInt() throws XMLStreamException {
        if (this.v1) {
            try {
                return this.dis.readInt();
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            byte b;
            int sum = 0;
            int shift = 0;
            do {
                b = this.dis.readByte();
                sum += (b & 0x7F) << shift;
                shift += 7;
            } while ((b & 0x80) == 128);
            return sum;
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    private static final class Attribute {
        String localName;
        String uri;
        String val;

        private Attribute() {
        }
    }

    private static final class Namespace {
        String uri;
        String prefix;

        private Namespace() {
        }
    }
}

