/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.xml.dom;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DOMSerializer {
    public static void serialize(Node node, XMLStreamWriter writer) throws XMLStreamException {
        DOMSerializer.serialize(node, writer, false, false);
    }

    public static void serialize(Node node, XMLStreamWriter writer, boolean stripPI, boolean stripComments) throws XMLStreamException {
        block0: while (node != null) {
            DOMSerializer.start(node, writer, stripPI, stripComments);
            Node tmp = node.getFirstChild();
            if (tmp != null) {
                node = tmp;
                continue;
            }
            tmp = node.getNextSibling();
            if (tmp != null) {
                DOMSerializer.end(node, writer);
                node = tmp;
                continue;
            }
            do {
                DOMSerializer.end(node, writer);
                node = node.getParentNode();
                if (node == null || node.getNextSibling() == null) continue;
                DOMSerializer.end(node, writer);
                node = node.getNextSibling();
                continue block0;
            } while (node != null);
        }
    }

    private static void start(Node node, XMLStreamWriter writer, boolean stripPI, boolean stripComments) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 1: {
                String localName = node.getLocalName();
                if (localName == null) {
                    localName = node.getNodeName();
                }
                writer.writeStartElement(node.getNamespaceURI(), localName);
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    String nodeName = attr.getNodeName();
                    if (nodeName.startsWith("xmlns")) {
                        String prefix = "";
                        if (nodeName.length() >= 5 && nodeName.charAt(5) == ':') {
                            prefix = nodeName.substring(6);
                        }
                        writer.writeNamespace(prefix, attr.getValue());
                        continue;
                    }
                    String uri = attr.getNamespaceURI();
                    String attrLocalName = attr.getLocalName();
                    if (uri == null && attrLocalName == null) {
                        attrLocalName = nodeName;
                    }
                    writer.writeAttribute(uri, attrLocalName, attr.getValue());
                }
                break;
            }
            case 3: {
                writer.writeCharacters(node.getNodeValue());
                break;
            }
            case 8: {
                if (stripComments) break;
                writer.writeComment(node.getNodeValue());
                break;
            }
            case 7: {
                if (stripPI) break;
                writer.writeProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 4: {
                writer.writeCData(node.getNodeValue());
                break;
            }
            case 9: {
                writer.writeStartDocument();
                break;
            }
            case 10: {
                DocumentType docNode = (DocumentType)node;
                writer.writeDTD("<!DOCTYPE " + docNode.getNodeName() + ">");
            }
        }
    }

    private static void end(Node node, XMLStreamWriter writer) throws XMLStreamException {
        if (node.getNodeType() == 1) {
            writer.writeEndElement();
        } else if (node.getNodeType() == 9) {
            writer.writeEndDocument();
            writer.close();
        }
    }
}

