/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.xml.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.utils.XXEUtils;

public class DOMDeserializer
implements XMLStreamConstants {
    public static Node deserialize(XMLStreamReader reader) throws XMLStreamException, ParserConfigurationException {
        DocumentBuilderFactory factory = XXEUtils.createDocumentBuilderFactoryInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        return DOMDeserializer.deserialize(reader, docBuilder);
    }

    public static Node deserialize(XMLStreamReader reader, DocumentBuilder docBuilder) throws XMLStreamException {
        Document document = null;
        Node parentNode = null;
        String localname = null;
        String uri = null;
        block9: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 7: {
                    document = docBuilder.newDocument();
                    parentNode = document;
                    break;
                }
                case 1: {
                    Element e;
                    localname = reader.getLocalName();
                    uri = reader.getNamespaceURI();
                    if (uri == null) {
                        e = document.createElement(localname);
                    } else {
                        String prefix = reader.getPrefix();
                        String prefixedName = prefix != null && prefix.length() > 0 ? prefix + ":" + localname : localname;
                        e = document.createElementNS(uri, prefixedName);
                    }
                    parentNode.appendChild(e);
                    parentNode = e;
                    int numAttrs = reader.getAttributeCount();
                    for (int i = 0; i < numAttrs; ++i) {
                        String localName = reader.getAttributeLocalName(i);
                        uri = reader.getAttributeNamespace(i);
                        String val = reader.getAttributeValue(i);
                        if (uri == null) {
                            e.setAttribute(localName, val);
                            continue;
                        }
                        String prefix = reader.getAttributePrefix(i);
                        String prefixedName = prefix != null && prefix.length() > 0 ? prefix + ":" + localname : localname;
                        e.setAttributeNS(uri, prefixedName, val);
                    }
                    int numNamespaces = reader.getNamespaceCount();
                    for (int i = 0; i < numNamespaces; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        uri = reader.getNamespaceURI(i);
                        String qName = null;
                        qName = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                        e.setAttributeNS("", qName, uri);
                    }
                    continue block9;
                }
                case 5: {
                    parentNode.appendChild(document.createComment(reader.getText()));
                    break;
                }
                case 8: {
                    break;
                }
                case 2: {
                    parentNode = parentNode.getParentNode();
                    break;
                }
                case 3: {
                    parentNode.appendChild(document.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 4: {
                    parentNode.appendChild(document.createTextNode(reader.getText()));
                }
            }
        }
        return document;
    }
}

