/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.utils.xml.babel.baseparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.jms.utils.xml.babel.baseparser.PrefixMapping;
import weblogic.jms.utils.xml.babel.baseparser.Symbol;
import weblogic.utils.collections.Stack;

public final class SymbolTable {
    private int depth = 0;
    private Stack table = new Stack();
    private Map values = new HashMap();

    public void clear() {
        this.depth = 0;
        this.table.clear();
        this.values.clear();
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean withinElement() {
        return this.depth > 0;
    }

    public void put(String name, String value) {
        this.table.push(new Symbol(name, value, this.depth));
        if (!this.values.containsKey(name)) {
            Stack valueStack = new Stack();
            valueStack.push(value);
            this.values.put(name, valueStack);
        } else {
            Stack valueStack = (Stack)this.values.get(name);
            valueStack.push(value);
        }
    }

    public String get(String name) {
        Stack valueStack = (Stack)this.values.get(name);
        if (valueStack == null || valueStack.isEmpty()) {
            return null;
        }
        return (String)valueStack.peek();
    }

    public void openScope() {
        ++this.depth;
    }

    public List closeScope() {
        return this.closeScope(true);
    }

    public List closeScope(boolean collect_outofscope_entries) {
        ArrayList<PrefixMapping> returnValues = null;
        if (!this.table.isEmpty()) {
            Symbol symbol = (Symbol)this.table.peek();
            int symbolDepth = symbol.depth;
            while (symbolDepth == this.depth && !this.table.isEmpty()) {
                symbol = (Symbol)this.table.pop();
                Stack valueStack = (Stack)this.values.get(symbol.name);
                String oldValue = (String)valueStack.pop();
                if (collect_outofscope_entries) {
                    String value = null;
                    if (!valueStack.isEmpty()) {
                        value = (String)valueStack.peek();
                    }
                    if (returnValues == null) {
                        returnValues = new ArrayList<PrefixMapping>();
                    }
                    returnValues.add(new PrefixMapping(symbol.name, value, oldValue));
                }
                if (this.table.isEmpty()) break;
                symbol = (Symbol)this.table.peek();
                symbolDepth = symbol.depth;
            }
        }
        --this.depth;
        if (returnValues == null || returnValues.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return returnValues;
    }

    public Set getAll(String name) {
        HashSet<String> result = new HashSet<String>();
        for (Symbol s : this.table) {
            if (!name.equals(s.getName())) continue;
            result.add(s.getValue());
        }
        return result;
    }

    public String toString() {
        Iterator i = this.table.iterator();
        String retVal = "";
        while (i.hasNext()) {
            Symbol symbol = (Symbol)i.next();
            retVal = retVal + symbol + "\n";
        }
        return retVal;
    }

    public static void main(String[] args) {
        try {
            SymbolTable st = new SymbolTable();
            st.openScope();
            st.put("x", "foo");
            st.put("y", "bar");
            System.out.println("1 x:" + st.get("x"));
            System.out.println("1 y:" + st.get("y"));
            st.openScope();
            st.put("x", "bar");
            st.put("y", "foo");
            st.openScope();
            st.put("x", "barbie");
            st.openScope();
            st.closeScope();
            System.out.println("3 x:" + st.get("x"));
            st.closeScope();
            System.out.println("2 x:" + st.get("x"));
            System.out.println("2 y:" + st.get("y"));
            System.out.print(st);
            st.closeScope();
            System.out.println("1 x:" + st.get("x"));
            System.out.println("1 y:" + st.get("y"));
            st.closeScope();
            System.out.print(st);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

