/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferDataOutputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.extensions.SequenceGapException;
import weblogic.jms.multicast.JMSFragmentStash;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTMObjectIOBypassImpl;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;

public class JMSTMSocket
implements Runnable {
    private static final int MAX_FRAGMENT_SIZE = 10240;
    private static final int PAYLOAD_FUDGE_FACTOR = 232;
    private static final int MESSAGE_VERSION = 1;
    private static final int FRAGMENT_VERSION = 1;
    private static final int VERSION_MASK = 4095;
    private static final int FRAGMENT_MAGIC = 199886103;
    protected static final int INITIAL_SEQNO = 0;
    private JMSTDMSocket sock;
    private final Object wantLock = new Object();
    private int wantLockCount = 0;
    private final JMSSession session;
    protected boolean closed;
    private final JMSTMObjectIOBypassImpl objectIOBypassImpl = new JMSTMObjectIOBypassImpl();
    private final byte[] bdosMsgBuffer = new byte[10240];
    private final byte[] bdosFragBuffer = new byte[10240];
    private final byte[] bdisFragBuffer = new byte[10240];
    private final BufferOutputStream bdosMsg = new BufferDataOutputStream((ObjectIOBypass)this.objectIOBypassImpl, this.bdosMsgBuffer);
    private final BufferOutputStream bdosFrag = new BufferDataOutputStream(null, this.bdosFragBuffer);
    private final BufferDataInputStream bdisFrag = new BufferDataInputStream(null, this.bdisFragBuffer);
    private HashMap stashes;
    private final int receivePort;
    private final HashMap groups;
    private final HashMap destinations;
    private final HashMap dests;
    private long fragmentDelay;
    private long lastDelay;
    private long lastSendTime;
    private static final String PROTOCOL = "WeblogicMulticast";

    public JMSTMSocket(JMSSession session, JMSTDMSocket sock, int fragmentDelay, int receivePort) throws IOException {
        this.session = session;
        this.sock = sock;
        this.receivePort = receivePort;
        this.fragmentDelay = fragmentDelay;
        this.lastDelay = 0L;
        this.lastSendTime = 0L;
        this.closed = false;
        this.groups = new HashMap();
        this.destinations = new HashMap();
        this.dests = new HashMap();
        this.stashes = new HashMap();
        this.bdosMsg.setIsJMSMulticastOutputStream();
        this.bdosFrag.setIsJMSMulticastOutputStream();
    }

    public final void setFragmentDelay(long fd) {
        this.fragmentDelay = fd;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            if (!this.closed) {
                this.closed = true;
                this.sock = null;
                this.stashes = null;
            }
        }
        this.decWantLockCount();
    }

    public final void send(MessageImpl message, DestinationImpl destination, JMSID connectionId, InetAddress group, int port, byte ttl, long nextSeqNo) throws IOException {
        String fullDestinationName = destination.getServerName() + "/" + destination.getName();
        if (this.closed) {
            throw new IOException("Attempt to send message on multicast socket that is closed");
        }
        this.bdosMsg.reset();
        this.bdosMsg.writeShort(1);
        this.bdosMsg.writeByte(message.getType());
        message.writeExternal(this.bdosMsg.getObjectOutput());
        connectionId.writeExternal(this.bdosMsg.getObjectOutput());
        this.bdosMsg.flush();
        int messageSize = this.bdosMsg.size();
        int offset = 0;
        int fragNum = 0;
        while (offset < messageSize) {
            this.bdosFrag.reset();
            this.bdosFrag.writeInt(199886103);
            this.bdosFrag.writeShort(1);
            this.bdosFrag.writeUTF(fullDestinationName);
            this.bdosFrag.writeLong(nextSeqNo);
            this.bdosFrag.writeInt(messageSize);
            this.bdosFrag.writeInt(fragNum);
            this.bdosFrag.writeInt(offset);
            this.bdosFrag.flush();
            int bytesThisTime = Math.min(10008 - this.bdosFrag.size(), messageSize - offset);
            this.bdosFrag.writeInt(bytesThisTime);
            if (bytesThisTime > 0) {
                this.bdosFrag.write(this.bdosMsgBuffer, offset, bytesThisTime);
            }
            this.bdosFrag.flush();
            this.sendThrottled(this.bdosFragBuffer, this.bdosFrag.size(), group, port, ttl);
            offset += bytesThisTime;
            ++fragNum;
        }
    }

    private void sendThrottled(byte[] buffer, int length, InetAddress group, int port, byte ttl) throws IOException {
        long currentTime = System.currentTimeMillis();
        this.lastDelay = Math.max(this.lastDelay - Math.max(currentTime - this.lastSendTime, 0L) + this.fragmentDelay, 0L);
        this.lastSendTime = currentTime;
        if (this.lastDelay > 0L) {
            try {
                Thread.sleep(this.lastDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.sock.send(buffer, length, group, port, ttl);
    }

    public final String getProtocol() {
        return PROTOCOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            MessageImpl message;
            if (this.getWantLockCount() != 0) {
                Thread.yield();
            }
            Runnable runnable = this;
            synchronized (runnable) {
                if (this.sock == null) {
                    break;
                }
                try {
                    message = this.receive();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (message == null) {
                    continue;
                }
            }
            runnable = this.session;
            synchronized (runnable) {
                JMSTMSocket jMSTMSocket = this;
                synchronized (jMSTMSocket) {
                    JMSID connectionId = message.getConnectionId();
                    message.setConnectionId(null);
                    DestinationImpl destination = (DestinationImpl)message.getJMSDestination();
                    String fullDestinationName = destination.getServerName() + "/" + destination.getName();
                    JMSPushRequest pushRequest = new JMSPushRequest(0, null, message);
                    ArrayList dstconsumers = (ArrayList)this.destinations.get(fullDestinationName);
                    if (dstconsumers == null) {
                        continue;
                    }
                    for (int i = 0; i < dstconsumers.size(); ++i) {
                        ConsumerInternal consumer;
                        block21: {
                            consumer = (ConsumerInternal)dstconsumers.get(i);
                            if (consumer.privateGetNoLocal() && this.session.getConnection().getJMSID().equals(connectionId)) continue;
                            try {
                                if (consumer.getExpressionEvaluator() != null && !consumer.getExpressionEvaluator().evaluate(message)) {
                                }
                                break block21;
                            }
                            catch (ExpressionEvaluationException eee) {
                            }
                            catch (ClassCastException cce) {}
                            continue;
                        }
                        JMSID consumerId = consumer.getJMSID();
                        if (consumerId == null) continue;
                        JMSPushEntry pushEntry = new JMSPushEntry(null, consumerId, Long.MAX_VALUE, Long.MAX_VALUE, 1, 0);
                        pushRequest.addPushEntry(pushEntry);
                    }
                    this.session.pushMessage(pushRequest, false);
                }
            }
        }
    }

    private MessageImpl receive() throws Exception {
        block16: {
            try {
                Chunk chunk;
                if (this.closed) {
                    return null;
                }
                if (this.sock.receive(this.bdisFragBuffer) == 0) {
                    return null;
                }
                this.bdisFrag.reset();
                if (this.bdisFrag.readInt() != 199886103) {
                    return null;
                }
                if ((this.bdisFrag.readShort() & 0xFFF) != 1) {
                    return null;
                }
                String fullDestinationName = this.bdisFrag.readUTF();
                DestinationImpl destination = (DestinationImpl)this.dests.get(fullDestinationName);
                if (destination == null) {
                    return null;
                }
                long seqNo = this.bdisFrag.readLong();
                int messageSize = this.bdisFrag.readInt();
                int fragNum = this.bdisFrag.readInt();
                int offset = this.bdisFrag.readInt();
                int payloadSize = this.bdisFrag.readInt();
                JMSFragmentStash fragStash = (JMSFragmentStash)this.stashes.get(fullDestinationName);
                if (fragStash == null) {
                    fragStash = new JMSFragmentStash(this.session, seqNo, destination);
                    this.stashes.put(fullDestinationName, fragStash);
                }
                if ((chunk = fragStash.processFragment(seqNo, messageSize, fragNum, offset, this.bdisFrag, payloadSize)) != null) {
                    BufferInputStreamChunked bisc = new BufferInputStreamChunked(this.objectIOBypassImpl, new ChunkedDataInputStream(chunk, 0));
                    if ((bisc.readShort() & 0xFFF) != 1) {
                        return null;
                    }
                    MessageImpl message = MessageImpl.createMessageImpl(bisc.readByte());
                    message.readExternal(bisc);
                    JMSID connectionId = new JMSID();
                    connectionId.readExternal(bisc);
                    message.setJMSDestinationImpl(destination);
                    message.setConnectionId(connectionId);
                    return message;
                }
            }
            catch (IOException e) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("IOException", e);
                }
            }
            catch (ClassNotFoundException e) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("ClassNotFoundException", e);
                }
            }
            catch (SequenceGapException e) {
                this.session.onException(e);
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("SequenceGapException", e);
                }
            }
            catch (Throwable t) {
                if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block16;
                JMSDebug.JMSFrontEnd.debug("Throwable", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void joinGroup(DestinationImpl destination, ConsumerInternal consumer) throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                InetAddress group;
                if (this.sock == null) {
                    throw new IOException("socket closed");
                }
                if (destination.getPort() != this.receivePort) {
                    throw new IOException("Wrong port");
                }
                String fullDestinationName = destination.getServerName() + "/" + destination.getName();
                try {
                    group = InetAddress.getByName(destination.getMulticastAddress());
                }
                catch (UnknownHostException ne) {
                    throw new IOException("Cannot parse multicast address " + destination.getMulticastAddress());
                }
                ArrayList<ConsumerInternal> grpconsumers = (ArrayList<ConsumerInternal>)this.groups.get(group);
                if (grpconsumers != null) {
                    if (grpconsumers.indexOf(consumer) < 0) {
                        grpconsumers.add(consumer);
                        ArrayList<ConsumerInternal> dstconsumers = (ArrayList<ConsumerInternal>)this.destinations.get(fullDestinationName);
                        if (dstconsumers == null) {
                            dstconsumers = new ArrayList<ConsumerInternal>();
                            this.destinations.put(fullDestinationName, dstconsumers);
                            this.dests.put(fullDestinationName, destination);
                        }
                        dstconsumers.add(consumer);
                    }
                } else {
                    this.sock.joinGroup(group);
                    grpconsumers = new ArrayList<ConsumerInternal>();
                    grpconsumers.add(consumer);
                    this.groups.put(group, grpconsumers);
                    ArrayList<ConsumerInternal> dstconsumers = new ArrayList<ConsumerInternal>();
                    this.destinations.put(fullDestinationName, dstconsumers);
                    this.dests.put(fullDestinationName, destination);
                    dstconsumers.add(consumer);
                }
            }
            catch (Throwable t) {
                this.decWantLockCount();
                throw new IOException(t.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void leaveGroup(DestinationImpl destination, ConsumerInternal consumer) throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                int index;
                InetAddress group;
                if (this.sock == null) {
                    throw new IOException("socket closed");
                }
                try {
                    group = InetAddress.getByName(destination.getMulticastAddress());
                }
                catch (UnknownHostException ne) {
                    throw new IOException("Cannot parse multicast address " + destination.getMulticastAddress());
                }
                ArrayList grpconsumers = (ArrayList)this.groups.get(group);
                if (grpconsumers == null || (index = grpconsumers.indexOf(consumer)) < 0) {
                    throw new IOException("Cannot find group info about consumer");
                }
                grpconsumers.remove(index);
                String fullDestinationName = destination.getServerName() + "/" + destination.getName();
                ArrayList dstconsumers = (ArrayList)this.destinations.get(fullDestinationName);
                if (dstconsumers == null || (index = dstconsumers.indexOf(consumer)) < 0) {
                    throw new IOException("can not find destination info about consumer");
                }
                dstconsumers.remove(index);
                if (dstconsumers.size() == 0) {
                    this.destinations.remove(fullDestinationName);
                    this.dests.remove(fullDestinationName);
                    this.stashes.remove(fullDestinationName);
                }
                if (grpconsumers.size() == 0) {
                    this.groups.remove(group);
                    this.sock.leaveGroup(group);
                }
            }
            catch (Throwable t) {
                this.decWantLockCount();
                throw new IOException(t.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                if (this.sock == null) {
                    throw new IOException("socket is closed");
                }
                for (InetAddress group : this.groups.keySet()) {
                    this.sock.joinGroup(group);
                }
                this.stashes = new HashMap();
            }
            catch (Throwable t) {
                this.decWantLockCount();
                throw new IOException(t.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                if (this.sock == null) {
                    throw new IOException("socket is closed");
                }
                for (InetAddress group : this.groups.keySet()) {
                    this.sock.leaveGroup(group);
                }
                this.stashes = null;
            }
            catch (Throwable t) {
                this.decWantLockCount();
                throw new IOException(t.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            ++this.wantLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            --this.wantLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            return this.wantLockCount;
        }
    }
}

