/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferDataOutputStream;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.XMLMessageImpl;

public final class JMSTMObjectIOBypassImpl
implements ObjectIOBypass {
    private static final Class[] CLASS_ARRAY = new Class[]{null, null, null, null, null, BytesMessageImpl.class, HdrMessageImpl.class, MapMessageImpl.class, ObjectMessageImpl.class, StreamMessageImpl.class, TextMessageImpl.class, XMLMessageImpl.class, DestinationImpl.class, JMSID.class, JMSMessageId.class, JMSServerId.class, null, null, String.class, null};
    public static final short JMSSUBSCRIBER = 1;
    public static final short JMSBEXAXID = 3;
    public static final short JMSBEXATRANENTRYRECEIVE = 4;
    public static final short JMSBYTESMESSAGE = 5;
    public static final short JMSHDRMESSAGE = 6;
    public static final short JMSMAPMESSAGE = 7;
    public static final short JMSOBJECTMESSAGE = 8;
    public static final short JMSSTREAMMESSAGE = 9;
    public static final short JMSTEXTMESSAGE = 10;
    public static final short JMSXMLMESSAGE = 11;
    public static final short DURABLETOPICMESSAGEINFO = 17;
    private static final short STRING = 18;
    public static final short JMSDISTSUBSCRIBER = 19;
    private static HashMap classToId;
    private static final short CODE_NULL = -1;
    private static final short CODE_NOTFOUND = -3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSTMObjectIOBypassImpl() {
        Class[] classArray = CLASS_ARRAY;
        synchronized (CLASS_ARRAY) {
            if (classToId != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            classToId = new HashMap();
            for (short i = 0; i < CLASS_ARRAY.length; i = (short)((short)(i + 1))) {
                if (CLASS_ARRAY[i] == null) continue;
                classToId.put(CLASS_ARRAY[i], new Short(i));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final short getCode(Object obj) {
        if (obj == null) {
            return -1;
        }
        Short s = (Short)classToId.get(obj.getClass());
        if (s == null) {
            return -3;
        }
        return s;
    }

    @Override
    public final void writeObject(ObjectOutput out, Object obj) throws IOException {
        if (obj == null) {
            out.writeShort(-1);
            return;
        }
        Short s = (Short)classToId.get(obj.getClass());
        if (s == null) {
            throw new IOException("Can't serialize class, type=" + obj.getClass().getName());
        }
        short v = s;
        out.writeShort(v);
        if (v == 18) {
            BufferDataOutputStream.writeUTF32(out, (String)obj);
        } else {
            ((Externalizable)obj).writeExternal(out);
        }
    }

    @Override
    public final Object readObject(ObjectInput in) throws ClassNotFoundException, IOException {
        Externalizable ext;
        short typeNum = in.readShort();
        if (typeNum == -1) {
            return null;
        }
        if (typeNum == 18) {
            return BufferDataInputStream.readUTF32(in);
        }
        if (typeNum < 0 || typeNum >= CLASS_ARRAY.length || CLASS_ARRAY[typeNum] == null) {
            throw new IOException("Unrecognized class code " + typeNum);
        }
        Class c = CLASS_ARRAY[typeNum];
        try {
            ext = (Externalizable)c.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ClassNotFoundException(ie.toString() + ", " + c.getName());
        }
        catch (IllegalAccessException iae) {
            throw new ClassNotFoundException(iae.toString() + ", " + c.getName());
        }
        catch (SecurityException se) {
            throw new ClassNotFoundException(se.toString() + ", " + c.getName());
        }
        ext.readExternal(in);
        return ext;
    }
}

