/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import jakarta.jms.Destination;
import java.io.IOException;
import java.util.HashMap;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.extensions.SequenceGapException;
import weblogic.utils.io.Chunk;

public final class JMSFragmentStash {
    private static final int INVALID_FRAGMENT_NUMBER = -1;
    private final JMSSession session;
    private long currentSeqNo;
    private int lastFragNum;
    private HashMap<Integer, Chunk> chunkMap = null;
    private int numFragmentsReceived;
    private final Destination destination;

    JMSFragmentStash(JMSSession session, long seqNo, Destination destination) {
        this.session = session;
        this.currentSeqNo = seqNo - 1L;
        this.destination = destination;
    }

    Chunk processFragment(long seqNo, int messageSize, int fragNum, int offset, BufferDataInputStream bdisFrag, int payloadSize) throws SequenceGapException, IOException {
        Chunk tail;
        if (seqNo < this.currentSeqNo) {
            return null;
        }
        if (seqNo > this.currentSeqNo) {
            int count = (int)(seqNo - this.currentSeqNo);
            if (count > 1) {
                this.session.onException(new SequenceGapException("Missing message(s)", this.destination, count - 1));
            }
            this.currentSeqNo = seqNo;
            this.lastFragNum = -1;
            this.chunkMap = null;
            this.numFragmentsReceived = 0;
        }
        if (this.chunkMap == null || !this.chunkMap.containsKey(offset)) {
            Chunk chunk = Chunk.createOneSharedChunk(bdisFrag, payloadSize);
            if (offset + payloadSize >= messageSize) {
                this.lastFragNum = fragNum;
                if (this.lastFragNum == 0) {
                    return chunk;
                }
            }
            if (this.chunkMap == null) {
                this.chunkMap = new HashMap();
            }
            this.chunkMap.put(offset, chunk);
            ++this.numFragmentsReceived;
        }
        if (this.numFragmentsReceived != this.lastFragNum + 1) {
            return null;
        }
        Chunk head = tail = this.chunkMap.remove(0);
        int currentOffset = head.buf.length;
        while (this.numFragmentsReceived > 1) {
            tail = tail.next = this.chunkMap.remove(currentOffset);
            --this.numFragmentsReceived;
        }
        return head;
    }
}

