/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.frontend.FESessionCreateResponse;
import weblogic.messaging.dispatcher.Response;

public final class FESessionCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 5179168005654945285L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TRANSACTED_MASK = 256;
    private static final int XA_SESSION_MASK = 512;
    private boolean transacted;
    private boolean xaSession;
    private int acknowledgeMode;
    private transient String workManager;

    public FESessionCreateRequest(JMSID connectionId, boolean transacted, boolean xaSession, int acknowledgeMode, String workManager) {
        super(connectionId, 6663);
        this.transacted = transacted;
        this.xaSession = xaSession;
        this.acknowledgeMode = acknowledgeMode;
        this.workManager = workManager;
    }

    public final boolean getTransacted() {
        return this.transacted;
    }

    public final boolean getXASession() {
        return this.xaSession;
    }

    public final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public String getPushWorkManager() {
        return this.workManager;
    }

    @Override
    public int remoteSignature() {
        return 18;
    }

    @Override
    public Response createResponse() {
        return new FESessionCreateResponse();
    }

    public FESessionCreateRequest() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int version;
        out = this.getVersionedStream(out);
        int mask = version = 1;
        if (this.transacted) {
            mask |= 0x100;
        }
        if (this.xaSession) {
            mask |= 0x200;
        }
        out.writeInt(mask);
        super.writeExternal(out);
        out.writeShort((short)this.acknowledgeMode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 1);
        }
        super.readExternal(in);
        this.transacted = (mask & 0x100) != 0;
        this.xaSession = (mask & 0x200) != 0;
        this.acknowledgeMode = in.readShort();
    }
}

