/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSEnumerationNextElementResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class FEEnumerationNextElementRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 8195654245705975348L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    static final int START = 0;
    static final int CONTINUE = 1;

    public FEEnumerationNextElementRequest(JMSID enumerationId) {
        super(enumerationId, 4108);
    }

    @Override
    public int remoteSignature() {
        return 18;
    }

    @Override
    public Response createResponse() {
        return new JMSEnumerationNextElementResponse();
    }

    public FEEnumerationNextElementRequest() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out = this.getVersionedStream(out);
        out.writeInt(1);
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 1);
        }
        super.readExternal(in);
    }
}

