/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.Response;

public final class FEConsumerReceiveRequest
extends Request
implements Externalizable,
CompletionListener {
    static final long serialVersionUID = 8859525699995436679L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TIMEOUT_MASK = 3840;
    private static final int TIMEOUT_NEVER = 256;
    private static final int TIMEOUT_NO_WAIT = 512;
    static final int START = 0;
    static final int CONTINUE = 1;
    private long timeout;
    private transient CompletionListener appListener;
    private transient ConsumerInternal consumerInternal;

    public FEConsumerReceiveRequest(JMSID consumerId, long timeout, CompletionListener appListener, ConsumerInternal consumerInternal) {
        super(consumerId, 3338);
        this.timeout = timeout;
        if (appListener != null) {
            this.consumerInternal = consumerInternal;
            this.appListener = appListener;
            this.setListener(this);
        }
    }

    long getTimeout() {
        return this.timeout;
    }

    @Override
    public int remoteSignature() {
        return 19;
    }

    @Override
    public Response createResponse() {
        return new JMSConsumerReceiveResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(Object result) {
        CompletionListener stableListener;
        FEConsumerReceiveRequest fEConsumerReceiveRequest = this;
        synchronized (fEConsumerReceiveRequest) {
            if (this.appListener == null) {
                return;
            }
            stableListener = this.appListener;
            this.appListener = null;
        }
        try {
            this.consumerInternal.getSession().proccessReceiveResponse(this.consumerInternal, result, stableListener);
        }
        catch (Throwable throwable) {
            stableListener.onException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(Throwable throwable) {
        CompletionListener stableListener;
        FEConsumerReceiveRequest fEConsumerReceiveRequest = this;
        synchronized (fEConsumerReceiveRequest) {
            if (this.appListener == null) {
                return;
            }
            stableListener = this.appListener;
            this.appListener = null;
        }
        stableListener.onException(throwable);
    }

    public FEConsumerReceiveRequest() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out = this.getVersionedStream(out);
        int mask = 1;
        if (this.timeout == Long.MAX_VALUE) {
            mask |= 0x100;
        } else if (this.timeout == 0x7FFFFFFFFFFFFFFEL) {
            mask |= 0x200;
        }
        out.writeInt(mask);
        super.writeExternal(out);
        if ((mask & 0xF00) == 0) {
            out.writeLong(this.timeout);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 1);
        }
        super.readExternal(in);
        this.timeout = (mask & 0xF00) == 256 ? Long.MAX_VALUE : ((mask & 0xF00) == 512 ? 0x7FFFFFFFFFFFFFFEL : in.readLong());
    }
}

