/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FEConsumerCloseRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -1696547268688497887L;
    private long lastSequenceNumber;
    private long firstSequenceNumberNotSeen;
    private static final int EXTVERSION_PRE_1221 = 1;
    private static final int EXTVERSION_1221 = 2;
    private static final int EXTVERSION = 2;
    private static final int VERSION_MASK = 255;
    private static final int SEQUENCE_NUMBER_MASK = 256;
    private static final int FIRST_SEQUENCE_NUMBER_NOT_SEEN_MASK = 512;

    public FEConsumerCloseRequest(JMSID consumerId, long lastSequenceNumber, long firstSequenceNumberNotSeen) {
        super(consumerId, 2570);
        this.lastSequenceNumber = lastSequenceNumber;
        this.firstSequenceNumberNotSeen = firstSequenceNumberNotSeen;
    }

    public long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public long getFirstSequenceNumberNotSeen() {
        return this.firstSequenceNumberNotSeen;
    }

    @Override
    public int remoteSignature() {
        return 18;
    }

    @Override
    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FEConsumerCloseRequest() {
    }

    private byte getVersion(Object o) throws IOException {
        if (o instanceof PeerInfoable) {
            PeerInfo pi = ((PeerInfoable)o).getPeerInfo();
            if (pi.compareTo(PeerInfo.VERSION_1221) < 0) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int peerVersion;
        out = this.getVersionedStream(out);
        int mask = peerVersion = this.getVersion(out);
        if (this.lastSequenceNumber != 0L) {
            mask |= 0x100;
        }
        if (peerVersion >= 2 && this.firstSequenceNumberNotSeen != 0L) {
            mask |= 0x200;
        }
        out.writeInt(mask);
        super.writeExternal(out);
        if (this.lastSequenceNumber != 0L) {
            out.writeLong(this.lastSequenceNumber);
        }
        if (peerVersion >= 2 && this.firstSequenceNumberNotSeen != 0L) {
            out.writeLong(this.firstSequenceNumberNotSeen);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 2 && version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 2);
        }
        super.readExternal(in);
        if ((mask & 0x100) != 0) {
            this.lastSequenceNumber = in.readLong();
        }
        if ((mask & 0x200) != 0) {
            this.firstSequenceNumberNotSeen = in.readLong();
        }
    }
}

