/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jms.common.CDS;
import weblogic.jms.common.CDSSecurityHandle;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipChangeEventImpl;
import weblogic.jms.common.DDMembershipChangeListener;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSOBSHelper;
import weblogic.jms.common.PartitionUtils;
import weblogic.jms.extensions.DestinationAvailabilityListener;
import weblogic.jms.extensions.DestinationDetail;
import weblogic.jms.extensions.DestinationDetailImpl;
import weblogic.jms.extensions.RegistrationHandle;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.common.JMSCICHelper;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.work.InheritableThreadContext;

public class JMSDestinationAvailabilityHelper {
    private static final int REGISTRATION_MODE_DEFAULT = 0;
    private static final int REGISTRATION_MODE_LOCAL_ONLY = 1;
    private static final int REGISTRATION_MODE_ALL = 2;
    private static final int JNDI_CONNECT_TIMEOUT = Integer.parseInt(System.getProperty("weblogic.jndi.connectTimeout", "60000"));
    private static final int JNDI_RESPONSE_READ_TIMEOUT = Integer.parseInt(System.getProperty("weblogic.jndi.responseReadTimeout", "60000"));
    private static JMSDestinationAvailabilityHelper INSTANCE = new JMSDestinationAvailabilityHelper();
    private static boolean IS_COMPATIBLE;
    private String currentServerName = null;
    private String currentClusterName = null;
    private String currentDomainName = null;
    private boolean isServer;
    private static boolean coreEngine;
    private static boolean initialized;
    private static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String OBS_JNDI_FACTORY = "weblogic.jms.WLInitialContextFactory";

    private JMSDestinationAvailabilityHelper() {
    }

    private void initialize() {
        try {
            if (KernelStatus.isServer() && !coreEngine) {
                Class<?> clz = Class.forName("weblogic.jms.common.JMSManagementHelper");
                Object jmsServiceInstance = clz.newInstance();
                Method m = clz.getMethod("getServerName", new Class[0]);
                this.currentServerName = (String)m.invoke(jmsServiceInstance, new Object[0]);
                m = clz.getMethod("getClusterName", new Class[0]);
                this.currentClusterName = (String)m.invoke(jmsServiceInstance, new Object[0]);
                m = clz.getMethod("getDomainName", new Class[0]);
                this.currentDomainName = (String)m.invoke(jmsServiceInstance, new Object[0]);
            } else {
                this.currentServerName = "";
                CrossDomainSecurityManager.ensureSubjectManagerInitialized();
            }
        }
        catch (Exception exc) {
            throw new AssertionError((Object)exc);
        }
        initialized = true;
    }

    public static synchronized JMSDestinationAvailabilityHelper getInstance() {
        if (!initialized) {
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    public RegistrationHandle register(Hashtable properties, String destJNDIName, DestinationAvailabilityListener listener) {
        return this.register(new PropertiesContextFactory(properties), destJNDIName, listener, 2, null);
    }

    public RegistrationHandle register(Hashtable properties, String destJNDIName, DestinationAvailabilityListener listener, Context envContext) {
        return this.register(new PropertiesContextFactory(properties), destJNDIName, listener, 2, envContext);
    }

    private RegistrationHandle register(Hashtable properties, String destJNDIName, DestinationAvailabilityListener listener, int mode) {
        return this.register(new PropertiesContextFactory(properties), destJNDIName, listener, mode, null);
    }

    private RegistrationHandle register(ContextFactory ctxFactory, String destJNDIName, DestinationAvailabilityListener listener, int mode, Context envContext) {
        if (destJNDIName == null) {
            throw new AssertionError((Object)"register(): destJNDIName cannot be null");
        }
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new AssertionError((Object)("register(): Invalid registration mode " + mode));
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Registering the listener " + listener + " for destJNDIName=" + destJNDIName);
        }
        DestinationAvailabilityListenerWrapper destinationAvailabilityListenerWrapper = new DestinationAvailabilityListenerWrapper(ctxFactory, destJNDIName, listener, mode, envContext);
        CDSSecurityHandle secHandle = CDS.getCDS().registerForDDMembershipInformation(destinationAvailabilityListenerWrapper);
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Successfully registered the listener " + listener + " for destJNDIName=" + destJNDIName);
        }
        ctxFactory.setSecurityHandle(secHandle);
        return destinationAvailabilityListenerWrapper;
    }

    private boolean isLocalWLSServer(DDMemberInformation memberInformation) {
        return this.currentDomainName != null && this.currentDomainName.equals(memberInformation.getDDMemberDomainName()) && this.currentServerName != null && this.currentServerName.equals(memberInformation.getDDMemberServerName());
    }

    private boolean isLocalCluster(DDMemberInformation memberInformation) {
        return this.currentDomainName != null && this.currentDomainName.equals(memberInformation.getDDMemberDomainName()) && this.currentClusterName != null && this.currentClusterName.equals(memberInformation.getDDMemberClusterName());
    }

    private boolean isLocalServerDDMember(DDMemberInformation memberInformation) {
        return this.currentServerName != null && this.currentServerName.equals(memberInformation.getDDMemberServerName()) && this.currentClusterName.equals(memberInformation.getDDMemberClusterName()) && this.currentDomainName.equals(memberInformation.getDDMemberDomainName());
    }

    private boolean isRemoteClusterDDMember(DDMemberInformation memberInformation) {
        return this.currentDomainName == null || this.currentClusterName == null || !this.currentClusterName.equals(memberInformation.getDDMemberClusterName()) || !this.currentDomainName.equals(memberInformation.getDDMemberDomainName());
    }

    private DDMemberInformation[] getLocalServerDDMembers(DDMemberInformation[] ddMemberInfo) {
        ArrayList<DDMemberInformation> localDDMembersList = new ArrayList<DDMemberInformation>();
        if (ddMemberInfo != null) {
            for (int i = 0; i < ddMemberInfo.length; ++i) {
                if (!this.isLocalServerDDMember(ddMemberInfo[i])) continue;
                localDDMembersList.add(ddMemberInfo[i]);
            }
        }
        if (localDDMembersList.size() != 0) {
            return localDDMembersList.toArray(new DDMemberInformation[localDDMembersList.size()]);
        }
        return null;
    }

    private DDMemberInformation[] getRemoteClusterDDMembers(DDMemberInformation[] ddMemberInfo) {
        ArrayList<DDMemberInformation> localDDMembersList = new ArrayList<DDMemberInformation>();
        if (ddMemberInfo != null) {
            for (int i = 0; i < ddMemberInfo.length; ++i) {
                if (!this.isRemoteClusterDDMember(ddMemberInfo[i])) continue;
                localDDMembersList.add(ddMemberInfo[i]);
            }
        }
        if (localDDMembersList.size() != 0) {
            return localDDMembersList.toArray(new DDMemberInformation[localDDMembersList.size()]);
        }
        return null;
    }

    private DDMemberInformation[][] filterDDMembers(DDMemberInformation[] removedDDMemberInfo, DDMemberInformation[] addedDDMemberInfo) {
        HashMap<String, DDMemberInformation> newMap = new HashMap<String, DDMemberInformation>();
        for (int i = 0; addedDDMemberInfo != null && i < addedDDMemberInfo.length; ++i) {
            newMap.put(addedDDMemberInfo[i].getMemberName(), addedDDMemberInfo[i]);
        }
        HashMap<String, DDMemberInformation> oldMap = new HashMap<String, DDMemberInformation>();
        for (int i = 0; removedDDMemberInfo != null && i < removedDDMemberInfo.length; ++i) {
            oldMap.put(removedDDMemberInfo[i].getMemberName(), removedDDMemberInfo[i]);
        }
        LinkedList<DDMemberInformation> added = new LinkedList<DDMemberInformation>();
        LinkedList<DDMemberInformation> removed = new LinkedList<DDMemberInformation>();
        for (DDMemberInformation oldMember : oldMap.values()) {
            DDMemberInformation newMember = (DDMemberInformation)newMap.remove(oldMember.getMemberName());
            if (newMember == null) {
                removed.add(oldMember);
                continue;
            }
            if (!this.changed(oldMember, newMember)) continue;
            removed.add(oldMember);
            added.add(newMember);
        }
        added.addAll(newMap.values());
        DDMemberInformation[] removedArray = null;
        if (removed.size() > 0) {
            removedArray = removed.toArray(new DDMemberInformation[0]);
        }
        DDMemberInformation[] addedArray = null;
        if (added.size() > 0) {
            addedArray = added.toArray(new DDMemberInformation[0]);
        }
        return new DDMemberInformation[][]{removedArray, addedArray};
    }

    private boolean changed(DDMemberInformation oldMember, DDMemberInformation member) {
        DestinationImpl dImpl = (DestinationImpl)member.getDestination();
        DestinationImpl oldImpl = (DestinationImpl)oldMember.getDestination();
        if (!dImpl.getDestinationId().equals(oldImpl.getDestinationId())) {
            return true;
        }
        if (dImpl.getDispatcherId() != null && !dImpl.getDispatcherId().equals(oldImpl.getDispatcherId())) {
            return true;
        }
        if (!dImpl.getServerName().equals(oldImpl.getServerName())) {
            return true;
        }
        return dImpl.getJMSServerConfigName() != null && oldImpl.getJMSServerConfigName() != null && !dImpl.getJMSServerConfigName().equals(oldImpl.getJMSServerConfigName());
    }

    private DDMemberInformation[] filterDDMembers(DestinationAvailabilityListenerWrapper listener, DDMemberInformation[] ddMemberInfo) {
        DDMemberInformation[] filteredDDMembers = null;
        assert (listener != null);
        if (!this.isServer) {
            return ddMemberInfo;
        }
        int mode = listener.getMode();
        if (ddMemberInfo != null) {
            if (mode == 0) {
                DDMemberInformation[] localDDMembers = this.getLocalServerDDMembers(ddMemberInfo);
                filteredDDMembers = localDDMembers != null ? localDDMembers : this.getRemoteClusterDDMembers(ddMemberInfo);
            } else if (mode == 1) {
                DDMemberInformation[] localDDMembers = this.getLocalServerDDMembers(ddMemberInfo);
                if (localDDMembers != null) {
                    filteredDDMembers = localDDMembers;
                }
            } else {
                filteredDDMembers = ddMemberInfo;
            }
        }
        return filteredDDMembers;
    }

    private int getDestinationTypeAsInt(DDMemberInformation ddMemberInfo) {
        boolean isDD = ddMemberInfo.isDD();
        String type = ddMemberInfo.getDDType();
        if (!type.equals("jakarta.jms.Queue") && !type.equals("jakarta.jms.Topic")) {
            throw new AssertionError((Object)"Unknown Destination Type");
        }
        boolean isQueue = type.equals("jakarta.jms.Queue");
        if (ddMemberInfo.getDestination() != null) {
            if (isDD) {
                if (isQueue) {
                    return 4;
                }
                if (ddMemberInfo.getForwardingPolicy() == 0) {
                    return 6;
                }
                return 5;
            }
            if (isQueue) {
                return 0;
            }
            return 1;
        }
        if (isQueue) {
            return 2;
        }
        return 3;
    }

    private DestinationDetail createDestinationDetailFromDDMemberInformation(DDMemberInformation ddMemberInfo) {
        int deploymentMemberType;
        DestinationImpl destination;
        String persistentStoreName;
        String jmsServerConfigName;
        String jmsServerInstanceName;
        String createDestinationIdentifier;
        int dType = this.getDestinationTypeAsInt(ddMemberInfo);
        String partitionName = ddMemberInfo.getPartitionName();
        String ddConfigName = ddMemberInfo.getDDConfigName();
        String ddJndiName = ddMemberInfo.getDDJNDIName();
        int destinationType = this.getDestinationTypeAsInt(ddMemberInfo);
        String memberConfigName = ddMemberInfo.getMemberName();
        String memberJndiName = ddMemberInfo.getDDMemberJndiName();
        String memberLocalJndiName = ddMemberInfo.getDDMemberLocalJndiName();
        String serverName = ddMemberInfo.getDDMemberServerName();
        String migratableTargetName = ddMemberInfo.getDDMemberMigratableTargetName();
        boolean isLocalWLSServer = this.isLocalWLSServer(ddMemberInfo);
        boolean isLocalCluster = this.isLocalCluster(ddMemberInfo);
        boolean isAdvancedTopicSupported = ddMemberInfo.isAdvancedTopicSupported();
        if (dType != 2 && dType != 3) {
            DestinationImpl destinationImpl = (DestinationImpl)ddMemberInfo.getDestination();
            createDestinationIdentifier = destinationImpl.getCreateDestinationArgument();
            jmsServerInstanceName = destinationImpl.isPre90() ? null : destinationImpl.getServerName();
            jmsServerConfigName = destinationImpl.isPre90() ? null : destinationImpl.getJMSServerConfigName();
            persistentStoreName = destinationImpl.getPersistentStoreName();
            destination = destinationImpl;
            deploymentMemberType = ddMemberInfo.getDeploymentDDMemberType();
            if (!PartitionUtils.isDomain(partitionName)) {
                ddConfigName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, ddConfigName);
                memberConfigName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, memberConfigName);
                memberJndiName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, memberJndiName);
                memberLocalJndiName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, memberLocalJndiName);
                createDestinationIdentifier = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, "!@/", createDestinationIdentifier);
                jmsServerInstanceName = PartitionUtils.stripDecoratedPartitionName(partitionName, jmsServerInstanceName);
                jmsServerConfigName = PartitionUtils.stripDecoratedPartitionName(partitionName, jmsServerConfigName);
            }
        } else {
            createDestinationIdentifier = null;
            jmsServerInstanceName = null;
            jmsServerConfigName = null;
            persistentStoreName = null;
            destination = null;
            deploymentMemberType = 4;
            if (!PartitionUtils.isDomain(partitionName)) {
                ddConfigName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, ddConfigName);
                memberConfigName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, memberConfigName);
                memberJndiName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, memberJndiName);
                memberLocalJndiName = PartitionUtils.stripDecoratedPartitionNamesFromCombinedName(partitionName, memberLocalJndiName);
            }
        }
        return new DestinationDetailImpl(ddConfigName, ddJndiName, destinationType, memberConfigName, memberJndiName, memberLocalJndiName, createDestinationIdentifier, jmsServerInstanceName, jmsServerConfigName, persistentStoreName, destination, serverName, migratableTargetName, isLocalWLSServer, isLocalCluster, isAdvancedTopicSupported, deploymentMemberType, partitionName);
    }

    private void printDDMemberInfo(DDMemberInformation[] ddMemberInfo) {
        if (ddMemberInfo == null) {
            return;
        }
        for (int i = 0; i < ddMemberInfo.length; ++i) {
            System.out.println("member[" + i + "]:" + ddMemberInfo[i].toString());
        }
    }

    static {
        coreEngine = false;
        initialized = false;
        try {
            Class.forName("com.bea.core.encryption.EncryptionService");
            coreEngine = true;
        }
        catch (Throwable th) {
            coreEngine = false;
        }
        try {
            String compatibilityProp = System.getProperty("weblogic.jms.dahelper.compatibility", "false");
            IS_COMPATIBLE = Boolean.parseBoolean(compatibilityProp);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static interface ContextFactory {
        public Context getJNDIContext() throws NamingException;

        public AbstractSubject getRegistrationSubject();

        public void close();

        public String getProviderURL();

        public void refreshCtx() throws NamingException;

        public void setSecurityHandle(CDSSecurityHandle var1);

        public Object lookup(String var1) throws NamingException;

        public AbstractSubject getRightJNDISubject();

        public AbstractSubject getRightJMSSubject();

        public AbstractSubject getOrigSubject();

        public boolean isOrigSubDowngraded();
    }

    private final class RefreshWaitLock {
        int waiters;
        NamingException ne;

        private RefreshWaitLock() {
        }

        private synchronized void complete(NamingException exception) {
            this.ne = exception;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }

        private synchronized boolean waitUntilComplete() throws NamingException {
            if (this.waiters == 0) {
                return false;
            }
            ++this.waiters;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.waiters;
            if (this.ne != null) {
                throw this.ne;
            }
            return true;
        }
    }

    private class PropertiesContextFactory
    implements ContextFactory {
        final Hashtable properties;
        AbstractSubject origSubject;
        AbstractSubject registrationSubject;
        Context ctx;
        CDSSecurityHandle secHandle;
        boolean origSubDowngraded = false;
        RefreshWaitLock refreshWaitLock = new RefreshWaitLock();
        InheritableThreadContext originalContext;

        PropertiesContextFactory(Hashtable properties) {
            String jndiInitContextFactory;
            Hashtable hashtable = this.properties = properties == null ? new Hashtable() : new Hashtable(properties);
            if (JMSDebug.JMSOBS.isDebugEnabled()) {
                JMSDebug.JMSOBS.debug("PropertiesContextFactory:constructor properties=" + JMSOBSHelper.filterProperties(properties));
            }
            if (this.properties.containsKey("java.naming.factory.initial") && JMSDestinationAvailabilityHelper.OBS_JNDI_FACTORY.equals(jndiInitContextFactory = (String)this.properties.get("java.naming.factory.initial"))) {
                this.properties.put("java.naming.factory.initial", JMSDestinationAvailabilityHelper.JNDI_FACTORY);
                if (JMSDebug.JMSOBS.isDebugEnabled()) {
                    JMSDebug.JMSOBS.debug("PropertiesContextFactory:constructor restrict OBS internally, replace weblogic.jms.WLInitialContextFactory with weblogic.jndi.WLInitialContextFactory this.properties=" + JMSOBSHelper.filterProperties(this.properties));
                }
            }
            if (!this.properties.containsKey("weblogic.jndi.connectTimeout")) {
                if (JMSDebug.JMSOBS.isDebugEnabled()) {
                    JMSDebug.JMSOBS.debug("PropertiesContextFactory:constructor set weblogic.jndi.connectTimeout to " + JNDI_CONNECT_TIMEOUT);
                }
                this.properties.put("weblogic.jndi.connectTimeout", new Long(JNDI_CONNECT_TIMEOUT));
            }
            if (!this.properties.containsKey("weblogic.jndi.responseReadTimeout")) {
                if (JMSDebug.JMSOBS.isDebugEnabled()) {
                    JMSDebug.JMSOBS.debug("PropertiesContextFactory:constructor set weblogic.jndi.responseReadTimeout to " + JNDI_RESPONSE_READ_TIMEOUT);
                }
                this.properties.put("weblogic.jndi.responseReadTimeout", new Long(JNDI_RESPONSE_READ_TIMEOUT));
            }
            this.properties.put("weblogic.jndi.disableLoggingOfWarningMsg", "true");
            this.origSubject = CrossDomainSecurityManager.getCurrentSubject();
            if (this.origSubject == null || JMSDestinationAvailabilityHelper.this.isServer && CrossDomainSecurityManager.getCrossDomainSecurityUtil().isKernelIdentity(this.origSubject)) {
                this.origSubject = SubjectManager.getSubjectManager().getAnonymousSubject();
                this.origSubDowngraded = true;
            }
            this.registrationSubject = this.origSubject;
            this.originalContext = InheritableThreadContext.getContext();
        }

        @Override
        public AbstractSubject getOrigSubject() {
            return this.origSubject;
        }

        @Override
        public boolean isOrigSubDowngraded() {
            return this.origSubDowngraded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Context getJNDIContext() throws NamingException {
            this.refreshCtx();
            PropertiesContextFactory propertiesContextFactory = this;
            synchronized (propertiesContextFactory) {
                return this.ctx;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refreshCtx() throws NamingException {
            ClassLoader saved = this.originalContext.pushMultiThread();
            try {
                if (this.refreshWaitLock.waitUntilComplete()) {
                    return;
                }
                NamingException gotException = null;
                InitialContext newCtx = null;
                AbstractSubject regSub = null;
                try {
                    newCtx = this.properties == null ? new InitialContext() : new InitialContext(this.properties);
                    regSub = CrossDomainSecurityManager.getCurrentSubject();
                }
                catch (NamingException ne) {
                    gotException = ne;
                }
                catch (Throwable t) {
                    gotException = new NamingException(t.getMessage());
                    gotException.setRootCause(t);
                }
                PropertiesContextFactory propertiesContextFactory = this;
                synchronized (propertiesContextFactory) {
                    if (this.ctx != null) {
                        try {
                            this.ctx.close();
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                    this.ctx = newCtx;
                    if (gotException == null && !regSub.equals(SubjectManager.getSubjectManager().getAnonymousSubject())) {
                        this.registrationSubject = regSub;
                    }
                }
                this.refreshWaitLock.complete(gotException);
                if (gotException != null) {
                    throw gotException;
                }
            }
            finally {
                this.originalContext.popMultiThread(saved);
            }
        }

        @Override
        public synchronized AbstractSubject getRegistrationSubject() {
            return this.registrationSubject;
        }

        @Override
        public synchronized void close() {
            try {
                if (this.ctx != null) {
                    this.ctx.close();
                }
                if (this.secHandle != null) {
                    this.secHandle.close();
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }

        @Override
        public String getProviderURL() {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.get("java.naming.provider.url");
        }

        @Override
        public void setSecurityHandle(CDSSecurityHandle secHandle) {
            this.secHandle = secHandle;
        }

        private boolean hasRegistrationCredentials() {
            if (this.properties == null) {
                return false;
            }
            String value = (String)this.properties.get("java.naming.security.principal");
            return value != null;
        }

        @Override
        public AbstractSubject getRightJNDISubject() throws IllegalStateException {
            if (this.hasRegistrationCredentials()) {
                return this.getRegistrationSubject();
            }
            try {
                if (JMSDestinationAvailabilityHelper.this.isServer && this.secHandle.isRemoteDomain()) {
                    return SubjectManager.getSubjectManager().getAnonymousSubject();
                }
            }
            catch (IllegalStateException ise) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("The security handle is not ready yet, listener is not connected");
                }
                throw ise;
            }
            return this.origSubject;
        }

        @Override
        public AbstractSubject getRightJMSSubject() {
            AbstractSubject foreignSubject;
            block8: {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Getting right jms subject: properties= " + this.properties);
                }
                foreignSubject = null;
                try {
                    foreignSubject = this.getForeignSubject();
                }
                catch (IllegalStateException e) {
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("The listener has failed and is trying to reconnect, we cannot get the right subject, use anonymous");
                    }
                    if (this.secHandle.isReady()) break block8;
                    return SubjectManager.getSubjectManager().getAnonymousSubject();
                }
            }
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("foreign subject= " + foreignSubject);
            }
            if (foreignSubject != null) {
                return foreignSubject;
            }
            if (this.hasRegistrationCredentials()) {
                if (!JMSDestinationAvailabilityHelper.this.isServer || !this.secHandle.isRemoteDomain() && !CrossDomainSecurityManager.getCrossDomainSecurityUtil().isKernelIdentity(this.registrationSubject)) {
                    return this.registrationSubject;
                }
                return SubjectManager.getSubjectManager().getAnonymousSubject();
            }
            return this.origSubject;
        }

        private AbstractSubject getForeignSubject() {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Getting foreign subject isforeign= " + this.secHandle.isForeignJMSServer());
            }
            if (this.secHandle.isForeignJMSServer()) {
                return this.secHandle.getForeignSubject();
            }
            return null;
        }

        @Override
        public Object lookup(final String jndiName) throws NamingException {
            try {
                AbstractSubject subject = this.getRightJNDISubject();
                return CrossDomainSecurityManager.runAs(subject, new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        try {
                            return PropertiesContextFactory.this.ctx.lookup(jndiName);
                        }
                        catch (NamingException ne) {
                            if (ne instanceof NameNotFoundException) {
                                throw ne;
                            }
                            PropertiesContextFactory.this.refreshCtx();
                            return PropertiesContextFactory.this.ctx.lookup(jndiName);
                        }
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                NamingException ne = new NamingException(e.getMessage());
                throw ne;
            }
            catch (IllegalStateException ise) {
                NamingException ne = new NamingException(ise.getMessage());
                throw ne;
            }
        }
    }

    private final class DestinationAvailabilityListenerWrapper
    implements DDMembershipChangeListener,
    RegistrationHandle {
        private ContextFactory ctxFactory;
        private Context envContext;
        private String destJNDIName;
        private DestinationAvailabilityListener listener;
        private int mode;
        InheritableThreadContext originalContext;
        private ComponentInvocationContext cic = null;

        public DestinationAvailabilityListenerWrapper(ContextFactory ctxFactory, String destJNDIName, DestinationAvailabilityListener listener, int mode, Context envContext) {
            this.ctxFactory = ctxFactory;
            this.destJNDIName = destJNDIName;
            this.listener = listener;
            this.mode = mode;
            this.originalContext = InheritableThreadContext.getContext();
            this.envContext = envContext;
            if (KernelStatus.isServer()) {
                this.cic = JMSCICHelper.getCurrentCIC();
            }
        }

        public String getDDJNDIName() {
            return this.destJNDIName;
        }

        public DestinationAvailabilityListener getDestinationAvailabilityListener() {
            return this.listener;
        }

        public int getMode() {
            return this.mode;
        }

        @Override
        public String getDestinationName() {
            return this.destJNDIName;
        }

        @Override
        public String getProviderURL() {
            return this.ctxFactory.getProviderURL();
        }

        @Override
        public InitialContext getInitialContext() throws NamingException {
            return (InitialContext)this.ctxFactory.getJNDIContext();
        }

        @Override
        public Context getEnvContext() {
            return this.envContext;
        }

        @Override
        public AbstractSubject getSubject() {
            return this.ctxFactory.getRegistrationSubject();
        }

        @Override
        public void onDDMembershipChange(DDMembershipChangeEventImpl evt) {
            int i;
            if (this.listener == null) {
                return;
            }
            DDMemberInformation[] removedDDMemberInfo = JMSDestinationAvailabilityHelper.this.filterDDMembers(this, evt.getRemovedDDMemberInformation());
            DDMemberInformation[] addedDDMemberInfo = JMSDestinationAvailabilityHelper.this.filterDDMembers(this, evt.getAddedDDMemberInformation());
            if (!IS_COMPATIBLE && removedDDMemberInfo != null && addedDDMemberInfo != null) {
                DDMemberInformation[][] DDMemberInfo = JMSDestinationAvailabilityHelper.this.filterDDMembers(removedDDMemberInfo, addedDDMemberInfo);
                removedDDMemberInfo = DDMemberInfo[0];
                addedDDMemberInfo = DDMemberInfo[1];
            }
            if (removedDDMemberInfo != null) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Valid Removed DDMembers info:");
                    JMSDestinationAvailabilityHelper.this.printDDMemberInfo(removedDDMemberInfo);
                }
                int numberOfRemovedDDMembers = removedDDMemberInfo.length;
                final DestinationDetail[] removedDestinationsDetail = new DestinationDetailImpl[numberOfRemovedDDMembers];
                for (i = 0; i < numberOfRemovedDDMembers; ++i) {
                    removedDestinationsDetail[i] = JMSDestinationAvailabilityHelper.this.createDestinationDetailFromDDMemberInformation(removedDDMemberInfo[i]);
                }
                this.callOutListener(new PrivilegedAction(){

                    public Object run() {
                        DestinationAvailabilityListenerWrapper.this.listener.onDestinationsUnavailable(DestinationAvailabilityListenerWrapper.this.destJNDIName, Arrays.asList(removedDestinationsDetail));
                        return null;
                    }
                });
            }
            if (addedDDMemberInfo != null) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Valid Added DDMembers info:");
                    JMSDestinationAvailabilityHelper.this.printDDMemberInfo(addedDDMemberInfo);
                }
                int numberOfAddedDDMembers = addedDDMemberInfo.length;
                final DestinationDetail[] addedDestinationsDetail = new DestinationDetailImpl[numberOfAddedDDMembers];
                for (i = 0; i < numberOfAddedDDMembers; ++i) {
                    addedDestinationsDetail[i] = JMSDestinationAvailabilityHelper.this.createDestinationDetailFromDDMemberInformation(addedDDMemberInfo[i]);
                }
                this.callOutListener(new PrivilegedAction(){

                    public Object run() {
                        DestinationAvailabilityListenerWrapper.this.listener.onDestinationsAvailable(DestinationAvailabilityListenerWrapper.this.destJNDIName, Arrays.asList(addedDestinationsDetail));
                        return null;
                    }
                });
            }
        }

        private void callOutListener(PrivilegedAction action) {
            ClassLoader saved = this.originalContext.pushMultiThread();
            try {
                if (this.ctxFactory.isOrigSubDowngraded()) {
                    CrossDomainSecurityManager.runAs(this.ctxFactory.getOrigSubject(), action);
                } else {
                    action.run();
                }
            }
            finally {
                this.originalContext.popMultiThread(saved);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister() {
            DestinationAvailabilityListenerWrapper destinationAvailabilityListenerWrapper = this;
            synchronized (destinationAvailabilityListenerWrapper) {
                if (this.listener == null) {
                    return;
                }
                CDS.getCDS().unregisterDDMembershipChangeListener(this);
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Successfully unregistered the listener " + this.listener + " for destJNDIName=" + this.destJNDIName);
                }
                this.listener = null;
                this.ctxFactory.close();
            }
        }

        @Override
        public void onFailure(final String destJNDIName, final Exception ex) {
            if (this.listener == null) {
                return;
            }
            this.callOutListener(new PrivilegedAction(){

                public Object run() {
                    DestinationAvailabilityListenerWrapper.this.listener.onFailure(destJNDIName, ex);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ConnectionFactory lookupConnectionFactory(String jndiName) throws NamingException {
            ClassLoader saved = this.originalContext.pushMultiThread();
            try {
                ConnectionFactory connectionFactory = (ConnectionFactory)this.ctxFactory.lookup(jndiName);
                return connectionFactory;
            }
            finally {
                this.originalContext.popMultiThread(saved);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Destination lookupDestination(String jndiName) throws NamingException {
            ClassLoader saved = this.originalContext.pushMultiThread();
            try {
                Destination destination = (Destination)this.ctxFactory.lookup(jndiName);
                return destination;
            }
            finally {
                this.originalContext.popMultiThread(saved);
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public final Object runAs(PrivilegedExceptionAction action) throws PrivilegedActionException {
            ClassLoader saved = this.originalContext.pushMultiThread();
            try {
                try (ManagedInvocationContext mic = JMSCICHelper.pushJMSCIC(this.cic);){
                    Object object = CrossDomainSecurityManager.runAs(this.ctxFactory.getRightJMSSubject(), action);
                    return object;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.originalContext.popMultiThread(saved);
            }
        }
    }
}

