/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.lang.reflect.Method;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.dispatcher.AccessDispatcherManager;
import weblogic.jms.dispatcher.DispatcherAdapter;
import weblogic.jms.dispatcher.DispatcherPartitionContext;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.InitDispatcherManager;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.CrossPartitionDispatcher;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherUtils;
import weblogic.messaging.dispatcher.DispatcherWrapperState;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class JMSDispatcherManager
implements AccessDispatcherManager {
    private static final JMSDispatcherManager rawSingleton = new JMSDispatcherManager();
    private static final String FE_JMS_REQUEST_QUEUE = "FEJmsDispatcher";
    private static final String BE_JMS_REQUEST_QUEUE = "BEJmsDispatcher";
    private static final String JMS_ASYNC_REQUEST_QUEUE = "JmsAsyncQueue";
    private static final String MIN_POOL_PROP_PREFIX = "weblogic.jms.MinPoolSize.";
    public static final String PREFIX_SERVER_NAME = "weblogic.jms.S:";
    public static final String SERVER_PREFIX = "weblogic.messaging.dispatcher.S:";
    private static final Map<String, ContextImpl> PARTITION_ID_CONTEXT_MAP = new ConcurrentHashMap<String, ContextImpl>();
    private static final Map<String, ContextImpl> PARTITION_NAME_CONTEXT_MAP = new ConcurrentHashMap<String, ContextImpl>();

    public static JMSDispatcherManager getRawSingleton() {
        return rawSingleton;
    }

    @Override
    public DispatcherPartitionContext findDispatcherPartitionContextJMSException() throws jakarta.jms.JMSException {
        return this.findDispatcherPartitionContextJMSException(DispatcherUtils.getPartitionId());
    }

    @Override
    public DispatcherPartitionContext findDispatcherPartitionContextJMSException(String partitionId) throws jakarta.jms.JMSException {
        DispatcherPartitionContext dpc = this.lookupDispatcherPartitionContextById(partitionId);
        if (null == dpc) {
            throw new JMSException("JMS partition not available for Id " + partitionId);
        }
        return dpc;
    }

    @Override
    public DispatcherPartitionContext findDispatcherPartitionContextDispatcherException(String partitionId) throws DispatcherException {
        DispatcherPartitionContext dpc = this.lookupDispatcherPartitionContextById(partitionId);
        if (null == dpc) {
            throw new DispatcherException("no available JMS partition, Id " + partitionId);
        }
        return dpc;
    }

    @Override
    public JMSDispatcher findDispatcherByPartitionIdUnmarshalException(String partitionId) throws UnmarshalException {
        DispatcherPartitionContext dpc = this.lookupDispatcherPartitionContextById(partitionId);
        if (null == dpc) {
            throw new UnmarshalException("no JMS partition available, Id " + partitionId);
        }
        return ((ContextImpl)dpc).localDispatcherAdapter;
    }

    @Override
    public DispatcherPartitionContext lookupDispatcherPartitionContextById(String partitionId) {
        if (partitionId == null) {
            partitionId = "0";
        }
        return PARTITION_ID_CONTEXT_MAP.get(partitionId);
    }

    @Override
    public DispatcherPartitionContext lookupDispatcherPartitionContextByName(String partitionName) {
        if (partitionName == null) {
            partitionName = "DOMAIN";
        }
        return PARTITION_NAME_CONTEXT_MAP.get(partitionName);
    }

    static int getJMSThreadPoolSize() {
        try {
            Class<?> kernel = Class.forName("weblogic.kernel.Kernel");
            Method initialize = kernel.getMethod("ensureInitialized", new Class[0]);
            initialize.invoke(null, new Object[0]);
            Method getConfig = kernel.getMethod("getConfig", new Class[0]);
            Object configMBean = getConfig.invoke(null, new Object[0]);
            Class<?> ConfigMBean = Class.forName("weblogic.management.configuration.KernelMBean");
            Method getSize = ConfigMBean.getMethod("getJMSThreadPoolSize", new Class[0]);
            Object size = getSize.invoke(configMBean, new Object[0]);
            return (Integer)size;
        }
        catch (RuntimeException rte) {
            if (JMSDebug.JMSDispatherUtilsVerbose.isDebugEnabled()) {
                JMSDebug.JMSDispatherUtilsVerbose.debug(rte.getMessage(), rte);
            }
            throw rte;
        }
        catch (Throwable th) {
            RuntimeException rte = new RuntimeException(th);
            if (JMSDebug.JMSDispatherUtilsVerbose.isDebugEnabled()) {
                JMSDebug.JMSDispatherUtilsVerbose.debug(rte.getMessage(), rte);
            }
            throw rte;
        }
    }

    public static String getDispatcherJNDIName(DispatcherId dispatcherId) {
        return SERVER_PREFIX + dispatcherId;
    }

    private static DispatcherWrapper internalJNDILookup(Context ctx, DispatcherId dispatcherId) throws DispatcherException {
        DispatcherWrapper dispatcherWrapper;
        if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
            JMSDebug.JMSDispatcherLifecycle.debug("internalJNDILookup; JNDI lookup for dispatcher: id:" + dispatcherId.getDetail());
        }
        try {
            dispatcherWrapper = (DispatcherWrapper)ctx.lookup(SERVER_PREFIX + dispatcherId);
        }
        catch (NamingException ne) {
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("internalJNDILookup; dispatcher not found: id:" + dispatcherId.getDetail(), ne);
            }
            DispatcherException de = new DispatcherException("could not find Server " + dispatcherId);
            de.initCause(ne);
            throw de;
        }
        if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
            JMSDebug.JMSDispatcherLifecycle.debug("internalJNDILookup; adding: id:" + dispatcherId.getDetail());
        }
        return dispatcherWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextImpl createDispatcherPartitionContext(String partitionId, String partitionName, boolean oldExecuteQueueStyle, InitDispatcherManager initDispatcherManager, InvocableManagerDelegate invocableManagerDelegate, ComponentInvocationContext componentInvocationContext) {
        Map<String, ContextImpl> map = PARTITION_ID_CONTEXT_MAP;
        synchronized (map) {
            if (PARTITION_NAME_CONTEXT_MAP.containsKey(partitionName)) {
                RuntimeException rte = new RuntimeException("Already created JMS Dispatcher for partition " + partitionName);
                if (JMSDebug.JMSDispatherUtilsVerbose.isDebugEnabled()) {
                    JMSDebug.JMSDispatherUtilsVerbose.debug(rte.getMessage(), rte);
                }
                throw rte;
            }
            ContextImpl contextImpl = new ContextImpl(partitionId, partitionName, oldExecuteQueueStyle, initDispatcherManager, invocableManagerDelegate, componentInvocationContext);
            PARTITION_ID_CONTEXT_MAP.put(partitionId, contextImpl);
            PARTITION_NAME_CONTEXT_MAP.put(partitionName, contextImpl);
            contextImpl.isPartitionActive = true;
            return contextImpl;
        }
    }

    private static int getMinPoolSize(String poolName, int suggestedMin) {
        int ret;
        String prop = MIN_POOL_PROP_PREFIX + poolName;
        String propVal = null;
        String exc = null;
        try {
            if (System.getProperty(prop) == null) {
                prop = "weblogic.jms.MinPoolSize.Any";
            }
            propVal = System.getProperty(prop, "" + suggestedMin);
            ret = Math.max(Integer.parseInt(propVal), suggestedMin);
        }
        catch (Throwable t) {
            ret = suggestedMin;
            exc = t + "";
        }
        if (JMSDebug.JMSDispatherUtilsVerbose.isDebugEnabled()) {
            JMSDebug.JMSDispatherUtilsVerbose.debug("Parsed thread poolprop:   poolName=" + poolName + " prop=" + prop + " propval=" + propVal + " suggestedMin=" + suggestedMin + " exc='" + exc + "' ret=" + ret);
        }
        return ret;
    }

    protected class ContextImpl
    implements DispatcherPartitionContext {
        private final HashMap dispatchers = new HashMap();
        private final DispatcherAdapter localDispatcherAdapter;
        private final Dispatcher localDispatcher;
        private final WorkManager feDispatcherWorkManager;
        private final WorkManager beDispatcherWorkManager;
        private final WorkManager oneWayWorkManager;
        private final WorkManager resumeRequestWorkManager;
        private TimerManager defaultTimerManager;
        protected boolean oldExecuteQueueStyle = false;
        private int threadPoolSize = 5;
        private int configuredThreadPoolSizeForClient = 0;
        private final InvocableManagerDelegate invocableManagerDelegate;
        private int exportCount;
        private final ComponentInvocationContext componentInvocationContext;
        private final String partitionId;
        private final String partitionName;
        private volatile boolean isPartitionActive;
        private final InitDispatcherManager initDispatcherManager;

        private ContextImpl(String partitionId, String partitionName, boolean oldExecuteQueueStyle, InitDispatcherManager initDispatcherManager, InvocableManagerDelegate invocableManagerDelegate, ComponentInvocationContext componentInvocationContext) {
            DispatcherId localDispatcherId = initDispatcherManager.getLocalDispatcherId();
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.initialize; partitionId: " + partitionId + " initializing dispatcher; dispatcherName: " + localDispatcherId.getDetail());
            }
            this.partitionId = partitionId;
            this.partitionName = partitionName;
            this.initDispatcherManager = initDispatcherManager;
            this.componentInvocationContext = componentInvocationContext;
            this.invocableManagerDelegate = invocableManagerDelegate;
            this.threadPoolSize = initDispatcherManager.abstractThreadPoolSize(oldExecuteQueueStyle);
            if (!initDispatcherManager.isServer()) {
                this.configuredThreadPoolSizeForClient = this.threadPoolSize;
            }
            this.feDispatcherWorkManager = WorkManagerFactory.getInstance().findOrCreate(JMSDispatcherManager.FE_JMS_REQUEST_QUEUE, oldExecuteQueueStyle ? -1 : 100, JMSDispatcherManager.getMinPoolSize(JMSDispatcherManager.FE_JMS_REQUEST_QUEUE, Math.max(3, this.threadPoolSize)), -1);
            this.beDispatcherWorkManager = initDispatcherManager.isServer() ? WorkManagerFactory.getInstance().findOrCreate(JMSDispatcherManager.BE_JMS_REQUEST_QUEUE, 100, JMSDispatcherManager.getMinPoolSize(JMSDispatcherManager.BE_JMS_REQUEST_QUEUE, this.threadPoolSize), -1) : this.feDispatcherWorkManager;
            this.oneWayWorkManager = WorkManagerFactory.getInstance().findOrCreate(JMSDispatcherManager.JMS_ASYNC_REQUEST_QUEUE, 100, JMSDispatcherManager.getMinPoolSize(JMSDispatcherManager.JMS_ASYNC_REQUEST_QUEUE, 1), -1);
            this.resumeRequestWorkManager = WorkManagerFactory.getInstance().getSystem();
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.createLocalDispatcher: partitionId: " + partitionId + " add local DispatcherImpl to cache; dispatcherId: " + localDispatcherId.getDetail());
            }
            this.localDispatcher = new DispatcherImpl(localDispatcherId.getName(), localDispatcherId, this, initDispatcherManager.getObjectHandlerClassName(), partitionId, this.getPartitionName());
            this.dispatchers.put(localDispatcherId, this.localDispatcher);
            this.localDispatcherAdapter = new DispatcherAdapter(this.localDispatcher, this);
        }

        public String toString() {
            DispatcherAdapter myLocalDispatcherAdapter = this.localDispatcherAdapter;
            Dispatcher myDispatcher = null;
            if (myLocalDispatcherAdapter == null || (myDispatcher = myLocalDispatcherAdapter.getDelegate()) == null) {
                return "unintialized " + this.getClass().getSimpleName();
            }
            return "ID delegate=" + myDispatcher.getId() + " " + this.getClass().getSimpleName() + " " + myDispatcher;
        }

        @Override
        public String getPartitionName() {
            return this.partitionName;
        }

        @Override
        public String getPartitionId() {
            return this.partitionId;
        }

        @Override
        public boolean isLocal(weblogic.messaging.dispatcher.DispatcherWrapper wrapper) {
            DispatcherId wrapperId = wrapper.getId();
            DispatcherId localDispatcherId = this.initDispatcherManager.getLocalDispatcherId();
            boolean isNameMatch = localDispatcherId.getName().equals(wrapperId.getName());
            boolean isIdMatch = localDispatcherId.equals(wrapperId);
            if (isNameMatch || isIdMatch) {
                if (this.initDispatcherManager.isServer()) {
                    return this.initDispatcherManager.isServerLocalRJVM(wrapper.getRemoteDispatcher());
                }
                if (JMSDebug.JMSDispatherUtilsVerbose.isDebugEnabled()) {
                    JMSDebug.JMSDispatherUtilsVerbose.debug("debug JMSDispatcherManager.isLocal client TRUE isNameMatch" + isNameMatch + " isIdMatch:" + isIdMatch + " (localID:" + localDispatcherId + " localName:" + localDispatcherId.getName() + " ) (wrapper ID:" + wrapper.getId() + " wrapperName:" + wrapper.getName() + " )");
                }
                return true;
            }
            if (JMSDebug.JMSDispatherUtilsVerbose.isDebugEnabled()) {
                JMSDebug.JMSDispatherUtilsVerbose.debug("debug JMSDispatcherManager.isLocal FALSE isNameMatch" + isNameMatch + " isIdMatch:" + isIdMatch + " (localID:" + localDispatcherId + " localName:" + localDispatcherId.getName() + " ) (wrapper ID:" + wrapper.getId() + " wrapperName:" + wrapper.getName() + " )");
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeJMSDispatcherManager() {
            if (this.partitionId == null || "0".equals(this.partitionId)) {
                return;
            }
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeJMSDispatcherManager for partitionId=" + this.partitionId);
            }
            Map map = PARTITION_ID_CONTEXT_MAP;
            synchronized (map) {
                ContextImpl dpc = (ContextImpl)PARTITION_ID_CONTEXT_MAP.remove(this.partitionId);
                if (this != dpc && dpc != null) {
                    PARTITION_ID_CONTEXT_MAP.put(this.partitionId, dpc);
                } else {
                    PARTITION_NAME_CONTEXT_MAP.remove(this.partitionName);
                }
                this.isPartitionActive = false;
            }
        }

        @Override
        public ComponentInvocationContext getCIC(String partitionName) {
            DispatcherPartitionContext dpc = JMSDispatcherManager.this.lookupDispatcherPartitionContextByName(partitionName);
            return dpc instanceof ContextImpl ? ((ContextImpl)dpc).componentInvocationContext : null;
        }

        @Override
        public TimerManager getDefaultTimerManager() {
            if (null != this.defaultTimerManager) {
                return this.defaultTimerManager;
            }
            try (ManagedInvocationContext mic = (ManagedInvocationContext)this.pushComponentInvocationContext();){
                TimerManager timerManager = this.defaultTimerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
                return timerManager;
            }
        }

        @Override
        public boolean isPartitionActive() {
            return this.isPartitionActive;
        }

        @Override
        public int getConfiguredThreadPoolSizeForClient() {
            return this.configuredThreadPoolSizeForClient;
        }

        @Override
        public WorkManager getFEWorkManager() {
            return this.feDispatcherWorkManager;
        }

        @Override
        public WorkManager getBEWorkManager() {
            return this.beDispatcherWorkManager;
        }

        @Override
        public WorkManager getOneWayWorkManager() {
            return this.oneWayWorkManager;
        }

        @Override
        public WorkManager getDefaultWorkManager() {
            return this.resumeRequestWorkManager;
        }

        @Override
        public InvocableManagerDelegate getInvocableManagerDelegate() throws jakarta.jms.JMSException {
            InvocableManagerDelegate.checkValid(this.getPartitionId(), this.invocableManagerDelegate);
            return this.invocableManagerDelegate;
        }

        @Override
        public JMSDispatcher getLocalDispatcher() throws jakarta.jms.JMSException {
            if (this.isPartitionActive()) {
                return this.localDispatcherAdapter;
            }
            throw new JMSException("inactive JMS partition, Name " + this.partitionName);
        }

        @Override
        public void removeDispatcherReference(JMSDispatcher dispatcher) {
            Dispatcher toRemove = dispatcher.getDelegate();
            this.removeDispatcherReference(toRemove, false);
        }

        @Override
        public void removeDispatcherWrapperStateReference() {
            for (Object o : this.dispatchers.values()) {
                if (!(o instanceof DispatcherWrapperState)) continue;
                ((DispatcherWrapperState)o).deleteNotify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeDispatcherReference(Dispatcher dispatcher, boolean force) {
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; dispatcher.class: " + dispatcher.getClass().getName() + " dispatcherId: " + dispatcher.getId().getDetail());
            }
            if (this.initDispatcherManager.getLocalDispatcherId().equals(dispatcher.getId())) {
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; partitionId: " + this.partitionId + " ignored; local dispatcher; dispatcherId: " + dispatcher.getId().getDetail());
                }
                return;
            }
            if (dispatcher instanceof DispatcherWrapperState) {
                HashMap cachedMap;
                DispatcherWrapperState dws = (DispatcherWrapperState)dispatcher;
                if (dws.removeRefCount() && !force) {
                    if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                        JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; partitionId: " + this.partitionId + " ignoring; dispatcherId: " + dispatcher.getId().getDetail() + " refCount: " + dws.getRefCount() + " force: " + force);
                    }
                    return;
                }
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; partitionId: " + this.partitionId + " deleteNotify; dispatcherId: " + dispatcher.getId().getDetail());
                }
                if ((cachedMap = dws.deleteNotify()) == this.dispatchers) {
                    HashMap hashMap = this.dispatchers;
                    synchronized (hashMap) {
                        if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                            JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.eDispatcherReference; partitionId: " + this.partitionId + " removing; dispatcherId: " + dispatcher.getId().getDetail());
                        }
                        Object removedDispatcher = this.dispatchers.remove(dispatcher.getId());
                        if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                            if (removedDispatcher != null) {
                                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; partitionId: " + this.partitionId + " found and removed; dispatcherId: " + dispatcher.getId().getDetail());
                            } else {
                                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; partitionId: " + this.partitionId + " not found; dispatcherId: " + dispatcher.getId().getDetail());
                            }
                        }
                    }
                }
            } else if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.removeDispatcherReference; partitionId: " + this.partitionId + " ignored; not a DispatcherWrapperState; dispatcherId: " + dispatcher.getId().getDetail());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dispatcher dispatcherFind(DispatcherId dispatcherId, Map dispatchers) throws DispatcherException {
            Dispatcher retDispatcher;
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.dispatcherFind; partitionId: " + this.partitionId + " looking up dispatcher; dispatcherId: " + (dispatcherId == null ? "<null>" : dispatcherId.getDetail()));
            }
            Map map = dispatchers;
            synchronized (map) {
                if (dispatcherId == null) {
                    throw new DispatcherException("Dispatcher not found: " + dispatcherId);
                }
                DispatcherId localDispatcherId = this.initDispatcherManager.getLocalDispatcherId();
                if (dispatcherId.getId() != null && localDispatcherId.getName().equals(dispatcherId.getName()) || localDispatcherId.equals(dispatcherId)) {
                    if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                        JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.dispatcherFind; partitionId: " + this.partitionId + " returning local dispatcher; dispatcherId: " + this.localDispatcher.getId().getDetail());
                    }
                    return this.localDispatcher;
                }
                retDispatcher = (Dispatcher)dispatchers.get(dispatcherId);
            }
            if (retDispatcher == null) {
                DispatcherException de = new DispatcherException("Dispatcher not found: " + dispatcherId);
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.dispatcherFind; partitionId: " + this.partitionId + " dispatcher not found for id: " + dispatcherId.getDetail(), de);
                }
                throw de;
            }
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.dispatcherFind; partitionId: " + this.partitionId + " returning dispatcher: id:" + retDispatcher.getId().getDetail());
            }
            return retDispatcher;
        }

        @Override
        public JMSDispatcher dispatcherFindOrCreate(Context ctx, DispatcherId dispatcherId) throws DispatcherException {
            Dispatcher d;
            try {
                d = this.dispatcherFind(dispatcherId, this.dispatchers);
            }
            catch (DispatcherException de) {
                d = this.dispatcherCreate(ctx, dispatcherId, true, this.dispatchers);
            }
            return new DispatcherAdapter(d, this);
        }

        @Override
        public JMSDispatcher registerDispatcher(weblogic.messaging.dispatcher.DispatcherWrapper dispatcherWrapper) throws DispatcherException {
            if (this.isLocal(dispatcherWrapper)) {
                ContextImpl desiredDPC = (ContextImpl)JMSDispatcherManager.this.findDispatcherPartitionContextDispatcherException(dispatcherWrapper.getPartitionId());
                return new CrossPartitionDispatcher((DispatcherImpl)desiredDPC.localDispatcher);
            }
            Dispatcher d = this.localDispatcherOrDispWrapperState(dispatcherWrapper, true, this.dispatchers);
            return new DispatcherAdapter(d, this);
        }

        private Dispatcher dispatcherCreate(Context ctx, DispatcherId dispatcherId, boolean cacheIt, HashMap dispatchers) throws DispatcherException {
            DispatcherWrapper dispatcherWrapper = JMSDispatcherManager.internalJNDILookup(ctx, dispatcherId);
            if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.dispatcherCreate; partitionId: " + this.partitionId + " adding: id:" + dispatcherId.getDetail());
            }
            return this.localDispatcherOrDispWrapperState(dispatcherWrapper, cacheIt, dispatchers);
        }

        @Override
        public DispatcherWrapper getLocalDispatcherWrapper() throws jakarta.jms.JMSException {
            DispatcherImpl dispatcher = (DispatcherImpl)this.getLocalDispatcher().getDelegate();
            return dispatcher.constructPartitionAwareDispatcherWrapper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exportLocalDispatcher() throws jakarta.jms.JMSException {
            ContextImpl contextImpl = this;
            synchronized (contextImpl) {
                Dispatcher d = this.getLocalDispatcher().getDelegate();
                ++this.exportCount;
                if (this.exportCount == 1 && d instanceof DispatcherImpl) {
                    ((DispatcherImpl)d).export();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void unexportLocalDispatcher() throws jakarta.jms.JMSException {
            ContextImpl contextImpl = this;
            synchronized (contextImpl) {
                Dispatcher d = this.getLocalDispatcher().getDelegate();
                --this.exportCount;
                if (this.exportCount == 0) {
                    if (KernelStatus.isServer()) {
                        return;
                    }
                    if (d instanceof DispatcherImpl) {
                        ((DispatcherImpl)d).unexport();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dispatcher localDispatcherOrDispWrapperState(weblogic.messaging.dispatcher.DispatcherWrapper dispatcherWrapper, boolean cacheIt, HashMap dispatchers) throws DispatcherException {
            DispatcherWrapperState dws;
            if (this.isLocal(dispatcherWrapper)) {
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.localDispatcherOrDispWrapperState: partitionId: " + this.partitionId + " returning local dispatcher; id: " + this.localDispatcher.getId().getDetail());
                }
                return this.localDispatcher;
            }
            if (cacheIt) {
                HashMap hashMap = dispatchers;
                synchronized (hashMap) {
                    DispatcherWrapperState existing = (DispatcherWrapperState)dispatchers.get(dispatcherWrapper.getId());
                    if (existing != null) {
                        existing.addRefCount();
                        dws = existing;
                    } else if (this.partitionName.equals(dispatcherWrapper.getConnectionPartitionName())) {
                        dws = new DispatcherWrapperState(dispatcherWrapper, this, dispatchers);
                        dispatchers.put(dws.getId(), dws);
                        if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                            JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.localDispatcherOrDispWrapperState: partitionId: " + this.partitionId + " add DispatcherWrapperState to cache; id: " + dws.getId().getDetail());
                        }
                    } else {
                        dws = new DispatcherWrapperState(dispatcherWrapper, this, null);
                        if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                            JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.localDispatcherOrDispWrapperState: partitionId: " + this.partitionId + " so do not add DispatcherWrapperState to cache; id: " + dws.getId().getDetail());
                        }
                    }
                }
            } else {
                dws = new DispatcherWrapperState(dispatcherWrapper, this, null);
                if (JMSDebug.JMSDispatcherLifecycle.isDebugEnabled()) {
                    JMSDebug.JMSDispatcherLifecycle.debug("JMSDispatcherManager.ContextImpl.localDispatcherOrDispWrapperState: partitionId: " + this.partitionId + " not adding DispatcherWrapperState to cache; id: " + dws.getId().getDetail());
                }
            }
            return dws;
        }

        @Override
        public JMSDispatcher dispatcherAdapterOrPartitionAdapter(DispatcherWrapper dispatcherWrapper) throws DispatcherException {
            if (this.isLocal(dispatcherWrapper)) {
                ContextImpl desiredDPC = (ContextImpl)JMSDispatcherManager.this.findDispatcherPartitionContextDispatcherException(dispatcherWrapper.getPartitionId());
                return new CrossPartitionDispatcher((DispatcherImpl)desiredDPC.localDispatcher);
            }
            return new DispatcherAdapter(new DispatcherWrapperState(dispatcherWrapper, this, null), this);
        }

        @Override
        public Object pushComponentInvocationContext() {
            return this.initDispatcherManager.pushCIC(this.componentInvocationContext);
        }

        @Override
        public JMSDispatcher dispatcherCreateForCDS(Context ctx, DispatcherId dispatcherId) throws DispatcherException {
            DispatcherWrapper dispatcherWrapper = JMSDispatcherManager.internalJNDILookup(ctx, dispatcherId);
            return this.dispatcherAdapterOrPartitionAdapter(dispatcherWrapper);
        }
    }
}

