/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.dispatcher.InitDispatcherManager;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.messaging.common.JMSCICHelper;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherRemote;

public final class ClientDispatcherManager
implements InitDispatcherManager {
    private final JMSEnvironment jmsEnvironment;

    public ClientDispatcherManager(JMSDispatcherManager jmsDispatcherManager, JMSEnvironment jmsEnvironment) {
        this.jmsEnvironment = jmsEnvironment;
    }

    public void init() {
        this.jmsEnvironment.createJmsJavaOid();
    }

    @Override
    public int abstractThreadPoolSize(boolean oldExecuteQueueStyle) {
        int jmsThreadPoolSize = 0;
        if (this.jmsEnvironment.isThinClient()) {
            String poolSize = null;
            try {
                poolSize = System.getProperty("weblogic.JMSThreadPoolSize");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (poolSize != null) {
                try {
                    jmsThreadPoolSize = Integer.parseInt(poolSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (jmsThreadPoolSize < 5 && jmsThreadPoolSize > 0) {
                    jmsThreadPoolSize = 5;
                }
            }
        } else {
            jmsThreadPoolSize = JMSDispatcherManager.getJMSThreadPoolSize();
        }
        return jmsThreadPoolSize;
    }

    @Override
    public ManagedInvocationContext pushCIC(ComponentInvocationContext cic) {
        ManagedInvocationContext mic = JMSCICHelper.pushJMSCIC(null);
        return mic;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public String getObjectHandlerClassName() {
        return "weblogic.jms.dispatcher.ClientDispatcherObjectHandler";
    }

    @Override
    public DispatcherId getLocalDispatcherId() {
        return this.jmsEnvironment.getLocalDispatcherId();
    }

    @Override
    public boolean isServerLocalRJVM(DispatcherRemote dispatcherRemote) {
        return false;
    }
}

