/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.BufferOutputStreamChunked;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadChunkBase;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;

public class PayloadFactoryImpl {
    static boolean REPLACE_STOLEN_CHUNKS;
    static int SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT;
    static int CHUNK_LINK_THRESHOLD;

    static BufferOutputStream createOutputStream() {
        return new BufferOutputStreamChunked(null);
    }

    public static Payload createPayload(InputStream inputStream) throws IOException {
        int len = ((DataInput)((Object)inputStream)).readInt();
        if (len > CHUNK_LINK_THRESHOLD) {
            if (inputStream instanceof ChunkedDataInputStream) {
                ChunkedDataInputStream cdis = (ChunkedDataInputStream)inputStream;
                return new PayloadChunkBase(PayloadChunkBase.linkAndCopyChunksWithoutWastedMemory(cdis, len));
            }
            if (inputStream instanceof BufferInputStreamChunked) {
                ChunkedDataInputStream cdis = ((BufferInputStreamChunked)inputStream).getInternalCDIS();
                return new PayloadChunkBase(PayloadChunkBase.linkAndCopyChunksWithoutWastedMemory(cdis, len));
            }
        }
        return PayloadFactoryImpl.copyPayloadFromStream(inputStream, len);
    }

    static final Payload copyPayloadFromStream(InputStream inputStream, int length) throws IOException {
        Chunk first = PayloadChunkBase.copyIntoSharedChunks(inputStream, length);
        return new PayloadChunkBase(first);
    }

    static final Payload convertObjectToPayload(Object object) throws IOException {
        BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        bos.flush();
        return bos.moveToPayload();
    }

    static {
        String display;
        Integer i;
        String prop2;
        REPLACE_STOLEN_CHUNKS = true;
        SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT = 0;
        CHUNK_LINK_THRESHOLD = Chunk.CHUNK_SIZE * 9;
        try {
            int val;
            prop2 = "weblogic.jms.CHUNK_LINK_THRESHOLD";
            i = Integer.getInteger(prop2);
            if (i != null && CHUNK_LINK_THRESHOLD != (val = i.intValue())) {
                CHUNK_LINK_THRESHOLD = val;
                display = prop2 + "=" + CHUNK_LINK_THRESHOLD;
                System.out.println(display);
            }
        }
        catch (Throwable prop2) {
            // empty catch block
        }
        try {
            prop2 = "weblogic.jms.addChunkPool";
            String noPool = "noPool";
            String tc = System.getProperty("weblogic.jms.addChunkPool");
            if (tc != null && "noPool".equals(tc)) {
                display = "PayloadFactoryImpl weblogic.jms.addChunkPool";
                REPLACE_STOLEN_CHUNKS = false;
                display = display + " do NOT proactively refill chunk pool!!";
                System.out.println(display);
            }
        }
        catch (Throwable prop3) {
            // empty catch block
        }
        try {
            int val;
            prop2 = "weblogic.jms.ReplaceChunkPoolShift";
            i = Integer.getInteger("weblogic.jms.ReplaceChunkPoolShift");
            if (i != null && SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT != (val = i.intValue())) {
                SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT = val;
                display = "PayloadFactoryImpl weblogic.jms.ReplaceChunkPoolShift";
                display = display + "= " + SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT + " value";
                System.out.println(display);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

