/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import weblogic.jms.common.SecHelper;

public final class PasswordStore {
    private long currentHandle = Long.MIN_VALUE;
    private HashMap store = new HashMap();
    private char[] key;
    private static final char[] DEFAULT_KEY = new char[]{'B', 'E', 'A', '0', '1'};

    public PasswordStore() {
        this(DEFAULT_KEY);
    }

    public PasswordStore(char[] paramKey) {
        if (paramKey == null || paramKey.length <= 0) {
            paramKey = DEFAULT_KEY;
        }
        this.key = new char[paramKey.length];
        System.arraycopy(paramKey, 0, this.key, 0, paramKey.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object storePassword(Object password) throws GeneralSecurityException {
        String encryptedPassword;
        StoreData data;
        if (password == null) {
            data = new StoreData(2, password);
        } else if (password instanceof String) {
            encryptedPassword = SecHelper.encryptString(this.key, (String)password);
            data = new StoreData(0, encryptedPassword);
        } else if (password instanceof char[]) {
            encryptedPassword = SecHelper.encryptPassword(this.key, (char[])password);
            data = new StoreData(1, encryptedPassword);
        } else {
            data = new StoreData(2, password);
        }
        HashMap hashMap = this.store;
        synchronized (hashMap) {
            Long handle = new Long(this.currentHandle++);
            this.store.put(handle, data);
            return handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrievePassword(Object handle) throws GeneralSecurityException, IOException {
        StoreData data;
        if (handle == null) {
            return null;
        }
        if (!(handle instanceof Long)) {
            throw new GeneralSecurityException("Invalid handle type: " + handle.getClass().getName());
        }
        Long trueHandle = (Long)handle;
        HashMap hashMap = this.store;
        synchronized (hashMap) {
            if (!this.store.containsKey(trueHandle)) {
                return null;
            }
            data = (StoreData)this.store.get(trueHandle);
        }
        if (data.getType() == 1) {
            return SecHelper.decryptString(this.key, (String)data.getData());
        }
        if (data.getType() == 0) {
            return new String(SecHelper.decryptString(this.key, (String)data.getData()));
        }
        return data.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePassword(Object handle) {
        if (handle == null) {
            return;
        }
        if (!(handle instanceof Long)) {
            return;
        }
        HashMap hashMap = this.store;
        synchronized (hashMap) {
            this.store.remove(handle);
        }
    }

    private static class StoreData {
        private static final int TYPE_STRING = 0;
        private static final int TYPE_CHARARRAY = 1;
        private static final int TYPE_OTHER = 2;
        private int type;
        private Object data;

        private StoreData(int paramType, Object paramData) {
            this.type = paramType;
            this.data = paramData;
        }

        private int getType() {
            return this.type;
        }

        private Object getData() {
            return this.data;
        }
    }
}

