/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.Destination;
import jakarta.jms.ObjectMessage;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.kernel.KernelStatus;
import weblogic.store.PersistentStoreException;
import weblogic.store.TestStoreException;
import weblogic.utils.io.FilteringObjectInputStream;
import weblogic.utils.io.ReadObjectUtils;
import weblogic.utils.io.Replacer;

public final class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
Externalizable,
TestStoreException {
    private static final byte EXTVERSION = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = -1035306457762201546L;
    private transient Serializable object;
    PayloadStream payload;
    private static final Replacer REPLACER;
    private static final String REMOTE_OBJECT_REPLACER_CLASS_NAME = "weblogic.rmi.utils.io.RemoteObjectReplacer";
    private static boolean testStoreExceptionEnabled;
    public static final String DEBUG_STORE_PROPERTY = "JMS_BEA_DEBUG_STORE_EXCEPTION";

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(ObjectMessage message) throws jakarta.jms.JMSException {
        this(message, null, null);
    }

    public ObjectMessageImpl(ObjectMessage message, Destination destination, Destination replyDestination) throws jakarta.jms.JMSException {
        super(message, destination, replyDestination);
        this.setObject(message.getObject());
    }

    @Override
    public byte getType() {
        return 4;
    }

    public static boolean isTestStoreExceptionEnabled() {
        return testStoreExceptionEnabled;
    }

    @Override
    public void setObject(Serializable object) throws jakarta.jms.JMSException {
        this.setObject(object, null);
    }

    public void setObject(Serializable object, PeerInfo peerInfo) throws jakarta.jms.JMSException {
        this.writeMode();
        try {
            BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
            ObjectOutputStream2 oos = null;
            oos = peerInfo == null ? new ObjectOutputStream2(bos) : new ObjectOutputStreamPeerInfoable(bos, peerInfo);
            if (!oos.canReplace()) {
                object = (Serializable)oos.replaceObject(object);
            }
            oos.writeObject(object);
            oos.flush();
            this.payload = (PayloadStream)bos.moveToPayload();
            this.object = null;
        }
        catch (Exception e) {
            throw new JMSException(JMSClientExceptionLogger.logSerializationErrorLoggable().getMessage(), (Throwable)e);
        }
    }

    @Override
    public Serializable getObject() throws jakarta.jms.JMSException {
        this.decompressMessageBody();
        if (this.object == null && this.payload != null) {
            try {
                ObjectInputStream2 ois = new ObjectInputStream2(this.payload.getInputStream());
                this.object = (Serializable)ois.readObject();
                if (!ois.canResolve()) {
                    this.object = (Serializable)ois.resolveObject(this.object);
                }
            }
            catch (IOException ioe) {
                throw new JMSException(JMSClientExceptionLogger.logDeserializeIOLoggable().getMessage(), (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new JMSException(JMSClientExceptionLogger.logDeserializeCNFELoggable().getMessage(), (Throwable)cnfe);
            }
            catch (OutOfMemoryError oome) {
                IOException ioe = ReadObjectUtils.handleOutOfMemoryError(oome);
                throw new JMSException(JMSClientExceptionLogger.logDeserializeIOLoggable().getMessage(), (Throwable)ioe);
            }
        }
        return this.object;
    }

    @Override
    public void nullBody() {
        this.object = null;
        this.payload = null;
    }

    public String toString() {
        try {
            return "ObjectMessage[" + this.getJMSMessageID() + "," + this.getObject() + "]";
        }
        catch (jakarta.jms.JMSException jmse) {
            return "ObjectMessage[" + this.getJMSMessageID() + "]";
        }
    }

    private static Replacer getReplacer() {
        try {
            Class<?> ror = Class.forName(REMOTE_OBJECT_REPLACER_CLASS_NAME);
            Method getReplacerMethod = ror.getMethod("getReplacer", new Class[0]);
            return (Replacer)getReplacerMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
        catch (InvocationTargetException ite) {
            throw new AssertionError((Object)ite);
        }
    }

    @Override
    public PersistentStoreException getTestException() {
        try {
            Serializable value;
            if (ObjectMessageImpl.isTestStoreExceptionEnabled() && this.propertyExists(DEBUG_STORE_PROPERTY) && (value = this.getObject()) instanceof PersistentStoreException) {
                return (PersistentStoreException)value;
            }
        }
        catch (jakarta.jms.JMSException jMSException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        ObjectOutput out;
        super.writeExternal(tOut);
        int compressionThreshold = Integer.MAX_VALUE;
        if (tOut instanceof MessageImpl.JMSObjectOutputWrapper) {
            compressionThreshold = ((MessageImpl.JMSObjectOutputWrapper)tOut).getCompressionThreshold();
            out = ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput();
        } else {
            out = tOut;
        }
        if (!this.isCompressed() && this.payload == null) {
            BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
            ObjectOutputStream2 os = new ObjectOutputStream2(bos);
            os.writeObject(this.object);
            os.flush();
            this.payload = (PayloadStream)bos.moveToPayload();
        }
        int flag = this.getVersion(out) >= 30 ? (this.needToDecompressDueToInterop(out) ? 2 : (int)((byte)(2 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)))) : 1;
        out.writeByte(flag);
        if (this.isCompressed()) {
            PayloadStream tmp;
            if (flag == 1) {
                tmp = (PayloadStream)this.decompress();
                tmp.writeLengthAndData(out);
            } else if (this.needToDecompressDueToInterop(out)) {
                tmp = (PayloadStream)this.decompress();
                tmp.writeLengthAndData(out);
            } else {
                this.flushCompressedMessageBody(out);
            }
        } else if ((flag & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(out, this.payload);
        } else {
            this.payload.writeLengthAndData(out);
        }
    }

    @Override
    public final void decompressMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            this.payload = (PayloadStream)this.decompress();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        finally {
            this.cleanupCompressedMessageBody();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte unmaskedVersion = in.readByte();
        byte vrsn = (byte)(unmaskedVersion & 0x7F);
        if (vrsn < 1 || vrsn > 2) {
            throw JMSUtilities.versionIOException(vrsn, 1, 2);
        }
        if ((unmaskedVersion & 0xFFFFFF80) != 0) {
            this.readExternalCompressedMessageBody(in);
        } else {
            this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
        }
    }

    @Override
    public MessageImpl copy() throws jakarta.jms.JMSException {
        ObjectMessageImpl omi = new ObjectMessageImpl();
        this.copy(omi);
        try {
            if (this.payload == null && this.object != null) {
                BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
                ObjectOutputStream2 os = new ObjectOutputStream2(bos);
                os.writeObject(this.object);
                os.flush();
                omi.payload = (PayloadStream)bos.moveToPayload();
            } else if (this.payload != null) {
                omi.payload = this.payload.copyPayloadWithoutSharedStream();
                this.payloadCopyOnWrite = true;
                omi.payloadCopyOnWrite = true;
            } else {
                omi.payload = null;
            }
            omi.object = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        omi.setBodyWritable(false);
        omi.setPropertiesWritable(false);
        return omi;
    }

    @Override
    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    public PayloadStream getPayload() {
        return this.payload;
    }

    public byte[] getBodyBytes() throws jakarta.jms.JMSException {
        if (this.payload == null) {
            return new byte[0];
        }
        PayloadStream localPayload = this.payload;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            localPayload.writeTo(baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new JMSException(e);
        }
    }

    public void setBodyBytes(PayloadStream value) {
        this.payload = value;
        this.object = null;
    }

    public PayloadStream getMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return this.payload;
        }
        try {
            return (PayloadStream)this.decompress();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
    }

    static {
        block3: {
            REPLACER = ObjectMessageImpl.getReplacer();
            try {
                String property = System.getProperty("weblogic.store.qa.StoreTest");
                if (property != null) {
                    String trueValue = "true";
                    testStoreExceptionEnabled = trueValue.equalsIgnoreCase(property);
                }
            }
            catch (Throwable ignoreDebugSetUpFailure) {
                if (ignoreDebugSetUpFailure instanceof AccessControlException) break block3;
                ignoreDebugSetUpFailure.printStackTrace();
            }
        }
    }

    final class ObjectOutputStreamPeerInfoable
    extends ObjectOutputStream2
    implements PeerInfoable {
        private PeerInfo peerInfo;

        ObjectOutputStreamPeerInfoable(OutputStream os, PeerInfo peerInfo) throws IOException, StreamCorruptedException {
            super(os);
            this.peerInfo = peerInfo;
        }

        @Override
        public PeerInfo getPeerInfo() {
            return this.peerInfo;
        }
    }

    class ObjectOutputStream2
    extends ObjectOutputStream
    implements WLObjectOutput {
        private boolean canReplace;

        ObjectOutputStream2(OutputStream os) throws IOException, StreamCorruptedException {
            super(os);
            this.canReplace = true;
            if (KernelStatus.isApplet()) {
                this.canReplace = false;
            } else {
                this.enableReplaceObject(true);
            }
        }

        boolean canReplace() {
            return this.canReplace;
        }

        @Override
        protected Object replaceObject(Object o) throws IOException {
            if (REPLACER != null) {
                return REPLACER.replaceObject(o);
            }
            return o;
        }

        @Override
        public final void writeObjectWL(Object o) throws IOException {
            this.writeObject(o);
        }

        @Override
        public final void writeString(String s) throws IOException {
            this.writeObject(s);
        }

        @Override
        public final void writeDate(Date dateval) throws IOException {
            this.writeObject(dateval);
        }

        @Override
        public final void writeArrayList(ArrayList lst) throws IOException {
            this.writeObject(lst);
        }

        @Override
        public final void writeProperties(Properties propval) throws IOException {
            this.writeObject(propval);
        }

        @Override
        public final void writeBytes(byte[] val) throws IOException {
            this.writeObject(val);
        }

        public final void writeBytes(byte[] val, int off, int len) throws IOException {
            byte[] b = new byte[len];
            System.arraycopy(val, off, b, 0, len);
            this.writeObject(b);
        }

        @Override
        public final void writeArrayOfObjects(Object[] aoo) throws IOException {
            this.writeObject(aoo);
        }

        @Override
        public final void writeAbbrevString(String s) throws IOException {
            this.writeObject(s);
        }

        @Override
        public final void writeImmutable(Object o) throws IOException {
            this.writeObject(o);
        }
    }

    final class ObjectInputStream2
    extends FilteringObjectInputStream
    implements WLObjectInput {
        private boolean canResolve;

        ObjectInputStream2(InputStream is) throws IOException, StreamCorruptedException {
            super(is);
            this.canResolve = true;
            if (KernelStatus.isApplet()) {
                this.canResolve = false;
            } else {
                this.enableResolveObject(true);
            }
        }

        boolean canResolve() {
            return this.canResolve;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            this.checkLegacyBlacklistIfNeeded(v.getName());
            Class<?> cls = null;
            if (KernelStatus.isApplet()) {
                cls = Class.forName(v.getName());
            } else {
                ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                try {
                    cls = Class.forName(v.getName(), true, ccl);
                }
                catch (ClassNotFoundException cfe) {
                    cls = super.resolveClass(v);
                }
            }
            this.validateReturnType(cls);
            return cls;
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            if (KernelStatus.isApplet()) {
                return super.resolveProxyClass(interfaces);
            }
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            try {
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> cl = Class.forName(interfaces[i], false, ccl);
                    if ((cl.getModifiers() & 1) == 0) {
                        if (hasNonPublicInterface) {
                            if (nonPublicLoader != cl.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            nonPublicLoader = cl.getClassLoader();
                            hasNonPublicInterface = true;
                        }
                    }
                    classObjs[i] = cl;
                }
                return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : ccl, classObjs);
            }
            catch (ClassNotFoundException | IllegalArgumentException e) {
                return super.resolveProxyClass(interfaces);
            }
        }

        @Override
        protected Object resolveObject(Object o) throws IOException {
            if (REPLACER != null) {
                return REPLACER.resolveObject(o);
            }
            return o;
        }

        @Override
        public final Object readObjectWL() throws IOException, ClassNotFoundException {
            return this.readObject();
        }

        @Override
        public final Object readObjectWLValidated(Class returnType) throws IOException, ClassNotFoundException {
            return this.readObjectValidated(returnType);
        }

        @Override
        public final String readString() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
        }

        @Override
        public final Date readDate() throws IOException {
            try {
                return (Date)this.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
        }

        @Override
        public final ArrayList readArrayList() throws IOException, ClassNotFoundException {
            return (ArrayList)this.readObject();
        }

        @Override
        public final Properties readProperties() throws IOException {
            try {
                return (Properties)this.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
        }

        @Override
        public final byte[] readBytes() throws IOException {
            try {
                return (byte[])this.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
        }

        @Override
        public final Object[] readArrayOfObjects() throws IOException, ClassNotFoundException {
            return (Object[])this.readObject();
        }

        @Override
        public final String readAbbrevString() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
        }

        @Override
        public final Object readImmutable() throws IOException, ClassNotFoundException {
            return this.readObject();
        }
    }
}

