/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageFormatException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.TypeConverter;
import weblogic.utils.io.FilteringObjectInputStream;

public final class MapMessageImpl
extends MessageImpl
implements MapMessage,
Externalizable {
    private static final byte EXTVERSION = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = -3363325517439700010L;
    private HashMap hashMap;
    private PayloadStream payload;
    private PeerInfo peerInfo;

    public MapMessageImpl() {
        this.peerInfo = PeerInfo.getPeerInfo();
    }

    public MapMessageImpl(MapMessage message) throws jakarta.jms.JMSException {
        this(message, null, null);
    }

    public MapMessageImpl(MapMessage message, Destination destination, Destination replyDestination) throws jakarta.jms.JMSException {
        super(message, destination, replyDestination);
        Enumeration keys = message.getMapNames();
        if (keys.hasMoreElements()) {
            this.hashMap = new HashMap();
            do {
                String name = (String)keys.nextElement();
                this.hashMap.put(name, message.getObject(name));
            } while (keys.hasMoreElements());
        }
        this.peerInfo = PeerInfo.getPeerInfo();
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public boolean getBoolean(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toBoolean(this.getObject(name));
    }

    @Override
    public byte getByte(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toByte(this.getObject(name));
    }

    @Override
    public byte[] getBytes(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toByteArray(this.getObject(name));
    }

    @Override
    public char getChar(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toChar(this.getObject(name));
    }

    @Override
    public double getDouble(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toDouble(this.getObject(name));
    }

    @Override
    public float getFloat(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toFloat(this.getObject(name));
    }

    @Override
    public short getShort(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toShort(this.getObject(name));
    }

    @Override
    public int getInt(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toInt(this.getObject(name));
    }

    @Override
    public long getLong(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toLong(this.getObject(name));
    }

    @Override
    public String getString(String name) throws jakarta.jms.JMSException {
        return TypeConverter.toString(this.getObject(name));
    }

    @Override
    public Object getObject(String name) throws jakarta.jms.JMSException {
        return this.getHashMap().get(name);
    }

    @Override
    public Enumeration getMapNames() throws jakarta.jms.JMSException {
        return Collections.enumeration(this.getHashMap().keySet());
    }

    @Override
    public void setBoolean(String name, boolean value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Boolean(value));
    }

    @Override
    public void setByte(String name, byte value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Byte(value));
    }

    @Override
    public void setBytes(String name, byte[] value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value, int offset, int length) throws jakarta.jms.JMSException {
        byte[] copy = new byte[length];
        System.arraycopy(value, offset, copy, 0, length);
        this.setObjectInternal(name, copy);
    }

    @Override
    public void setChar(String name, char value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Character(value));
    }

    @Override
    public void setDouble(String name, double value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Double(value));
    }

    @Override
    public void setFloat(String name, float value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Float(value));
    }

    @Override
    public void setInt(String name, int value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Integer(value));
    }

    @Override
    public void setLong(String name, long value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Long(value));
    }

    @Override
    public void setObject(String name, Object value) throws jakarta.jms.JMSException {
        if (!(value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof byte[] || value instanceof Character || value == null)) {
            throw new MessageFormatException(JMSClientExceptionLogger.logInvalidDataTypeLoggable(value.getClass().getName()).getMessage());
        }
        this.setObjectInternal(name, value);
    }

    @Override
    public void setShort(String name, short value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, new Short(value));
    }

    @Override
    public void setString(String name, String value) throws jakarta.jms.JMSException {
        this.setObjectInternal(name, value);
    }

    private void setObjectInternal(String name, Object value) throws jakarta.jms.JMSException {
        this.writeMode();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logIllegalNameLoggable(name).getMessage());
        }
        this.getHashMap().put(name, value);
    }

    @Override
    public boolean itemExists(String name) throws jakarta.jms.JMSException {
        return this.getHashMap().containsKey(name);
    }

    @Override
    public void nullBody() {
        this.payload = null;
        this.hashMap = null;
    }

    public String toString() {
        return "MapMessage[" + this.getJMSMessageID() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        PayloadStream localPayload;
        ObjectOutput out;
        super.writeExternal(tOut);
        int compressionThreshold = Integer.MAX_VALUE;
        if (tOut instanceof MessageImpl.JMSObjectOutputWrapper) {
            compressionThreshold = ((MessageImpl.JMSObjectOutputWrapper)tOut).getCompressionThreshold();
            out = ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput();
        } else {
            out = tOut;
        }
        PeerInfo peerInfo = out instanceof PeerInfoable ? ((PeerInfoable)((Object)out)).getPeerInfo() : PeerInfo.getPeerInfo();
        if (!this.isCompressed()) {
            MapMessageImpl mapMessageImpl = this;
            synchronized (mapMessageImpl) {
                localPayload = this.getMapPayload(peerInfo);
                if (this.payload == null) {
                    this.payload = localPayload;
                    this.peerInfo = peerInfo;
                    this.hashMap = null;
                }
            }
        } else {
            localPayload = null;
        }
        int flag = this.getVersion(out) >= 30 ? (this.needToDecompressDueToInterop(out) ? 2 : (int)((byte)(2 | (this.shouldCompress(out, compressionThreshold) ? -128 : 0)))) : 1;
        out.writeByte(flag);
        if (this.isCompressed()) {
            if (flag == 1) {
                this.decompress().writeLengthAndData(out);
            } else if (this.needToDecompressDueToInterop(out)) {
                this.decompress().writeLengthAndData(out);
            } else {
                this.flushCompressedMessageBody(out);
            }
        } else if ((flag & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(out, localPayload);
        } else {
            localPayload.writeLengthAndData(out);
        }
    }

    @Override
    public final void decompressMessageBody() throws jakarta.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            this.payload = (PayloadStream)this.decompress();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)ioe);
        }
        finally {
            this.cleanupCompressedMessageBody();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PeerInfo peerInfo;
        super.readExternal(in);
        byte unmaskedVersion = in.readByte();
        byte vrsn = (byte)(unmaskedVersion & 0x7F);
        if (vrsn < 1 || vrsn > 2) {
            throw JMSUtilities.versionIOException(vrsn, 1, 2);
        }
        this.peerInfo = PeerInfo.getPeerInfo();
        if (in instanceof PeerInfoable && (peerInfo = ((PeerInfoable)((Object)in)).getPeerInfo()) != null && peerInfo.compareTo(this.peerInfo) < 0) {
            this.peerInfo = peerInfo;
        }
        if ((unmaskedVersion & 0xFFFFFF80) != 0) {
            this.readExternalCompressedMessageBody(in);
        } else {
            this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)in));
        }
    }

    @Override
    public MessageImpl copy() throws jakarta.jms.JMSException {
        MapMessageImpl mmi = new MapMessageImpl();
        this.copy(mmi);
        try {
            mmi.peerInfo = PeerInfo.getPeerInfo();
            PayloadStream localPayload = this.getMapPayload(mmi.peerInfo);
            mmi.payload = localPayload.copyPayloadWithoutSharedStream();
        }
        catch (IOException ioe) {
            throw new JMSException(JMSClientExceptionLogger.logCopyErrorLoggable().getMessage(), (Throwable)ioe);
        }
        mmi.setBodyWritable(false);
        mmi.setPropertiesWritable(false);
        return mmi;
    }

    @Override
    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        this.bodySize = this.payload == null ? 0L : (long)this.payload.getLength();
        return this.bodySize;
    }

    private HashMap getHashMap() throws jakarta.jms.JMSException {
        if (this.hashMap != null) {
            return this.hashMap;
        }
        this.decompressMessageBody();
        if (this.payload == null) {
            this.hashMap = new HashMap();
        } else {
            try {
                FilteringObjectInputStream ois = new FilteringObjectInputStream(this.payload.getInputStream());
                this.hashMap = JMSUtilities.readBigStringBasicMap(ois);
            }
            catch (IOException ioe) {
                throw new JMSException(JMSClientExceptionLogger.logDeserializationErrorLoggable().getMessage(), (Throwable)ioe);
            }
        }
        this.payload = null;
        return this.hashMap;
    }

    private PayloadStream getMapPayload(PeerInfo peerInfo) throws IOException {
        HashMap hashMap = this.hashMap;
        if (this.payload != null) {
            if (this.peerInfo != null && this.peerInfo.equals(peerInfo)) {
                return this.payload;
            }
            FilteringObjectInputStream ois = new FilteringObjectInputStream(this.payload.getInputStream());
            hashMap = JMSUtilities.readBigStringBasicMap(ois);
        } else if (hashMap == null) {
            hashMap = new HashMap();
        }
        BufferOutputStream bos = PayloadFactoryImpl.createOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        JMSUtilities.writeBigStringBasicMap(oos, hashMap, peerInfo, true);
        oos.flush();
        return (PayloadStream)bos.moveToPayload();
    }
}

