/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class JMSPushExceptionRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -8924769504929515114L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private JMSException exception;

    public JMSPushExceptionRequest(int invocableType, JMSID invocableId, JMSException exception) {
        super(invocableId, 0x3C00 | invocableType);
        this.exception = exception;
    }

    public void setInvocableType(int invocableType) {
        this.methodId = this.methodId & 0xFFFF00 & invocableType;
    }

    public JMSException getException() {
        return this.exception;
    }

    @Override
    public int remoteSignature() {
        return 64;
    }

    @Override
    public boolean isServerOneWay() {
        return true;
    }

    @Override
    public boolean isServerToServer() {
        return false;
    }

    @Override
    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public JMSPushExceptionRequest() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int mask = 1;
        out.writeInt(mask);
        super.writeExternal(out);
        out.writeObject(this.exception);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int mask = in.readInt();
        int version = mask & 0xFF;
        if (version != 1) {
            throw JMSUtilities.versionIOException(version, 1, 1);
        }
        super.readExternal(in);
        this.exception = (JMSException)in.readObject();
    }
}

