/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;

public final class HdrMessageImpl
extends MessageImpl
implements Externalizable {
    private static final byte EXTVERSION = 1;
    static final long serialVersionUID = -5400333814519213733L;
    private int controlOpcode;

    public HdrMessageImpl() {
    }

    public HdrMessageImpl(Message message) throws JMSException {
        this(message, null, null);
    }

    @Override
    public void nullBody() {
    }

    public HdrMessageImpl(Message message, Destination destination, Destination replyDestination) throws JMSException {
        super(message, destination, replyDestination);
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public final int getControlOpcode() {
        return this.controlOpcode;
    }

    @Override
    public final void setControlOpcode(int opcode) {
        assert ((opcode & 0xFF00FFFF) == 0);
        this.controlOpcode = opcode;
    }

    @Override
    public void writeExternal(ObjectOutput tOut) throws IOException {
        super.writeExternal(tOut);
        ObjectOutput out = tOut instanceof MessageImpl.JMSObjectOutputWrapper ? ((MessageImpl.JMSObjectOutputWrapper)tOut).getInnerObjectOutput() : tOut;
        out.writeByte(1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte vrsn = in.readByte();
        if (vrsn != 1) {
            throw JMSUtilities.versionIOException(vrsn, 1, 1);
        }
    }

    @Override
    public MessageImpl copy() throws JMSException {
        HdrMessageImpl hmi = new HdrMessageImpl();
        this.copy(hmi);
        return hmi;
    }

    @Override
    public long getPayloadSize() {
        return 0L;
    }

    @Override
    public void decompressMessageBody() {
    }
}

