/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import jakarta.jms.JMSException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import weblogic.jms.common.ClientCrossDomainSecurityUtil;
import weblogic.jms.common.CrossDomainSecurityUtil;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class CrossDomainSecurityManager {
    private static final String THICK_SUBJECT_MANAGER = "weblogic.security.service.SubjectManagerImpl";
    private static final String IIOPCLIENT_SUBJECT_MANAGER = "weblogic.corba.client.security.SubjectManagerImpl";
    private static final String T3CLIENT_SUBJECT_MANAGER = "weblogic.security.subject.SubjectManager";
    private static boolean initialized;
    private static final AbstractSubject kernelID;
    public static CrossDomainSecurityUtil util;

    private static final AbstractSubject getKernelIdentity() {
        try {
            CrossDomainSecurityManager.ensureSubjectManagerInitialized();
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException ace) {
            return null;
        }
    }

    public static CrossDomainSecurityUtil getCrossDomainSecurityUtil() {
        return util;
    }

    public static void setCrossDomainSecurityUtil(CrossDomainSecurityUtil cdsutil) {
        util = cdsutil;
    }

    public static void ensureSubjectManagerInitialized() {
        Method ensureInitializedMethod;
        Class<?> subjectManagerImpl;
        block13: {
            if (initialized) {
                return;
            }
            try {
                subjectManagerImpl = Class.forName(THICK_SUBJECT_MANAGER);
            }
            catch (ClassNotFoundException c) {
                try {
                    subjectManagerImpl = Class.forName(IIOPCLIENT_SUBJECT_MANAGER);
                }
                catch (ClassNotFoundException d) {
                    try {
                        subjectManagerImpl = Class.forName(T3CLIENT_SUBJECT_MANAGER);
                    }
                    catch (ClassNotFoundException e) {
                        if (SubjectManager.getSubjectManager() != null) {
                            subjectManagerImpl = SubjectManager.getSubjectManager().getClass();
                            break block13;
                        }
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }
        try {
            ensureInitializedMethod = subjectManagerImpl.getMethod("ensureInitialized", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        try {
            ensureInitializedMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        initialized = true;
    }

    public static final AbstractSubject getCurrentSubject() {
        return SubjectManager.getSubjectManager().getCurrentSubject(kernelID);
    }

    public static final void doAs(AbstractSubject subject, PrivilegedExceptionAction action) throws JMSException {
        block2: {
            try {
                subject.doAs(kernelID, action);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (!(e instanceof JMSException)) break block2;
                throw (JMSException)e;
            }
        }
    }

    public static final void doAsWithWrappedException(AbstractSubject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        subject.doAs(kernelID, action);
    }

    public static final Object runAs(AbstractSubject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        return subject.doAs(kernelID, action);
    }

    public static final Object runAs(AbstractSubject subject, PrivilegedAction action) {
        return subject.doAs(kernelID, action);
    }

    static {
        kernelID = CrossDomainSecurityManager.getKernelIdentity();
        util = new ClientCrossDomainSecurityUtil();
    }
}

