/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInput;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringInput;

public class BufferInputStreamChunked
extends BufferInputStream
implements StringInput,
ChunkInput,
ObjectInput {
    private final ObjectIOBypass objectIOBypass;
    private final ChunkedDataInputStream cdis;
    private int mark = 0;
    private static final int VERSION = 1234;

    public BufferInputStreamChunked(ObjectIOBypass objectIOBypass, ChunkedDataInputStream cdis) {
        this.objectIOBypass = objectIOBypass;
        this.cdis = cdis;
        this.internalMarkForCDIS();
    }

    private void internalMarkForCDIS() {
        this.cdis.mark(16384);
    }

    private void internalReset() {
        this.cdis.reset();
        this.internalMarkForCDIS();
    }

    ChunkedDataInputStream getInternalCDIS() {
        return this.cdis;
    }

    @Override
    public void unput() throws IOException {
        int targetLocation = this.cdis.pos() - 1;
        this.internalReset();
        this.cdis.skip(targetLocation);
    }

    @Override
    public void reset() throws IOException {
        this.internalReset();
        this.skip(this.mark);
        this.mark = 0;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos();
    }

    @Override
    public int pos() {
        return this.cdis.pos();
    }

    @Override
    public void gotoPos(int oldPos) throws IOException {
        this.mark = 0;
        this.internalReset();
        this.skip(oldPos);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int size() {
        return Chunk.size(this.cdis.getChunks());
    }

    @Override
    public int read() throws IOException {
        return this.cdis.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.cdis.read(b, off, len);
    }

    @Override
    public int available() {
        return this.cdis.available();
    }

    @Override
    public synchronized void close() throws IOException {
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.cdis.readFully(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.cdis.skipBytes(n);
    }

    @Override
    public Chunk readChunks() throws IOException {
        return this.cdis.readChunks();
    }

    public int peekInt(int offset) throws IOException {
        return this.cdis.peekInt(offset);
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        int version = this.readInt();
        if (version != 1234) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logUnknownStreamVersionLoggable(version).getMessage());
        }
        if (this.objectIOBypass == null) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logRawObjectErrorLoggable().getMessage());
        }
        return this.objectIOBypass.readObject(this);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.cdis.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.cdis.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.cdis.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return this.cdis.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.cdis.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return this.cdis.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        return this.cdis.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        return this.cdis.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.cdis.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.cdis.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        throw new IOException(JMSClientExceptionLogger.logNotImplementedLoggable().getMessage());
    }

    @Override
    public final String readUTF() throws IOException {
        return DataIO.readUTF(this);
    }

    @Override
    public final String readASCII() throws IOException {
        return this.cdis.readASCII();
    }

    @Override
    public final String readUTF8() throws IOException {
        return this.cdis.readUTF8();
    }

    @Override
    public final String readUTF32() throws IOException {
        return BufferInputStreamChunked.readUTF32(this);
    }

    static String readUTF32(DataInput dis) throws IOException {
        int utflen = dis.readInt();
        StringBuffer str = new StringBuffer(utflen);
        int count = 0;
        block5: while (count < utflen) {
            int c = dis.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = dis.readByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = dis.readByte();
                    byte char3 = dis.readByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }
}

