/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.utils.io.DataIO;

public final class BufferDataInputStream
extends BufferInputStream
implements ObjectInput {
    private byte[] buf;
    private int pos;
    private int mark = 0;
    private final int offset;
    private int count;
    private final ObjectIOBypass objectIOBypass;
    private static final int VERSION = 1234;

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.count = buf.length;
        this.offset = 0;
        this.objectIOBypass = objectIOBypass;
    }

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.offset = offset;
        this.objectIOBypass = objectIOBypass;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public void unput() {
        --this.pos;
    }

    public int size() {
        return this.count;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimitIsIgnored) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.offset;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    void gotoPos(int oldPos) throws IOException {
        this.pos = oldPos;
    }

    @Override
    public synchronized void close() throws IOException {
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (this.pos + len > this.count) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        int numSkipped = Math.min(this.count - this.pos, n);
        this.pos += numSkipped;
        return numSkipped;
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        int version = this.readInt();
        if (version != 1234) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logUnknownStreamVersionLoggable(version).getMessage());
        }
        if (this.objectIOBypass == null) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logRawObjectErrorLoggable().getMessage());
        }
        return this.objectIOBypass.readObject(this);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++] != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++];
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int result = ((short)(this.buf[this.pos] & 0xFF) << 8) + ((short)(this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (short)result;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int result = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return result;
    }

    @Override
    public final char readChar() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int result = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (char)result;
    }

    final int peekInt(int offsetFromPos) throws IOException {
        int peekpos = this.pos + offsetFromPos;
        if (peekpos + 4 > this.count) {
            return -42;
        }
        return ((this.buf[this.pos] & 0xFF) << 24) + ((this.buf[this.pos + 1] & 0xFF) << 16) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 0);
    }

    @Override
    public final int readInt() throws IOException {
        if (this.pos + 4 > this.count) {
            throw new EOFException();
        }
        int result = ((this.buf[this.pos] & 0xFF) << 24) + ((this.buf[this.pos + 1] & 0xFF) << 16) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 0);
        this.pos += 4;
        return result;
    }

    @Override
    public final long readLong() throws IOException {
        if (this.pos + 8 > this.count) {
            throw new EOFException();
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        throw new IOException(JMSClientExceptionLogger.logNotImplementedLoggable().getMessage());
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final String readUTF32() throws IOException {
        return BufferDataInputStream.readUTF32(this);
    }

    public final String readUTF8() throws IOException {
        return DataIO.readUTF8(this);
    }

    public static String readUTF32(DataInput dis) throws IOException {
        int utflen = dis.readInt();
        StringBuffer str = new StringBuffer(utflen);
        int count = 0;
        block5: while (count < utflen) {
            int c = dis.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = dis.readByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = dis.readByte();
                    byte char3 = dis.readByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }
}

