/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.TransactionRolledBackException;
import java.io.Serializable;
import javax.transaction.xa.XAResource;
import org.w3c.dom.Document;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.MMessageListener;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLAcknowledgeInfo;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.extensions.XMLMessage;
import weblogic.messaging.dispatcher.CompletionListener;

public class WLSessionImpl
extends ReconnectController
implements SessionInternal,
WLAsyncSession {
    private WLConnectionImpl parent;

    public WLSessionImpl(JMSSession producer, WLConnectionImpl recConnection) {
        super(recConnection, producer);
        this.parent = recConnection;
    }

    @Override
    protected ReconnectController getParent() {
        return this.parent;
    }

    @Override
    protected Object getConnectionStateLock() {
        return this.parent.getConnectionStateLock();
    }

    @Override
    protected WLConnectionImpl getWLConnectionImpl() {
        return this.parent.getWLConnectionImpl();
    }

    @Override
    protected JMSConnection getPhysicalJMSConnection() {
        return this.parent.getPhysicalJMSConnection();
    }

    protected JMSSession getJMSSessionWaitForState() {
        return (JMSSession)this.getPhysicalWaitForState();
    }

    protected JMSSession getPhysicalJMSSession() {
        return (JMSSession)this.getPhysical();
    }

    @Override
    public void acknowledge() throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.throwForAckRefreshedSessionRules();
        physicalJMSSession.acknowledge();
    }

    @Override
    public void commit() throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        if (physicalJMSSession.checkRefreshedWithPendingWork()) {
            throw new TransactionRolledBackException(JMSClientExceptionLogger.logLostServerConnectionLoggable().getMessage(), "ReservedRollbackOnly");
        }
        physicalJMSSession.commit();
    }

    @Override
    public void recover() throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.checkRefreshedWithPendingWork();
        physicalJMSSession.recover();
    }

    @Override
    public void rollback() throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.checkRefreshedWithPendingWork();
        physicalJMSSession.rollback();
    }

    @Override
    public void run() {
        this.getPhysicalJMSSession().run();
    }

    @Override
    public void acknowledge(Message message) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.throwForAckRefreshedSessionRules();
        physicalJMSSession.acknowledge(message);
    }

    @Override
    public void acknowledge(WLAcknowledgeInfo ackInfo) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.throwForAckRefreshedSessionRules();
        physicalJMSSession.acknowledge(ackInfo);
    }

    public long getLastSequenceNumber() {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        return physicalJMSSession.getLastSequenceNumber();
    }

    @Override
    public void setMMessageListener(MMessageListener listener) {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.setMMessageListener(listener);
    }

    public void close(long sequenceNumber) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.close(sequenceNumber);
    }

    public void commit(long sequenceNumber) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.commit(sequenceNumber);
    }

    public int rollback(long sequenceNumber) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.rollback(sequenceNumber);
        return physicalJMSSession.getPipelineGenerationFromProxy();
    }

    public int recover(long sequenceNumber) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.recover(sequenceNumber);
        return physicalJMSSession.getPipelineGenerationFromProxy();
    }

    public void removePendingWTMessage(long sequenceNumber) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.removePendingWTMessage(sequenceNumber, true);
    }

    public int getPipelineGenerationFromProxy() throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        return physicalJMSSession.getPipelineGenerationFromProxy();
    }

    public void acknowledge(Message message, int acknowledgePolicy, boolean isInfectedAck) throws jakarta.jms.JMSException {
        JMSSession physicalJMSSession = this.getPhysicalJMSSession();
        physicalJMSSession.throwForAckRefreshedSessionRules();
        physicalJMSSession.acknowledge((MessageImpl)message, acknowledgePolicy, isInfectedAck);
    }

    @Override
    public void pushMessage(MessageImpl message, JMSPushEntry pushEntry) {
        this.getPhysicalJMSSession().pushMessage(message, pushEntry);
    }

    @Override
    public void checkSAFClosed() throws jakarta.jms.JMSException {
        this.getPhysicalJMSSession().checkSAFClosed();
    }

    @Override
    public int consumersCount() {
        return this.getJMSSessionWaitForState().consumersCount();
    }

    @Override
    public int producersCount() {
        return this.getJMSSessionWaitForState().producersCount();
    }

    @Override
    public String getWLSServerName() {
        return this.getJMSSessionWaitForState().getWLSServerName();
    }

    @Override
    public String getRuntimeMBeanName() {
        return this.getJMSSessionWaitForState().getRuntimeMBeanName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return this.getJMSSessionWaitForState().getParentInfo();
    }

    @Override
    public String getPartitionName() {
        return this.getPhysicalJMSConnection().getPartitionName();
    }

    @Override
    public JMSID getJMSID() {
        return this.getJMSSessionWaitForState().getJMSID();
    }

    @Override
    public void setPipelineGeneration(int pipelineGeneration) {
        this.getJMSSessionWaitForState().setPipelineGeneration(pipelineGeneration);
    }

    @Override
    public XMLMessage createXMLMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createXMLMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createXMLMessage();
        }
    }

    @Override
    public XMLMessage createXMLMessage(String xml) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createXMLMessage(xml);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createXMLMessage(xml);
        }
    }

    @Override
    public XMLMessage createXMLMessage(Document doc) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createXMLMessage(doc);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createXMLMessage(doc);
        }
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.setExceptionListener(exceptionListener);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).setExceptionListener(exceptionListener);
        }
    }

    @Override
    public int getMessagesMaximum() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.getMessagesMaximum();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).getMessagesMaximum();
        }
    }

    @Override
    public void setMessagesMaximum(int messagesMaximum) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.setMessagesMaximum(messagesMaximum);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).setMessagesMaximum(messagesMaximum);
        }
    }

    @Override
    public int getOverrunPolicy() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.getOverrunPolicy();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).getOverrunPolicy();
        }
    }

    @Override
    public void setOverrunPolicy(int policy) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.setOverrunPolicy(policy);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).setOverrunPolicy(policy);
        }
    }

    @Override
    public long getRedeliveryDelay() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.getRedeliveryDelay();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).getRedeliveryDelay();
        }
    }

    @Override
    public void setRedeliveryDelay(long redeliveryDelay) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.setRedeliveryDelay(redeliveryDelay);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).setRedeliveryDelay(redeliveryDelay);
        }
    }

    @Override
    public BytesMessage createBytesMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createBytesMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createBytesMessage();
        }
    }

    @Override
    public MapMessage createMapMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createMapMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createMapMessage();
        }
    }

    @Override
    public Message createMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createMessage();
        }
    }

    @Override
    public ObjectMessage createObjectMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createObjectMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createObjectMessage();
        }
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable serializable) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createObjectMessage(serializable);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createObjectMessage(serializable);
        }
    }

    @Override
    public StreamMessage createStreamMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createStreamMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createStreamMessage();
        }
    }

    @Override
    public TextMessage createTextMessage() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createTextMessage();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createTextMessage();
        }
    }

    @Override
    public TextMessage createTextMessage(String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createTextMessage(uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createTextMessage(uoo);
        }
    }

    @Override
    public boolean getTransacted() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.getTransacted();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).getTransacted();
        }
    }

    @Override
    public int getAcknowledgeMode() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.getAcknowledgeMode();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).getAcknowledgeMode();
        }
    }

    @Override
    public MessageListener getMessageListener() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.getMessageListener();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).getMessageListener();
        }
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.setMessageListener(messageListener);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).setMessageListener(messageListener);
        }
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createProducer(destination);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createProducer(destination);
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createConsumer(destination);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createConsumer(destination);
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createConsumer(destination, uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createConsumer(destination, uoo);
        }
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String uoo, boolean b) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createConsumer(destination, uoo, b);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createConsumer(destination, uoo, b);
        }
    }

    @Override
    public Queue createQueue(String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createQueue(uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createQueue(uoo);
        }
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createReceiver(queue);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createReceiver(queue);
        }
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createReceiver(queue, uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createReceiver(queue, uoo);
        }
    }

    @Override
    public QueueSender createSender(Queue queue) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSender(queue);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSender(queue);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createBrowser(queue);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createBrowser(queue);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createBrowser(queue, uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createBrowser(queue, uoo);
        }
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createTemporaryQueue();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createTemporaryQueue();
        }
    }

    @Override
    public Topic createTopic(String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createTopic(uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createTopic(uoo);
        }
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSubscriber(topic);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSubscriber(topic);
        }
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String uoo, boolean b) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSubscriber(topic, uoo, b);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSubscriber(topic, uoo, b);
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createDurableSubscriber(topic, uoo);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createDurableSubscriber(topic, uoo);
        }
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws jakarta.jms.JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String uoo, String uoo1, boolean b) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createDurableSubscriber(topic, uoo, uoo1, b);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createDurableSubscriber(topic, uoo, uoo1, b);
        }
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws jakarta.jms.JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createPublisher(topic);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createPublisher(topic);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createTemporaryTopic();
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createTemporaryTopic();
        }
    }

    @Override
    public void unsubscribe(String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.unsubscribe(uoo);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).unsubscribe(uoo);
        }
    }

    @Override
    public void unsubscribe(Topic topic, String name) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.unsubscribe(topic, name);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).unsubscribe(topic, name);
        }
    }

    @Override
    public void associateTransaction(Message message) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            physical.associateTransaction(message);
        }
        catch (JMSException jmse) {
            this.computeJMSSession(startTime, physical, jmse).associateTransaction(message);
        }
    }

    @Override
    public void acknowledgeAsync(WLAcknowledgeInfo ackInfo, CompletionListener listener) {
        this.getPhysicalJMSSession().acknowledgeAsync(ackInfo, listener);
    }

    @Override
    public void sendAsync(MessageProducer producer, Message message, CompletionListener listener) {
        ((WLProducerImpl)producer).sendAsync(message, listener);
    }

    @Override
    public void sendAsync(WLMessageProducer producer, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) {
        ((WLProducerImpl)producer).sendAsync(message, deliveryMode, priority, timeToLive, listener);
    }

    @Override
    public void sendAsync(WLMessageProducer producer, Destination destination, Message message, CompletionListener listener) {
        ((WLProducerImpl)producer).sendAsync(destination, message, listener);
    }

    @Override
    public void sendAsync(WLMessageProducer producer, Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) {
        ((WLProducerImpl)producer).sendAsync(destination, message, deliveryMode, priority, timeToLive, listener);
    }

    @Override
    public void receiveAsync(MessageConsumer consumer, CompletionListener listener) {
        ((WLConsumerImpl)consumer).receiveAsync(listener);
    }

    @Override
    public void receiveAsync(MessageConsumer consumer, long timeout, CompletionListener listener) {
        ((WLConsumerImpl)consumer).receiveAsync(timeout, listener);
    }

    @Override
    public void receiveNoWaitAsync(MessageConsumer consumer, CompletionListener listener) {
        ((WLConsumerImpl)consumer).receiveNoWaitAsync(listener);
    }

    @Override
    public XAResource getXAResource(String serverName) {
        return this.getPhysicalJMSSession().getXAResource(serverName);
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSharedConsumer(topic, sharedSubscriptionName);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSharedConsumer(topic, sharedSubscriptionName);
        }
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        }
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSharedDurableConsumer(topic, name);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSharedDurableConsumer(topic, name);
        }
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSSession physical = this.getPhysicalJMSSession();
        try {
            return physical.createSharedDurableConsumer(topic, name, messageSelector);
        }
        catch (JMSException jmse) {
            return this.computeJMSSession(startTime, physical, jmse).createSharedDurableConsumer(topic, name, messageSelector);
        }
    }
}

