/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.ProducerInternal;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;

public class WLProducerImpl
extends ReconnectController
implements ProducerInternal {
    private WLSessionImpl parent;

    public WLProducerImpl(JMSProducer producer, WLSessionImpl recSession) {
        super(recSession, producer);
        this.parent = recSession;
    }

    @Override
    protected ReconnectController getParent() {
        return this.parent;
    }

    @Override
    Object getConnectionStateLock() {
        return this.parent.getConnectionStateLock();
    }

    @Override
    protected WLConnectionImpl getWLConnectionImpl() {
        return this.parent.getWLConnectionImpl();
    }

    @Override
    protected JMSConnection getPhysicalJMSConnection() {
        return this.parent.getPhysicalJMSConnection();
    }

    private JMSProducer getPhysicalJMSProducer() {
        return (JMSProducer)this.getPhysical();
    }

    private JMSProducer checkClosedReconnectGetProducer(long startTime, JMSProducer oldProd) throws JMSException {
        return (JMSProducer)this.checkClosedReconnect(startTime, oldProd);
    }

    private JMSProducer checkClosedReconnectGetProducer() throws JMSException {
        return this.checkClosedReconnectGetProducer(System.currentTimeMillis(), (JMSProducer)this.getPhysical());
    }

    @Override
    public int getCompressionThreshold() throws JMSException {
        return ((JMSProducer)this.getPhysicalWaitForState()).getCompressionThreshold();
    }

    @Override
    public String getWLSServerName() {
        return ((JMSProducer)this.getPhysicalWaitForState()).getWLSServerName();
    }

    @Override
    public String getRuntimeMBeanName() {
        return ((JMSProducer)this.getPhysicalWaitForState()).getRuntimeMBeanName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return ((JMSProducer)this.getPhysicalWaitForState()).getParentInfo();
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    @Override
    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    @Override
    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    @Override
    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    @Override
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message) throws JMSException {
        this.send(topic, message);
    }

    @Override
    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(topic, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void setSequence(String name) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setSequence(name);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setSequence(name);
        }
    }

    @Override
    public String getSequence() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getSequence();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getSequence();
        }
    }

    @Override
    public void reserveUnitOfOrderWithSequence() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.reserveUnitOfOrderWithSequence();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).reserveUnitOfOrderWithSequence();
        }
    }

    @Override
    public void reserveSequence(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.reserveSequence(destination, message, deliveryMode, priority, ttlArg);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.reserveSequence(destination, message, deliveryMode, priority, timeToLive);
        }
    }

    @Override
    public void releaseSequenceAndUnitOfOrder(boolean fanout) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.releaseSequenceAndUnitOfOrder(fanout);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).releaseSequenceAndUnitOfOrder(fanout);
        }
    }

    @Override
    public void releaseSequenceAndUnitOfOrder(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean fanout) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.releaseSequenceAndUnitOfOrder(destination, message, deliveryMode, priority, ttlArg, fanout);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.releaseSequenceAndUnitOfOrder(destination, message, deliveryMode, priority, timeToLive, fanout);
        }
    }

    @Override
    public long getTimeToDeliver() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getTimeToDeliver();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getTimeToDeliver();
        }
    }

    @Override
    public void setTimeToDeliver(long timeToDeliver) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setTimeToDeliver(timeToDeliver);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setTimeToDeliver(timeToDeliver);
        }
    }

    @Override
    public int getRedeliveryLimit() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getRedeliveryLimit();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getRedeliveryLimit();
        }
    }

    @Override
    public void setRedeliveryLimit(int redeliveryLimit) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setRedeliveryLimit(redeliveryLimit);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setRedeliveryLimit(redeliveryLimit);
        }
    }

    @Override
    public long getSendTimeout() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getSendTimeout();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getSendTimeout();
        }
    }

    @Override
    public void setSendTimeout(long sendTimeout) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setSendTimeout(sendTimeout);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setSendTimeout(sendTimeout);
        }
    }

    @Override
    public String getUnitOfOrder() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getUnitOfOrder();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getUnitOfOrder();
        }
    }

    @Override
    public void setUnitOfOrder(String name) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setUnitOfOrder(name);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setUnitOfOrder(name);
        }
    }

    @Override
    public void setUnitOfOrder() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setUnitOfOrder();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setUnitOfOrder();
        }
    }

    @Override
    public void forward(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.forward(message, deliveryMode, priority, ttlArg);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.forward(message, deliveryMode, priority, timeToLive);
        }
    }

    @Override
    public void forward(Message message) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.forward(message);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).forward(message);
        }
    }

    @Override
    public void forward(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.forward(destination, message, deliveryMode, priority, ttlArg);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.forward(destination, message, deliveryMode, priority, timeToLive);
        }
    }

    @Override
    public void forward(Destination destination, Message message) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.forward(destination, message);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).forward(destination, message);
        }
    }

    @Override
    public void setCompressionThreshold(int limit) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setCompressionThreshold(limit);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setCompressionThreshold(limit);
        }
    }

    @Override
    public void setDisableMessageID(boolean b) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setDisableMessageID(b);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setDisableMessageID(b);
        }
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getDisableMessageID();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getDisableMessageID();
        }
    }

    @Override
    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setDisableMessageTimestamp(b);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setDisableMessageTimestamp(b);
        }
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getDisableMessageTimestamp();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getDisableMessageTimestamp();
        }
    }

    @Override
    public void setDeliveryMode(int i) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setDeliveryMode(i);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setDeliveryMode(i);
        }
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getDeliveryMode();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getDeliveryMode();
        }
    }

    @Override
    public void setPriority(int i) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setPriority(i);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setPriority(i);
        }
    }

    @Override
    public int getPriority() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getPriority();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getPriority();
        }
    }

    @Override
    public void setTimeToLive(long l) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.setTimeToLive(l);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.idempotentJMSProducer(startTime, physical, jmse).setTimeToLive(l);
        }
    }

    @Override
    public long getTimeToLive() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getTimeToLive();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getTimeToLive();
        }
    }

    @Override
    public Destination getDestination() throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            return physical.getDestination();
        }
        catch (weblogic.jms.common.JMSException jmse) {
            return this.idempotentJMSProducer(startTime, physical, jmse).getDestination();
        }
    }

    @Override
    public void send(Message message) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.send(message);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).send(message);
        }
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.send(message, deliveryMode, priority, ttlArg);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.send(message, deliveryMode, priority, timeToLive);
        }
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.send(destination, message);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).send(destination, message);
        }
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.send(destination, message, deliveryMode, priority, ttlArg);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.send(destination, message, deliveryMode, priority, timeToLive);
        }
    }

    public void sendAsync(Message message, weblogic.messaging.dispatcher.CompletionListener listener) {
        this.getPhysicalJMSProducer().sendAsync(message, listener);
    }

    public void sendAsync(Message message, int deliveryMode, int priority, long timeToLive, weblogic.messaging.dispatcher.CompletionListener listener) {
        this.getPhysicalJMSProducer().sendAsync(message, deliveryMode, priority, timeToLive, listener);
    }

    public void sendAsync(Destination destination, Message message, weblogic.messaging.dispatcher.CompletionListener listener) {
        this.getPhysicalJMSProducer().sendAsync(destination, message, listener);
    }

    public void sendAsync(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, weblogic.messaging.dispatcher.CompletionListener listener) {
        this.getPhysicalJMSProducer().sendAsync(destination, message, deliveryMode, priority, timeToLive, listener);
    }

    @Override
    public void send(Message message, CompletionListener jmsCompletionListener) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.send(message, jmsCompletionListener);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).send(message, jmsCompletionListener);
        }
    }

    @Override
    public void send(Destination destination, Message message, CompletionListener jmsCompletionListener) throws JMSException {
        long startTime = System.currentTimeMillis();
        JMSProducer physical = this.checkClosedReconnectGetProducer();
        try {
            physical.send(destination, message, jmsCompletionListener);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            this.nonIdempotentJMSProducer(startTime, physical, jmse).send(destination, message, jmsCompletionListener);
        }
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener jmsCompletionListener) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.send(message, deliveryMode, priority, ttlArg, jmsCompletionListener);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.send(message, deliveryMode, priority, timeToLive, jmsCompletionListener);
        }
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener jmsCompletionListener) throws JMSException {
        long elapsed;
        long start = System.currentTimeMillis();
        JMSProducer firstProd = this.getPhysicalJMSProducer();
        JMSProducer reconProd = this.checkClosedReconnectGetProducer(start, firstProd);
        long ttlArg = timeToLive;
        if (firstProd != reconProd && timeToLive > 0L && (elapsed = System.currentTimeMillis() - start) < timeToLive) {
            ttlArg = timeToLive - elapsed;
        }
        try {
            reconProd.send(destination, message, deliveryMode, priority, ttlArg, jmsCompletionListener);
        }
        catch (weblogic.jms.common.JMSException jmse) {
            long elapsed2;
            reconProd = this.nonIdempotentJMSProducer(start, reconProd, jmse);
            if (firstProd != reconProd && timeToLive > 0L && (elapsed2 = System.currentTimeMillis() - start) < timeToLive) {
                timeToLive -= elapsed2;
            }
            reconProd.send(destination, message, deliveryMode, priority, timeToLive);
        }
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        return this.getTimeToDeliver();
    }

    @Override
    public void setDeliveryDelay(long delay) throws JMSException {
        if (delay < 0L) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidJMSDeliveryDelayLoggable().getMessage());
        }
        this.setTimeToDeliver(delay);
    }

    @Override
    public String getPartitionName() {
        return this.getPhysicalJMSConnection().getPartitionName();
    }
}

