/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSession;
import java.util.Enumeration;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.extensions.WLConnection;
import weblogic.messaging.dispatcher.DispatcherId;

public class WLConnectionImpl
extends ReconnectController
implements ConnectionInternal {
    private final Object reconnectLock = new Object();
    private JMSConnectionFactory jmsConnectionFactory;
    private int reconnectPolicy;
    private long reconnectBlockingMillis;
    private long totalReconnectPeriodMillis;
    private long lastReconnectTimer;
    private long firstReconnectTime;
    private JMSContext connectionEstablishContext;

    public WLConnectionImpl(JMSConnectionFactory conFactory, JMSConnection jmsConnection) {
        super(null, jmsConnection);
        this.jmsConnectionFactory = conFactory;
        this.connectionEstablishContext = new JMSContext();
    }

    @Override
    protected ReconnectController getParent() {
        return this;
    }

    @Override
    protected WLConnectionImpl getWLConnectionImpl() {
        return this;
    }

    protected JMSConnectionFactory getJmsConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    @Override
    protected JMSConnection getPhysicalJMSConnection() {
        return (JMSConnection)this.getPhysical();
    }

    @Override
    Object getConnectionStateLock() {
        return this.reconnectLock;
    }

    protected JMSContext getConnectionEstablishContext() {
        return this.connectionEstablishContext;
    }

    void setConnectionEstablishContext(JMSContext c) {
        this.connectionEstablishContext = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsumerReconnectInfo computeConsumerReconnectInfo(DispatcherId id) {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            int policy = 11;
            if (this.mergeCloseAndReconnect(policy) == 0) {
                return null;
            }
        }
        ConsumerReconnectInfo consumerReconnectInfo = new ConsumerReconnectInfo();
        consumerReconnectInfo.setClientDispatcherId(id);
        consumerReconnectInfo.setClientJMSID(JMSID.create());
        consumerReconnectInfo.setDelayServerClose(90000L);
        return consumerReconnectInfo;
    }

    int mergeCloseAndReconnect(int requiredPolicy) {
        int state = this.getState();
        if (state != -1280 && state != -2304 && WLConnectionImpl.reconnectPolicyHas(requiredPolicy, this.getReconnectPolicyInternal())) {
            return this.getReconnectPolicyInternal();
        }
        return 0;
    }

    static boolean reconnectPolicyHas(int mask, int value) {
        return (mask & value) == mask && mask != 0;
    }

    boolean rememberReconnectState(JMSConnection con, int newState) {
        if (this.getPhysical() != con) {
            return false;
        }
        int state = this.getState();
        if (0 == state || 1028 == state) {
            String lastProblem;
            this.jmsConnectionFactory = this.jmsConnectionFactory;
            boolean nullClientId = con.getClientIDInternal() == null;
            int minReconnPolicy = nullClientId ? 1 : 9;
            int mergedPolicy = this.mergeCloseAndReconnect(minReconnPolicy);
            if (mergedPolicy == 0) {
                lastProblem = this.getLastProblem() == null ? this.missingBits(mergedPolicy, minReconnPolicy) : null;
            } else if (con.hasTemporaryDestination()) {
                mergedPolicy = 0;
                lastProblem = "connection used temporary destinations";
            } else {
                lastProblem = null;
            }
            if (mergedPolicy != 0 && con.getPreDisconnectState() == null) {
                try {
                    con.getReconnectState(mergedPolicy);
                }
                catch (CloneNotSupportedException impossible) {
                    con.recurseSetNoRetry(this);
                    throw new AssertionError((Object)impossible);
                }
                this.setRecursiveStateNotify(newState);
                return true;
            }
            if (this.getLastProblem() == null) {
                this.setLastProblem(new JMSException(lastProblem));
            }
        }
        con.setPreDisconnectState(null);
        con.recurseSetNoRetry(this);
        return false;
    }

    String missingBits(int mergedPolicy, int reconnPolicy) {
        String and = "";
        String missing = "Cannot reconnect, missing";
        if ((1 & reconnPolicy) > (1 & mergedPolicy)) {
            missing = missing + and + " ConnectionReconnect";
            and = ", and";
        }
        if ((2 & reconnPolicy) > (2 & mergedPolicy)) {
            missing = missing + and + " SessionReconnect";
            and = ", and";
        }
        if ((8 & reconnPolicy) > (8 & mergedPolicy)) {
            missing = missing + and + " ConsumerReconnect";
        }
        return missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processReconnectTimer(JMSConnection jmsConnection) {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            jmsConnection.clearTimerInfo();
            String txt = this.getPhysical() != jmsConnection ? "WLConnectionImpl Debug ignoring reconnect, match " + this.getPhysical() + " !=" + jmsConnection : (this.getState() != 1280 && this.getState() != 512 ? "WLConnectionImpl Debug ignoring reconnect, state " + this.getStringState(this.getState()) : (jmsConnection.getPreDisconnectState() == null ? "null predisconnect state in " + this.getStringState(this.getState()) : null));
            if (txt != null) {
                if (TODOREMOVEDebug) {
                    System.err.println(txt);
                }
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug(txt);
                }
                return;
            }
            this.setupReconnectSchedule(this.getPhysicalJMSConnection(), 1536);
        }
        jmsConnection.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void reconnectComplete(JMSConnection oldJmsConnection, JMSConnection newJMSConnection, Throwable connectionProblem) {
        try {
            block19: {
                Object object = this.getConnectionStateLock();
                // MONITORENTER : object
                if (oldJmsConnection == this.getPhysical()) {
                    try {
                        int state = this.getState();
                        switch (state) {
                            case -2304: 
                            case -1280: 
                            case 0: 
                            case 512: 
                            case 1028: 
                            case 1040: 
                            case 1280: {
                                return;
                            }
                            case 1536: {
                                this.setLastProblem(connectionProblem);
                                if (connectionProblem == null && newJMSConnection != null) {
                                    oldJmsConnection.postCreateReplacement();
                                    newJMSConnection.copyExceptionContext(oldJmsConnection);
                                    newJMSConnection = null;
                                    this.setRecursiveStateNotify(0);
                                    return;
                                }
                                if (newJMSConnection != this.getPhysical()) return;
                                newJMSConnection = null;
                                return;
                            }
                        }
                        this.wrongState(state);
                        return;
                    }
                    finally {
                        if (this.getState() != 1536) break block19;
                        this.setRecursiveStateNotify(512);
                        oldJmsConnection.scheduleReconnectTimer();
                    }
                }
            }
            // MONITOREXIT : object
            return;
        }
        finally {
            try {
                if (newJMSConnection != null) {
                    newJMSConnection.close();
                }
            }
            catch (jakarta.jms.JMSException jMSException) {}
        }
    }

    private JMSConnection getJMSConnection() {
        return (JMSConnection)this.getPhysicalWaitForState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReconnectPolicy(String reconnectPolicy) throws IllegalArgumentException {
        int internal = WLConnectionImpl.validateAndConvertReconnectPolicy(reconnectPolicy);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.reconnectPolicy = internal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getReconnectPolicy() {
        int reconnectPolicyInternal;
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            reconnectPolicyInternal = this.getReconnectPolicyInternal();
        }
        return WLConnectionImpl.convertReconnectPolicy(reconnectPolicyInternal);
    }

    int getReconnectPolicyInternal() {
        return this.reconnectPolicy;
    }

    public static int validateAndConvertReconnectPolicy(String policy) throws IllegalArgumentException {
        if (JMSConstants.RECONNECT_POLICY_NONE.equals(policy)) {
            return 0;
        }
        if (!JMSConnection.isT3Client()) {
            throw new IllegalArgumentException("only t3 client supports reconnect");
        }
        if (JMSConstants.RECONNECT_POLICY_PRODUCER.equals(policy)) {
            return 7;
        }
        if (JMSConstants.RECONNECT_POLICY_ALL.equals(policy)) {
            return 15;
        }
        throw new IllegalArgumentException("Unrecognized ReconnectPolicy " + policy);
    }

    static String convertReconnectPolicy(int policy) throws IllegalArgumentException {
        switch (policy) {
            case 7: {
                return JMSConstants.RECONNECT_POLICY_PRODUCER;
            }
            case 0: {
                return JMSConstants.RECONNECT_POLICY_NONE;
            }
            case 15: {
                return JMSConstants.RECONNECT_POLICY_ALL;
            }
        }
        throw new IllegalArgumentException("Unrecognized ReconnectPolicy " + policy);
    }

    long getFirstReconnectTime() {
        return this.firstReconnectTime;
    }

    long getLastReconnectTimer() {
        return this.lastReconnectTimer;
    }

    void clearLastReconnectTimer() {
        this.lastReconnectTimer = 0L;
    }

    void updateFirstReconnectTime() {
        this.firstReconnectTime = System.currentTimeMillis();
    }

    void updateLastReconnectTimer() {
        long config = this.getWLConnectionImpl().getTotalReconnectPeriodMillis();
        if (config == -1L) {
            this.lastReconnectTimer = Long.MAX_VALUE;
        } else {
            try {
                this.lastReconnectTimer = System.currentTimeMillis() + config;
            }
            catch (RuntimeException e) {
                this.lastReconnectTimer = Long.MAX_VALUE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReconnectBlockingMillis(long mil) throws IllegalArgumentException {
        WLConnectionImpl.validateReconnectMillis(mil);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.reconnectBlockingMillis = mil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getReconnectBlockingMillis() {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            return this.getReconnectBlockingInternal();
        }
    }

    long getReconnectBlockingInternal() {
        return this.reconnectBlockingMillis;
    }

    public static void validateReconnectMillis(long mil) throws IllegalArgumentException {
        if (mil < -1L) {
            throw new IllegalArgumentException("values less than -1 (infinite blocking time) are illegal");
        }
    }

    @Override
    public long getTotalReconnectPeriodMillis() {
        return this.totalReconnectPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTotalReconnectPeriodMillis(long mil) {
        WLConnectionImpl.validateReconnectMillis(mil);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.totalReconnectPeriodMillis = mil;
        }
    }

    @Override
    public final JMSDispatcher getFrontEndDispatcher() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getFrontEndDispatcher();
    }

    @Override
    public JMSID getJMSID() {
        return this.getJMSConnection().getJMSID();
    }

    @Override
    public PeerInfo getFEPeerInfo() {
        return this.getJMSConnection().getFEPeerInfo();
    }

    @Override
    public final void setAllowCloseInOnMessage(boolean allowCloseInOnMessage) {
        this.getJMSConnection().setAllowCloseInOnMessage(allowCloseInOnMessage);
    }

    @Override
    public final boolean getUserTransactionsEnabled() {
        return this.getJMSConnection().getUserTransactionsEnabled();
    }

    @Override
    public boolean isXAServerEnabled() {
        return this.getJMSConnection().isXAServerEnabled();
    }

    @Override
    public String getWLSServerName() {
        return this.getJMSConnection().getWLSServerName();
    }

    @Override
    public String getRuntimeMBeanName() {
        return this.getJMSConnection().getRuntimeMBeanName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return this.getJMSConnection().getParentInfo();
    }

    @Override
    public void setDispatchPolicy(String name) {
        this.getJMSConnection().setDispatchPolicy(name);
    }

    @Override
    public void setAcknowledgePolicy(int policy) {
        this.getJMSConnection().setAcknowledgePolicy(policy);
    }

    @Override
    public int getAcknowledgePolicy() {
        return this.getJMSConnection().getAcknowledgePolicy();
    }

    @Override
    public String getJMSVersion() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getJMSVersion();
    }

    @Override
    public int getJMSMajorVersion() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getJMSMajorVersion();
    }

    @Override
    public int getJMSMinorVersion() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getJMSMinorVersion();
    }

    @Override
    public String getJMSProviderName() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getJMSProviderName();
    }

    @Override
    public String getProviderVersion() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getProviderVersion();
    }

    @Override
    public int getProviderMajorVersion() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getProviderMajorVersion();
    }

    @Override
    public int getProviderMinorVersion() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getProviderMinorVersion();
    }

    @Override
    public Enumeration getJMSXPropertyNames() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getJMSXPropertyNames();
    }

    @Override
    public Session createSession() throws jakarta.jms.JMSException {
        return this.createSession(1);
    }

    @Override
    public Session createSession(boolean b, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createSession(b, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createSession(b, i);
        }
    }

    @Override
    public Session createSession(int sessionMode) throws jakarta.jms.JMSException {
        if (sessionMode == 0) {
            return this.createSession(true, 0);
        }
        return this.createSession(false, sessionMode);
    }

    @Override
    public String getClientID() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.getClientID();
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).getClientID();
        }
    }

    public static int validateAndConvertClientIdPolicy(String policy) throws IllegalArgumentException {
        if (WLConnection.CLIENT_ID_POLICY_RESTRICTED.equals(policy)) {
            return 0;
        }
        if (WLConnection.CLIENT_ID_POLICY_UNRESTRICTED.equals(policy)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized clientIdPolicy " + policy);
    }

    public static String convertClientIdPolicy(int policy) throws IllegalArgumentException {
        switch (policy) {
            case 0: {
                return WLConnection.CLIENT_ID_POLICY_RESTRICTED;
            }
            case 1: {
                return WLConnection.CLIENT_ID_POLICY_UNRESTRICTED;
            }
        }
        throw new IllegalArgumentException("Unrecognized clientIdPolicy " + policy);
    }

    @Override
    public String getClientIDPolicy() {
        return this.getJMSConnection().getClientIDPolicy();
    }

    @Override
    public void setClientID(String clientId, String clientIdPolicy) throws jakarta.jms.JMSException, IllegalArgumentException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        if (this.getFEPeerInfo().compareTo(PeerInfo.VERSION_1033) < 0) {
            throw new jakarta.jms.JMSException("Unsupported Operation. Only " + PeerInfo.VERSION_1033.getVersionAsString() + " and later supports this feature");
        }
        try {
            physical.setClientID(clientId, clientIdPolicy);
        }
        catch (JMSException jmse) {
            this.computeJMSConnection(startTime, physical, jmse).setClientID(clientId, clientIdPolicy);
        }
    }

    @Override
    public void setClientID(String uoo) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            physical.setClientID(uoo);
        }
        catch (JMSException jmse) {
            this.computeJMSConnection(startTime, physical, jmse).setClientID(uoo);
        }
    }

    @Override
    public String getSubscriptionSharingPolicy() {
        return this.getJMSConnection().getSubscriptionSharingPolicy();
    }

    @Override
    public void setSubscriptionSharingPolicy(String subscriptionSharingPolicy) throws jakarta.jms.JMSException, IllegalArgumentException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        if (this.getFEPeerInfo().compareTo(PeerInfo.VERSION_1033) < 0) {
            throw new jakarta.jms.JMSException("Unsupported Operation. Only " + PeerInfo.VERSION_1033.getVersionAsString() + " and later supports this feature");
        }
        try {
            physical.setSubscriptionSharingPolicy(subscriptionSharingPolicy);
        }
        catch (JMSException jmse) {
            this.computeJMSConnection(startTime, physical, jmse).setSubscriptionSharingPolicy(subscriptionSharingPolicy);
        }
    }

    public static int getSubscriptionSharingPolicyAsInt(String policy) {
        if (policy.equals(JMSConstants.SUBSCRIPTION_EXCLUSIVE)) {
            return 0;
        }
        if (policy.equals(JMSConstants.SUBSCRIPTION_SHARABLE)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + policy);
    }

    public static String getSubscriptionSharingPolicyAsString(int policy) {
        switch (policy) {
            case 0: {
                return JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            }
            case 1: {
                return JMSConstants.SUBSCRIPTION_SHARABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + policy);
    }

    @Override
    public ConnectionMetaData getMetaData() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.getMetaData();
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).getMetaData();
        }
    }

    @Override
    public ExceptionListener getExceptionListener() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.getExceptionListener();
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).getExceptionListener();
        }
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            physical.setExceptionListener(exceptionListener);
        }
        catch (JMSException jmse) {
            this.computeJMSConnection(startTime, physical, jmse).setExceptionListener(exceptionListener);
        }
    }

    @Override
    public void start() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            physical.start();
        }
        catch (JMSException jmse) {
            this.computeJMSConnection(startTime, physical, jmse).start();
        }
    }

    @Override
    public void stop() throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            physical.stop();
        }
        catch (JMSException jmse) {
            if (physical.isConnected()) {
                this.computeJMSConnection(startTime, physical, jmse).stop();
            }
            throw jmse;
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String uoo, ServerSessionPool serverSessionPool, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createConnectionConsumer(destination, uoo, serverSessionPool, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createConnectionConsumer(destination, uoo, serverSessionPool, i);
        }
    }

    @Override
    public QueueSession createQueueSession(boolean b, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createQueueSession(b, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createQueueSession(b, i);
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Queue queue, String uoo, ServerSessionPool serverSessionPool, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createConnectionConsumer(queue, uoo, serverSessionPool, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createConnectionConsumer(queue, uoo, serverSessionPool, i);
        }
    }

    @Override
    public TopicSession createTopicSession(boolean b, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createTopicSession(b, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createTopicSession(b, i);
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Topic topic, String uoo, ServerSessionPool serverSessionPool, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createConnectionConsumer(topic, uoo, serverSessionPool, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createConnectionConsumer(topic, uoo, serverSessionPool, i);
        }
    }

    @Override
    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createSharedConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createSharedConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
        }
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String uoo, String uoo1, ServerSessionPool serverSessionPool, int i) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createDurableConnectionConsumer(topic, uoo, uoo1, serverSessionPool, i);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createDurableConnectionConsumer(topic, uoo, uoo1, serverSessionPool, i);
        }
    }

    @Override
    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws jakarta.jms.JMSException {
        long startTime = System.currentTimeMillis();
        JMSConnection physical = this.getPhysicalJMSConnection();
        try {
            return physical.createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
        }
        catch (JMSException jmse) {
            return this.computeJMSConnection(startTime, physical, jmse).createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, serverSessionPool, maxMessages);
        }
    }

    @Override
    public void setInboundDest(Destination inboundDest) throws jakarta.jms.JMSException {
        this.getPhysicalJMSConnection().setInboundDest(inboundDest);
    }

    public void markAsJMSSessionPooledInWrapper() {
        JMSConnection physical = this.getPhysicalJMSConnection();
        physical.markAsJMSSessionPooledInWrapper();
    }

    @Override
    public String getPartitionName() throws jakarta.jms.JMSException {
        return this.getJMSConnection().getPartitionName();
    }
}

