/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.IOException;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import javax.naming.NameNotFoundException;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.common.DestroyConnectionException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.LostServerException;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.utils.NestedThrowable;

abstract class ReconnectController {
    private static final int STATE_NO_RETRY = -2304;
    private static final int STATE_USER_CLOSED = -1280;
    private static final int STATE_CONNECTED = 0;
    private static final int STATE_HAVE_RECON_INFO_PHYSICAL_CLOSE_DONE = 512;
    private static final int STATE_HAVE_RECON_INFO_PEERGONEE_IN_PROGRESS = 1028;
    private static final int STATE_HAVE_RECON_INFO_CLOSE_IN_PROGRESS = 1040;
    private static final int STATE_RECON_SCHEDULED = 1280;
    private static final int STATE_RECON_IN_PROGRESS = 1536;
    private int state;
    private Throwable lastProblem;
    ReconnectController firstChild;
    ReconnectController lastChild;
    ReconnectController prevChild;
    ReconnectController nextChild;
    ReconnectController parent;
    private volatile Reconnectable physical;
    private static int RETRIES = 12;
    private static long LARGE_TIME_FOR_EXCEPTION_MSG = 14400000L;
    static boolean TODOREMOVEDebug = false;

    protected ReconnectController(ReconnectController parent, Reconnectable reconnectable) {
        int parentState;
        this.physical = reconnectable;
        assert (this.getState() == 0);
        if (parent != null && (parentState = parent.getState()) != -1280) {
            this.parent = parent;
            this.setState(parentState);
            parent.addChild(this);
        }
    }

    abstract Object getConnectionStateLock();

    protected abstract ReconnectController getParent();

    protected abstract JMSConnection getPhysicalJMSConnection();

    protected abstract WLConnectionImpl getWLConnectionImpl();

    int getState() {
        return this.state;
    }

    private void setState(int arg) {
        this.state = arg;
    }

    Throwable getLastProblem() {
        return this.lastProblem;
    }

    protected void setLastProblem(Throwable arg) {
        this.lastProblem = arg;
        if (TODOREMOVEDebug) {
            if (arg == null) {
                System.err.println("Debug ReconnectController lastProblem cleared");
            } else {
                JMSConnection.displayExceptionCauses("Debug ReconnectController lastProblem set", arg);
            }
        }
    }

    protected Reconnectable getPhysical() {
        return this.physical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            return this.getState() == -1280;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChild(ReconnectController child) {
        assert (child != this);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            if (this.getState() == -1280) {
                return;
            }
            if (this.lastChild == null) {
                this.firstChild = this.lastChild = child;
            } else {
                child.prevChild = this.lastChild;
                this.lastChild.nextChild = child;
                this.lastChild = child;
            }
        }
    }

    protected void removeChild(ReconnectController child) {
        if (child == this) {
            return;
        }
        if (child.prevChild == null) {
            this.firstChild = child.nextChild;
        } else {
            child.prevChild.nextChild = child.nextChild;
        }
        if (child.nextChild == null) {
            this.lastChild = child.prevChild;
        } else {
            child.nextChild.prevChild = child.prevChild;
        }
        child.prevChild = null;
        child.nextChild = null;
    }

    protected void setRecursiveStateUserClosed() {
        this.setState(-1280);
        ReconnectController child;
        while ((child = this.firstChild) != null) {
            this.removeChild(child);
            child.setRecursiveStateUserClosed();
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecursiveState(int newState) {
        assert (newState != -1280);
        if (TODOREMOVEDebug) {
            if (newState == -2304) {
                new Exception("DEBUG ReconnectController STATE_NO_RETRY from " + this.getStringState(this.getState())).printStackTrace();
            } else {
                System.err.println("DEBUG ReconnectController stateBecomes " + this.getStringState(newState) + " " + this.getPhysical());
            }
        }
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.setStateChildrenInternal(newState);
        }
    }

    private void setStateChildrenInternal(int newState) {
        if (this.getState() == -1280 || this.getState() == -2304) {
            return;
        }
        this.setState(newState);
        ReconnectController child = this.firstChild;
        while (child != null) {
            child.setStateChildrenInternal(newState);
            child = child.nextChild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecursiveStateNotify(int newState) {
        Object connectionStateLock;
        Object object = connectionStateLock = this.getConnectionStateLock();
        synchronized (object) {
            this.setRecursiveState(newState);
            connectionStateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reconnectable getPhysicalWaitForState(long startTime) {
        Object connectionStateLock;
        Object object = connectionStateLock = this.getConnectionStateLock();
        synchronized (object) {
            return this.waitForStateInternal(startTime);
        }
    }

    protected Reconnectable getPhysicalWaitForState() {
        return this.getPhysicalWaitForState(System.currentTimeMillis());
    }

    boolean stateNeedsWait() {
        return 1024 <= this.getState();
    }

    protected Reconnectable waitForStateInternal(long startTime) {
        long waitArg;
        long config;
        while (this.stateNeedsWait() && (config = this.getWLConnectionImpl().getReconnectBlockingInternal()) != 0L && (config != -1L || this.getWLConnectionImpl().getLastReconnectTimer() != 0L) && (waitArg = this.remainingMillis(startTime)) >= 1L) {
            if (TODOREMOVEDebug) {
                System.err.println("ReconnectController Debug waiting to change " + this.getStringState(this.getState()) + " " + waitArg + " " + this.getPhysical());
            } else if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("ReconnectController waiting to change " + this.getStringState(this.getState()) + " " + waitArg);
            }
            try {
                this.getConnectionStateLock().wait(waitArg);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        return this.getPhysical();
    }

    private long remainingMillis(long startTime) {
        long config = this.getWLConnectionImpl().getReconnectBlockingInternal();
        if (config == -1L) {
            return LARGE_TIME_FOR_EXCEPTION_MSG;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        return config - elapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reconnectable waitForStateOrTime(long endWaitTime) {
        Object connectionStateLock;
        Object object = connectionStateLock = this.getConnectionStateLock();
        synchronized (object) {
            long remainingMillis = endWaitTime - System.currentTimeMillis();
            while (remainingMillis > 0L && this.stateNeedsWait()) {
                try {
                    connectionStateLock.wait(remainingMillis);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            return this.getPhysical();
        }
    }

    protected AssertionError wrongState(int state) {
        AssertionError assertionError = new AssertionError((Object)this.wrongStateString(state));
        if (TODOREMOVEDebug) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        return assertionError;
    }

    String wrongStateString(int state) {
        return "ReconnectController unexpected state " + state + " is " + this.getStringState(state);
    }

    protected String getStringState(int state) {
        String stateString;
        switch (state) {
            case 0: {
                stateString = "STATE_CONNECTED";
                break;
            }
            case 512: {
                stateString = "STATE_HAVE_RECON_INFO_PHYSICAL_CLOSE_DONE";
                break;
            }
            case 1040: {
                stateString = "STATE_HAVE_RECON_INFO_CLOSE_IN_PROGRESS";
                break;
            }
            case 1028: {
                stateString = "STATE_HAVE_RECON_INFO_PEERGONEE_IN_PROGRESS";
                break;
            }
            case -2304: {
                stateString = "STATE_NO_RETRY";
                break;
            }
            case 1536: {
                stateString = "STATE_RECON_IN_PROGRESS";
                break;
            }
            case 1280: {
                stateString = "STATE_RECON_SCHEDULED";
                break;
            }
            case -1280: {
                stateString = "STATE_USER_CLOSED";
                break;
            }
            default: {
                stateString = "Illegal State " + state;
            }
        }
        return stateString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPhysicalReconnectable(Reconnectable newReconnectable) {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            int state = this.getState();
            switch (state) {
                case 0: 
                case 512: 
                case 1536: {
                    this.physical = newReconnectable;
                    break;
                }
                case -2304: 
                case -1280: 
                case 1028: 
                case 1040: 
                case 1280: {
                    break;
                }
                default: {
                    throw this.wrongState(state);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws jakarta.jms.JMSException {
        this.getPhysical().isCloseAllowed("close");
        try {
            if (this.getState() == 0 && this.getPhysicalJMSConnection().isConnected()) {
                this.getPhysical().close();
            }
        }
        finally {
            Object connectionStateLock;
            Object object = connectionStateLock = this.getConnectionStateLock();
            synchronized (object) {
                try {
                    this.getPhysical().forgetReconnectState();
                }
                finally {
                    if (this.getState() != -1280) {
                        this.setRecursiveStateUserClosed();
                        if (this.parent != null) {
                            this.parent.removeChild(this);
                        }
                        connectionStateLock.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reconnectable analyzeExceptionAndReconnect(long startTime, Reconnectable lastPhysical, boolean idempotent, JMSException jmse) throws jakarta.jms.JMSException {
        int state = -256;
        int lcv = RETRIES;
        while (true) {
            block17: {
                JMSConnection physicalJMSConnection;
                try {
                    Object object = this.getConnectionStateLock();
                    synchronized (object) {
                        state = this.getState();
                        if (lcv == 0) {
                            return this.changedPhysicalOrThrow(lastPhysical, jmse);
                        }
                        if (lcv == RETRIES) {
                            this.throwNonRecoverableException(jmse, idempotent);
                            this.getWLConnectionImpl().updateLastReconnectTimer();
                        }
                        switch (state) {
                            case -2304: 
                            case -1280: 
                            case 0: {
                                return this.changedPhysicalOrThrow(lastPhysical, jmse);
                            }
                            case 512: {
                                if (this.getWLConnectionImpl().getReconnectPolicyInternal() == 0) {
                                    this.getWLConnectionImpl().setRecursiveStateNotify(-2304);
                                    return this.changedPhysicalOrThrow(lastPhysical, jmse);
                                }
                                physicalJMSConnection = this.getPhysicalJMSConnection();
                                state = this.setupReconnectSchedule(physicalJMSConnection, 1280);
                                break;
                            }
                            case 1028: 
                            case 1040: 
                            case 1280: 
                            case 1536: {
                                this.waitForStateInternal(startTime);
                                if (!this.stateNeedsWait()) {
                                    break block17;
                                }
                                return this.changedPhysicalOrThrow(lastPhysical, jmse);
                            }
                            default: {
                                throw this.wrongState(state);
                            }
                        }
                    }
                }
                catch (LostServerException lse) {
                    if (jmse == null || lse.getCause() != null) {
                        throw lse;
                    }
                    throw this.attachReasonToException(lse, startTime, state);
                }
                assert (state == 1280);
                physicalJMSConnection.getReconnectWorkManager().schedule(physicalJMSConnection);
            }
            --lcv;
        }
    }

    protected int setupReconnectSchedule(JMSConnection physicalJMSConnection, int state) {
        physicalJMSConnection.setReplacementConnection(null);
        this.getWLConnectionImpl().setRecursiveStateNotify(state);
        return state;
    }

    private Reconnectable changedPhysicalOrThrow(Reconnectable oldPhysical, JMSException jmse) throws JMSException {
        Reconnectable current = this.getPhysical();
        if (oldPhysical != null && oldPhysical.getFEPeerInfo() == current.getFEPeerInfo()) {
            throw jmse;
        }
        return current;
    }

    private LostServerException attachReasonToException(LostServerException lse, long startTime, int state) {
        LostServerException wrapLast;
        long remaining;
        String reason = state == 0 ? null : (this.getWLConnectionImpl().getReconnectBlockingInternal() > -1L && (remaining = this.remainingMillis(startTime)) <= 0L ? "timed out in state " + this.getStringState(state) + " after " + (this.getWLConnectionImpl().getReconnectBlockingInternal() - remaining) + " milliseconds" : "server connection in state " + this.getStringState(state));
        Throwable cause = this.getWLConnectionImpl().getLastProblem();
        if (cause == null) {
            if (reason == null) {
                if (TODOREMOVEDebug) {
                    System.err.println("DEBUG ReconnectController in " + this.getStringState(this.getState()));
                }
                return lse;
            }
            wrapLast = new LostServerException(reason);
        } else {
            wrapLast = new LostServerException(reason, cause);
        }
        wrapLast.setReplayLastException(true);
        lse.initCause(wrapLast);
        return lse;
    }

    protected JMSConnection computeJMSConnection(long startTime, Reconnectable reconnectable, JMSException jmse) throws jakarta.jms.JMSException {
        return (JMSConnection)this.analyzeExceptionAndReconnect(startTime, reconnectable, true, jmse);
    }

    protected JMSSession computeJMSSession(long startTime, Reconnectable reconnectable, JMSException jmse) throws jakarta.jms.JMSException {
        return (JMSSession)this.analyzeExceptionAndReconnect(startTime, reconnectable, true, jmse);
    }

    protected JMSProducer nonIdempotentJMSProducer(long startTime, Reconnectable reconnectable, JMSException jmse) throws jakarta.jms.JMSException {
        return (JMSProducer)this.analyzeExceptionAndReconnect(startTime, reconnectable, false, jmse);
    }

    protected JMSProducer idempotentJMSProducer(long startTime, Reconnectable reconnectable, JMSException jmse) throws jakarta.jms.JMSException {
        return (JMSProducer)this.analyzeExceptionAndReconnect(startTime, reconnectable, true, jmse);
    }

    protected JMSConsumer computeJMSConsumer(long startTime, Reconnectable reconnectable, JMSException jmse) throws jakarta.jms.JMSException {
        return (JMSConsumer)this.analyzeExceptionAndReconnect(startTime, reconnectable, true, jmse);
    }

    protected Reconnectable checkClosedReconnect(long startTime, Reconnectable oldPhysical) throws jakarta.jms.JMSException {
        try {
            oldPhysical.publicCheckClosed();
            return oldPhysical;
        }
        catch (JMSException jmse) {
            Reconnectable newPhysical = this.analyzeExceptionAndReconnect(startTime, oldPhysical, true, jmse);
            if (newPhysical != oldPhysical) {
                return newPhysical;
            }
            throw jmse;
        }
    }

    private void throwNonRecoverableException(JMSException jmse, boolean idempotent) throws jakarta.jms.JMSException {
        int lcv;
        if (jmse == null) {
            return;
        }
        int breakLoop = 40;
        boolean hasReplayedLostServerException = false;
        Throwable nonJmse = jmse;
        for (lcv = 40; nonJmse instanceof JMSException && lcv != 0; --lcv) {
            if (nonJmse instanceof DestroyConnectionException) {
                throw jmse;
            }
            if (!hasReplayedLostServerException && nonJmse instanceof LostServerException) {
                hasReplayedLostServerException = ((LostServerException)nonJmse).isReplayLastException();
            }
            nonJmse = nonJmse.getCause();
        }
        lcv = 40;
        for (Throwable cause = nonJmse; cause != null && lcv != 0; cause = cause.getCause(), --lcv) {
            if (cause instanceof ConnectException || cause instanceof UnknownHostException || cause instanceof ConnectIOException || cause instanceof NoSuchObjectException) {
                return;
            }
            if (!(cause instanceof DispatcherException) || !(cause.getCause() instanceof NameNotFoundException)) continue;
            if (TODOREMOVEDebug) {
                System.err.println("DEBUG ReconnectController new recover NameNotFound " + this.getStringState(this.getState()));
                JMSConnection.displayExceptionCauses("DEBUG ReconnectController nameNotFound", jmse);
            }
            return;
        }
        if (jmse instanceof LostServerException && (nonJmse == null || hasReplayedLostServerException)) {
            return;
        }
        if (idempotent && jmse instanceof LostServerException && nonJmse instanceof Exception && ReconnectController.getCauseOrNested(nonJmse) instanceof UnmarshalException && (ReconnectController.getCauseOrNested(nonJmse.getCause()) instanceof IOException || ReconnectController.getCauseOrNested(nonJmse.getCause()) instanceof SocketException)) {
            return;
        }
        if (TODOREMOVEDebug) {
            System.err.println("DEBUG ReconnectController did not recover " + this.getStringState(this.getState()) + " preInvokeFailure " + (40 - lcv));
            JMSConnection.displayExceptionCauses("DEBUG ReconnectController nonRecover", jmse);
        }
        throw jmse;
    }

    private static Throwable getCauseOrNested(Throwable throwable) {
        Throwable nest;
        if (throwable.getCause() != null) {
            return throwable.getCause();
        }
        if (throwable instanceof NestedThrowable && (nest = ((NestedThrowable)((Object)throwable)).getNested()) != throwable) {
            return nest;
        }
        return null;
    }
}

