/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicSession;
import jakarta.jms.TransactionInProgressException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAResource;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.XASessionInternal;
import weblogic.jms.common.JMSException;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.TransactionHelper;

public final class JMSXASession
extends JMSSession
implements XASessionInternal,
Reconnectable,
Cloneable {
    private static final String SERVER_TX_HELPER_CLASS = "weblogic.transaction.TxHelper";
    private static final String CLIENT_TX_HELPER_CLASS = "weblogic.transaction.TransactionHelper";
    private final boolean originalTransacted;

    protected JMSXASession(JMSConnection connection, boolean transacted, boolean stopped) throws jakarta.jms.JMSException {
        super(connection, false, 2, stopped);
        this.setUserTransactionsEnabled(true);
        this.originalTransacted = transacted;
        this.checkITM(connection);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean getTransacted() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.originalTransacted;
    }

    @Override
    public void commit() throws jakarta.jms.JMSException {
        if (TransactionHelper.getTransactionHelper().getTransaction() == null) {
            throw new jakarta.jms.IllegalStateException(JMSClientExceptionLogger.logNoTransactionLoggable().getMessage());
        }
        throw new TransactionInProgressException(JMSClientExceptionLogger.logErrorCommittingSessionLoggable().getMessage());
    }

    @Override
    public void rollback() throws jakarta.jms.JMSException {
        if (TransactionHelper.getTransactionHelper().getTransaction() == null) {
            throw new jakarta.jms.IllegalStateException(JMSClientExceptionLogger.logNoTransaction2Loggable().getMessage());
        }
        throw new TransactionInProgressException(JMSClientExceptionLogger.logErrorRollingBackSessionLoggable().getMessage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public XAResource getXAResource() {
        if (!KernelStatus.isServer()) {
            if (!this.getConnection().isWrappedIC()) throw new IllegalStateException(JMSClientExceptionLogger.logOnlyFromServerLoggable().getMessage());
            this.xaRes = this.getXAResource(null);
            return this.xaRes;
        }
        try {
            Class<?> txHelperClz = Class.forName(SERVER_TX_HELPER_CLASS);
            Method m = txHelperClz.getMethod("getServerInterposedTransactionManager", new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            if (o == null) {
                return null;
            }
            m = o.getClass().getMethod("getXAResource", new Class[0]);
            this.xaRes = (XAResource)m.invoke(o, new Object[0]);
            return this.xaRes;
        }
        catch (InvocationTargetException ite) {
            throw new AssertionError((Object)ite);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
    }

    @Override
    public XAResource getXAResource(String serverName) {
        if (!this.getConnection().isWrappedIC()) {
            throw new IllegalStateException("No jndi environment available in connection. Please use weblogic.jms.WLInitialContext or weblogic.jms.WrappedInitialContext for jndi lookup.");
        }
        if (serverName == null) {
            serverName = this.getConnection().getWLSServerName();
        }
        Hashtable tmpEnv = (Hashtable)this.getConnection().getJndiEnv().clone();
        tmpEnv.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        try {
            JMSConnectionFactory.decryptCredential(tmpEnv);
        }
        catch (jakarta.jms.JMSException e) {
            throw new AssertionError((Object)e);
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(tmpEnv);
            this.xaRes = this.innerGetXAResource(ctx, serverName, true);
        }
        catch (NamingException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return this.xaRes;
    }

    public XAResource getXAResource(Context ctx, String serverName) {
        return this.innerGetXAResource(ctx, serverName, false);
    }

    private XAResource innerGetXAResource(Context ctx, String serverName, boolean useXAWrapper) {
        try {
            Class<?> txHelperClz = Class.forName(CLIENT_TX_HELPER_CLASS);
            Method m = txHelperClz.getMethod("getClientInterposedTransactionManager", Context.class, String.class);
            Object o = m.invoke(null, ctx, serverName);
            if (o == null) {
                return null;
            }
            m = o.getClass().getMethod("setClusterwideRecoveryEnabled", Boolean.TYPE);
            m.invoke(o, Boolean.TRUE);
            if (useXAWrapper) {
                m = o.getClass().getMethod("setReturnTransactionThreadStateAwareITMXAResource", Boolean.TYPE);
                m.invoke(o, Boolean.TRUE);
            }
            m = o.getClass().getMethod("getXAResource", new Class[0]);
            return (XAResource)m.invoke(o, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            throw new AssertionError((Object)ite);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError((Object)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
    }

    @Override
    public QueueSession getQueueSession() {
        return (QueueSession)this.getSession();
    }

    @Override
    public TopicSession getTopicSession() {
        return (TopicSession)this.getSession();
    }

    @Override
    public Session getSession() {
        return this;
    }

    private void checkITM(JMSConnection conn) throws jakarta.jms.JMSException {
        if (!KernelStatus.isServer() && conn.isWrappedIC()) {
            Context ctx = null;
            try {
                String serverName = conn.getWLSServerName();
                Hashtable tmpEnv = (Hashtable)conn.getJndiEnv().clone();
                tmpEnv.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                JMSConnectionFactory.decryptCredential(tmpEnv);
                ctx = new InitialContext(tmpEnv);
                Class<?> txHelperClz = Class.forName(CLIENT_TX_HELPER_CLASS);
                Method m = txHelperClz.getMethod("getClientInterposedTransactionManagerThrowsOnException", Context.class, String.class);
                Object object = m.invoke(null, ctx, serverName);
            }
            catch (Exception e) {
                throw new JMSException("Error when try to get ITM via jndi lookup", (Throwable)e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
    }
}

