/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAJMSContext;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueConnectionFactory;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicConnectionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.XAJMSContextImpl;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.frontend.FEConnectionFactoryRemote;
import weblogic.jndi.annotation.CrossPartitionAware;
import weblogic.rmi.extensions.server.RemoteWrapper;

@CrossPartitionAware
public final class JMSXAConnectionFactory
extends JMSConnectionFactory
implements XAQueueConnectionFactory,
XATopicConnectionFactory,
Externalizable,
RemoteWrapper {
    static final long serialVersionUID = 343051208017579157L;
    private static final byte EXTVERSION = 1;

    public JMSXAConnectionFactory(FEConnectionFactoryRemote feConnectionFactoryRemote, String paramFullyQualifiedName, String partitionName, int securityPolicy) {
        super(feConnectionFactoryRemote, paramFullyQualifiedName, partitionName, securityPolicy);
    }

    @Override
    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        ConnectionInternal connection = this.createConnectionInternal(username, password, true, 1);
        return (XAQueueConnection)((Object)connection);
    }

    @Override
    public XAQueueConnection createXAQueueConnection() throws JMSException {
        ConnectionInternal connection = this.createConnectionInternal(null, null, true, 1);
        return (XAQueueConnection)((Object)connection);
    }

    @Override
    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return (XAConnection)((Object)this.createConnectionInternal(username, password, true, 0));
    }

    @Override
    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)((Object)this.createConnectionInternal(null, null, true, 0));
    }

    @Override
    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        ConnectionInternal connection = this.createConnectionInternal(username, password, true, 2);
        return (XATopicConnection)((Object)connection);
    }

    @Override
    public XATopicConnection createXATopicConnection() throws JMSException {
        ConnectionInternal connection = this.createConnectionInternal(null, null, true, 2);
        return (XATopicConnection)((Object)connection);
    }

    @Override
    public XAJMSContext createXAContext() {
        return new XAJMSContextImpl(this, JMSXAConnectionFactory.getContainerType());
    }

    @Override
    public XAJMSContext createXAContext(String userName, String password) {
        return new XAJMSContextImpl(this, JMSXAConnectionFactory.getContainerType(), userName, password);
    }

    public JMSXAConnectionFactory() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte vrsn = in.readByte();
        if (vrsn != 1) {
            throw JMSUtilities.versionIOException(vrsn, 1, 1);
        }
    }

    @Override
    public Remote getRemoteDelegate() {
        return super.getRemoteDelegate();
    }
}

