/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import jakarta.transaction.Transaction;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.transaction.xa.XAResource;
import org.w3c.dom.Document;
import weblogic.common.internal.PeerInfo;
import weblogic.diagnostics.integration.DiagnosticIntegrationManager;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.client.AsyncSendCallback;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConsumer;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.JMSExceptionContext;
import weblogic.jms.client.JMSMessageContext;
import weblogic.jms.client.JMSMessageReference;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.JMSQueueBrowser;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.client.LockedMap;
import weblogic.jms.client.MMessageAsyncSession;
import weblogic.jms.client.MMessageListener;
import weblogic.jms.client.MessageWrapper;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.AlreadyClosedException;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSSessionRecoverResponse;
import weblogic.jms.common.JMSWorkContextHelper;
import weblogic.jms.common.JMSWorkManager;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageList;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.extensions.DataOverrunException;
import weblogic.jms.extensions.JMSMessageFactoryImpl;
import weblogic.jms.extensions.WLAcknowledgeInfo;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.jms.extensions.WLMessageFactory;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.extensions.XMLMessage;
import weblogic.jms.frontend.FEBrowserCloseRequest;
import weblogic.jms.frontend.FEBrowserCreateRequest;
import weblogic.jms.frontend.FEConsumerCloseRequest;
import weblogic.jms.frontend.FEConsumerCreateRequest;
import weblogic.jms.frontend.FEConsumerCreateResponse;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentOneWayRequest;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentRequest;
import weblogic.jms.frontend.FEConsumerReceiveRequest;
import weblogic.jms.frontend.FEDestinationCreateRequest;
import weblogic.jms.frontend.FEProducerCloseRequest;
import weblogic.jms.frontend.FEProducerCreateRequest;
import weblogic.jms.frontend.FEProducerCreateResponse;
import weblogic.jms.frontend.FESessionAcknowledgeRequest;
import weblogic.jms.frontend.FESessionCloseRequest;
import weblogic.jms.frontend.FESessionRecoverRequest;
import weblogic.jms.frontend.FESessionSetRedeliveryDelayRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateResponse;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTDMSocketIPM;
import weblogic.jms.multicast.JMSTMSocket;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.common.JMSCICHelper;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.transaction.InterposedTransactionManagerXAResource;
import weblogic.transaction.TransactionHelper;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class JMSSession
implements SessionInternal,
Invocable,
Reconnectable,
Cloneable,
WLAsyncSession,
MMessageAsyncSession {
    private static final AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private static final WLMessageFactory MESSAGEFACTORY = JMSMessageFactoryImpl.getFactory();
    private static int DUPSACKINTERVAL = 50;
    private static boolean IGNOREWINDOWCURRENT = false;
    private static boolean DECWINDOWCURRENT = true;
    private SubjectManager subjectManager = SubjectManager.getSubjectManager();
    private long expectedSequenceNumber = 1L;
    private long highMark = 1L;
    private JMSPushRequest firstPushRequest;
    private JMSPushRequest lastPushRequest;
    private JMSPushRequest firstReceivePushRequest;
    private JMSPushRequest lastReceivePushRequest;
    private UnackedMessage firstUnackedMessage;
    private PendingWTMessage firstPendingWTMessage;
    private volatile JMSID sessionId;
    private int messagesMaximum;
    private int overrunPolicy;
    private final int acknowledgePolicy;
    private final int subscriptionSharingPolicy;
    private int pushRequestCount;
    private final JMSConnection connection;
    private final boolean transacted;
    private final int acknowledgeMode;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private final long sendTimeout;
    private boolean userTransactionsEnabled;
    private final boolean allowCloseInOnMessage;
    private long redeliveryDelay = -1L;
    private final String clientID;
    private boolean decrementWindow;
    private final WorkManager dispatchWorkManager;
    private final String dispatchPolicyName;
    private final Object lockObject = new Object();
    private boolean synchronousListener = false;
    private JMSPushRequest shortCutPushRequest = null;
    private boolean needToRemoveIt = true;
    private JMSPushRequest shortCutPrevPushRequest = null;
    private boolean waitForNewMessage = false;
    private boolean notifyNewMessage = false;
    private final Object synchronousListenerObject = new Object();
    private LockedMap consumers = new LockedMap("consumers", null);
    private LockedMap producers = new LockedMap("producers", null);
    private LockedMap browsers = new LockedMap("browsers", null);
    private static final int IDLE = 0;
    private static final int IN_CLOSE = 1;
    static final int IN_RECEIVE = 2;
    private static final int IN_LISTENER = 4;
    static final int TYPE_UNSPECIFIED = 0;
    static final int TYPE_TOPIC = 1;
    static final int TYPE_QUEUE = 2;
    private JMSMessageContext messageContext;
    private JMSExceptionContext exceptionContext;
    private JMSException deferredException;
    private int consumerListenerCount;
    private int state = 0;
    private Thread listenerThread;
    private String runtimeMBeanName;
    private int waiterCount;
    private boolean stopped;
    private boolean running;
    private boolean recovering;
    private int type;
    private long lastSequenceNumber;
    private long firstSequenceNumberNotSeen = 0L;
    private MessageList clientAckList;
    private JMSPushRequest recoverableClientAckMessages;
    private JMSPushRequest carryForwardOnReconnect;
    private JMSMessageReference mRefCache;
    private JMSTDMSocket dgmSock;
    private JMSTMSocket mSock;
    private int pipelineGeneration;
    private String unitOfOrder;
    private UseForRunnable useForRunnable;
    private AsyncSendCallbackRunnable asyncSendCallbackRunner;
    private WLSessionImpl wlSessionImpl;
    private JMSSession replacementSession;
    private boolean pendingWork;
    private volatile boolean refreshedWithPendingWork;
    private boolean prefetchStarted = false;
    private boolean prefetchDisabled = false;
    private int dupsOKAckCountDown;
    private int dupsOKAckCount = 0;
    private boolean allowDelayAckForDupsOK = true;
    private boolean requireAckForDupsOK = false;
    private boolean session_clientResponsibleForAck = false;
    private boolean connectionOlderThan90;
    private boolean recoversFor90HasBeenCalled = false;
    private JMSMessageId lastExposedMsgId;
    private JMSMessageId previousExposedMsgId;
    private JMSMessageId lastAckMsgId;
    private long lastAckSequenceNumber;
    private HashMap replacementConsumerMap;
    private boolean consumersReconnect;
    private boolean closeStarted;
    private JMSSession staleJMSSession;
    private static boolean IGNORE_JmsAsyncQueue = false;
    private boolean ignoreJmsAsyncQueue = false;
    protected XAResource xaRes;
    private DiagnosticIntegrationManager integrationManager;
    private MMessageListener mmListener;
    private long realLastSequenceNumber;
    private boolean realLastSequenceNumberShouldApply = false;
    private int proxyGenerationForOlderServer = 0;
    private boolean closeWithExternalSequenceNumber = false;
    static final TextMessageImpl ASYNC_RESERVED_MSG;
    private boolean isRemoteDomain;
    private static final AuthenticatedSubject kernelId;
    int checkSeqGap = 1;
    int msgIndex = 1;

    protected JMSSession(JMSConnection connection, boolean transacted, int acknowledgeMode, boolean stopped) throws JMSException {
        this.connection = connection;
        this.transacted = transacted;
        this.useForRunnable = new UseForRunnable(this);
        this.acknowledgeMode = transacted ? 2 : acknowledgeMode;
        this.stopped = stopped;
        this.userTransactionsEnabled = connection.getUserTransactionsEnabled();
        this.allowCloseInOnMessage = connection.getAllowCloseInOnMessage();
        this.messagesMaximum = connection.getMessagesMaximum();
        this.deliveryMode = connection.getDeliveryMode();
        this.priority = connection.getPriority();
        this.timeToLive = connection.getTimeToLive();
        this.acknowledgePolicy = connection.getAcknowledgePolicy();
        this.subscriptionSharingPolicy = connection.getSubscriptionSharingPolicyAsInt();
        this.overrunPolicy = connection.getOverrunPolicy();
        this.clientID = connection.getClientIDInternal();
        this.sendTimeout = connection.getSendTimeout();
        this.pipelineGeneration = connection.getPipelineGeneration();
        this.dispatchPolicyName = connection.getDispatchPolicy();
        this.dispatchWorkManager = WorkManagerFactory.getInstance().find(this.dispatchPolicyName);
        this.asyncSendCallbackRunner = new AsyncSendCallbackRunnable(KernelStatus.isServer() ? this.dispatchWorkManager : null);
        if (IGNORE_JmsAsyncQueue && this.dispatchPolicyName.equals("JmsAsyncQueue")) {
            this.ignoreJmsAsyncQueue = true;
        }
        if (this.userTransactionsEnabled) {
            this.allowDelayAckForDupsOK = false;
        }
        this.dupsOKAckCount = this.dupsOKAckCountDown = this.messagesMaximum != -1 || this.messagesMaximum <= 100 ? this.messagesMaximum / 2 : DUPSACKINTERVAL;
        try {
            if (System.getProperty("weblogic.jms.dupsOKCountDownSize") != null) {
                this.dupsOKAckCountDown = Integer.parseInt(System.getProperty("weblogic.jms.dupsOKCountDownSize"));
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        boolean bl = this.connectionOlderThan90 = connection.getPeerVersion() < 5;
        if (this.pipelineGeneration == 0) {
            if (PeerInfo.VERSION_DIABLO.compareTo(this.getFEPeerInfo()) <= 0 && PeerInfo.VERSION_920.compareTo(this.getFEPeerInfo()) > 0) {
                this.pipelineGeneration = 0xF00000;
            }
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSSession (id: " + this.sessionId + ") : zero pipelineGeneration 0x" + Integer.toHexString(this.pipelineGeneration) + " peerinfo " + this.getFEPeerInfo());
            }
        }
        if (KernelStatus.isServer()) {
            this.integrationManager = JMSSession.getDiagnosticIntegrationManager();
        }
        try {
            this.isRemoteDomain = CrossDomainSecurityManager.getCrossDomainSecurityUtil().isRemoteDomain(connection.getFrontEndDispatcher());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JMSSession jmsSession = (JMSSession)super.clone();
        jmsSession.consumers = (LockedMap)this.consumers.clone();
        jmsSession.producers = (LockedMap)this.producers.clone();
        jmsSession.browsers = (LockedMap)this.browsers.clone();
        return jmsSession;
    }

    @Override
    public ReconnectController getReconnectController() {
        return this.wlSessionImpl;
    }

    @Override
    public Reconnectable getReconnectState(int policy) throws CloneNotSupportedException {
        JMSSession session = (JMSSession)this.clone();
        session.producers = WLConnectionImpl.reconnectPolicyHas(4, policy) ? JMSConnection.recurseGetReconnectState(session.producers, policy) : JMSConnection.recurseSetNoRetry(session.producers, this.connection);
        session.staleJMSSession = this;
        if (WLConnectionImpl.reconnectPolicyHas(8, policy)) {
            session.consumers = JMSConnection.recurseGetReconnectState(session.consumers, policy);
            session.consumersReconnect = true;
            session.session_clientResponsibleForAck = this.session_clientResponsibleForAck;
        } else {
            if (ReconnectController.TODOREMOVEDebug && session.consumersCount() > 0) {
                System.out.println("DEBUG JMSSession reconnectState recurseSetNoRetry consumers ignored " + session.consumers);
            }
            session.consumers = JMSConnection.recurseSetNoRetry(session.consumers, this.connection);
            session.consumersReconnect = false;
            session.session_clientResponsibleForAck = false;
        }
        if (session.consumersReconnect && !this.transacted && this.firstUnackedMessage != null && this.acknowledgeMode == 2) {
            session.setPendingWork(true);
        }
        return session;
    }

    @Override
    public Reconnectable preCreateReplacement(Reconnectable parent) throws JMSException {
        this.asyncSendCallbackRunner.onReconnect();
        JMSSession newSession = ((JMSConnection)parent).setupJMSSession(this.transacted, this.acknowledgeMode, this instanceof JMSXASession, this.type);
        newSession.setMapLocks(this.producers.getLock());
        newSession.exceptionContext = this.exceptionContext;
        newSession.messagesMaximum = this.messagesMaximum;
        newSession.overrunPolicy = this.overrunPolicy;
        newSession.deliveryMode = this.deliveryMode;
        newSession.priority = this.priority;
        newSession.timeToLive = this.timeToLive;
        newSession.synchronousListener = this.synchronousListener;
        newSession.unitOfOrder = this.unitOfOrder;
        if (this.redeliveryDelay != -1L && this.redeliveryDelay != newSession.redeliveryDelay) {
            newSession.setRedeliveryDelay(this.redeliveryDelay);
        }
        if (this.staleJMSSession != null) {
            newSession.refreshedWithPendingWork = this.transacted ? this.staleJMSSession.pendingWork : this.staleJMSSession.firstUnackedMessage != null;
        }
        newSession.subjectManager = this.subjectManager;
        newSession.consumersReconnect = this.consumersReconnect;
        newSession.replacementConsumerMap = new HashMap();
        JMSConnection.recursePreCreateReplacement(newSession, this.consumers);
        JMSConnection.recursePreCreateReplacement(newSession, this.producers);
        this.transferClientRspForAckMessages(newSession);
        newSession.replacementConsumerMap.clear();
        this.replacementSession = newSession;
        return newSession;
    }

    String debugMaps() {
        return this.producers + "\n" + this.consumers + "\n" + this.browsers;
    }

    @Override
    public void postCreateReplacement() {
        JMSConnection.recursePostCreateReplacement(this.consumers);
        JMSConnection.recursePostCreateReplacement(this.producers);
        JMSSession replacementSessionLocal = this.replacementSession;
        replacementSessionLocal.setWLSessionImpl(this.wlSessionImpl);
        replacementSessionLocal.forgetReconnectState();
        this.wlSessionImpl.setPhysicalReconnectable(replacementSessionLocal);
    }

    @Override
    public void forgetReconnectState() {
        Object next;
        this.staleJMSSession = null;
        Iterator iterator = this.producers.cloneValuesIterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (!(next instanceof Reconnectable)) continue;
            ((Reconnectable)next).forgetReconnectState();
        }
        iterator = this.consumers.cloneValuesIterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (!(next instanceof Reconnectable)) continue;
            ((Reconnectable)next).forgetReconnectState();
        }
        this.replacementSession = null;
    }

    boolean hasTemporaryDestination() {
        Iterator iterator = this.consumers.valuesIterator();
        while (iterator.hasNext()) {
            if (!((JMSConsumer)iterator.next()).hasTemporaryDestination()) continue;
            WLSessionImpl stableWLSession = this.wlSessionImpl;
            return stableWLSession != null && stableWLSession.getState() != -2304 && stableWLSession.getState() != -1280;
        }
        iterator = this.producers.valuesIterator();
        while (iterator.hasNext()) {
            if (!((JMSProducer)iterator.next()).hasTemporaryDestination()) continue;
            WLSessionImpl stableWLSession = this.wlSessionImpl;
            return stableWLSession != null && stableWLSession.getState() != -2304 && stableWLSession.getState() != -1280;
        }
        return false;
    }

    @Override
    public PeerInfo getFEPeerInfo() {
        return this.connection.getFEPeerInfo();
    }

    @Override
    public final synchronized int getMessagesMaximum() throws JMSException {
        this.checkClosed();
        return this.messagesMaximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void setMessagesMaximum(int messagesMaximum) throws JMSException {
        this.checkClosed();
        Object object = this.lockObject;
        synchronized (object) {
            if (messagesMaximum < -1 || messagesMaximum == 0) {
                throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidMessagesMaximumValueLoggable());
            }
            this.messagesMaximum = messagesMaximum;
        }
    }

    public int getSubscriptionSharingPolicy() throws JMSException {
        this.checkClosed();
        return this.subscriptionSharingPolicy;
    }

    @Override
    public final synchronized int getOverrunPolicy() throws JMSException {
        this.checkClosed();
        return this.overrunPolicy;
    }

    @Override
    public final synchronized void setOverrunPolicy(int overrunPolicy) throws JMSException {
        this.checkClosed();
        if (overrunPolicy != 0 && overrunPolicy != 1) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidOverrunPolicyLoggable(overrunPolicy));
        }
        this.overrunPolicy = overrunPolicy;
    }

    @Override
    public final long getRedeliveryDelay() throws JMSException {
        this.checkClosed();
        return this.getRedeliveryDelayInternal();
    }

    private long getRedeliveryDelayInternal() {
        return this.redeliveryDelay == -1L ? this.getConnection().getRedeliveryDelay() : this.redeliveryDelay;
    }

    @Override
    public final void setRedeliveryDelay(long redeliveryDelay) throws JMSException {
        this.checkClosed();
        if (redeliveryDelay < -1L) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryDelayLoggable().getMessage());
        }
        long origDelay = this.getRedeliveryDelayInternal();
        if (redeliveryDelay != origDelay && this.consumers.size() != 0) {
            this.redeliveryDelay = redeliveryDelay;
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FESessionSetRedeliveryDelayRequest(this.sessionId, redeliveryDelay));
        }
    }

    public final int getDeliveryMode() {
        return this.deliveryMode;
    }

    public final void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final long getTimeToLive() {
        return this.timeToLive;
    }

    public final void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    final long getSendTimeout() {
        return this.sendTimeout;
    }

    final void setId(JMSID sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public final JMSID getJMSID() {
        return this.sessionId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.connection.getDispatcherPartition4rmic();
    }

    public final void setType(int type) {
        this.type = type;
    }

    @Override
    public void setPipelineGeneration(int pipelineGeneration) {
        this.pipelineGeneration = pipelineGeneration;
    }

    public synchronized int getPipelineGenerationFromProxy() {
        if (this.connectionOlderThan90) {
            return this.proxyGenerationForOlderServer;
        }
        return this.pipelineGeneration;
    }

    final int getType() {
        return this.type;
    }

    @Override
    public final InvocableMonitor getInvocableMonitor() {
        return null;
    }

    final long getLastSequenceNumber() {
        if (this.realLastSequenceNumberShouldApply) {
            return this.realLastSequenceNumber;
        }
        return this.lastSequenceNumber;
    }

    final synchronized void setRealLastSequenceNumber(long sequenceNumber) {
        this.realLastSequenceNumber = sequenceNumber;
        this.realLastSequenceNumberShouldApply = true;
    }

    final boolean isTransacted() {
        return this.transacted;
    }

    final boolean userTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    final void setUserTransactionsEnabled(boolean value) {
        this.userTransactionsEnabled = value;
    }

    @Override
    public String getWLSServerName() {
        return this.connection.getWLSServerName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return this.connection;
    }

    public final void setRuntimeMBeanName(String runtimeMBeanName) {
        this.runtimeMBeanName = runtimeMBeanName;
    }

    @Override
    public final String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public final JMSConnection getConnection() {
        return this.connection;
    }

    @Override
    public final String getPartitionName() {
        return this.connection.getPartitionName();
    }

    public final String toString() {
        return this.connection.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    final MessageImpl receiveMessage(ConsumerInternal consumer, long timeout, CompletionListener appListener) throws JMSException {
        return this.receiveMessage(consumer, timeout, appListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MessageImpl receiveMessage(ConsumerInternal consumer, long timeout, CompletionListener appListener, Class bodyClass) throws JMSException {
        MessageImpl origmsg;
        boolean noTran;
        long timeArg;
        if (bodyClass != null && appListener != null) {
            throw new weblogic.jms.common.JMSException("Unexpected non-null appListener non-null bodyClass passed to JMSSession.receiveMessage");
        }
        JMSID consumerId = consumer.getJMSID();
        JMSConsumerReceiveResponsePrivate result = null;
        long startTime = System.currentTimeMillis();
        long waitTime = timeout;
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            while (this.stopped) {
                if (this.isClosed() || timeout == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                if (this.firstReceivePushRequest != null) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ie) {
                        throw new weblogic.jms.common.JMSException(ie);
                    }
                    if (timeout == Long.MAX_VALUE) continue;
                    long haveWaited = System.currentTimeMillis() - startTime;
                    if (haveWaited >= timeout) {
                        return null;
                    }
                    waitTime = timeout - haveWaited;
                    if (waitTime > 0L) continue;
                }
                if (!this.stopped && !this.isClosed()) continue;
                return null;
            }
            Object haveWaited = this.lockObject;
            synchronized (haveWaited) {
                JMSPushEntry pushEntry;
                JMSPushRequest pushRequest;
                JMSPushRequest prevPushRequest = null;
                for (pushRequest = this.firstReceivePushRequest; pushRequest != null; pushRequest = (JMSPushRequest)pushRequest.getNext()) {
                    pushEntry = pushRequest.getFirstPushEntry();
                    if (consumer.getJMSID().equals(pushEntry.getConsumerId())) {
                        if (bodyClass != null) {
                            MessageImpl m = pushRequest.getMessage();
                            try {
                                if (m.getBody(bodyClass) == null) {
                                    throw new MessageFormatException(JMSClientExceptionLogger.logNoMessageBodyLoggable().getMessage());
                                }
                            }
                            catch (MessageFormatException e) {
                                this.rememberFirstSequenceNumberNotSeen(pushEntry.getFrontEndSequenceNumber());
                                throw e;
                            }
                        }
                        pushEntry = pushRequest.removePushEntry();
                        result = new JMSConsumerReceiveResponsePrivate(pushRequest.getMessage(), pushEntry.getFrontEndSequenceNumber(), pushEntry.isTransactional(), pushEntry.getDeliveryCount());
                        break;
                    }
                    prevPushRequest = pushRequest;
                }
                if (result != null && (pushEntry = pushRequest.getFirstPushEntry()) == null) {
                    JMSPushRequest nextPushRequest = (JMSPushRequest)pushRequest.getNext();
                    pushRequest.setNext(null);
                    if (prevPushRequest == null) {
                        this.firstReceivePushRequest = nextPushRequest;
                    } else {
                        prevPushRequest.setNext(nextPushRequest);
                    }
                    if (nextPushRequest == null) {
                        this.lastReceivePushRequest = null;
                    }
                }
            }
        }
        if (result != null) {
            return this.proccessReceiveResponse(consumer, result, appListener);
        }
        waitTime = waitTime <= 0L || timeout == Long.MAX_VALUE || timeout == 0x7FFFFFFFFFFFFFFEL ? timeout : timeout - (startTime - System.currentTimeMillis());
        if (!this.transacted && this.userTransactionsEnabled) {
            timeArg = timeout;
            noTran = false;
        } else {
            timeArg = waitTime;
            noTran = true;
        }
        FEConsumerReceiveRequest request = new FEConsumerReceiveRequest(consumerId, timeArg, appListener, consumer);
        if (appListener == null) {
            if (!(this instanceof JMSXASession) && this.connection.isWrappedIC() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                throw new IllegalStateException(JMSClientExceptionLogger.logUnexpectedTransactionLoggable().getMessage());
            }
            JMSConsumerReceiveResponse receiveResponse = (JMSConsumerReceiveResponse)(noTran ? this.connection.getFrontEndDispatcher().dispatchSyncNoTran(request) : this.connection.getFrontEndDispatcher().dispatchSyncTran(request));
            origmsg = receiveResponse.getMessage();
            if (bodyClass != null && origmsg != null) {
                try {
                    if (origmsg.getBody(bodyClass) == null) {
                        throw new MessageFormatException(JMSClientExceptionLogger.logNoMessageBodyLoggable().getMessage());
                    }
                }
                catch (MessageFormatException e) {
                    JMSPushEntry pushEntry = new JMSPushEntry(null, consumer.getJMSID(), 0L, receiveResponse.getSequenceNumber(), origmsg.getDeliveryCount(), 0);
                    if (receiveResponse.isTransactional()) {
                        pushEntry.setTransactional();
                    }
                    pushEntry.setClientResponsibleForAcknowledge(origmsg.getClientResponsibleForAcknowledge());
                    JMSPushRequest pushRequest = new JMSPushRequest(0, this.sessionId, origmsg, pushEntry);
                    Object object = this.lockObject;
                    synchronized (object) {
                        this.addPushRequests(pushRequest, true);
                    }
                    object = this;
                    synchronized (object) {
                        this.rememberFirstSequenceNumberNotSeen(receiveResponse.getSequenceNumber());
                    }
                    throw e;
                }
            }
            return this.proccessReceiveResponse(consumer, receiveResponse, appListener);
        }
        Transaction transaction = noTran ? TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend() : null;
        try {
            this.connection.getFrontEndDispatcher().dispatchAsync(request);
            origmsg = ASYNC_RESERVED_MSG;
            return origmsg;
        }
        catch (DispatcherException e) {
            throw new weblogic.jms.common.JMSException(e);
        }
        finally {
            if (transaction != null) {
                TransactionHelper.getTransactionHelper().getTransactionManager().forceResume(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageImpl proccessReceiveResponse(ConsumerInternal consumer, Object result, CompletionListener appListener) throws JMSException {
        JMSConsumerReceiveResponse receiveResponse = (JMSConsumerReceiveResponse)result;
        MessageImpl messageImpl = null;
        MessageImpl originalMessageImpl = receiveResponse.getMessage();
        if (originalMessageImpl != null) {
            this.session_clientResponsibleForAck |= originalMessageImpl.getClientResponsibleForAcknowledge();
            int deliveryCount = receiveResponse instanceof JMSConsumerReceiveResponsePrivate ? ((JMSConsumerReceiveResponsePrivate)receiveResponse).getDeliveryCount() : originalMessageImpl.getDeliveryCount();
            if (this.connection.isLocal()) {
                messageImpl = originalMessageImpl.copy();
                messageImpl.setSequenceNumber(originalMessageImpl.getSequenceNumber());
                messageImpl.setClientResponsibleForAcknowledge(originalMessageImpl.getClientResponsibleForAcknowledge());
                messageImpl.setDeliveryCount(deliveryCount);
            } else {
                messageImpl = originalMessageImpl;
                messageImpl.setDeliveryCount(deliveryCount);
            }
            long sequenceNumber = receiveResponse.getSequenceNumber();
            messageImpl.setSequenceNumber(sequenceNumber);
            messageImpl.setDDForwarded(false);
            if (this.transacted) {
                this.setPendingWork(true);
            }
            if (receiveResponse.isTransactional()) {
                JMSSession jMSSession = this;
                synchronized (jMSSession) {
                    this.rememberLastSequenceNumber(sequenceNumber, messageImpl.getId());
                }
            }
            JMSSession jMSSession = this;
            synchronized (jMSSession) {
                this.rememberLastSequenceNumber(sequenceNumber, messageImpl.getId());
                this.addUnackedMessage(consumer, messageImpl);
            }
            if (this.acknowledgeMode == 2) {
                messageImpl.setSession(this);
            } else if (this.acknowledgeMode != 4) {
                if (this.acknowledgeMode == 3 && this.checkDelayAckForDupsOK(messageImpl) && --this.dupsOKAckCount > 0) {
                    this.requireAckForDupsOK = true;
                } else {
                    this.acknowledge(messageImpl, this.acknowledgePolicy, false);
                    this.requireAckForDupsOK = false;
                    this.dupsOKAckCount = this.dupsOKAckCountDown;
                }
            }
        }
        if (messageImpl != null) {
            messageImpl.setJMSDestinationImpl((DestinationImpl)consumer.getDestination());
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSSession (id: " + this.sessionId + ") : Received message " + messageImpl.getJMSMessageID());
            }
        }
        return this.afterReceive(messageImpl, consumer.getJMSID(), appListener);
    }

    final MessageImpl afterReceive(MessageImpl message, JMSID consumerId, CompletionListener appListener) {
        if (message != null) {
            message.setSerializeDestination(true);
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSConsumer (id: " + consumerId + ") : Received message " + message.getJMSMessageID());
            }
            message.setForward(true);
            message.setSAFSequenceName(null);
            message.setSAFSeqNumber(0L);
        }
        if (appListener != null) {
            appListener.onCompletion(message);
        }
        return message;
    }

    private void setPendingWorkOnMsgRecv() {
        if (this.acknowledgeMode == 2) {
            this.setPendingWork(true);
        }
    }

    private void rememberLastSequenceNumber(long sequenceNumber, JMSMessageId msgId) {
        this.previousExposedMsgId = this.lastExposedMsgId;
        this.lastSequenceNumber = sequenceNumber;
        this.lastExposedMsgId = msgId;
        this.rememberFirstSequenceNumberNotSeen(0L);
    }

    private void rememberFirstSequenceNumberNotSeen(long sequenceNumber) {
        this.firstSequenceNumberNotSeen = sequenceNumber;
    }

    private long getFirstSequenceNumberNotSeen() {
        return this.firstSequenceNumberNotSeen;
    }

    void rememberLastServerAck(JMSMessageId msgId) {
        if (this.transacted) {
            return;
        }
        this.lastAckMsgId = msgId;
    }

    public JMSMessageId getLastAckMsgId() {
        return this.lastAckMsgId;
    }

    public JMSMessageId getLastExposedMsgId() {
        return this.lastExposedMsgId;
    }

    @Override
    public final BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createBytesMessage();
    }

    @Override
    public final MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createMapMessage();
    }

    @Override
    public final Message createMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createMessage();
    }

    @Override
    public final ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createObjectMessage();
    }

    @Override
    public final ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createObjectMessage(object);
    }

    @Override
    public final StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createStreamMessage();
    }

    @Override
    public final TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage();
    }

    @Override
    public final TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage(string);
    }

    @Override
    public final XMLMessage createXMLMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage();
    }

    @Override
    public final XMLMessage createXMLMessage(String string) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage(string);
    }

    @Override
    public final XMLMessage createXMLMessage(Document doc) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage(doc);
    }

    public final TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage(stringBuffer);
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    @Override
    public final int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        if (this.transacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    @Override
    public void commit() throws JMSException {
        this.commit(-1L);
    }

    synchronized void commit(long sequenceNumber) throws JMSException {
        this.checkClosed();
        if (sequenceNumber != -1L) {
            this.setRealLastSequenceNumber(sequenceNumber);
        }
        if (!this.transacted) {
            throw new IllegalStateException(JMSClientExceptionLogger.logNoTransaction3Loggable().getMessage());
        }
        this.checkOpPermissionForAsyncSend("Session.commit()");
        this.waitTillAllAsyncSendProcessed();
        this.firstUnackedMessage = null;
        this.firstPendingWTMessage = null;
        try {
            Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getJMSID(), this.getLastSequenceNumber(), 1, true));
            this.decrementWindow = false;
        }
        catch (JMSException jmse) {
            if ("ReservedRollbackOnly".equals(jmse.getErrorCode())) {
                try {
                    this.recoverGuts(false, -1L);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            throw jmse;
        }
    }

    void rollback(long sequenceNumber) throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException(JMSClientExceptionLogger.logNoTransaction4Loggable().getMessage());
        }
        this.checkOpPermissionForAsyncSend("Session.rollback()");
        this.waitTillAllAsyncSendProcessed();
        this.recoverGuts(false, sequenceNumber);
    }

    @Override
    public void rollback() throws JMSException {
        this.rollback(-1L);
    }

    final void consumerIncrementWindowCurrent(final JMSID consumerId, final int windowIncrement, final boolean clientResponsibleForAcknowledge) throws JMSException {
        byte peerVersion = this.connection.getPeerVersion();
        if (peerVersion < 3) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEConsumerIncrementWindowCurrentRequest(consumerId, windowIncrement, clientResponsibleForAcknowledge));
        } else {
            final JMSConnection connectionFinal = this.connection;
            CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getFrontEndDispatcher(), CrossDomainSecurityManager.getCurrentSubject(), true), new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    connectionFinal.getFrontEndDispatcher().dispatchNoReply(new FEConsumerIncrementWindowCurrentOneWayRequest(consumerId, windowIncrement, clientResponsibleForAcknowledge));
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            if (this.stopped) {
                return;
            }
            if (!this.inListener() || !this.allowCloseInOnMessage) {
                this.waitForState(-5);
            }
            if (this.isClosed()) {
                return;
            }
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                if (!this.stopped || this.isClosed()) {
                    return;
                }
                this.stopped = false;
                this.notifyAll();
                if (!(!this.running && this.havePushRequests() || this.synchronousListener)) {
                    return;
                }
                this.running = true;
            }
        }
        this.dispatchWorkManager.schedule(this.useForRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resume() throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                this.stopped = false;
                if (!this.havePushRequests() && !this.synchronousListener) {
                    return;
                }
                this.running = true;
            }
        }
        this.dispatchWorkManager.schedule(this.useForRunnable);
    }

    @Override
    public final void close() throws JMSException {
        this.close(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void close(long sequenceNumber) throws JMSException {
        Object object;
        this.checkOpPermissionForAsyncSend("Session.close()");
        JMSID sessionId = null;
        boolean removeFromConnection = false;
        try {
            object = this;
            // MONITORENTER : object
            if (sequenceNumber == -1L) {
                this.realLastSequenceNumberShouldApply = false;
            } else {
                this.setRealLastSequenceNumber(sequenceNumber);
            }
            this.closeStarted = true;
            this.realLastSequenceNumberShouldApply = false;
            Object object2 = this.synchronousListenerObject;
            // MONITORENTER : object2
            this.synchronousListenerObject.notifyAll();
            // MONITOREXIT : object2
            this.asyncSendCallbackRunnerClosing();
            this.waitTillAllAsyncSendProcessed();
            if (!this.inListener() || !this.allowCloseInOnMessage) {
                this.waitForState(-5);
            }
            if (this.isClosed()) {
                // MONITOREXIT : object
                try {
                    object2 = this;
                    // MONITORENTER : object2
                    this.waitForState(-3);
                    try {
                        this.removeDurableConsumers();
                        return;
                    }
                    finally {
                        this.consumers.clear();
                        this.producers.clear();
                        this.browsers.clear();
                        this.firstUnackedMessage = null;
                        this.firstPendingWTMessage = null;
                        this.clientAckList = null;
                        this.clearState(1);
                        this.notify();
                    }
                }
                finally {
                    this.XAClose();
                    object2 = this.synchronousListenerObject;
                }
            }
            if (this.requireAckForDupsOK) {
                this.acknowledge(true, false);
            }
            removeFromConnection = true;
            sessionId = this.poisonSession();
            if (this.mSock != null) {
                this.mSock.close();
                this.mSock = null;
            }
            this.poisonConsumersAndCloseLocaly();
            this.poisonProducers();
            this.poisonBrowsers();
            this.setState(1);
            // MONITOREXIT : object
            this.dispatchSessionCloseRequest(sessionId);
        }
        catch (Throwable throwable) {
            try {
                Object object3 = this;
                // MONITORENTER : object3
                this.waitForState(-3);
                try {
                    this.removeDurableConsumers();
                }
                finally {
                    this.consumers.clear();
                    this.producers.clear();
                    this.browsers.clear();
                    this.firstUnackedMessage = null;
                    this.firstPendingWTMessage = null;
                    this.clientAckList = null;
                    this.clearState(1);
                    this.notify();
                }
                // MONITOREXIT : object3
                this.XAClose();
                object3 = this.synchronousListenerObject;
            }
            catch (Throwable throwable2) {
                this.XAClose();
                Object object4 = this.synchronousListenerObject;
                // MONITORENTER : object4
                this.synchronousListenerObject.notifyAll();
                // MONITOREXIT : object4
                if (!removeFromConnection) throw throwable2;
                this.connection.sessionRemove(sessionId);
                throw throwable2;
            }
            this.synchronousListenerObject.notifyAll();
            // MONITOREXIT : object3
            if (!removeFromConnection) throw throwable;
            this.connection.sessionRemove(sessionId);
            throw throwable;
        }
        try {
            object = this;
            // MONITORENTER : object
            this.waitForState(-3);
            try {
                this.removeDurableConsumers();
                return;
            }
            finally {
                this.consumers.clear();
                this.producers.clear();
                this.browsers.clear();
                this.firstUnackedMessage = null;
                this.firstPendingWTMessage = null;
                this.clientAckList = null;
                this.clearState(1);
                this.notify();
            }
        }
        finally {
            this.XAClose();
            object = this.synchronousListenerObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSID poisonSession() {
        JMSSession lock;
        JMSSession jMSSession = lock = this.wlSessionImpl == null ? this : this.wlSessionImpl.getConnectionStateLock();
        synchronized (jMSSession) {
            JMSID sessionId = this.sessionId;
            this.sessionId = null;
            return sessionId;
        }
    }

    @Override
    public void isCloseAllowed(String operation) throws JMSException {
        if (!this.isOperationAllowed()) {
            throw new IllegalStateException(JMSClientExceptionLogger.logInvalidCloseFromListenerLoggable(operation, "Session").getMessage());
        }
    }

    boolean isOperationAllowed() {
        return this.allowCloseInOnMessage || !this.inListener();
    }

    private void removeDurableConsumers() {
        Iterator iterator = this.consumers.cloneValuesIterator();
        while (iterator.hasNext()) {
            ConsumerInternal consumer = (ConsumerInternal)iterator.next();
            if (!consumer.isDurable()) continue;
            consumer.removeDurableConsumer();
        }
    }

    private void poisonBrowsers() {
        Iterator iterator = this.browsers.cloneValuesIterator();
        while (iterator.hasNext()) {
            JMSQueueBrowser browser = (JMSQueueBrowser)iterator.next();
            browser.setId(null);
        }
    }

    private void poisonConsumersAndCloseLocaly() throws JMSException {
        Iterator iterator = this.consumers.cloneValuesIterator();
        while (iterator.hasNext()) {
            ConsumerInternal consumer = (ConsumerInternal)iterator.next();
            this.consumerCloseLocal(consumer, false);
        }
    }

    private void poisonProducers() {
        Iterator iterator = this.producers.cloneValuesIterator();
        while (iterator.hasNext()) {
            JMSProducer producer = (JMSProducer)iterator.next();
            producer.setId(null);
        }
    }

    private void dispatchSessionCloseRequest(JMSID sessionId) throws JMSException {
        if (!this.connection.isConnected()) {
            return;
        }
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionCloseRequest(sessionId, this.getLastSequenceNumber()));
    }

    private void waitForOutstandingReceives() throws JMSException {
        try {
            this.setState(1);
            this.waitForState(-3);
        }
        finally {
            this.clearState(1);
        }
    }

    @Override
    public final void recover() throws JMSException {
        this.recover(-1L);
    }

    final void recover(long sequenceNumber) throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException(JMSClientExceptionLogger.logTransactedLoggable().getMessage());
        }
        this.recoverGuts(true, sequenceNumber);
    }

    private void recoverGuts(boolean sessionRecover, long sequenceNumber) throws JMSException {
        this.checkClosed();
        if (this.connection.getPeerVersion() < 5) {
            this.recoverGuts81(sessionRecover, sequenceNumber);
        } else {
            this.recoverGuts90(sessionRecover, sequenceNumber);
        }
    }

    private final synchronized void recoverGuts81(boolean sessionRecover, long seq) throws JMSException {
        MessageList listCopy;
        ConsumerInternal consumer;
        boolean doFERecover;
        if (seq != -1L) {
            this.setRealLastSequenceNumber(seq);
        }
        if (this.requireAckForDupsOK) {
            this.acknowledge(false, false);
        }
        this.decrementWindow = false;
        long sendSequenceNumber = this.getLastSequenceNumber();
        this.rememberLastSequenceNumber(0L, null);
        boolean bl = doFERecover = this.transacted || this.firstUnackedMessage != null;
        if (doFERecover) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionRecoverRequest(this.getJMSID(), sendSequenceNumber, !sessionRecover, this.pipelineGeneration));
            this.setExpectedSequenceNumber81(((JMSSessionRecoverResponse)response).getSequenceNumber(), false);
            Iterator iterator = this.consumers.cloneValuesIterator();
            while (iterator.hasNext()) {
                consumer = (ConsumerInternal)iterator.next();
                consumer.setWindowCurrent(consumer.getWindowMaximum());
                consumer.setExpectedSequenceNumber(this.expectedSequenceNumber);
            }
            this.firstUnackedMessage = null;
            this.firstPendingWTMessage = null;
        }
        if ((listCopy = this.clientAckList) != null) {
            JMSMessageReference mRef;
            this.clientAckList = null;
            Request pushRequest = null;
            JMSPushRequest newPushRequest = null;
            JMSPushRequest firstPushRequest = null;
            long sequenceNumber = this.expectedSequenceNumber;
            for (mRef = (JMSMessageReference)listCopy.getLast(); mRef != null; mRef = (JMSMessageReference)mRef.getPrev()) {
                consumer = mRef.getConsumer();
                sequenceNumber = mRef.getSequenceNumber();
                consumer.setExpectedSequenceNumber(sequenceNumber, true);
            }
            this.setExpectedSequenceNumber81(sequenceNumber, true);
            for (mRef = (JMSMessageReference)listCopy.getFirst(); mRef != null; mRef = (JMSMessageReference)mRef.getNext()) {
                MessageImpl message = mRef.getMessage();
                message.incrementDeliveryCount();
                message = mRef.getMessage();
                message.reset();
                message.setPropertiesWritable(false);
                newPushRequest = new JMSPushRequest(0, null, message);
                if (pushRequest != null) {
                    pushRequest.setNext(newPushRequest);
                } else {
                    firstPushRequest = newPushRequest;
                }
                pushRequest = newPushRequest;
                newPushRequest = null;
                consumer = mRef.getConsumer();
                long messageSequenceNumber = mRef.getSequenceNumber();
                JMSPushEntry pushEntry = new JMSPushEntry(null, consumer.getJMSID(), 0L, messageSequenceNumber, message.getDeliveryCount(), 0x200000);
                pushEntry.setClientResponsibleForAcknowledge(true);
                ((JMSPushRequest)pushRequest).setPushEntries(pushEntry);
            }
            if (firstPushRequest != null) {
                this.pushMessage(firstPushRequest, this.consumerListenerCount == 0);
            }
        }
        if (this.inState(4)) {
            this.recovering = true;
        }
        this.proxyGenerationForOlderServer = this.proxyGenerationForOlderServer == Integer.MAX_VALUE ? 0 : ++this.proxyGenerationForOlderServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recoverGuts90(boolean sessionRecover, long sequenceNumber) throws JMSException {
        FESessionRecoverRequest feSessionRecoverRequest;
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            if (sequenceNumber != -1L) {
                this.setRealLastSequenceNumber(sequenceNumber);
            }
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSSession (id: " + this.sessionId + ") : Recover msg " + this.getLastSequenceNumber() + ", info " + (this.firstUnackedMessage == null) + "/" + (this.clientAckList == null) + "/" + this.transacted);
            }
            if (this.requireAckForDupsOK) {
                this.acknowledge(false, false);
            }
            long sendLastSequenceNumber = this.getLastSequenceNumber();
            this.rememberLastSequenceNumber(0L, null);
            if (this.acknowledgeMode == 4 || this.acknowledgeMode == 128) {
                return;
            }
            if (this.inState(4)) {
                this.recovering = true;
            }
            this.decrementWindow = false;
            Object object = this.lockObject;
            synchronized (object) {
                int old = this.pipelineGeneration;
                this.pipelineGeneration = JMSPushEntry.nextRecoverGeneration(this.pipelineGeneration);
                this.recoversFor90HasBeenCalled = true;
                if (this.session_clientResponsibleForAck) {
                    JMSPushRequest oldPushRequest = this.firstPushRequest;
                    this.lastPushRequest = null;
                    this.setFirstPushRequest(null);
                    this.pushRequestCount = 0;
                    this.restoreClientAckMessages(sendLastSequenceNumber, oldPushRequest);
                } else {
                    for (JMSPushRequest current = this.firstPushRequest; current != null; current = (JMSPushRequest)current.getNext()) {
                        if (!this.connection.isLocal() || current.getFirstPushEntry().getPipelineGeneration() != 0) continue;
                        current.getFirstPushEntry().setPipelineGeneration(0x100000);
                    }
                }
                Iterator iterator = this.consumers.cloneValuesIterator();
                while (iterator.hasNext()) {
                    ConsumerInternal consumer = (ConsumerInternal)iterator.next();
                    consumer.setWindowCurrent(consumer.getWindowMaximum());
                }
            }
            this.firstUnackedMessage = null;
            this.firstPendingWTMessage = null;
            feSessionRecoverRequest = new FESessionRecoverRequest(this.getJMSID(), sendLastSequenceNumber, !sessionRecover, this.pipelineGeneration);
        }
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(feSessionRecoverRequest);
    }

    private void restoreClientAckMessages(long recoveredSeqNum, JMSPushRequest oldPushRequest) {
        JMSPushEntry pushEntry;
        JMSPushRequest current;
        MessageList listCopy = this.clientAckList;
        this.clientAckList = null;
        ConsumerInternal consumer = null;
        JMSID lastConsumerID = null;
        if (listCopy != null) {
            for (JMSMessageReference mRef = (JMSMessageReference)listCopy.getFirst(); mRef != null; mRef = (JMSMessageReference)mRef.getNext()) {
                if (mRef.getConsumer().isClosed()) continue;
                if (!mRef.getConsumer().getJMSID().equals(lastConsumerID)) {
                    lastConsumerID = mRef.getConsumer().getJMSID();
                    consumer = this.consumerFind(lastConsumerID);
                }
                if (consumer == null) continue;
                MessageImpl message = mRef.getMessage();
                try {
                    message.setMessageReference(null);
                    message = message.copy();
                    message.setMessageReference(mRef);
                    mRef.setMessage(message);
                    message.reset();
                    message.setPropertiesWritable(false);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                if (mRef.getSequenceNumber() <= recoveredSeqNum) {
                    mRef.incrementDeliveryCount();
                }
                JMSPushEntry pushEntry2 = new JMSPushEntry(this.getJMSID(), mRef.getConsumer().getJMSID(), 0L, mRef.getSequenceNumber(), mRef.getDeliveryCount(), 0x200000);
                pushEntry2.setClientResponsibleForAcknowledge(true);
                this.fabricateClientAckPushEntry(consumer, message, pushEntry2);
            }
        }
        for (current = this.recoverableClientAckMessages; current != null; current = (JMSPushRequest)current.getNext()) {
            for (pushEntry = current.removePushEntry(); pushEntry != null; pushEntry = pushEntry.getNext()) {
                if (!pushEntry.getClientResponsibleForAcknowledge()) continue;
                if (!pushEntry.getConsumerId().equals(lastConsumerID)) {
                    lastConsumerID = pushEntry.getConsumerId();
                    consumer = this.consumerFind(lastConsumerID);
                }
                if (consumer == null) continue;
                this.fabricateClientAckPushEntry(consumer, current.getMessage(), pushEntry);
            }
        }
        for (current = oldPushRequest; current != null; current = (JMSPushRequest)current.getNext()) {
            for (pushEntry = current.removePushEntry(); pushEntry != null; pushEntry = pushEntry.getNext()) {
                if (!pushEntry.getClientResponsibleForAcknowledge()) continue;
                if (!pushEntry.getConsumerId().equals(lastConsumerID)) {
                    lastConsumerID = pushEntry.getConsumerId();
                    consumer = this.consumerFind(lastConsumerID);
                }
                if (consumer == null) continue;
                this.fabricateClientAckPushEntry(consumer, current.getMessage(), pushEntry);
            }
        }
    }

    private void fabricateClientAckPushEntry(ConsumerInternal consumer, MessageImpl message, JMSPushEntry pushEntry) {
        pushEntry.setPipelineGeneration(0x200000);
        JMSPushRequest pushRequest = new JMSPushRequest(0, this.getJMSID(), message, pushEntry);
        if (consumer.getMessageListenerContext() == null) {
            this.addPushRequests(pushRequest, true);
            if (consumer.getExpectedSequenceNumber() > this.firstReceivePushRequest.getFrontEndSequenceNumber()) {
                consumer.setExpectedSequenceNumber(this.firstReceivePushRequest.getFrontEndSequenceNumber());
            }
            return;
        }
        if (this.lastPushRequest != null) {
            this.lastPushRequest.setNext(pushRequest);
        } else {
            this.setFirstPushRequest(pushRequest);
        }
        this.lastPushRequest = pushRequest;
        ++this.pushRequestCount;
    }

    private boolean duplicateMessage(MessageImpl msg, JMSID consumerId, MessageList listCopy) {
        if (listCopy != null) {
            for (JMSMessageReference mref = (JMSMessageReference)listCopy.getFirst(); mref != null; mref = (JMSMessageReference)mref.getNext()) {
                if (mref.getMessage() != msg) continue;
                return true;
            }
        }
        for (JMSPushRequest pushRequest = this.firstPushRequest; pushRequest != null; pushRequest = (JMSPushRequest)pushRequest.getNext()) {
            if (msg == pushRequest.getMessage()) {
                return true;
            }
            for (JMSPushEntry pushEntry = pushRequest.getFirstPushEntry(); pushEntry != null; pushEntry = pushEntry.getNext()) {
                if (!consumerId.equals(pushEntry.getConsumerId()) || !msg.getId().equals(pushRequest.getMessage().getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final void acknowledge() throws JMSException {
        this.acknowledge(null, 1, false);
    }

    @Override
    public final void acknowledge(Message message) throws JMSException {
        this.throwForAckRefreshedSessionRules();
        this.acknowledge((WLAcknowledgeInfo)((Object)message), this.acknowledgePolicy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(boolean forClose, boolean clientResponsibleForAcknowledge) throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            JMSMessageId lastExposed;
            long sequenceNumber;
            if (this.inListener()) {
                sequenceNumber = this.getLastSequenceNumber() - 1L;
                lastExposed = this.previousExposedMsgId;
            } else {
                sequenceNumber = this.getLastSequenceNumber();
                lastExposed = this.lastExposedMsgId;
            }
            this.checkClosed();
            try {
                if (!clientResponsibleForAcknowledge) {
                    this.rememberLastServerAck(lastExposed);
                    if (!forClose || this.connection.isConnected()) {
                        this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getJMSID(), sequenceNumber, 1, false));
                    }
                    this.rememberLastServerAck(null);
                }
            }
            catch (Exception e) {
                JMSSession.handleException(e);
            }
            finally {
                this.removePendingWTMessage(sequenceNumber, IGNOREWINDOWCURRENT);
                this.removeUnackedMessage(sequenceNumber, clientResponsibleForAcknowledge, false);
            }
        }
    }

    @Override
    public final void acknowledge(WLAcknowledgeInfo ackInfo) throws JMSException {
        this.throwForAckRefreshedSessionRules();
        this.acknowledge(ackInfo, this.acknowledgePolicy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(WLAcknowledgeInfo ackInfo, int acknowledgePolicy, boolean isInfectedAck) throws JMSException {
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            JMSMessageId lastExposedMsg;
            long sequenceNumber;
            boolean clientResponsibleForAcknowledge;
            if (ackInfo == null) {
                clientResponsibleForAcknowledge = false;
                sequenceNumber = this.getLastSequenceNumber();
                lastExposedMsg = this.lastExposedMsgId;
            } else {
                clientResponsibleForAcknowledge = ackInfo.getClientResponsibleForAcknowledge();
                if (acknowledgePolicy == 1 && this.mmListener == null) {
                    sequenceNumber = this.getLastSequenceNumber();
                    lastExposedMsg = this.lastExposedMsgId;
                } else {
                    sequenceNumber = ackInfo.getSequenceNumber();
                    lastExposedMsg = ackInfo.getMessageId();
                }
            }
            this.checkClosed();
            if (this.transacted) {
                return;
            }
            try {
                if (!clientResponsibleForAcknowledge) {
                    if (isInfectedAck) {
                        this.connection.getFrontEndDispatcher().dispatchSyncTran(new FESessionAcknowledgeRequest(this.getJMSID(), sequenceNumber, acknowledgePolicy, false));
                    } else {
                        this.rememberLastServerAck(lastExposedMsg);
                        this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FESessionAcknowledgeRequest(this.getJMSID(), sequenceNumber, acknowledgePolicy, false));
                        this.rememberLastServerAck(null);
                    }
                    if (sequenceNumber == this.getLastSequenceNumber()) {
                        this.decrementWindow = false;
                    }
                }
            }
            catch (Exception e) {
                JMSSession.handleException(e);
            }
            finally {
                this.removePendingWTMessage(sequenceNumber, IGNOREWINDOWCURRENT);
                this.removeUnackedMessage(sequenceNumber, clientResponsibleForAcknowledge, isInfectedAck);
            }
        }
    }

    void throwForAckRefreshedSessionRules() throws LostServerException {
        if (this.checkRefreshedWithPendingWork()) {
            throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
        }
    }

    @Override
    public final void associateTransaction(Message message) throws JMSException {
        MessageImpl msg = (MessageImpl)message;
        if (!this.userTransactionsEnabled && msg.getUnitOfOrder() != null) {
            throw new JMSException("associateTransaction with Unit of Order requires XASession");
        }
        this.acknowledge(msg, 1, true);
    }

    @Override
    public final MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        if (this.messageContext != null) {
            return this.messageContext.getMessageListener();
        }
        return null;
    }

    public final synchronized JMSMessageContext getJMSMessageContext() {
        return this.messageContext;
    }

    @Override
    public final synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkClosed();
        if (this.consumerListenerCount > 0) {
            throw new IllegalStateException(JMSClientExceptionLogger.logSessionHasConsumersLoggable().getMessage());
        }
        this.messageContext = new JMSMessageContext(messageListener);
    }

    @Override
    public final synchronized void setMMessageListener(MMessageListener messageListener) {
        this.mmListener = messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.inlineHandleOnMessageException();
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            Object object = this.lockObject;
            synchronized (object) {
                this.lastPushRequest = null;
                this.setFirstPushRequest(null);
                this.pushRequestCount = 0;
            }
            this.setState(4);
        }
        JMSContext savedMessageContext = null;
        boolean popSubject = false;
        try {
            MessageListener messageListener = this.getMessageListener();
            if (messageListener == null) {
                return;
            }
            savedMessageContext = JMSContext.push(this.messageContext, true);
            popSubject = true;
            for (JMSPushRequest pushRequest = this.firstPushRequest; pushRequest != null; pushRequest = (JMSPushRequest)pushRequest.getNext()) {
                MessageImpl message = pushRequest.getMessage().copy();
                message.setDDForwarded(false);
                JMSPushEntry pushEntry = pushRequest.getFirstPushEntry();
                ConsumerInternal consumer = this.consumerFind(pushEntry.getConsumerId());
                message.setSequenceNumber(pushEntry.getFrontEndSequenceNumber());
                message.setDeliveryCount(pushEntry.getDeliveryCount());
                this.onMessage(consumer, messageListener, message);
            }
        }
        catch (JMSException ignore) {
            JMSClientExceptionLogger.logStackTrace(ignore);
        }
        finally {
            this.clearState(4);
            try {
                this.inlineHandleOnMessageException();
            }
            finally {
                if (popSubject) {
                    JMSContext.pop(savedMessageContext, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inlineHandleOnMessageException() {
        JMSException inlineOnMessageException;
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            if (this.deferredException == null) {
                return;
            }
            inlineOnMessageException = this.deferredException;
            this.deferredException = null;
        }
        this.onException(inlineOnMessageException);
    }

    @Override
    public final synchronized Topic createTopic(String topicName) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperationLoggable().getMessage());
        }
        return (Topic)this.createDestination(topicName, 2);
    }

    @Override
    public final synchronized TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        byte flags = 5;
        return (TopicSubscriber)this.createConsumer(topic, null, false, null, flags);
    }

    @Override
    public final synchronized TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        byte flags = 5;
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, noLocal, null, flags);
    }

    @Override
    public final TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    @Override
    public final TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation2Loggable("createDurableSubscriber").getMessage());
        }
        if (name == null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSubscriberNameLoggable());
        }
        if (name.length() == 0) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logZeroLengthSubscriberNameLoggable());
        }
        if (topic instanceof DistributedDestinationImpl) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidDistributedTopicLoggable());
        }
        byte flags = 5;
        return (TopicSubscriber)this.createConsumer(topic, selector, noLocal, name, flags);
    }

    @Override
    public final TopicPublisher createPublisher(Topic topic) throws JMSException {
        byte flags = 4;
        return (TopicPublisher)this.createProducer(topic, flags);
    }

    @Override
    public final TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation3Loggable().getMessage());
        }
        return (TemporaryTopic)this.createTemporaryDestination(8);
    }

    @Override
    public final synchronized void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation4Loggable().getMessage());
        }
        if (name == null || name.length() == 0) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidSubscriptionLoggable().getMessage());
        }
        if (this.connection.getClientIDPolicyInt() == 1) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidUnrestrictedUnsubscribeLoggable(name, this.clientID).getMessage());
        }
        this.subscriptionRemove(name);
    }

    @Override
    public synchronized void unsubscribe(Topic topic, String name) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation4Loggable().getMessage());
        }
        if (name == null || name.length() == 0) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidSubscriptionLoggable().getMessage());
        }
        if (this.connection.getClientIDPolicyInt() == 1 && (topic == null || topic instanceof DistributedDestinationImpl)) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidUnrestrictedUnsubscribe2Loggable(name, this.clientID).getMessage());
        }
        this.subscriptionRemove((DestinationImpl)topic, name);
    }

    @Override
    public final synchronized Queue createQueue(String queueName) throws JMSException {
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedQueueOperationLoggable().getMessage());
        }
        return (Queue)this.createDestination(queueName, 1);
    }

    @Override
    public final QueueReceiver createReceiver(Queue queue) throws JMSException {
        byte flags = 3;
        return (QueueReceiver)this.createConsumer(queue, null, false, null, flags);
    }

    @Override
    public final QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        byte flags = 3;
        return (QueueReceiver)this.createConsumer(queue, messageSelector, false, null, flags);
    }

    @Override
    public final QueueSender createSender(Queue queue) throws JMSException {
        byte flags = 2;
        return (QueueSender)this.createProducer(queue, flags);
    }

    @Override
    public final QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    @Override
    public final synchronized QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedQueueOperation2Loggable().getMessage());
        }
        byte flags = 3;
        weblogic.jms.common.Destination.checkDestinationType(queue, flags);
        JMSQueueBrowser browser = new JMSQueueBrowser(queue, messageSelector, this);
        this.browsers.put(browser.getJMSID(), browser);
        try {
            InvocableManagerDelegate delegate = this.connection.clientDispatcherPartitionContext.getInvocableManagerDelegate();
            delegate.invocableAdd(22, browser);
        }
        catch (Exception jmse) {
            JMSClientExceptionLogger.logStackTrace(jmse);
            throw jmse;
        }
        return browser;
    }

    final synchronized void closeBrowser(JMSID browserId, boolean localOnly) throws JMSException {
        if (this.browsers.remove(browserId) == null) {
            return;
        }
        if (!localOnly) {
            Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEBrowserCloseRequest(browserId));
        }
        InvocableManagerDelegate delegate = this.connection.clientDispatcherPartitionContext.getInvocableManagerDelegate();
        delegate.invocableRemove(22, browserId);
    }

    @Override
    public final MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkClosed();
        return this.createConsumer(destination, null, false, null, (byte)0);
    }

    @Override
    public final MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false, null, (byte)0);
    }

    @Override
    public final MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.createConsumer(destination, messageSelector, noLocal, null, (byte)0);
    }

    private MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal, String duraName, byte flags) throws JMSException {
        return this.createConsumer(destination, messageSelector, noLocal, duraName, duraName != null, false, flags);
    }

    private MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal, String subscriptionName, boolean isDurable, boolean isJMS2Share, byte flags) throws JMSException {
        String innerMsgSelector = messageSelector;
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestinationLoggable().getMessage());
        }
        if (((DestinationImpl)destination).isTopic() && this.connection.isInbound()) {
            String clientId = this.connection.getClientID();
            if (clientId == null || clientId.length() == 0) {
                throw new JMSException("ClientId cannot be null to create topic subscriber for inbound connection.");
            }
            if (this.connection.getInboundDest().isReplicated()) {
                innerMsgSelector = innerMsgSelector == null ? "NOT JMS_WL_DDForwarded" : "(" + innerMsgSelector + ") AND NOT JMS_WL_DDForwarded";
            }
        }
        JMSConsumer jmsConsumer = this.setupConsumer(destination, innerMsgSelector, noLocal, subscriptionName, isDurable, isJMS2Share, flags, this.wlSessionImpl.getWLConnectionImpl().computeConsumerReconnectInfo(JMSEnvironment.getJMSEnvironment().getLocalDispatcherId()));
        WLConsumerImpl wlConsumer = new WLConsumerImpl(jmsConsumer, this.wlSessionImpl);
        jmsConsumer.setWlConsumerImpl(wlConsumer);
        return wlConsumer;
    }

    synchronized JMSConsumer setupConsumer(Destination destination, String messageSelector, boolean noLocal, String subscriptionName, boolean isDurable, boolean isJMS2Share, byte flags, ConsumerReconnectInfo consumerReconnectInfo) throws JMSException {
        JMSConsumer consumer;
        this.checkClosed();
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestinationLoggable().getMessage());
        }
        weblogic.jms.common.Destination.checkDestinationType(destination, flags);
        if (this.acknowledgeMode != 128) {
            subscriptionName = this.throwWhenInvalidSubscriberName(destination, subscriptionName, isJMS2Share);
            consumer = new JMSConsumer(this, subscriptionName, isDurable, isJMS2Share, (DestinationImpl)destination, messageSelector, noLocal, this.messagesMaximum, flags);
        } else {
            if (subscriptionName != null && isDurable) {
                subscriptionName = null;
                isDurable = false;
            }
            String multicastAddress = this.setupMulticastInternal(destination);
            consumer = new JMSConsumer(this, subscriptionName, isDurable, isJMS2Share, (DestinationImpl)destination, messageSelector, noLocal, this.messagesMaximum, flags);
            try {
                this.mSock.joinGroup((DestinationImpl)destination, consumer);
            }
            catch (IOException ne) {
                throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logCannotJoinMulticastGroupLoggable(multicastAddress, ne));
            }
        }
        if (consumer.isDurable() && consumerReconnectInfo != null) {
            consumerReconnectInfo.setDelayServerClose(0L);
        }
        FEConsumerCreateResponse response = this.consumerCreate(subscriptionName, isDurable, isJMS2Share, (DestinationImpl)destination, messageSelector, noLocal, this.messagesMaximum, consumerReconnectInfo);
        consumer.setId(response.getConsumerId());
        consumer.setRuntimeMBeanName(response.getRuntimeMBeanName());
        consumer.setConsumerReconnectInfo(response.getConsumerReconnectInfo());
        this.consumerAdd(consumer);
        return consumer;
    }

    private String throwWhenInvalidSubscriberName(Destination destination, String subscriptionName, boolean isJMS2Share) throws IllegalStateException {
        if (!((DestinationImpl)destination).isTopic()) {
            subscriptionName = null;
        } else if (subscriptionName != null) {
            if (subscriptionName.length() == 0) {
                subscriptionName = null;
            } else if (this.clientID == null && !isJMS2Share || this.clientID != null && this.clientID.length() == 0) {
                throw new IllegalStateException(JMSClientExceptionLogger.logInvalidConsumerCreationLoggable(subscriptionName).getMessage());
            }
        }
        return subscriptionName;
    }

    private String setupMulticastInternal(Destination destination) throws weblogic.jms.common.JMSException {
        if (((DestinationImpl)destination).isQueue()) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoMulticastForQueuesLoggable());
        }
        String multicastAddress = ((DestinationImpl)destination).getMulticastAddress();
        int port = ((DestinationImpl)destination).getPort();
        if (multicastAddress == null || port <= 0) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logTopicNoMulticastLoggable(destination.toString()));
        }
        try {
            if (this.mSock == null) {
                this.dgmSock = new JMSTDMSocketIPM(port);
                this.dgmSock.setSoTimeout(1000);
                this.mSock = new JMSTMSocket(this, this.dgmSock, 1, port);
                this.dispatchWorkManager.schedule(this.mSock);
            }
        }
        catch (IOException e) {
            if (this.mSock != null) {
                this.mSock.close();
            }
            if (this.dgmSock != null) {
                this.dgmSock.close();
            }
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logCannotOpenMulticastSocketLoggable(e));
        }
        return multicastAddress;
    }

    @Override
    public final synchronized MessageProducer createProducer(Destination destination) throws JMSException {
        return this.createProducer(destination, (byte)0);
    }

    synchronized JMSProducer setupJMSProducer(Destination destination, byte flags) throws JMSException {
        this.checkClosed();
        weblogic.jms.common.Destination.checkDestinationType(destination, flags);
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEProducerCreateRequest(this.sessionId, (DestinationImpl)destination));
        JMSID producerId = ((FEProducerCreateResponse)response).getProducerId();
        JMSProducer producer = new JMSProducer(this, producerId, (DestinationImpl)destination, ((FEProducerCreateResponse)response).getRuntimeMBeanName());
        if (this.unitOfOrder != null) {
            producer.setUnitOfOrder(this.unitOfOrder);
        }
        producer.setDestinationFlags(flags);
        this.producerAdd(producer);
        return producer;
    }

    private MessageProducer createProducer(Destination destination, byte flags) throws JMSException {
        JMSProducer jmsProd = this.setupJMSProducer(destination, flags);
        WLProducerImpl recProd = new WLProducerImpl(jmsProd, this.wlSessionImpl);
        jmsProd.setWlProducerImpl(recProd);
        return recProd;
    }

    @Override
    public final TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedQueueOperation3Loggable().getMessage());
        }
        return (TemporaryQueue)this.createTemporaryDestination(4);
    }

    @Override
    public final synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.exceptionContext = new JMSExceptionContext(exceptionListener, this.connection.isInbound());
    }

    public final synchronized JMSExceptionContext getJMSExceptionContext() {
        return this.exceptionContext;
    }

    public final synchronized ExceptionListener getExceptionListener() {
        if (this.exceptionContext != null) {
            return this.exceptionContext.getExceptionListener();
        }
        return null;
    }

    public final void onException(JMSException exception) {
        this.onExceptionInternal(exception, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onExceptionInternal(JMSException exception, boolean deferIfInUse) {
        JMSContext savedExceptionContext;
        block8: {
            boolean bl;
            block6: {
                block7: {
                    savedExceptionContext = null;
                    if (this.exceptionContext == null) break block6;
                    savedExceptionContext = JMSContext.push(this.exceptionContext);
                    if (!deferIfInUse) break block7;
                    boolean bl2 = this.exceptionContext.invokeListenerIfItIsIdle(exception);
                    if (savedExceptionContext == null) return bl2;
                    JMSContext.pop(savedExceptionContext);
                    return bl2;
                }
                this.exceptionContext.blockTillIdleThenRunExclusively(exception);
                boolean bl3 = false;
                if (savedExceptionContext == null) return bl3;
                JMSContext.pop(savedExceptionContext);
                return bl3;
            }
            try {
                JMSExceptionContext exceptionContext;
                if (!(exception instanceof weblogic.jms.common.JMSException) || ((weblogic.jms.common.JMSException)exception).isInformational() || (exceptionContext = this.getConnection().getJMSExceptionContext()) == null) break block8;
                bl = JMSConnection.onExceptionInternal(exception, exceptionContext, deferIfInUse);
                if (savedExceptionContext == null) return bl;
            }
            catch (Throwable e) {
                try {
                    JMSClientExceptionLogger.logStackTrace(e);
                    if (savedExceptionContext == null) return false;
                }
                catch (Throwable throwable) {
                    if (savedExceptionContext == null) throw throwable;
                    JMSContext.pop(savedExceptionContext);
                    throw throwable;
                }
                JMSContext.pop(savedExceptionContext);
                return false;
            }
            JMSContext.pop(savedExceptionContext);
            return bl;
        }
        if (savedExceptionContext == null) return false;
        JMSContext.pop(savedExceptionContext);
        return false;
    }

    private FEConsumerCreateResponse consumerCreate(String subscriptionName, boolean isDurable, boolean isJMS2Share, DestinationImpl destination, String messageSelector, boolean noLocal, int messagesMaximum, ConsumerReconnectInfo consumerReconnectInfo) throws JMSException {
        Response response;
        PeerInfo pi;
        if (!(destination.getType() != 4 && destination.getType() != 8 || destination.getConnection() != null && this.connection.getJMSID().equals(destination.getConnection().getJMSID()))) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logInvalidConnectionLoggable().getMessage());
        }
        if (isJMS2Share && (!isDurable || this.clientID == null) && (pi = this.getFEPeerInfo()).compareTo(PeerInfo.VERSION_1221) < 0) {
            if (isDurable) {
                throw new JMSException("Unsupported operation to front-end server version [" + pi + "]: create shared durable subscription with name " + subscriptionName + " and null client id");
            }
            throw new JMSException("Unsupported operation to front-end server version [" + pi + "]: create shared nondurable subscription with name " + subscriptionName);
        }
        if (subscriptionName != null && isDurable && !isJMS2Share && this.getConnection().getClientIDPolicyInt() == 0 && this.subscriptionSharingPolicy == 0 && !this.connection.markDurableSubscriber(subscriptionName)) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logSubscriptionNameInUseLoggable(subscriptionName));
        }
        try {
            response = this.connection.getFrontEndDispatcher().dispatchSync(new FEConsumerCreateRequest(this.sessionId, this.clientID, subscriptionName, isDurable, destination, messageSelector, noLocal, messagesMaximum, this.getRedeliveryDelay(), consumerReconnectInfo, isJMS2Share ? 1 : this.subscriptionSharingPolicy));
        }
        catch (JMSException jmse) {
            if (subscriptionName != null && isDurable && !isJMS2Share) {
                this.connection.removeDurableSubscriber(subscriptionName);
            }
            throw jmse;
        }
        if (!(response instanceof FEConsumerCreateResponse)) {
            if (subscriptionName != null && isDurable && !isJMS2Share) {
                this.connection.removeDurableSubscriber(subscriptionName);
            }
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidFrontEndResponseLoggable(response));
        }
        if (subscriptionName != null && isDurable && this.getConnection().getClientIDPolicyInt() == 0) {
            this.connection.addDurableSubscriber(subscriptionName, ((FEConsumerCreateResponse)response).getConsumerId());
        }
        return (FEConsumerCreateResponse)response;
    }

    private synchronized void consumerAdd(JMSConsumer consumer) {
        this.consumers.put(consumer.getJMSID(), consumer);
        try {
            InvocableManagerDelegate delegate = this.connection.clientDispatcherPartitionContext.getInvocableManagerDelegate();
            delegate.invocableAdd(6, consumer);
        }
        catch (Exception e) {
            JMSClientExceptionLogger.logStackTrace(e);
        }
    }

    @Override
    public int consumersCount() {
        return this.consumers.size();
    }

    @Override
    public int producersCount() {
        return this.producers.size();
    }

    final synchronized void consumerClose(ConsumerInternal consumer) throws JMSException {
        this.consumerClose(consumer, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void consumerClose(ConsumerInternal consumer, long sequenceNumber) throws JMSException {
        JMSID consumerId;
        if (sequenceNumber != -1L) {
            this.setRealLastSequenceNumber(sequenceNumber);
        }
        Object object = this.synchronousListenerObject;
        synchronized (object) {
            this.synchronousListenerObject.notifyAll();
        }
        if (!this.inListener()) {
            this.waitForState(-5);
        }
        object = consumer;
        synchronized (object) {
            if (consumer.isClosed()) {
                return;
            }
            consumerId = this.consumerCloseLocal(consumer, true);
        }
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEConsumerCloseRequest(consumerId, this.getLastSequenceNumber(), this.getFirstSequenceNumberNotSeen()));
        this.waitForOutstandingReceives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSID consumerCloseLocal(ConsumerInternal consumer, boolean fromJMSConsumer) throws JMSException {
        JMSID consumerId;
        ConsumerInternal consumerInternal = consumer;
        synchronized (consumerInternal) {
            this.consumerRemove(consumer, fromJMSConsumer);
            consumerId = consumer.getJMSID();
            consumer.setClosed(true);
            if (fromJMSConsumer && this.acknowledgeMode == 128) {
                this.leaveGroup((DestinationImpl)consumer.getDestination(), consumer);
            }
        }
        return consumerId;
    }

    private synchronized ConsumerInternal consumerFind(JMSID consumerId) {
        return (ConsumerInternal)this.consumers.get(consumerId);
    }

    private synchronized void consumerRemove(ConsumerInternal consumer, boolean fromJMSConsumer) {
        if (fromJMSConsumer) {
            this.consumers.remove(consumer.getJMSID());
        }
        try {
            InvocableManagerDelegate delegate = this.connection.clientDispatcherPartitionContext.getInvocableManagerDelegate();
            delegate.invocableRemove(6, consumer.getJMSID());
        }
        catch (JMSException e) {
            JMSClientExceptionLogger.logStackTrace(e);
        }
    }

    private synchronized void producerAdd(JMSProducer producer) {
        this.producers.put(producer.getJMSID(), producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void producerClose(JMSID producerId) throws JMSException {
        this.checkClosed();
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            this.producers.remove(producerId);
        }
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEProducerCloseRequest(producerId));
    }

    static final JMSException handleException(Exception e) throws JMSException {
        if (e instanceof JMSException) {
            throw (JMSException)e;
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logSystemErrorLoggable(e), (Throwable)e);
    }

    private Destination createDestination(String destinationName, int destinationType) throws JMSException {
        this.checkClosed();
        Response response = this.connection.getFrontEndDispatcher().dispatchSyncNoTran(new FEDestinationCreateRequest(destinationName, destinationType, false));
        return ((JMSDestinationCreateResponse)response).getDestination();
    }

    final JMSID createBackEndBrowser(DestinationImpl destination, String messageSelector) throws JMSException {
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FEBrowserCreateRequest(this.connection.getJMSID(), this.sessionId, destination, messageSelector));
        return ((JMSBrowserCreateResponse)response).getBrowserId();
    }

    private synchronized Destination createTemporaryDestination(int destinationType) throws JMSException {
        this.checkClosed();
        Response response = this.connection.getFrontEndDispatcher().dispatchSync(new FETemporaryDestinationCreateRequest(this.connection.getJMSID(), destinationType, true));
        ((FETemporaryDestinationCreateResponse)response).getDestination().setConnection(this.connection);
        return ((FETemporaryDestinationCreateResponse)response).getDestination();
    }

    private void subscriptionRemove(String name) throws JMSException {
        if (!this.connection.markDurableSubscriber(name)) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logSubscriptionNameInUse2Loggable(name));
        }
        try {
            this.connection.consumerRemove(name);
        }
        finally {
            this.connection.removeDurableSubscriber(name);
        }
    }

    private void subscriptionRemove(DestinationImpl topic, String name) throws JMSException {
        if (this.getConnection().getClientIDPolicyInt() == 0) {
            this.subscriptionRemove(name);
            return;
        }
        this.connection.consumerRemove(topic, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pushMessage(MessageImpl message, JMSPushEntry pushEntry) {
        JMSException runOnExceptionOutsideOfLock;
        JMSPushRequest pushRequest = new JMSPushRequest(0, this.sessionId, message, pushEntry);
        Object object = this.lockObject;
        synchronized (object) {
            runOnExceptionOutsideOfLock = this.addSelfSequencePushRequest(pushRequest);
        }
        if (runOnExceptionOutsideOfLock != null) {
            this.onException(runOnExceptionOutsideOfLock);
        }
    }

    public final JMSPushRequest getFirstPushRequest() {
        return this.firstPushRequest;
    }

    private void setFirstPushRequest(JMSPushRequest arg) {
        this.firstPushRequest = arg;
    }

    private final JMSException addSelfSequencePushRequest(JMSPushRequest pushRequest) {
        DataOverrunException exceptionOutsideOfLock = null;
        if (this.acknowledgeMode == 128) {
            if (this.messagesMaximum != -1 && this.pushRequestCount >= this.messagesMaximum) {
                if (this.overrunPolicy == 0) {
                    return new DataOverrunException(JMSClientExceptionLogger.logDropNewerLoggable().getMessage(), pushRequest.getMessage().getJMSMessageID(), pushRequest.getMessage().getJMSCorrelationID(), pushRequest.getMessage().getJMSDestination());
                }
                exceptionOutsideOfLock = new DataOverrunException(JMSClientExceptionLogger.logDropOlderLoggable().getMessage(), this.firstPushRequest.getMessage().getJMSMessageID(), this.firstPushRequest.getMessage().getJMSCorrelationID(), this.firstPushRequest.getMessage().getJMSDestination());
                this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                --this.pushRequestCount;
            }
            ++this.pushRequestCount;
        }
        if (this.firstPushRequest == null) {
            this.setFirstPushRequest(pushRequest);
        } else {
            this.lastPushRequest.setNext(pushRequest);
        }
        this.lastPushRequest = pushRequest;
        return exceptionOutsideOfLock;
    }

    private final void addPushRequests(JMSPushRequest myPushRequest, boolean forReceive) {
        Request firstPushRequest = myPushRequest;
        Request prevPushRequest = null;
        Request currentPush = firstPushRequest;
        this.session_clientResponsibleForAck |= ((JMSPushRequest)firstPushRequest).getFirstPushEntry().getClientResponsibleForAcknowledge();
        if (!this.connectionOlderThan90) {
            for (JMSPushRequest current = firstPushRequest; current != null; current = (JMSPushRequest)current.getNext()) {
                if (forReceive || !this.connection.isLocal() || current.getFirstPushEntry().getPipelineGeneration() != 0 || !this.recoversFor90HasBeenCalled) continue;
                current.getFirstPushEntry().setPipelineGeneration(0x100000);
            }
        }
        while (!forReceive && currentPush != null && ((JMSPushRequest)currentPush).getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
            JMSPushEntry prevClientAckPushEntry = null;
            for (JMSPushEntry pushEntry = ((JMSPushRequest)currentPush).getFirstPushEntry(); pushEntry != null; pushEntry = pushEntry.getNext()) {
                if (!pushEntry.getClientResponsibleForAcknowledge()) continue;
                if (prevClientAckPushEntry == null) {
                    ((JMSPushRequest)currentPush).setFirstPushEntry(pushEntry);
                } else {
                    prevClientAckPushEntry.setNext(pushEntry);
                }
                prevClientAckPushEntry = pushEntry;
            }
            if (prevClientAckPushEntry == null) {
                if (firstPushRequest == currentPush) {
                    firstPushRequest = (JMSPushRequest)currentPush.getNext();
                }
                currentPush = (JMSPushRequest)currentPush.getNext();
                continue;
            }
            prevClientAckPushEntry.setNext(null);
            ((JMSPushRequest)currentPush).setLastPushEntry(prevClientAckPushEntry);
            if (prevPushRequest == null) {
                firstPushRequest = currentPush;
            } else {
                prevPushRequest.setNext(currentPush);
            }
            prevPushRequest = currentPush;
            currentPush = (JMSPushRequest)currentPush.getNext();
        }
        if (firstPushRequest == null) {
            return;
        }
        if (prevPushRequest != null) {
            prevPushRequest.setNext(currentPush);
            currentPush = prevPushRequest;
        }
        while (currentPush != null) {
            for (JMSPushEntry pushEntry = ((JMSPushRequest)currentPush).getFirstPushEntry(); pushEntry != null; pushEntry = pushEntry.getNext()) {
                int pushEntryPipelineGeneration = pushEntry.getPipelineGeneration();
                if (pushEntryPipelineGeneration == this.pipelineGeneration || pushEntryPipelineGeneration == 0 || pushEntry.getClientResponsibleForAcknowledge()) continue;
                if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                    JMSDebug.JMSMessagePath.debug("ignore stale pipelineGeneration " + JMSPushEntry.displayRecoverGeneration(pushEntryPipelineGeneration) + " when expecting " + JMSPushEntry.displayRecoverGeneration(this.pipelineGeneration));
                }
                pushEntry.setPipelineGeneration(0x100000);
            }
            if (currentPush.getNext() == null) break;
            currentPush = (JMSPushRequest)currentPush.getNext();
        }
        JMSPushRequest lastPushRequest = currentPush;
        if (forReceive) {
            if (this.firstReceivePushRequest == null) {
                this.firstReceivePushRequest = firstPushRequest;
                this.lastReceivePushRequest = lastPushRequest;
                return;
            }
        } else if (this.firstPushRequest == null) {
            this.setFirstPushRequest((JMSPushRequest)firstPushRequest);
            this.lastPushRequest = lastPushRequest;
            return;
        }
        if (forReceive) {
            if (lastPushRequest.getFrontEndSequenceNumber() < this.firstReceivePushRequest.getFrontEndSequenceNumber()) {
                lastPushRequest.setNext(this.firstReceivePushRequest);
                this.firstReceivePushRequest = firstPushRequest;
                return;
            }
        } else if (lastPushRequest.getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
            lastPushRequest.setNext(this.firstPushRequest);
            this.firstPushRequest = firstPushRequest;
            return;
        }
        if (forReceive) {
            if (((JMSPushRequest)firstPushRequest).getFrontEndSequenceNumber() > this.lastReceivePushRequest.getFrontEndSequenceNumber()) {
                this.lastReceivePushRequest.setNext(firstPushRequest);
                this.lastReceivePushRequest = lastPushRequest;
                return;
            }
        } else if (((JMSPushRequest)firstPushRequest).getFrontEndSequenceNumber() > this.lastPushRequest.getFrontEndSequenceNumber()) {
            this.lastPushRequest.setNext(firstPushRequest);
            this.lastPushRequest = lastPushRequest;
            return;
        }
        JMSPushRequest pushRequest = forReceive ? this.firstReceivePushRequest : this.firstPushRequest;
        while (pushRequest.getNext() != null) {
            if (forReceive && ((JMSPushRequest)firstPushRequest).getFrontEndSequenceNumber() == ((JMSPushRequest)pushRequest.getNext()).getFrontEndSequenceNumber()) {
                return;
            }
            if (lastPushRequest.getFrontEndSequenceNumber() < ((JMSPushRequest)pushRequest.getNext()).getFrontEndSequenceNumber() && pushRequest.getFrontEndSequenceNumber() < ((JMSPushRequest)firstPushRequest).getFrontEndSequenceNumber()) {
                lastPushRequest.setNext(pushRequest.getNext());
                pushRequest.setNext(firstPushRequest);
                return;
            }
            pushRequest = (JMSPushRequest)pushRequest.getNext();
        }
    }

    private final JMSPushRequest removePushRequests() {
        JMSPushRequest pushRequest = this.firstPushRequest;
        if (pushRequest == null) {
            return null;
        }
        if (this.acknowledgeMode == 128) {
            this.lastPushRequest = null;
            this.setFirstPushRequest(null);
            this.pushRequestCount = 0;
            return pushRequest;
        }
        if (this.expectedSequenceNumber < pushRequest.getFrontEndSequenceNumber()) {
            return null;
        }
        JMSPushRequest prevPushRequest = null;
        while (this.firstPushRequest != null && this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
            prevPushRequest = this.firstPushRequest;
            this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
        }
        if (this.firstPushRequest == null) {
            this.lastPushRequest = null;
            return pushRequest;
        }
        assert (this.firstPushRequest.getFrontEndSequenceNumber() >= this.expectedSequenceNumber == this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() >= this.expectedSequenceNumber);
        if (this.expectedSequenceNumber < this.firstPushRequest.getFrontEndSequenceNumber()) {
            if (prevPushRequest != null) {
                prevPushRequest.setNext(null);
            }
            return pushRequest;
        }
        do {
            this.expectedSequenceNumber = this.firstPushRequest.getLastPushEntry().getFrontEndSequenceNumber() + 1L;
            prevPushRequest = this.firstPushRequest;
            this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
        } while (this.firstPushRequest != null && this.firstPushRequest.getFrontEndSequenceNumber() < this.expectedSequenceNumber);
        if (this.firstPushRequest == null) {
            this.lastPushRequest = null;
        } else {
            prevPushRequest.setNext(null);
        }
        return pushRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setExpectedSequenceNumber81(long sequenceNumber, boolean force) {
        Object object = this.lockObject;
        synchronized (object) {
            JMSPushRequest pushRequest = this.firstPushRequest;
            JMSPushRequest prevPushRequest = null;
            if (force || sequenceNumber > this.expectedSequenceNumber) {
                this.expectedSequenceNumber = sequenceNumber;
            }
            if (force || pushRequest == null) {
                return;
            }
            while (pushRequest != null && pushRequest.getFrontEndSequenceNumber() < this.expectedSequenceNumber) {
                boolean doRemove = true;
                JMSPushEntry prevPushEntry = null;
                for (JMSPushEntry pushEntry = pushRequest.getFirstPushEntry(); pushEntry != null; pushEntry = pushEntry.getNext()) {
                    if (pushEntry.getClientResponsibleForAcknowledge()) {
                        doRemove = false;
                    } else if (prevPushEntry == null) {
                        pushRequest.removePushEntry();
                    } else {
                        prevPushEntry.setNext(pushEntry.getNext());
                    }
                    prevPushEntry = pushEntry;
                }
                if (doRemove) {
                    if (prevPushRequest == null) {
                        this.setFirstPushRequest((JMSPushRequest)pushRequest.getNext());
                        if (this.firstPushRequest == null) {
                            this.lastPushRequest = null;
                            return;
                        }
                    } else {
                        prevPushRequest.setNext(pushRequest.getNext());
                    }
                } else {
                    prevPushRequest = pushRequest;
                }
                pushRequest = (JMSPushRequest)pushRequest.getNext();
            }
        }
    }

    private final boolean havePushRequests() {
        if (this.firstPushRequest == null) {
            return false;
        }
        if (this.acknowledgeMode == 128) {
            return true;
        }
        return this.firstPushRequest.getFrontEndSequenceNumber() <= this.expectedSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void pushMessage(Request invocableRequest, boolean forReceive) {
        JMSException runOnExceptionOutsideOfLock;
        block13: {
            JMSPushRequest pushRequest = (JMSPushRequest)invocableRequest;
            runOnExceptionOutsideOfLock = null;
            try {
                Object object = this.lockObject;
                // MONITORENTER : object
                if (this.acknowledgeMode == 128) {
                    runOnExceptionOutsideOfLock = this.addSelfSequencePushRequest(pushRequest);
                } else {
                    this.addPushRequests(pushRequest, forReceive);
                    if (!forReceive && this.synchronousListener) {
                        this.adjustHighMark();
                    }
                }
                if (this.running || this.stopped || this.synchronousListener) {
                    // MONITOREXIT : object
                    if (runOnExceptionOutsideOfLock == null) return;
                    this.onException(runOnExceptionOutsideOfLock);
                    return;
                }
                if (this.havePushRequests()) break block13;
            }
            catch (Throwable throwable) {
                if (runOnExceptionOutsideOfLock == null) throw throwable;
                this.onException(runOnExceptionOutsideOfLock);
                throw throwable;
            }
            if (runOnExceptionOutsideOfLock == null) return;
            this.onException(runOnExceptionOutsideOfLock);
            return;
        }
        this.running = true;
        // MONITOREXIT : object
        if (runOnExceptionOutsideOfLock != null) {
            this.onException(runOnExceptionOutsideOfLock);
        }
        Thread t = Thread.currentThread();
        boolean sched = JMSWorkManager.isThinclient() ? true : (this.ignoreJmsAsyncQueue && !this.connection.isLocal() ? false : (this.connection.isLocal() && this.dispatchWorkManager.getType() == 2 ? true : !this.dispatchWorkManager.isThreadOwner(t)));
        if (sched) {
            this.dispatchWorkManager.schedule(this.useForRunnable);
            return;
        }
        this.executeMessage();
    }

    private void executeMessage() {
        if (this.mmListener == null) {
            this.execute();
            return;
        }
        this.executeMM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustHighMark() {
        boolean firstNewMessage = true;
        if (this.firstPushRequest == null || this.highMark < this.firstPushRequest.getFrontEndSequenceNumber()) {
            return;
        }
        JMSPushRequest prevPushRequest = null;
        JMSPushRequest pushRequest = this.firstPushRequest;
        while (pushRequest.getFrontEndSequenceNumber() <= this.highMark) {
            if (pushRequest.getFrontEndSequenceNumber() == this.highMark) {
                ++this.highMark;
                if (firstNewMessage && pushRequest.getFirstPushEntry().getPipelineGeneration() != 0x100000) {
                    Object object = this.synchronousListenerObject;
                    synchronized (object) {
                        if (this.waitForNewMessage) {
                            if (this.notifyNewMessage) {
                                if (prevPushRequest == null) {
                                    this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                                } else {
                                    prevPushRequest.setNext(pushRequest.getNext());
                                }
                                this.shortCutPrevPushRequest = prevPushRequest;
                                this.needToRemoveIt = false;
                            } else {
                                this.shortCutPrevPushRequest = prevPushRequest;
                                this.needToRemoveIt = true;
                            }
                            this.shortCutPushRequest = pushRequest;
                            this.waitForNewMessage = false;
                            this.synchronousListenerObject.notify();
                        }
                    }
                    firstNewMessage = false;
                }
            }
            prevPushRequest = pushRequest;
            if ((pushRequest = (JMSPushRequest)pushRequest.getNext()) != null) continue;
        }
        this.expectedSequenceNumber = this.highMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message getAsyncMessageForConsumer(ConsumerInternal consumer, long timeout, Class bodyClass) throws JMSException {
        JMSPushEntry pushEntry = null;
        MessageImpl message = null;
        boolean fromShortCut = false;
        long startTime = System.currentTimeMillis();
        long waitTime = timeout;
        JMSSession jMSSession = this;
        synchronized (jMSSession) {
            while (this.stopped) {
                if (this.isClosed() || timeout == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException ie) {
                    throw new weblogic.jms.common.JMSException(ie);
                }
                if (timeout == Long.MAX_VALUE) continue;
                long haveWaited = System.currentTimeMillis() - startTime;
                if (haveWaited >= timeout) {
                    return null;
                }
                waitTime = timeout - haveWaited;
                if (waitTime <= 0L) continue;
            }
        }
        MessageFormatException mfException = null;
        long lastSequenceNumberOnmfException = 0L;
        Object object = this.lockObject;
        synchronized (object) {
            boolean removeMsg = false;
            while (this.firstPushRequest != null && this.firstPushRequest.getFrontEndSequenceNumber() < this.highMark) {
                pushEntry = this.firstPushRequest.getFirstPushEntry();
                if (!pushEntry.getClientResponsibleForAcknowledge()) {
                    if (this.connection.isLocal()) {
                        removeMsg = true;
                        if (pushEntry.getPipelineGeneration() == 0) {
                            removeMsg = false;
                        } else if (pushEntry.getPipelineGeneration() == 0x100000) {
                            removeMsg = true;
                        } else if (pushEntry.getPipelineGeneration() == this.pipelineGeneration) {
                            removeMsg = false;
                        }
                    } else {
                        removeMsg = false;
                        if (pushEntry.getPipelineGeneration() == 0x100000 || pushEntry.getPipelineGeneration() != this.pipelineGeneration) {
                            removeMsg = true;
                        }
                    }
                    if (removeMsg) {
                        pushEntry = null;
                        this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                        continue;
                    }
                }
                if (!pushEntry.getConsumerId().equals(consumer.getId())) {
                    pushEntry = null;
                    this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                    continue;
                }
                message = this.firstPushRequest.getMessage();
                if (bodyClass != null) {
                    try {
                        if (message.getBody(bodyClass) == null) {
                            throw new MessageFormatException(JMSClientExceptionLogger.logNoMessageBodyLoggable().getMessage());
                        }
                    }
                    catch (MessageFormatException e) {
                        mfException = e;
                        lastSequenceNumberOnmfException = pushEntry.getFrontEndSequenceNumber();
                        break;
                    }
                }
                if (this.connection.isLocal()) {
                    message = message.copy();
                }
                this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                break;
            }
            if (mfException == null && pushEntry == null) {
                if (timeout != 0x7FFFFFFFFFFFFFFEL) {
                    this.waitForNewMessage = true;
                    this.notifyNewMessage = timeout == Long.MAX_VALUE;
                } else {
                    this.notifyNewMessage = false;
                    this.waitForNewMessage = false;
                }
            }
            this.shortCutPrevPushRequest = null;
            this.shortCutPushRequest = null;
        }
        if (mfException != null) {
            object = this;
            synchronized (object) {
                this.rememberFirstSequenceNumberNotSeen(lastSequenceNumberOnmfException);
            }
            throw mfException;
        }
        if (pushEntry == null && timeout != 0x7FFFFFFFFFFFFFFEL) {
            JMSPushRequest myPrevPushRequest;
            JMSPushRequest myPushRequest;
            boolean shouldRemoveFromPushRequest = false;
            Object object2 = this.synchronousListenerObject;
            synchronized (object2) {
                if (this.shortCutPushRequest == null) {
                    try {
                        this.synchronousListenerObject.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                myPushRequest = this.shortCutPushRequest;
                myPrevPushRequest = this.shortCutPrevPushRequest;
                this.shortCutPrevPushRequest = null;
                this.shortCutPushRequest = null;
                shouldRemoveFromPushRequest = this.needToRemoveIt;
                this.needToRemoveIt = false;
            }
            if (myPushRequest != null) {
                message = myPushRequest.getMessage();
                if (bodyClass != null) {
                    try {
                        if (message.getBody(bodyClass) == null) {
                            throw new MessageFormatException(JMSClientExceptionLogger.logNoMessageBodyLoggable().getMessage());
                        }
                    }
                    catch (MessageFormatException e) {
                        Object object3;
                        if (!shouldRemoveFromPushRequest) {
                            object3 = this.lockObject;
                            synchronized (object3) {
                                if (myPrevPushRequest == null) {
                                    this.setFirstPushRequest(myPushRequest);
                                } else {
                                    myPushRequest.setNext(myPrevPushRequest.getNext());
                                    myPrevPushRequest.setNext(myPushRequest);
                                }
                            }
                        }
                        object3 = this;
                        synchronized (object3) {
                            this.rememberFirstSequenceNumberNotSeen(myPushRequest.getFirstPushEntry().getFrontEndSequenceNumber());
                        }
                        throw e;
                    }
                }
                if (shouldRemoveFromPushRequest) {
                    object2 = this;
                    synchronized (object2) {
                        Object object4 = this.lockObject;
                        synchronized (object4) {
                            if (myPrevPushRequest == null) {
                                this.setFirstPushRequest((JMSPushRequest)this.firstPushRequest.getNext());
                            } else {
                                myPrevPushRequest.setNext(myPushRequest.getNext());
                            }
                        }
                    }
                }
                if (this.connection.isLocal()) {
                    message = message.copy();
                }
                pushEntry = myPushRequest.getFirstPushEntry();
            } else {
                object2 = this;
                synchronized (object2) {
                    if (this.isClosed()) {
                        throw new IllegalStateException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
                    }
                }
            }
        }
        if (pushEntry != null) {
            boolean clientResponsibleForAck = pushEntry.getClientResponsibleForAcknowledge();
            message.setJMSDestinationImpl((DestinationImpl)consumer.getDestination());
            message.setSequenceNumber(pushEntry.getFrontEndSequenceNumber());
            message.setDeliveryCount(pushEntry.getDeliveryCount());
            message.setClientResponsibleForAcknowledge(clientResponsibleForAck);
            JMSSession jMSSession2 = this;
            synchronized (jMSSession2) {
                this.rememberLastSequenceNumber(pushEntry.getFrontEndSequenceNumber(), message.getId());
            }
            if (this.acknowledgeMode == 2) {
                message.setSession(this);
                this.addUnackedMessage(consumer, message);
                consumer.decrementWindowCurrent(clientResponsibleForAck);
            } else if (this.acknowledgeMode == 1 || this.acknowledgeMode == 3) {
                this.addUnackedMessage(consumer, message);
                if (this.acknowledgeMode != 3 || !this.checkDelayAckForDupsOK(message) || --this.dupsOKAckCount <= 0) {
                    this.requireAckForDupsOK = false;
                    this.acknowledge(message, 1, false);
                    this.dupsOKAckCount = this.dupsOKAckCountDown;
                } else {
                    this.requireAckForDupsOK = true;
                }
                consumer.decrementWindowCurrent(clientResponsibleForAck);
            } else {
                consumer.decrementWindowCurrent(clientResponsibleForAck);
            }
            return message;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void execute() {
        inlineOnMessageException = null;
        subjectPushed = false;
        lastListenerSubject = null;
        lastListenerClassLoader = null;
        lastListenerContext = null;
        clSave = null;
        if (!KernelStatus.isServer()) ** GOTO lbl-1000
        lastListenerClassLoader = clSave = Thread.currentThread().getContextClassLoader();
lbl-1000:
        // 2 sources

        {
            while (true) {
                if (inlineOnMessageException != null) {
                    jmse = inlineOnMessageException;
                    inlineOnMessageException = null;
                    this.onException((JMSException)jmse);
                }
                jmse = this;
                synchronized (jmse) {
                    if (this.deferredException != null) {
                        inlineOnMessageException = this.deferredException;
                        this.deferredException = null;
                        continue;
                    }
                    var12_13 = this.lockObject;
                    synchronized (var12_13) {
                        if (this.stopped || this.closeStarted || this.isClosed()) {
                            this.running = false;
                            return;
                        }
                        pushRequest = this.removePushRequests();
                        if (!this.connectionOlderThan90 && pushRequest != null && (pushEntryGen = pushRequest.getFirstPushEntry().getPipelineGeneration()) != this.pipelineGeneration && pushEntryGen != 0x200000 && pushEntryGen != 0) {
                            pushRequest = (JMSPushRequest)pushRequest.getNext();
                            this.assignClientAckCarryForward(pushRequest);
                            continue;
                        }
                        this.assignClientAckCarryForward(pushRequest);
                        if (pushRequest == null) {
                            this.running = false;
                            // MONITOREXIT @DISABLED, blocks:[4, 85, 29, 61, 30] lbl38 : MonitorExitStatement: MONITOREXIT : var12_13
                            // MONITOREXIT @DISABLED, blocks:[4, 85, 29, 61] lbl39 : MonitorExitStatement: MONITOREXIT : jmse
                            try {
                                this.inlineHandleOnMessageException();
                                return;
                            }
                            finally {
                                if (KernelStatus.isServer()) {
                                    Thread.currentThread().setContextClassLoader(clSave);
                                    if (lastListenerContext != null) {
                                        JMSEnvironment.getJMSEnvironment().popLocalJNDIContext();
                                    }
                                    if (lastListenerSubject != null || subjectPushed) {
                                        this.subjectManager.popSubject(JMSSession.KERNEL_ID);
                                    }
                                }
                            }
                        }
                    }
                    this.setState(4);
                }
                abnormalStop = false;
                try {
                    do {
                        message = pushRequest.getMessage();
                        if (this.connection.isLocal()) {
                            message = message.copy();
                        }
                        message.setDDForwarded(false);
                        pushEntry = pushRequest.removePushEntry();
                        while (pushEntry != null && pushRequest != null && !abnormalStop) {
                            consumer = this.consumerFind(pushEntry.getConsumerId());
                            clientResponsibleForAck = pushEntry.getClientResponsibleForAcknowledge();
                            if (consumer == null || consumer.isClosed()) {
                                var17_21 = this;
                                synchronized (var17_21) {
                                    if (abnormalStop |= this.stopped != false || this.closeStarted != false) {
                                        var18_22 = this.lockObject;
                                        synchronized (var18_22) {
                                            pushEntry.setNext(pushRequest.getFirstPushEntry());
                                            pushRequest.setFirstPushEntry(pushEntry);
                                            for (tmp = pushEntry; tmp != null; tmp = tmp.getNext()) {
                                                pushRequest.setLastPushEntry(tmp);
                                            }
                                            break;
                                        }
                                    }
                                }
                            } else if (clientResponsibleForAck || !(this.pipelineGeneration != 0 ? pushEntry.getPipelineGeneration() == 0x100000 : pushEntry.getFrontEndSequenceNumber() < consumer.getExpectedSequenceNumber() && clientResponsibleForAck == false)) {
                                listener = consumer.getMessageListener();
                                if (listener != null) {
                                    message.setJMSDestinationImpl((DestinationImpl)consumer.getDestination());
                                    messageCopy = pushEntry.getNext() == null ? message : message.copy();
                                    messageCopy.setSequenceNumber(pushEntry.getFrontEndSequenceNumber());
                                    messageCopy.setDeliveryCount(pushEntry.getDeliveryCount());
                                    messageCopy.setClientResponsibleForAcknowledge(clientResponsibleForAck);
                                    this.addUnackedMessage(consumer, messageCopy);
                                    consumerContext = consumer.getMessageListenerContext();
                                    listenerContext = consumerContext.getJNDIContext();
                                    listenerClassLoader = consumerContext.getClassLoader();
                                    if (!this.connection.isInbound()) {
                                        listenerSubject = consumerContext.getSubject();
                                        if (listenerSubject != lastListenerSubject) {
                                            if (lastListenerSubject != null) {
                                                this.subjectManager.popSubject(JMSSession.KERNEL_ID);
                                            }
                                            this.subjectManager.pushSubject(JMSSession.KERNEL_ID, listenerSubject);
                                            lastListenerSubject = listenerSubject;
                                        }
                                    } else if (!subjectPushed) {
                                        this.subjectManager.pushSubject(JMSSession.KERNEL_ID, this.subjectManager.getAnonymousSubject());
                                        subjectPushed = true;
                                    }
                                    if (KernelStatus.isServer()) {
                                        if (listenerContext != lastListenerContext) {
                                            if (lastListenerContext != null) {
                                                JMSEnvironment.getJMSEnvironment().popLocalJNDIContext();
                                            }
                                            JMSEnvironment.getJMSEnvironment().pushLocalJNDIContext(listenerContext);
                                            lastListenerContext = listenerContext;
                                        }
                                        if (listenerClassLoader != lastListenerClassLoader) {
                                            Thread.currentThread().setContextClassLoader(listenerClassLoader);
                                            lastListenerClassLoader = listenerClassLoader;
                                        }
                                    }
                                    try {
                                        mic /* !! */  = JMSCICHelper.pushJMSCIC(consumerContext.getComponentInvocationContext());
                                        var20_25 = null;
                                        try {
                                            this.decrementWindow = true;
                                            this.recoverableClientAckMessages = pushRequest;
                                            this.onMessage(consumer, (MessageListener)listener, messageCopy);
                                        }
                                        catch (Throwable var21_27) {
                                            var20_25 = var21_27;
                                            throw var21_27;
                                        }
                                        finally {
                                            if (mic /* !! */  != null) {
                                                if (var20_25 != null) {
                                                    try {
                                                        mic /* !! */ .close();
                                                    }
                                                    catch (Throwable var21_26) {
                                                        var20_25.addSuppressed(var21_26);
                                                    }
                                                } else {
                                                    mic /* !! */ .close();
                                                }
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        JMSClientExceptionLogger.logStackTrace(e);
                                    }
                                    finally {
                                        this.recoverableClientAckMessages = null;
                                        if (this.recovering) {
                                            mic /* !! */  = this;
                                            synchronized (mic /* !! */ ) {
                                                var20_25 = this.lockObject;
                                                synchronized (var20_25) {
                                                    if (this.recovering) {
                                                        this.recovering = false;
                                                        this.carryForwardOnReconnect = null;
                                                        pushRequest = null;
                                                    }
                                                }
                                            }
                                        }
                                        if (this.decrementWindow) {
                                            consumer.decrementWindowCurrent(clientResponsibleForAck);
                                        }
                                    }
                                }
                            }
                            pushEntry = pushRequest == null ? null : pushRequest.removePushEntry();
                        }
                        if (pushRequest == null) continue;
                        pushRequest = (JMSPushRequest)pushRequest.getNext();
                    } while (pushRequest != null);
                }
                catch (Throwable ignore) {
                    JMSClientExceptionLogger.logStackTrace(ignore);
                }
                finally {
                    listener = this;
                    synchronized (listener) {
                        this.clearState(4);
                        if (!(this.stopped || this.closeStarted || this.isClosed())) {
                        }
                        this.running = false;
                        return;
                    }
                }
                ignore = this.lockObject;
                synchronized (ignore) {
                    if (!this.havePushRequests()) {
                        this.running = false;
                        return;
                    }
                    ** if (!this.dispatchWorkManager.scheduleIfBusy((Runnable)this.useForRunnable)) goto lbl170
                }
lbl169:
                // 1 sources

                return;
lbl170:
                // 1 sources

                if (this.integrationManager == null) continue;
                correlation = this.integrationManager.newCorrelation();
                this.integrationManager.activateCorrelation(correlation);
            }
        }
    }

    private static DiagnosticIntegrationManager getDiagnosticIntegrationManager() {
        try {
            return (DiagnosticIntegrationManager)SecurityServiceManager.runAs(kernelId, kernelId, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return DiagnosticIntegrationManager.Factory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected final void executeMM() {
        pushRequest = null;
        firstMessageWrapper = null;
        lastMessageWrapper = null;
        pipelineGenerationSnapShot = 0;
        stateInListener = false;
        block66: while (true) {
            var6_8 = this;
            // MONITORENTER : var6_8
            if (this.stopped) {
                // MONITOREXIT : var6_8
                try {
                    if (lastMessageWrapper == null) {
                    }
                    var7_9 = this;
                    // MONITORENTER : var7_9
                    this.rememberLastSequenceNumber(lastMessageWrapper.getSequence(), lastMessageWrapper.getMessageImpl().getId());
                    // MONITOREXIT : var7_9
                    this.mmListener.onMessages(firstMessageWrapper, this.messagesMaximum);
                }
                finally {
                    var7_9 = this;
                }
            }
            var7_9 = this.lockObject;
            // MONITORENTER : var7_9
            pipelineGenerationSnapShot = this.pipelineGeneration;
            pushRequest = this.removePushRequests();
            if (pushRequest == null) {
                // MONITOREXIT : var7_9
                // MONITOREXIT : var6_8
                try {
                    if (lastMessageWrapper == null) {
                    }
                    var8_14 = this;
                    // MONITORENTER : var8_14
                    this.rememberLastSequenceNumber(lastMessageWrapper.getSequence(), lastMessageWrapper.getMessageImpl().getId());
                    // MONITOREXIT : var8_14
                    this.mmListener.onMessages(firstMessageWrapper, this.messagesMaximum);
                }
                finally {
                    var8_13 = this;
                }
            }
            if (!this.connectionOlderThan90 && (pushEntryGen = pushRequest.getFirstPushEntry().getPipelineGeneration()) != this.pipelineGeneration && pushEntryGen != 0x200000 && pushEntryGen != 0) {
                // MONITOREXIT : var7_9
                // MONITOREXIT : var6_8
                continue;
            }
            // MONITOREXIT : var7_9
            if (!stateInListener) {
                this.setState(4);
            }
            stateInListener = true;
            // MONITOREXIT : var6_8
            while (true) {
                if (pushRequest != null) ** break;
                continue block66;
                message = pushRequest.getMessage();
                message.setDDForwarded(false);
                message.setSAFSequenceName(null);
                message.setSAFSeqNumber(0L);
                pushEntry = pushRequest.removePushEntry();
                while (pushEntry != null) {
                    block81: {
                        if (!JMSSession.$assertionsDisabled && pushEntry.getClientResponsibleForAcknowledge()) {
                            throw new AssertionError();
                        }
                        consumer = this.consumerFind(pushEntry.getConsumerId());
                        if (consumer != null && !consumer.isClosed() && (this.pipelineGeneration != 0 || pushEntry.getFrontEndSequenceNumber() >= consumer.getExpectedSequenceNumber() && pushEntry.getPipelineGeneration() != 0x100000)) {
                            try {
                                if (consumer.getMessageListener() == null) {
                                }
                            }
                            catch (JMSException e) {}
                            break block81;
                            message.setJMSDestinationImpl((DestinationImpl)consumer.getDestination());
                            message.setClientResponsibleForAcknowledge(false);
                            message.setSequenceNumber(pushEntry.getFrontEndSequenceNumber());
                            this.addPendingWTMessage(consumer, pushEntry.getFrontEndSequenceNumber());
                            this.addUnackedMessage(consumer, message);
                            mr = new MessageWrapper(((JMSConsumer)consumer).getWLConsumerImpl().getProxyID(), this.connectionOlderThan90 != false ? this.proxyGenerationForOlderServer : pipelineGenerationSnapShot, pushEntry.getFrontEndSequenceNumber(), pushEntry.getDeliveryCount(), message);
                            if (lastMessageWrapper == null) {
                                firstMessageWrapper = mr;
                            } else {
                                lastMessageWrapper.next(mr);
                            }
                            lastMessageWrapper = mr;
                        }
                    }
                    pushEntry = pushRequest.removePushEntry();
                }
                pushRequest = (JMSPushRequest)pushRequest.getNext();
            }
            break;
        }
        catch (Throwable var31_27) {
            try {
                if (lastMessageWrapper == null) {
                }
                var32_1 = this;
                // MONITORENTER : var32_1
                this.rememberLastSequenceNumber(lastMessageWrapper.getSequence(), lastMessageWrapper.getMessageImpl().getId());
                // MONITOREXIT : var32_1
                this.mmListener.onMessages(firstMessageWrapper, this.messagesMaximum);
            }
            finally {
                var32_1 = this;
            }
        }
    }

    private void assignClientAckCarryForward(JMSPushRequest pushRequest) {
        this.carryForwardOnReconnect = pushRequest != null && pushRequest.getMessage().getClientResponsibleForAcknowledge() ? pushRequest : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessage(ConsumerInternal consumer, MessageListener messageListener, MessageImpl message) {
        block21: {
            if (!this.transacted && this.acknowledgeMode == 2) {
                message.setSession(this);
            }
            JMSSession jMSSession = this;
            synchronized (jMSSession) {
                this.rememberLastSequenceNumber(message.getSequenceNumber(), message.getId());
            }
            boolean clientResponsibleForAcknowledge = message.getClientResponsibleForAcknowledge();
            try {
                JMSWorkContextHelper.infectThread(message);
                message.setSerializeDestination(true);
                message.setForward(true);
                message.setSAFSequenceName(null);
                message.setSAFSeqNumber(0L);
                messageListener.onMessage(message);
            }
            catch (Throwable t) {
                this.handleOnMessageFailure(t);
                return;
            }
            finally {
                JMSWorkContextHelper.disinfectThread();
            }
            if (this.acknowledgeMode != 3 && this.acknowledgeMode != 1 || this.getLastSequenceNumber() == 0L || this.transacted) {
                return;
            }
            try {
                if (this.acknowledgeMode != 3 || !this.checkDelayAckForDupsOK(message) || --this.dupsOKAckCount <= 0) {
                    this.requireAckForDupsOK = false;
                    this.refreshedWithPendingWork = false;
                    if (this.isRemoteDomain) {
                        final MessageImpl ackInfo = message;
                        CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getFrontEndDispatcher(), null, false), new PrivilegedExceptionAction(){

                            public Object run() throws JMSException {
                                JMSSession.this.acknowledge(ackInfo);
                                return null;
                            }
                        });
                    } else {
                        this.acknowledge(message);
                    }
                    this.dupsOKAckCount = this.dupsOKAckCountDown;
                } else {
                    this.requireAckForDupsOK = true;
                }
            }
            catch (JMSException je) {
                if (!this.onExceptionInternal(je, true)) break block21;
                JMSSession jMSSession2 = this;
                synchronized (jMSSession2) {
                    if (this.deferredException == null) {
                        this.deferredException = je;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnMessageFailure(Throwable t) {
        block14: {
            JMSClientExceptionLogger.logStackTrace(t);
            try {
                if (this.transacted || this.acknowledgeMode != 1 && this.acknowledgeMode != 3) break block14;
                try {
                    if (this.isRemoteDomain) {
                        CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getFrontEndDispatcher(), null, false), (PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
                        break block14;
                    }
                    this.recover();
                }
                catch (JMSException recoverException) {
                    JMSClientExceptionLogger.logStackTrace(recoverException);
                }
            }
            finally {
                RuntimeException re1 = new RuntimeException(JMSClientExceptionLogger.logClientThrowingExceptionLoggable().getMessage(), t);
                weblogic.jms.common.JMSException jmse = new weblogic.jms.common.JMSException(re1);
                if (this.onExceptionInternal(jmse, true)) {
                    JMSSession jMSSession = this;
                    synchronized (jMSSession) {
                        if (this.deferredException == null) {
                            this.deferredException = jmse;
                        }
                    }
                }
            }
        }
    }

    final void decrementConsumerListenerCount() {
        --this.consumerListenerCount;
    }

    final void incrementConsumerListenerCount() {
        ++this.consumerListenerCount;
    }

    final void setState(int state) {
        this.state |= state;
        if ((state & 4) != 0) {
            this.listenerThread = Thread.currentThread();
        }
    }

    private boolean inState(int state) {
        return (this.state & state) != 0;
    }

    private boolean inListener() {
        return Thread.currentThread().equals(this.listenerThread);
    }

    final synchronized void clearState(int state) {
        this.state &= ~state;
        if ((state & 4) != 0) {
            this.listenerThread = null;
        }
        if (this.waiterCount > 0) {
            this.notifyAll();
        }
    }

    private void waitForState(int allowableStates) throws JMSException {
        while ((this.state & ~allowableStates) != 0) {
            ++this.waiterCount;
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new weblogic.jms.common.JMSException(ie);
            }
            finally {
                --this.waiterCount;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.sessionId == null;
    }

    boolean isRemoteDomain() {
        return this.isRemoteDomain;
    }

    @Override
    public boolean isReconnectControllerClosed() {
        return this.wlSessionImpl == null || this.wlSessionImpl.isClosed();
    }

    final synchronized void checkClosed() throws JMSException {
        if (this.isClosed()) {
            JMSSession lock;
            JMSSession jMSSession = lock = this.wlSessionImpl == null ? this : this.wlSessionImpl.getConnectionStateLock();
            synchronized (jMSSession) {
                if (this.isReconnectControllerClosed()) {
                    throw new AlreadyClosedException(JMSClientExceptionLogger.logSessionIsClosedLoggable());
                }
                throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
            }
        }
    }

    @Override
    public final void publicCheckClosed() throws JMSException {
        this.checkClosed();
    }

    @Override
    public final synchronized void checkSAFClosed() throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
    }

    private void leaveGroup(DestinationImpl destination, ConsumerInternal consumer) throws JMSException {
        try {
            this.mSock.leaveGroup(destination, consumer);
        }
        catch (IOException ne) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logCannotLeaveMulticastGroupLoggable(destination.getMulticastAddress(), ne));
        }
    }

    private synchronized void addUnackedMessage(ConsumerInternal consumer, MessageImpl message) {
        if (this.acknowledgeMode == 4 || this.acknowledgeMode == 128) {
            return;
        }
        if (!message.getClientResponsibleForAcknowledge()) {
            UnackedMessage unackedMessage = new UnackedMessage(consumer, message.getSequenceNumber());
            unackedMessage.next = this.firstUnackedMessage;
            this.firstUnackedMessage = unackedMessage;
            this.setPendingWorkOnMsgRecv();
        } else {
            JMSMessageReference mRef;
            if (this.clientAckList == null) {
                this.clientAckList = new MessageList();
            }
            long sequenceNumber = message.getSequenceNumber();
            if (this.mRefCache != null) {
                mRef = this.mRefCache;
                this.mRefCache = null;
                mRef.reset(message, consumer);
            } else {
                mRef = new JMSMessageReference(message, consumer);
            }
            message.setMessageReference(mRef);
            mRef.setSequenceNumber(sequenceNumber);
            this.clientAckList.addLast(mRef);
        }
    }

    private synchronized void addPendingWTMessage(ConsumerInternal consumer, long seq) {
        PendingWTMessage pendingWTMessage = new PendingWTMessage(consumer, seq);
        pendingWTMessage.next = this.firstPendingWTMessage;
        this.firstPendingWTMessage = pendingWTMessage;
    }

    public synchronized void removePendingWTMessage(long sequenceNumber, boolean adjustWindow) throws JMSException {
        PendingWTMessage savedPendingWTMessage = this.firstPendingWTMessage;
        PendingWTMessage prevPendingWTMessage = null;
        while (savedPendingWTMessage != null && sequenceNumber != savedPendingWTMessage.sequenceNumber) {
            prevPendingWTMessage = savedPendingWTMessage;
            savedPendingWTMessage = savedPendingWTMessage.next;
        }
        if (savedPendingWTMessage != null) {
            if (savedPendingWTMessage == this.firstPendingWTMessage) {
                this.firstPendingWTMessage = null;
            } else {
                prevPendingWTMessage.next = null;
            }
            while (savedPendingWTMessage != null) {
                ConsumerInternal messageConsumer = savedPendingWTMessage.consumer;
                if (adjustWindow) {
                    messageConsumer.decrementWindowCurrent(false);
                }
                savedPendingWTMessage = savedPendingWTMessage.next;
            }
        }
    }

    private synchronized void removeUnackedMessage(long sequenceNumber, boolean clientResponsibleForAcknowledge, boolean isMbean) {
        if (!clientResponsibleForAcknowledge) {
            UnackedMessage savedUnackedMessage = this.firstUnackedMessage;
            UnackedMessage prevUnackedMessage = null;
            while (savedUnackedMessage != null && sequenceNumber != savedUnackedMessage.sequenceNumber) {
                prevUnackedMessage = savedUnackedMessage;
                savedUnackedMessage = savedUnackedMessage.next;
            }
            if (savedUnackedMessage != null) {
                if (savedUnackedMessage == this.firstUnackedMessage) {
                    this.firstUnackedMessage = null;
                } else {
                    prevUnackedMessage.next = null;
                }
                while (savedUnackedMessage != null) {
                    ConsumerInternal messageConsumer = savedUnackedMessage.consumer;
                    if (!isMbean && messageConsumer.getWindowCurrent() < messageConsumer.getWindowMaximum()) {
                        messageConsumer.setWindowCurrent(messageConsumer.getWindowCurrent() + 1);
                    }
                    savedUnackedMessage = savedUnackedMessage.next;
                }
            }
            return;
        }
        if (this.clientAckList == null) {
            return;
        }
        JMSMessageReference mRef = (JMSMessageReference)this.clientAckList.removeBeforeSequenceNumber(sequenceNumber);
        if (this.mRefCache == null && mRef != null) {
            mRef.prepareForCache();
            this.mRefCache = mRef;
        }
    }

    @Override
    public final int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15620: {
                this.pushMessage(request, false);
                return Integer.MAX_VALUE;
            }
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSuchMethod2Loggable(request.getMethodId(), this.getClass().getName()));
    }

    public static String unitOfOrderFromID(JMSID jmsid) {
        return "weblogicUOO.T" + Long.toString(jmsid.getTimestamp(), 36) + ".S" + Long.toString(jmsid.getSeed(), 36) + ".C" + jmsid.getCounter();
    }

    public void setUnitOfOrder(String unitOfOrder) {
        if (".System".equals(unitOfOrder)) {
            unitOfOrder = JMSSession.unitOfOrderFromID(this.getJMSID());
        }
        this.unitOfOrder = unitOfOrder;
    }

    public void markAsSystemMessageListener(boolean val) {
        this.synchronousListener = val;
        this.prefetchStarted = false;
    }

    void setWLSessionImpl(WLSessionImpl recSess) {
        this.wlSessionImpl = recSess;
        this.setMapLocks(this.wlSessionImpl.getConnectionStateLock());
    }

    void setMapLocks(Object connectionStateLock) {
        this.consumers.setLock(connectionStateLock);
        this.producers.setLock(connectionStateLock);
        this.browsers.setLock(connectionStateLock);
    }

    void setPendingWork(boolean inVal) {
        this.pendingWork = inVal;
    }

    boolean checkRefreshedWithPendingWork() {
        this.setPendingWork(false);
        if (this.refreshedWithPendingWork) {
            this.refreshedWithPendingWork = false;
            return true;
        }
        return false;
    }

    boolean prefetchStarted() {
        return this.prefetchStarted;
    }

    void startPrefetch() {
        this.prefetchStarted = true;
    }

    boolean prefetchDisabled() {
        return this.prefetchDisabled;
    }

    void disablePrefetch() {
        this.prefetchDisabled = true;
    }

    private boolean checkDelayAckForDupsOK(MessageImpl message) {
        if (this.allowDelayAckForDupsOK && message.getClientResponsibleForAcknowledge()) {
            this.allowDelayAckForDupsOK = false;
        }
        return this.allowDelayAckForDupsOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferClientRspForAckMessages(JMSSession toSess) {
        boolean doFirstReceivePushRequest;
        boolean doFirstPushRequest;
        JMSMessageReference lastRef;
        if (toSess.session_clientResponsibleForAck && this.staleJMSSession != null && this.staleJMSSession.session_clientResponsibleForAck) {
            JMSSession jMSSession = this.staleJMSSession;
            synchronized (jMSSession) {
                Object object = this.staleJMSSession.lockObject;
                synchronized (object) {
                    this.carryForwardOnReconnect = this.staleJMSSession.carryForwardOnReconnect;
                    if (this.carryForwardOnReconnect != null) {
                        if (this.firstPushRequest == null) {
                            this.firstPushRequest = this.carryForwardOnReconnect;
                            this.setFirstPushRequest(this.firstPushRequest);
                            this.lastPushRequest = this.lastPushInList(this.firstPushRequest);
                        } else {
                            JMSPushRequest lastCarryBefore = this.lastPushInList(this.carryForwardOnReconnect);
                            while (lastCarryBefore.getNext() != null && ((JMSPushRequest)lastCarryBefore.getNext()).getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
                                lastCarryBefore = (JMSPushRequest)lastCarryBefore.getNext();
                            }
                            if (lastCarryBefore.getFrontEndSequenceNumber() < this.firstPushRequest.getFrontEndSequenceNumber()) {
                                lastCarryBefore.setNext(this.firstPushRequest);
                                this.setFirstPushRequest(this.carryForwardOnReconnect);
                            }
                        }
                    }
                }
            }
        }
        if (!this.consumersReconnect || !this.session_clientResponsibleForAck) {
            return;
        }
        toSess.session_clientResponsibleForAck = true;
        long lastSeqNo = 0L;
        if (this.clientAckList != null && (lastRef = (JMSMessageReference)this.clientAckList.getLast()) != null) {
            lastSeqNo = lastRef.getSequenceNumber();
        }
        boolean bl = doFirstPushRequest = this.firstPushRequest != null && this.firstPushRequest.getMessage().getClientResponsibleForAcknowledge();
        if (doFirstPushRequest) {
            lastSeqNo = this.getMaxSequenceNumber(this.firstPushRequest, lastSeqNo);
        }
        boolean bl2 = doFirstReceivePushRequest = this.firstReceivePushRequest != null && this.firstReceivePushRequest.getMessage().getClientResponsibleForAcknowledge();
        if (doFirstReceivePushRequest) {
            lastSeqNo = this.getMaxSequenceNumber(this.firstReceivePushRequest, lastSeqNo);
        }
        if (this.clientAckList != null) {
            for (JMSMessageReference mRef = (JMSMessageReference)this.clientAckList.getFirst(); mRef != null; mRef = (JMSMessageReference)mRef.getNext()) {
                JMSConsumer newCons;
                MessageImpl mImpl = mRef.getMessage();
                mRef.setSequenceNumber(mRef.getSequenceNumber() - lastSeqNo);
                mImpl.setSequenceNumber(mImpl.getSequenceNumber() - lastSeqNo);
                ConsumerInternal oldConsumer = mRef.getConsumer();
                if (oldConsumer == null || (newCons = (JMSConsumer)toSess.replacementConsumerMap.get(oldConsumer.getJMSID())) == null) continue;
                mRef.reset(mImpl, newCons);
            }
        }
        toSess.clientAckList = this.clientAckList;
        if (doFirstPushRequest) {
            toSess.setFirstPushRequest(this.refreshPushRequests(toSess, this.firstPushRequest, lastSeqNo));
            toSess.lastPushRequest = this.lastPushInList(toSess.firstPushRequest);
        }
        if (doFirstReceivePushRequest) {
            toSess.firstReceivePushRequest = this.refreshPushRequests(toSess, this.firstReceivePushRequest, lastSeqNo);
            toSess.lastReceivePushRequest = this.lastPushInList(toSess.firstReceivePushRequest);
        }
    }

    private JMSPushRequest lastPushInList(JMSPushRequest first) {
        JMSPushRequest prev = first;
        for (JMSPushRequest curPush = first; curPush != null; curPush = (JMSPushRequest)curPush.getNext()) {
            prev = curPush;
        }
        return prev;
    }

    void mapReplacementConsumer(JMSConsumer oldCons, JMSConsumer newCons) {
        this.replacementConsumerMap.put(oldCons.getJMSID(), newCons);
    }

    private JMSPushRequest refreshPushRequests(JMSSession newSess, JMSPushRequest currPushR, long offsetSeqNo) {
        while (currPushR != null && currPushR.getFirstPushEntry() == null) {
            currPushR = (JMSPushRequest)currPushR.getNext();
        }
        JMSPushRequest retPushR = null;
        Request prevPushR = null;
        while (currPushR != null) {
            MessageImpl msgCurr = currPushR.getMessage();
            JMSPushRequest newPushR = new JMSPushRequest(0, null, msgCurr);
            if (retPushR == null) {
                retPushR = newPushR;
            } else {
                prevPushR.setNext(newPushR);
            }
            msgCurr.setSequenceNumber(msgCurr.getSequenceNumber() - offsetSeqNo);
            prevPushR = newPushR;
            for (JMSPushEntry currPushE = currPushR.getFirstPushEntry(); currPushE != null; currPushE = currPushE.getNext()) {
                JMSConsumer newCons = (JMSConsumer)newSess.replacementConsumerMap.get(currPushE.getConsumerId());
                if (newCons == null || !currPushE.getClientResponsibleForAcknowledge()) continue;
                long seqNo = currPushE.getFrontEndSequenceNumber() - offsetSeqNo;
                JMSPushEntry newPushE = new JMSPushEntry(null, newCons.getJMSID(), 0L, seqNo, msgCurr.getDeliveryCount(), 0x200000);
                newPushE.setClientResponsibleForAcknowledge(true);
                newPushR.addPushEntry(newPushE);
            }
            currPushR = (JMSPushRequest)currPushR.getNext();
        }
        return retPushR;
    }

    private long getMaxSequenceNumber(JMSPushRequest pushR, long init) {
        long ret = init;
        for (JMSPushRequest currPushR = pushR; currPushR != null; currPushR = (JMSPushRequest)currPushR.getNext()) {
            for (JMSPushEntry currPushE = currPushR.getFirstPushEntry(); currPushE != null; currPushE = currPushE.getNext()) {
                if (ret >= currPushE.getFrontEndSequenceNumber()) continue;
                ret = currPushE.getFrontEndSequenceNumber();
            }
        }
        return ret;
    }

    @Override
    public void acknowledgeAsync(WLAcknowledgeInfo ackInfo, CompletionListener listener) {
        try {
            this.acknowledge(ackInfo);
            listener.onCompletion(null);
        }
        catch (Throwable t) {
            listener.onException(t);
        }
    }

    @Override
    public void sendAsync(MessageProducer producer, Message message, CompletionListener listener) {
        try {
            producer.send(message);
        }
        catch (Throwable t) {
            listener.onException(t);
        }
    }

    @Override
    public void sendAsync(WLMessageProducer producer, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) {
        try {
            producer.send(message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            listener.onException(t);
        }
    }

    @Override
    public void sendAsync(WLMessageProducer producer, Destination destination, Message message, CompletionListener listener) {
        try {
            producer.send(destination, message);
        }
        catch (Throwable t) {
            listener.onException(t);
        }
    }

    @Override
    public void sendAsync(WLMessageProducer producer, Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) {
        try {
            producer.send(destination, message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            listener.onException(t);
        }
    }

    @Override
    public void receiveAsync(MessageConsumer consumer, CompletionListener listener) {
        ((WLConsumerImpl)consumer).receiveAsync(listener);
    }

    @Override
    public void receiveAsync(MessageConsumer consumer, long timeout, CompletionListener listener) {
        ((WLConsumerImpl)consumer).receiveAsync(timeout, listener);
    }

    @Override
    public void receiveNoWaitAsync(MessageConsumer consumer, CompletionListener listener) {
        ((WLConsumerImpl)consumer).receiveNoWaitAsync(listener);
    }

    @Override
    public XAResource getXAResource(String serverName) {
        return null;
    }

    boolean XABegin() {
        return this.xaRes != null && this.xaRes instanceof InterposedTransactionManagerXAResource && ((InterposedTransactionManagerXAResource)this.xaRes).begin(3) == 1;
    }

    void XAFinish() {
        if (this.xaRes != null && this.xaRes instanceof InterposedTransactionManagerXAResource) {
            ((InterposedTransactionManagerXAResource)this.xaRes).finish(3);
        }
    }

    void XAClose() {
        if (this.xaRes != null && this.xaRes instanceof InterposedTransactionManagerXAResource) {
            ((InterposedTransactionManagerXAResource)this.xaRes).close();
        }
        this.xaRes = null;
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableConsumer(topic, name, null, false);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation2Loggable("createDurableConsumer").getMessage());
        }
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return (TopicSubscriber)this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation2Loggable("createSharedConsumer").getMessage());
        }
        if (sharedSubscriptionName == null) {
            throw new weblogic.jms.common.JMSException("The shared subscription name parameter passed to createSharedConsumer was null");
        }
        if (sharedSubscriptionName.length() == 0) {
            throw new weblogic.jms.common.JMSException("The shared subscription name parameter passed to createSharedConsumer has zero length");
        }
        byte flags = 5;
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, false, sharedSubscriptionName, false, true, flags);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        this.checkClosed();
        if (this.type == 2) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation2Loggable("createSharedDurableConsumer").getMessage());
        }
        if (name == null) {
            throw new weblogic.jms.common.JMSException("The name parameter passed to createSharedDurableConsumer was null");
        }
        if (name.length() == 0) {
            throw new weblogic.jms.common.JMSException("The name parameter passed to createSharedDurableConsumer has zero length");
        }
        if (topic instanceof DistributedDestinationImpl) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidDistributedTopicLoggable());
        }
        byte flags = 5;
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, false, name, true, true, flags);
    }

    void enqueueAsyncSendCallback(AsyncSendCallback cb) throws JMSException {
        this.asyncSendCallbackRunner.enqueueAsyncSendCallback(cb);
    }

    void incrementAsyncSendPendingSize(AsyncSendCallback cb) {
        this.asyncSendCallbackRunner.incrementPendingSize(cb);
    }

    void dequeueAsyncSendCallback(AsyncSendCallback cb) {
        this.asyncSendCallbackRunner.dequeueAsyncSendCallback(cb);
    }

    void wakeupAsyncSendCallback() {
        this.asyncSendCallbackRunner.wakeup();
    }

    void checkOpPermissionForAsyncSend(String op) throws IllegalStateException {
        if (this.asyncSendCallbackRunner.isRunnerThread(Thread.currentThread())) {
            throw new IllegalStateException("Operation " + op + " is not allowed from jakarta.jms.CompletionListener");
        }
    }

    void asyncSendCallbackRunnerClosing() {
        this.asyncSendCallbackRunner.closing();
    }

    void waitTillAllAsyncSendProcessed() throws JMSException {
        this.asyncSendCallbackRunner.waitTillEmpty();
    }

    void blockAsyncSendIfOverPendingThreshold() throws JMSException {
        this.asyncSendCallbackRunner.blockIfOverPendingThreshold();
    }

    static {
        try {
            IGNORE_JmsAsyncQueue = System.getProperty("weblogic.jms.IGNORE_JmsAsyncQueue", "false").equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ASYNC_RESERVED_MSG = new TextMessageImpl("internal ASYNC_RESERVED_MSG");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private class AsyncSendCallbackRunnable
    implements Runnable {
        private static final long MAX_TOTAL_PENDING_SIZE = 1000000L;
        private static final long PER_MESSAGE_SIZE_BASE = 10000L;
        private long totalPendingSize = 0L;
        private LinkedList<AsyncSendCallback> asyncSendCallbacks = null;
        private volatile WorkManager myworkManager;
        private Thread mycurrentThread;
        private boolean myrunning;
        private boolean myclosed;
        private boolean myclosing;

        protected AsyncSendCallbackRunnable(WorkManager wm) {
            this.myworkManager = wm;
            this.mycurrentThread = null;
            this.myrunning = false;
            this.myclosed = false;
            this.myclosing = false;
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("AsyncSendCallbackRunner created for Session@" + JMSSession.this.hashCode() + ", WorkManager@" + (this.myworkManager == null ? "null" : this.myworkManager.hashCode() + "[" + this.myworkManager + ", " + this.myworkManager.getClass().getName() + "]"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void enqueueAsyncSendCallback(AsyncSendCallback cb) throws JMSException {
            Object object;
            if (this.myworkManager == null) {
                object = JMSSession.class;
                // MONITORENTER : weblogic.jms.client.JMSSession.class
                if (this.isClosing()) {
                    throw new JMSException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
                }
                if (this.myworkManager == null) {
                    int thrcnt = ((JMSSession)JMSSession.this).connection.clientDispatcherPartitionContext.getConfiguredThreadPoolSizeForClient();
                    if (thrcnt <= 0) {
                        thrcnt = JMSSession.this.dispatchWorkManager.getConfiguredThreadCount();
                    }
                    this.myworkManager = WorkManagerFactory.getInstance().findOrCreate("JmsAsyncSend", 100, thrcnt, -1);
                    if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                        JMSDebug.JMSMessagePath.debug("AsyncSendCallbackRunner created WorkManager@" + this.myworkManager.hashCode() + "[" + this.myworkManager + ", " + this.myworkManager.getClass().getName() + ",(" + thrcnt + "," + this.myworkManager.getConfiguredThreadCount() + ")] for Session@" + JMSSession.this.hashCode() + "[" + JMSSession.this.sessionId + "]");
                    }
                }
                // MONITOREXIT : object
            }
            object = this;
            // MONITORENTER : object
            if (this.myclosed) throw new JMSException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
            if (this.myclosing) {
                throw new JMSException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
            }
            if (this.asyncSendCallbacks == null) {
                this.asyncSendCallbacks = new LinkedList();
            }
            this.asyncSendCallbacks.add(cb);
            this.notifyAll();
            // MONITOREXIT : object
            cb.enqueued();
            if (!this.beforeSchedule()) return;
            this.myworkManager.schedule(this);
            if (!JMSDebug.JMSMessagePath.isDebugEnabled()) return;
            JMSDebug.JMSMessagePath.debug("AsyncSendCallbackRunner scheduled for session=" + JMSSession.this.sessionId + ", wm=" + this.myworkManager);
        }

        synchronized void incrementPendingSize(AsyncSendCallback cb) {
            if (this.asyncSendCallbacks == null) {
                return;
            }
            if (this.asyncSendCallbacks.contains(cb)) {
                this.totalPendingSize += 10000L + cb.getMessageSize();
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dequeueAsyncSendCallback(AsyncSendCallback cb) {
            AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                if (this.asyncSendCallbacks == null) {
                    return;
                }
                if (this.asyncSendCallbacks.remove(cb)) {
                    this.totalPendingSize -= 10000L + cb.getMessageSize();
                }
                this.notifyAll();
            }
            cb.dequeued();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasCallbackPending() {
            AsyncSendCallback head;
            AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                if (this.asyncSendCallbacks == null) {
                    return false;
                }
                head = this.asyncSendCallbacks.peek();
            }
            if (head == null) {
                return false;
            }
            return head.isCallbackPending();
        }

        synchronized void wakeup() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onReconnect() {
            AsyncSendCallback[] cbs;
            AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                if (this.asyncSendCallbacks == null) {
                    return;
                }
                cbs = this.asyncSendCallbacks.toArray(new AsyncSendCallback[this.asyncSendCallbacks.size()]);
            }
            JMSException ex = new JMSException("Connection reconnect");
            for (int i = 0; i < cbs.length; ++i) {
                AsyncSendCallback cb = cbs[i];
                cb.processException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int cnt;
                AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
                synchronized (asyncSendCallbackRunnable) {
                    this.mycurrentThread = Thread.currentThread();
                    cnt = this.asyncSendCallbacks.size();
                }
                if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                    JMSDebug.JMSMessagePath.debug("AsyncSendCallbackRunner run(), thread[" + this.mycurrentThread + "], AsyncSendCallbacks=" + cnt + ", session=" + JMSSession.this.sessionId + ", wm=" + this.myworkManager);
                }
                this.executeCallback();
            }
            catch (Throwable e) {
                JMSClientExceptionLogger.logStackTrace(e);
            }
            finally {
                if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                    JMSDebug.JMSMessagePath.debug("AsyncSendCallbackRunner run() exit, thread[" + this.mycurrentThread + "], session=" + JMSSession.this.sessionId + ", wm=" + this.myworkManager);
                }
                AsyncSendCallbackRunnable cnt = this;
                synchronized (cnt) {
                    this.myrunning = false;
                    this.mycurrentThread = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCallback() {
            while (true) {
                AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
                synchronized (asyncSendCallbackRunnable) {
                    while (!this.hasCallbackPending()) {
                        if ((this.myclosed || this.myclosing) && (this.asyncSendCallbacks == null || this.asyncSendCallbacks.isEmpty())) {
                            this.myrunning = false;
                            this.mycurrentThread = null;
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            JMSClientExceptionLogger.logStackTrace(e);
                        }
                    }
                }
                while (this.hasCallbackPending()) {
                    AsyncSendCallback head;
                    AsyncSendCallbackRunnable asyncSendCallbackRunnable2 = this;
                    synchronized (asyncSendCallbackRunnable2) {
                        head = this.asyncSendCallbacks.peek();
                    }
                    if (head == null || !head.isCallbackPending()) continue;
                    head.callCompletionListener();
                }
                asyncSendCallbackRunnable = this;
                synchronized (asyncSendCallbackRunnable) {
                    if (this.asyncSendCallbacks.isEmpty()) {
                        this.notifyAll();
                        this.myrunning = false;
                        this.mycurrentThread = null;
                        break;
                    }
                }
            }
        }

        synchronized boolean isRunnerThread(Thread thr) {
            return thr == this.mycurrentThread;
        }

        synchronized boolean beforeSchedule() {
            if (this.myrunning) {
                return false;
            }
            this.myrunning = true;
            return true;
        }

        private synchronized boolean isClosing() {
            return this.myclosing || this.myclosed;
        }

        synchronized void closing() {
            this.myclosing = true;
            this.notifyAll();
        }

        synchronized void close() {
            this.myclosed = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitTillEmpty() throws JMSException {
            boolean schedule = false;
            AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                if (this.asyncSendCallbacks == null) {
                    return;
                }
                if (!this.asyncSendCallbacks.isEmpty() && this.beforeSchedule()) {
                    schedule = true;
                }
            }
            if (schedule) {
                this.myworkManager.schedule(this);
            }
            asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                while (!this.asyncSendCallbacks.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        JMSClientExceptionLogger.logStackTrace(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void blockIfOverPendingThreshold() throws JMSException {
            if (this.isClosing()) {
                throw new JMSException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
            }
            boolean schedule = false;
            AsyncSendCallbackRunnable asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                if (this.asyncSendCallbacks == null) {
                    return;
                }
                if (!this.asyncSendCallbacks.isEmpty() && this.beforeSchedule()) {
                    schedule = true;
                }
            }
            if (schedule) {
                this.myworkManager.schedule(this);
            }
            asyncSendCallbackRunnable = this;
            synchronized (asyncSendCallbackRunnable) {
                while (!this.isClosing() && this.totalPendingSize > 1000000L) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        JMSClientExceptionLogger.logStackTrace(e);
                    }
                }
            }
            if (this.isClosing()) {
                throw new JMSException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
            }
        }
    }

    private class JMSConsumerReceiveResponsePrivate
    extends JMSConsumerReceiveResponse {
        static final long serialVersionUID = -7380653133580038280L;
        private int deliveryCount;

        JMSConsumerReceiveResponsePrivate(MessageImpl message, long sequenceNumber, boolean isTransactional, int deliveryCount) {
            super(message, sequenceNumber, isTransactional);
            this.deliveryCount = deliveryCount;
        }

        int getDeliveryCount() {
            return this.deliveryCount;
        }
    }

    private class UseForRunnable
    implements Runnable {
        private JMSSession session;

        protected UseForRunnable(JMSSession session) {
            this.session = session;
        }

        @Override
        public void run() {
            this.session.executeMessage();
        }
    }

    static final class PendingWTMessage {
        final ConsumerInternal consumer;
        final long sequenceNumber;
        PendingWTMessage next;

        PendingWTMessage(ConsumerInternal consumer, long sequenceNumber) {
            this.consumer = consumer;
            this.sequenceNumber = sequenceNumber;
        }
    }

    static final class UnackedMessage {
        final ConsumerInternal consumer;
        final long sequenceNumber;
        UnackedMessage next;

        UnackedMessage(ConsumerInternal consumer, long sequenceNumber) {
            this.consumer = consumer;
            this.sequenceNumber = sequenceNumber;
        }
    }
}

