/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.IllegalStateException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import java.util.Enumeration;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSEnumeration;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSBrowserGetEnumerationResponse;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.frontend.FEBrowserGetEnumerationRequest;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class JMSQueueBrowser
implements QueueBrowser,
Invocable {
    private final JMSDispatcher frontEndDispatcher;
    private JMSID browserId;
    private final Queue queue;
    private final String selector;
    private final JMSSession session;

    public JMSQueueBrowser(Queue queue, String selector, JMSSession session) throws jakarta.jms.JMSException {
        this.queue = queue;
        this.selector = selector;
        this.session = session;
        this.frontEndDispatcher = session.getConnection().getFrontEndDispatcher();
        this.browserId = session.createBackEndBrowser((DestinationImpl)queue, selector);
    }

    void setId(JMSID browserId) {
        this.browserId = browserId;
    }

    @Override
    public JMSID getJMSID() {
        return this.browserId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.session.getDispatcherPartition4rmic();
    }

    @Override
    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    @Override
    public Queue getQueue() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.queue;
    }

    @Override
    public String getMessageSelector() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.selector;
    }

    @Override
    public Enumeration getEnumeration() throws jakarta.jms.JMSException {
        this.checkClosed();
        Response response = this.frontEndDispatcher.dispatchSync(new FEBrowserGetEnumerationRequest(this.browserId));
        return new JMSEnumeration(this.queue, this, ((JMSBrowserGetEnumerationResponse)response).getEnumerationId(), this.frontEndDispatcher);
    }

    public JMSSession getSession() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.session;
    }

    boolean isClosed() {
        return this.browserId == null;
    }

    private void checkClosed() throws jakarta.jms.JMSException {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException(JMSClientExceptionLogger.logClosedBrowserLoggable().getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws jakarta.jms.JMSException {
        JMSID browserId;
        JMSQueueBrowser jMSQueueBrowser = this;
        synchronized (jMSQueueBrowser) {
            if (this.isClosed()) {
                return;
            }
            browserId = this.browserId;
            this.browserId = null;
        }
        this.session.closeBrowser(browserId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushException(Request invocableRequest) throws jakarta.jms.JMSException {
        JMSID browserId;
        JMSPushExceptionRequest request = (JMSPushExceptionRequest)invocableRequest;
        JMSQueueBrowser jMSQueueBrowser = this;
        synchronized (jMSQueueBrowser) {
            browserId = this.browserId;
            this.browserId = null;
        }
        if (browserId != null) {
            this.session.closeBrowser(browserId, true);
        }
        request.setState(Integer.MAX_VALUE);
        return request.getState();
    }

    @Override
    public int invoke(Request request) throws jakarta.jms.JMSException {
        switch (request.getMethodId()) {
            case 15382: {
                return this.pushException(request);
            }
        }
        throw new JMSException(JMSClientExceptionLogger.logNoSuchMethod3Loggable(request.getMethodId(), this.getClass().getName()));
    }
}

