/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ContainerType;
import weblogic.jms.client.JMSContextImpl;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.common.TypeConverter;
import weblogic.jms.common.WLJMSRuntimeException;
import weblogic.jms.common.WLMessageFormatRuntimeException;
import weblogic.jms.extensions.WLJMSProducer;
import weblogic.jms.extensions.WLMessageProducer;

public class JMSProducerImpl
implements WLJMSProducer {
    JMSContextImpl contextImpl;
    boolean disableMessageID = false;
    boolean disableMessageTimestamp = false;
    int deliveryMode = 2;
    int priority = 4;
    long timeToLive = 0L;
    long deliveryDelay = -1L;
    String jmsCorrelationID = null;
    byte[] jmsCorrelationIDAsBytes = null;
    String jmsType = null;
    Destination jmsReplyTo = null;
    Hashtable<String, Object> properties = new Hashtable();
    private CompletionListener completionListener = null;
    private int redeliveryLimit;
    private long sendTimeout;
    private String unitOfOrder;
    private int compressionThreshold;

    public JMSProducerImpl(JMSContext contextImpl) {
        this.contextImpl = (JMSContextImpl)contextImpl;
        this.redeliveryLimit = this.contextImpl.getDefaultRedeliveryLimit();
        this.sendTimeout = ((WLProducerImpl)this.contextImpl.getMessageProducer()).getPhysicalJMSConnection().getSendTimeout();
        this.unitOfOrder = this.contextImpl.getDefaultUnitOfOrder();
        this.compressionThreshold = this.contextImpl.getDefaultCompressionThreshold();
    }

    @Override
    public JMSProducer send(Destination destination, Message message) {
        this.contextImpl.checkNotClosed();
        this.checkMessage(message);
        this.configureMessageProducer();
        this.configureMessage(message);
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, message);
            } else {
                this.contextImpl.getMessageProducer().send(destination, message, this.completionListener);
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, String payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        TextMessage textMessage = payload == null ? this.contextImpl.createTextMessage() : this.contextImpl.createTextMessage(payload);
        this.configureMessage(textMessage);
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, textMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, textMessage, this.completionListener);
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, Map<String, Object> payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        MapMessage mapMessage = this.contextImpl.createMapMessage();
        this.configureMessage(mapMessage);
        if (payload != null) {
            try {
                for (Map.Entry<String, Object> thisEntry : payload.entrySet()) {
                    mapMessage.setObject(thisEntry.getKey(), thisEntry.getValue());
                }
            }
            catch (JMSException e) {
                throw WLJMSRuntimeException.convertJMSException(e);
            }
        }
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, mapMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, mapMessage, this.completionListener);
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, byte[] payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        BytesMessage bytesMessage = this.contextImpl.createBytesMessage();
        this.configureMessage(bytesMessage);
        if (payload != null) {
            try {
                bytesMessage.writeBytes(payload);
            }
            catch (JMSException e) {
                throw WLJMSRuntimeException.convertJMSException(e);
            }
        }
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, bytesMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, bytesMessage, this.completionListener);
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, Serializable payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        ObjectMessage objectMessage = this.contextImpl.createObjectMessage(payload);
        this.configureMessage(objectMessage);
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, objectMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, objectMessage, this.completionListener);
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    private void configureMessageProducer() {
        MessageProducer messageProducer = this.contextImpl.getMessageProducer();
        try {
            messageProducer.setPriority(this.priority);
            if (this.deliveryDelay != -1L) {
                messageProducer.setDeliveryDelay(this.deliveryDelay);
            } else {
                long delay = this.getDeliveryDelay();
                messageProducer.setDeliveryDelay(delay);
            }
            messageProducer.setDeliveryMode(this.deliveryMode);
            messageProducer.setTimeToLive(this.timeToLive);
            messageProducer.setDisableMessageID(this.disableMessageID);
            messageProducer.setDisableMessageTimestamp(this.disableMessageTimestamp);
            WLMessageProducer wlMessageProducer = (WLMessageProducer)messageProducer;
            wlMessageProducer.setRedeliveryLimit(this.redeliveryLimit);
            wlMessageProducer.setSendTimeout(this.sendTimeout);
            wlMessageProducer.setUnitOfOrder(this.unitOfOrder);
            wlMessageProducer.setCompressionThreshold(this.compressionThreshold);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    private void checkMessage(Message message) {
        if (message == null) {
            throw new WLMessageFormatRuntimeException(JMSClientExceptionLogger.logMessageIsNullLoggable());
        }
    }

    private void configureMessage(Message message) {
        try {
            if (this.jmsCorrelationID != null) {
                message.setJMSCorrelationID(this.jmsCorrelationID);
            }
            if (this.jmsCorrelationIDAsBytes != null) {
                message.setJMSCorrelationIDAsBytes(this.jmsCorrelationIDAsBytes);
            }
            if (this.jmsType != null) {
                message.setJMSType(this.jmsType);
            }
            if (this.jmsReplyTo != null) {
                message.setJMSReplyTo(this.jmsReplyTo);
            }
            for (Map.Entry<String, Object> thisEntry : this.properties.entrySet()) {
                message.setObjectProperty(thisEntry.getKey(), thisEntry.getValue());
            }
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public JMSProducer setDisableMessageID(boolean disableMessageID) {
        this.contextImpl.checkNotClosed();
        this.disableMessageID = disableMessageID;
        return this;
    }

    @Override
    public boolean getDisableMessageID() {
        this.contextImpl.checkNotClosed();
        return this.disableMessageID;
    }

    @Override
    public JMSProducer setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.contextImpl.checkNotClosed();
        this.disableMessageTimestamp = disableMessageTimestamp;
        return this;
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        this.contextImpl.checkNotClosed();
        return this.disableMessageTimestamp;
    }

    @Override
    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.contextImpl.checkNotClosed();
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logInvalidJMSProducerDeliveryModeLoggable(deliveryMode));
        }
        this.deliveryMode = deliveryMode;
        return this;
    }

    @Override
    public int getDeliveryMode() {
        this.contextImpl.checkNotClosed();
        return this.deliveryMode;
    }

    @Override
    public JMSProducer setPriority(int priority) {
        this.contextImpl.checkNotClosed();
        if (priority < 0 || priority > 9) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logInvalidJMSProducerDeliveryModeLoggable(this.deliveryMode));
        }
        this.priority = priority;
        return this;
    }

    @Override
    public int getPriority() {
        this.contextImpl.checkNotClosed();
        return this.priority;
    }

    @Override
    public JMSProducer setTimeToLive(long timeToLive) {
        this.contextImpl.checkNotClosed();
        this.timeToLive = timeToLive;
        return this;
    }

    @Override
    public long getTimeToLive() {
        this.contextImpl.checkNotClosed();
        return this.timeToLive;
    }

    @Override
    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.contextImpl.checkNotClosed();
        if (deliveryDelay < 0L) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logInvalidJMSDeliveryDelayLoggable().getMessage());
        }
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    @Override
    public long getDeliveryDelay() {
        this.contextImpl.checkNotClosed();
        if (this.deliveryDelay != -1L) {
            return this.deliveryDelay;
        }
        return ((WLProducerImpl)this.contextImpl.getMessageProducer()).getPhysicalJMSConnection().getTimeToDeliver();
    }

    @Override
    public JMSProducer setAsync(CompletionListener completionListener) {
        if (this.contextImpl.getContainerType() == ContainerType.JavaEE_Web_or_EJB) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logMethodForbiddenInJavaEEWebEJBLoggable());
        }
        this.contextImpl.checkNotClosed();
        this.completionListener = completionListener;
        return this;
    }

    @Override
    public CompletionListener getAsync() {
        this.contextImpl.checkNotClosed();
        return this.completionListener;
    }

    @Override
    public JMSProducer setProperty(String name, boolean value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    private void checkAndSetProperty(String name, Object value) {
        JMSProducerImpl.checkPropertyNameSet(name);
        JMSProducerImpl.checkValidPropertyValue(name, value);
        JMSProducerImpl.checkValidPropertyName(name);
        this.properties.put(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, byte value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, short value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, int value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, long value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, float value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, Float.valueOf(value));
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, double value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, String value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, Object value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    @Override
    public JMSProducer clearProperties() {
        this.contextImpl.checkNotClosed();
        this.properties.clear();
        return this;
    }

    @Override
    public boolean propertyExists(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        return this.properties.containsKey(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toBoolean(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public byte getByteProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toByte(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public short getShortProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toShort(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public int getIntProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toInt(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public long getLongProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toLong(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public float getFloatProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toFloat(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public double getDoubleProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toDouble(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public String getStringProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        try {
            return TypeConverter.toString(this.properties.get(name));
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
    }

    @Override
    public Object getObjectProperty(String name) {
        this.contextImpl.checkNotClosed();
        JMSProducerImpl.checkPropertyNameSet(name);
        Object obj = this.properties.get(name);
        return obj;
    }

    @Override
    public Set<String> getPropertyNames() {
        this.contextImpl.checkNotClosed();
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.contextImpl.checkNotClosed();
        this.jmsCorrelationIDAsBytes = correlationID;
        this.jmsCorrelationID = null;
        return this;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        this.contextImpl.checkNotClosed();
        return this.jmsCorrelationIDAsBytes;
    }

    @Override
    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.contextImpl.checkNotClosed();
        this.jmsCorrelationID = correlationID;
        this.jmsCorrelationIDAsBytes = null;
        return this;
    }

    @Override
    public String getJMSCorrelationID() {
        this.contextImpl.checkNotClosed();
        return this.jmsCorrelationID;
    }

    @Override
    public JMSProducer setJMSType(String type) {
        this.contextImpl.checkNotClosed();
        this.jmsType = type;
        return this;
    }

    @Override
    public String getJMSType() {
        this.contextImpl.checkNotClosed();
        return this.jmsType;
    }

    @Override
    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.contextImpl.checkNotClosed();
        this.jmsReplyTo = replyTo;
        return this;
    }

    @Override
    public Destination getJMSReplyTo() {
        this.contextImpl.checkNotClosed();
        return this.jmsReplyTo;
    }

    private static void checkPropertyNameSet(String name) {
        if (name == null) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logJMSProducerPropertyNameEmpty());
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logJMSProducerPropertyNameEmpty());
        }
    }

    private static void checkValidPropertyValue(String name, Object value) {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            throw new WLMessageFormatRuntimeException(JMSClientExceptionLogger.logJMSProducerPropertyValueInvalidLoggable(value.getClass().toString()));
        }
    }

    private static void checkValidPropertyName(String name) {
        if ("NULL".equalsIgnoreCase(name) || "TRUE".equalsIgnoreCase(name) || "FALSE".equalsIgnoreCase(name) || "NOT".equalsIgnoreCase(name) || "AND".equalsIgnoreCase(name) || "OR".equalsIgnoreCase(name) || "BETWEEN".equalsIgnoreCase(name) || "LIKE".equalsIgnoreCase(name) || "IN".equalsIgnoreCase(name) || "IS".equalsIgnoreCase(name)) {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logJMSProducerPropertyNameReservedLoggable(name));
        }
        char[] namechars = name.toCharArray();
        if (Character.isJavaIdentifierStart(namechars[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i])) continue;
                throw new WLJMSRuntimeException(JMSClientExceptionLogger.logJMSProducerPropertyNameHasBadCharLoggable(name));
            }
        } else {
            throw new WLJMSRuntimeException(JMSClientExceptionLogger.logJMSProducerPropertyNameHasBadFirstCharLoggable(name));
        }
    }

    @Override
    public int getRedeliveryLimit() {
        this.contextImpl.checkNotClosed();
        return this.redeliveryLimit;
    }

    @Override
    public WLJMSProducer setRedeliveryLimit(int redeliveryLimit) {
        this.contextImpl.checkNotClosed();
        if (redeliveryLimit < -1) {
            throw new JMSRuntimeException(JMSClientExceptionLogger.logInvalidRedeliveryLimitLoggable().getMessage());
        }
        this.redeliveryLimit = redeliveryLimit;
        return this;
    }

    @Override
    public long getSendTimeout() {
        this.contextImpl.checkNotClosed();
        return this.sendTimeout;
    }

    @Override
    public WLJMSProducer setSendTimeout(long sendTimeout) {
        this.contextImpl.checkNotClosed();
        if (sendTimeout < 0L) {
            throw new JMSRuntimeException(JMSClientExceptionLogger.logInvalidSendTimeoutLoggable().getMessage());
        }
        this.sendTimeout = sendTimeout;
        return this;
    }

    @Override
    public String getUnitOfOrder() {
        this.contextImpl.checkNotClosed();
        return this.unitOfOrder;
    }

    @Override
    public WLJMSProducer setUnitOfOrder(String name) {
        this.contextImpl.checkNotClosed();
        this.unitOfOrder = name;
        return this;
    }

    @Override
    public WLJMSProducer setUnitOfOrder() {
        this.contextImpl.checkNotClosed();
        try {
            WLMessageProducer wlmessageproducer = (WLMessageProducer)this.contextImpl.getMessageProducer();
            String oldUnitOfOrder = wlmessageproducer.getUnitOfOrder();
            wlmessageproducer.setUnitOfOrder();
            String generatedUnitOfOrder = wlmessageproducer.getUnitOfOrder();
            wlmessageproducer.setUnitOfOrder(oldUnitOfOrder);
            this.unitOfOrder = generatedUnitOfOrder;
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    @Override
    public WLJMSProducer forward(Destination destination, Message message) {
        this.contextImpl.checkNotClosed();
        this.checkMessage(message);
        this.configureMessageProducer();
        this.configureMessage(message);
        try {
            if (this.completionListener != null) {
                throw new UnsupportedOperationException(JMSClientExceptionLogger.logAsyncForwardUnsupportedLoggable().getMessage());
            }
            ((WLMessageProducer)this.contextImpl.getMessageProducer()).forward(destination, message);
        }
        catch (JMSException e) {
            throw WLJMSRuntimeException.convertJMSException(e);
        }
        return this;
    }

    @Override
    public WLJMSProducer setCompressionThreshold(int limit) {
        this.contextImpl.checkNotClosed();
        if (limit < 0) {
            throw new JMSRuntimeException(JMSClientExceptionLogger.logInvalidCompressionThresholdLoggable().getMessage());
        }
        this.compressionThreshold = limit;
        return this;
    }

    @Override
    public int getCompressionThreshold() {
        this.contextImpl.checkNotClosed();
        return this.compressionThreshold;
    }
}

