/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.transaction.Transaction;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantLock;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.client.AsyncSendCallback;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.client.ProducerInternal;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.common.AlreadyClosedException;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.JMSWorkContextHelper;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.ProducerSendResponse;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.extensions.JMSForwardHelper;
import weblogic.jms.frontend.FEProducerSendRequest;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.transaction.TransactionHelper;

public final class JMSProducer
implements ProducerInternal,
Invocable,
Reconnectable,
Cloneable {
    private static int ONEWAYSENDCONSECUTIVEMESSAGELIMIT = 320000;
    private final JMSSession session;
    private volatile JMSID producerId;
    private volatile boolean closeInProgress;
    private final DestinationImpl destination;
    private int deliveryMode;
    private int priority;
    private long timeToDeliver = -1L;
    private long timeToLive;
    private int redeliveryLimit = -1;
    private long sendTimeout;
    private boolean messageIdsDisabled;
    private boolean messageTimestampsDisabled;
    private PeerInfo peerInfo;
    private final String runtimeMBeanName;
    private String unitOfOrderName;
    private String sequenceName;
    private int compressionThreshold = Integer.MAX_VALUE;
    private WLProducerImpl wlProducerImpl;
    private byte destinationFlags;
    private JMSProducer replacementProducer;
    private int oneWaySendMode;
    private int oneWayWindowSize;
    private static boolean ONEWAYSENDENABLED = false;
    private static int oneWaySendModeConf = 0;
    private static int oneWayWindowSizeConf = 1;
    private static final int MODE_SYNC_TRAN = 0;
    private static final int MODE_SYNC_NO_TRAN = 1;
    private static final int MODE_SYNC_NO_TRAN_WITH_ID = 2;
    private static final int MODE_NO_REPLY_WITH_ID = 3;
    private static final int MODE_ASYNC_TRAN = 4;
    private static final int MODE_ASYNC_NO_TRAN = 5;
    private static final int MODE_ASYNC_TRAN_WITH_ID = 6;
    private static final int MODE_ASYNC_NO_TRAN_WITH_ID = 7;
    private final Object asyncSendCountLock = new Object();
    private long wlAsyncSendCount = 0L;
    private long jmsAsyncSendCount = 0L;
    private ProducerFlowControl producerFlowControl;
    private static final boolean FOREIGNMSGTIMESTAMP_ENABLED = Boolean.valueOf(System.getProperty("weblogic.jms.foreignMessage.originalTimestamp", "false"));
    int count = 0;
    int totalConsecutiveOneWaySendMessageSize = 0;

    JMSProducer(JMSSession session, JMSID producerId, DestinationImpl destination, String runtimeMBeanName) {
        this.session = session;
        this.producerId = producerId;
        this.destination = destination;
        this.runtimeMBeanName = runtimeMBeanName;
        this.peerInfo = session.getConnection().getFEPeerInfo();
        this.deliveryMode = session.getDeliveryMode();
        this.priority = session.getPriority();
        this.timeToLive = session.getTimeToLive();
        this.sendTimeout = session.getSendTimeout();
        JMSConnection con = session.getConnection();
        this.producerFlowControl = new ProducerFlowControl(con);
        this.compressionThreshold = session.getConnection().getCompressionThreshold();
        this.oneWaySendMode = con.getOneWaySendMode();
        this.oneWayWindowSize = con.getOneWaySendWindowSize();
        if (this.oneWaySendMode != 0 && JMSEnvironment.getJMSEnvironment().isThinClient()) {
            this.oneWaySendMode = 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JMSProducer jmsProducer = (JMSProducer)super.clone();
        return jmsProducer;
    }

    @Override
    public ReconnectController getReconnectController() {
        return this.wlProducerImpl;
    }

    @Override
    public Reconnectable getReconnectState(int reconnectPolicy) throws CloneNotSupportedException {
        JMSProducer jmsProducer = (JMSProducer)this.clone();
        this.closeInProgress = true;
        return jmsProducer;
    }

    @Override
    public Reconnectable preCreateReplacement(Reconnectable parent) throws jakarta.jms.JMSException {
        JMSProducer newProducer = ((JMSSession)parent).setupJMSProducer(this.destination, this.destinationFlags);
        if (this.unitOfOrderName == null && newProducer.getUnitOfOrder() != null || this.unitOfOrderName != null && !this.unitOfOrderName.equals(newProducer.getUnitOfOrder())) {
            newProducer.setUnitOfOrder(this.unitOfOrderName);
        }
        newProducer.sequenceName = this.sequenceName;
        newProducer.messageIdsDisabled = this.messageIdsDisabled;
        newProducer.messageTimestampsDisabled = this.messageTimestampsDisabled;
        newProducer.deliveryMode = this.deliveryMode;
        newProducer.priority = this.priority;
        newProducer.timeToDeliver = this.timeToDeliver;
        newProducer.timeToLive = this.timeToLive;
        newProducer.redeliveryLimit = this.redeliveryLimit;
        newProducer.sendTimeout = this.sendTimeout;
        this.replacementProducer = newProducer;
        return newProducer;
    }

    @Override
    public void postCreateReplacement() {
        this.replacementProducer.setWlProducerImpl(this.wlProducerImpl);
        this.wlProducerImpl.setPhysicalReconnectable(this.replacementProducer);
    }

    @Override
    public boolean isReconnectControllerClosed() {
        return this.wlProducerImpl == null || this.wlProducerImpl.isClosed();
    }

    @Override
    public void forgetReconnectState() {
        this.replacementProducer = null;
    }

    @Override
    public PeerInfo getFEPeerInfo() {
        return this.session.getFEPeerInfo();
    }

    @Override
    public boolean isClosed() {
        return this.producerId == null || this.closeInProgress;
    }

    @Override
    public String getWLSServerName() {
        return this.session.getConnection().getWLSServerName();
    }

    @Override
    public ClientRuntimeInfo getParentInfo() {
        return this.session;
    }

    @Override
    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    @Override
    public String getPartitionName() {
        return this.session.getConnection().getPartitionName();
    }

    @Override
    public final void setCompressionThreshold(int compressionThreshold) throws jakarta.jms.JMSException {
        if (compressionThreshold < 0) {
            throw new jakarta.jms.JMSException(JMSClientExceptionLogger.logInvalidCompressionThresholdLoggable().getMessage());
        }
        this.compressionThreshold = compressionThreshold;
    }

    @Override
    public final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    void setId(JMSID producerId) {
        this.producerId = producerId;
    }

    @Override
    public JMSID getJMSID() {
        return this.producerId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.session.getDispatcherPartition4rmic();
    }

    @Override
    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    @Override
    public Destination getDestination() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.destination;
    }

    @Override
    public void send(Destination destination, Message message) throws jakarta.jms.JMSException {
        this.sendWithListener(null, destination, message);
    }

    private void sendWithListener(weblogic.messaging.dispatcher.CompletionListener appListener, Destination destination, Message message) throws jakarta.jms.JMSException {
        this.sendWithListenerUnified(null, appListener, destination, message);
    }

    private void sendWithListenerUnified(CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener, Destination destination, Message message) throws jakarta.jms.JMSException {
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestination2Loggable().getMessage());
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        this.sendInternal(destination, message, this.deliveryMode, this.priority, this.timeToLive, jmsAppListener, appListener);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.sendWithListener(null, destination, message, deliveryMode, priority, timeToLive);
    }

    private void sendWithListener(weblogic.messaging.dispatcher.CompletionListener appListener, Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.sendWithListenerUnified(null, appListener, destination, message, deliveryMode, priority, timeToLive);
    }

    private void sendWithListenerUnified(CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener, Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestination2Loggable().getMessage());
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestination2Loggable().getMessage());
        }
        if (priority < 0 || priority > 9) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidPrioritySendLoggable(priority));
        }
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidDeliveryModeSendLoggable(deliveryMode));
        }
        this.sendInternal(destination, message, deliveryMode, priority, timeToLive, jmsAppListener, appListener);
    }

    @Override
    public void send(Message message) throws jakarta.jms.JMSException {
        this.sendWithListener(null, message);
    }

    private void sendWithListener(weblogic.messaging.dispatcher.CompletionListener appListener, Message message) throws jakarta.jms.JMSException {
        this.sendWithListenerUnified(null, appListener, message);
    }

    private void sendWithListenerUnified(CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener, Message message) throws jakarta.jms.JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestinationLoggable().getMessage());
        }
        this.sendInternal(this.destination, message, this.deliveryMode, this.priority, this.timeToLive, jmsAppListener, appListener);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.sendWithListener(null, message, deliveryMode, priority, timeToLive);
    }

    private void sendWithListener(weblogic.messaging.dispatcher.CompletionListener appListener, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.sendWithListenerUnified(null, appListener, message, deliveryMode, priority, timeToLive);
    }

    private void sendWithListenerUnified(CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestination2Loggable().getMessage());
        }
        if (priority < 0 || priority > 9) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidPrioritySendLoggable(priority));
        }
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidDeliveryModeSendLoggable(deliveryMode));
        }
        this.sendInternal(this.destination, message, deliveryMode, priority, timeToLive, jmsAppListener, appListener);
    }

    @Override
    public void send(Queue queue, Message message) throws jakarta.jms.JMSException {
        this.send((Destination)queue, message);
    }

    @Override
    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public Queue getQueue() throws jakarta.jms.JMSException {
        return (Queue)this.getDestination();
    }

    @Override
    public Topic getTopic() throws jakarta.jms.JMSException {
        return (Topic)this.getDestination();
    }

    @Override
    public void publish(Message message) throws jakarta.jms.JMSException {
        this.send(message);
    }

    @Override
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message) throws jakarta.jms.JMSException {
        this.send(topic, message);
    }

    @Override
    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        this.send(topic, message, deliveryMode, priority, timeToLive);
    }

    private void forwardInternal(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (!(message instanceof MessageImpl)) {
            throw new JMSException(JMSClientExceptionLogger.logNotForwardable3Loggable());
        }
        if (this.peerInfo.getMajor() < 9) {
            throw new JMSException(JMSClientExceptionLogger.logUnsupportedLoggable());
        }
        if (!((MessageImpl)message).isForwardable()) {
            throw new JMSException(JMSClientExceptionLogger.logNotForwardable2Loggable());
        }
        this.deliveryInternal(destination, message, deliveryMode, priority, timeToLive, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener) throws jakarta.jms.JMSException {
        if (this.session.XABegin() && jmsAppListener != null && this.session.userTransactionsEnabled()) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedAsyncSendInXALoggable().getMessage());
        }
        try {
            this.deliveryInternalUnified(destination, message, deliveryMode, priority, timeToLive, false, jmsAppListener, appListener);
        }
        finally {
            this.session.XAFinish();
        }
    }

    public static void sendReturn(ProducerSendResponse sendResponse, Message message, MessageImpl messageImpl, boolean forwarding, long timeToDeliver, long timeToLive, int deliveryMode, int priority, Destination destination) throws jakarta.jms.JMSException {
        JMSMessageId messageId;
        block28: {
            messageId = sendResponse.getMessageId();
            if (!forwarding) {
                messageImpl.setId(messageId);
                messageImpl.setOldMessage(!sendResponse.get90StyleMessageId());
            }
            if (message == messageImpl) {
                messageImpl.setJMSDestinationImpl((DestinationImpl)destination);
            } else {
                try {
                    message.setJMSDestination(destination);
                }
                catch (ClassCastException classCastException) {
                }
                catch (InvalidDestinationException invalidDestinationException) {
                }
                catch (jakarta.jms.JMSException jMSException) {
                    // empty catch block
                }
                message.setJMSDeliveryMode(messageImpl.getJMSDeliveryMode());
                message.setJMSPriority(messageImpl.getJMSPriority());
                if (message instanceof MessageImpl) {
                    if (!forwarding) {
                        ((MessageImpl)message).setId(messageId);
                        ((MessageImpl)message).setOldMessage(messageImpl.isOldMessage());
                    }
                } else {
                    message.setJMSTimestamp(messageImpl.getJMSTimestamp());
                    try {
                        message.setJMSMessageID(messageImpl.getJMSMessageID());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (messageImpl.getJMSExpiration() != 0L) {
                message.setJMSExpiration(messageId.getTimestamp() + timeToLive);
            } else {
                message.setJMSExpiration(0L);
            }
            if (timeToDeliver >= 0L) {
                try {
                    message.setJMSDeliveryTime(messageId.getTimestamp() + timeToDeliver);
                }
                catch (AbstractMethodError abstractMethodError) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (jakarta.jms.JMSException jmse) {
                    if (jmse.getLinkedException() instanceof Exception && (jmse.getLinkedException().getCause() instanceof AbstractMethodError || jmse.getLinkedException().getCause() instanceof NoSuchMethodError || jmse.getLinkedException().getCause() instanceof UnsupportedOperationException)) break block28;
                    throw jmse;
                }
            }
        }
        try {
            deliveryMode = sendResponse.getDeliveryMode();
            if (deliveryMode != -1) {
                message.setJMSDeliveryMode(deliveryMode);
            }
        }
        catch (jakarta.jms.JMSException jmse) {
            // empty catch block
        }
        priority = sendResponse.getPriority();
        if (priority != -1) {
            message.setJMSPriority(priority);
        }
        if ((timeToLive = sendResponse.getTimeToLive()) != -1L) {
            message.setJMSExpiration(messageId.getTimestamp() + timeToLive);
        }
        if (message instanceof MessageImpl) {
            int redeliveryLimit;
            timeToDeliver = sendResponse.getTimeToDeliver();
            if (timeToDeliver != -1L) {
                ((MessageImpl)message).setDeliveryTime(messageId.getTimestamp() + timeToDeliver);
            }
            if ((redeliveryLimit = sendResponse.getRedeliveryLimit()) != 0) {
                ((MessageImpl)message).setJMSRedeliveryLimit(redeliveryLimit);
            }
        }
    }

    private void deliveryInternal(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean forwarding, weblogic.messaging.dispatcher.CompletionListener appListener) throws jakarta.jms.JMSException {
        this.deliveryInternalUnified(destination, message, deliveryMode, priority, timeToLive, forwarding, null, appListener);
    }

    private void deliveryInternalUnified(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean forwarding, CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener) throws jakarta.jms.JMSException {
        MessageImpl messageImpl;
        block18: {
            if (!(this.session instanceof JMSXASession) && this.session.getConnection().isWrappedIC() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                throw new IllegalStateException(JMSClientExceptionLogger.logUnexpectedTransactionLoggable().getMessage());
            }
            if (jmsAppListener != null && this.session.userTransactionsEnabled() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedAsyncSendInXALoggable().getMessage());
            }
            if (destination == null) {
                throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestination2Loggable().getMessage());
            }
            if (!(destination instanceof DestinationImpl)) {
                throw new InvalidDestinationException(JMSClientExceptionLogger.logForeignDestination2Loggable().getMessage());
            }
            if (this.session.getType() == 2 && !((DestinationImpl)destination).isQueue()) {
                throw new InvalidDestinationException(JMSClientExceptionLogger.logMustBeAQueueLoggable(destination.toString()).getMessage());
            }
            if (this.session.getType() == 1 && !((DestinationImpl)destination).isTopic()) {
                throw new InvalidDestinationException(JMSClientExceptionLogger.logMustBeATopicLoggable(destination.toString()).getMessage());
            }
            if (appListener == null) {
                this.producerFlowControl.doFlowControl();
            } else {
                this.producerFlowControl.markWLAsyncSendFlowControlTime();
            }
            try {
                Destination replyto;
                messageImpl = (MessageImpl)message;
                messageImpl.resetUserPropertySize();
                if (!forwarding) {
                    messageImpl.setForward(false);
                    messageImpl.resetForwardsCount();
                    messageImpl.setOldMessage(false);
                    messageImpl.setJMSXUserID(null);
                    if (!(messageImpl.getSAFSequenceName() == null && messageImpl.getSAFSeqNumber() == 0L || messageImpl.getKeepSAFSequenceNameAndNumber())) {
                        messageImpl.setSAFSequenceName(null);
                        messageImpl.setSAFSeqNumber(0L);
                    }
                }
                if ((this.session.getConnection().isLocal() || jmsAppListener != null) && (replyto = (messageImpl = messageImpl.copy()).getJMSReplyTo()) != null && replyto instanceof DestinationImpl) {
                    try {
                        messageImpl.setJMSReplyTo((Destination)((DestinationImpl)replyto).clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            catch (ClassCastException cce) {
                messageImpl = JMSProducer.convertMessage(message);
                if (!FOREIGNMSGTIMESTAMP_ENABLED) break block18;
                messageImpl.setLongProperty("WL_JMS_ForeignTimestampMillis", message.getJMSTimestamp());
                messageImpl.setStringProperty("WL_JMS_ForeignTimestampString", JMSForwardHelper.getFormattedTime(message.getJMSTimestamp()));
            }
        }
        if (timeToLive == 0L) {
            timeToLive = 0L;
        }
        messageImpl.setJMSExpiration(timeToLive);
        long timeToDeliver = this.getTimeToDeliverInternal();
        messageImpl.setDeliveryTime(timeToDeliver);
        messageImpl.setJMSRedeliveryLimit(this.redeliveryLimit);
        messageImpl.setJMSDestinationImpl(null);
        if (!forwarding) {
            messageImpl.setId(null);
        }
        messageImpl.setJMSDeliveryMode(deliveryMode);
        messageImpl.setJMSPriority(priority);
        messageImpl.setDDForwarded(false);
        messageImpl.setDeliveryCount(0);
        messageImpl.setUnitOfOrderName(this.unitOfOrderName);
        JMSWorkContextHelper.infectMessage(messageImpl);
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : Sending message deliveryMode = " + deliveryMode + " priority = " + priority + " timeToLive = " + timeToLive + " timeToDeliver = " + timeToDeliver + " redeliveryLimit = " + this.redeliveryLimit);
        }
        JMSProducerSendResponse jMSProducerSendResponse = (JMSProducerSendResponse)this.toFEProducer(destination, message, messageImpl, deliveryMode, timeToDeliver, priority, timeToLive, forwarding, jmsAppListener, appListener);
    }

    private void wrappedSendReturn(JMSProducerSendResponse sendResponse, Destination destination, Message message, MessageImpl messageImpl, int deliveryMode, long timeToDeliver, int priority, long timeToLive, boolean forwarding) throws jakarta.jms.JMSException {
        JMSProducer.sendReturn(sendResponse, message, messageImpl, forwarding, timeToDeliver, timeToLive, deliveryMode, priority, destination);
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : Successfully sent message " + message.getJMSMessageID());
        }
        this.producerFlowControl.updateFlowControl(sendResponse);
    }

    private static MessageImpl convertMessage(Message message) throws jakarta.jms.JMSException {
        try {
            if (message instanceof BytesMessage) {
                return new BytesMessageImpl((BytesMessage)message);
            }
            if (message instanceof MapMessage) {
                return new MapMessageImpl((MapMessage)message);
            }
            if (message instanceof ObjectMessage) {
                return new ObjectMessageImpl((ObjectMessage)message);
            }
            if (message instanceof StreamMessage) {
                return new StreamMessageImpl((StreamMessage)message);
            }
            if (message instanceof TextMessage) {
                return new TextMessageImpl((TextMessage)message);
            }
            return new HdrMessageImpl(message);
        }
        catch (IOException ioe) {
            throw JMSUtilities.jmsExceptionThrowable(JMSClientExceptionLogger.logErrorConvertingForeignMessageLoggable().getMessage(), ioe);
        }
    }

    @Override
    public void setDisableMessageID(boolean messageIdsDisabled) throws jakarta.jms.JMSException {
        this.checkClosed();
        this.messageIdsDisabled = messageIdsDisabled;
    }

    @Override
    public boolean getDisableMessageID() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.messageIdsDisabled;
    }

    @Override
    public void setDisableMessageTimestamp(boolean messageTimestampsDisabled) throws jakarta.jms.JMSException {
        this.checkClosed();
        this.messageTimestampsDisabled = messageTimestampsDisabled;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.messageTimestampsDisabled;
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidDeliveryModeLoggable());
        }
        this.deliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    @Override
    public void setPriority(int priority) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (priority < 0 || priority > 9) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidPriorityLoggable());
        }
        this.priority = priority;
    }

    @Override
    public int getPriority() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.priority;
    }

    @Override
    public long getTimeToDeliver() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.getTimeToDeliverInternal();
    }

    private long getTimeToDeliverInternal() {
        return this.timeToDeliver == -1L ? this.session.getConnection().getTimeToDeliver() : this.timeToDeliver;
    }

    @Override
    public void setTimeToDeliver(long timeToDeliver) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (timeToDeliver < -1L) {
            throw new jakarta.jms.JMSException(JMSClientExceptionLogger.logInvalidTimeToDeliverLoggable().getMessage());
        }
        this.timeToDeliver = timeToDeliver;
    }

    @Override
    public int getRedeliveryLimit() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.redeliveryLimit;
    }

    @Override
    public void setRedeliveryLimit(int redeliveryLimit) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (redeliveryLimit < -1) {
            throw new jakarta.jms.JMSException(JMSClientExceptionLogger.logInvalidRedeliveryLimitLoggable().getMessage());
        }
        this.redeliveryLimit = redeliveryLimit;
    }

    @Override
    public long getSendTimeout() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.sendTimeout;
    }

    @Override
    public void setSendTimeout(long sendTimeout) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (sendTimeout < 0L) {
            throw new jakarta.jms.JMSException(JMSClientExceptionLogger.logInvalidSendTimeoutLoggable().getMessage());
        }
        this.sendTimeout = sendTimeout;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws jakarta.jms.JMSException {
        this.checkClosed();
        this.timeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws jakarta.jms.JMSException {
        JMSID producerId;
        this.session.checkOpPermissionForAsyncSend("JMSProducer/MessageProducer.close()");
        JMSProducer jMSProducer = this;
        synchronized (jMSProducer) {
            JMSProducer lock;
            if (this.isClosed()) {
                return;
            }
            JMSProducer jMSProducer2 = lock = this.wlProducerImpl == null ? this : this.wlProducerImpl.getConnectionStateLock();
            synchronized (jMSProducer2) {
                producerId = this.producerId;
                this.producerId = null;
            }
        }
        this.waitTillAllJMSAsyncSendProcessed();
        this.session.producerClose(producerId);
    }

    @Override
    public void isCloseAllowed(String operation) throws jakarta.jms.JMSException {
    }

    boolean hasTemporaryDestination() {
        DestinationImpl stableDestination = this.destination;
        return stableDestination != null && (stableDestination.getType() == 4 || stableDestination.getType() == 8);
    }

    JMSSession getSession() {
        return this.session;
    }

    public String toString() {
        return this.session.getConnection().getRuntimeMBeanName() + "." + this.session.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    private void checkClosed() throws jakarta.jms.JMSException {
        if (this.isClosed()) {
            JMSProducer lock;
            JMSProducer jMSProducer = lock = this.wlProducerImpl == null ? this : this.wlProducerImpl.getConnectionStateLock();
            synchronized (jMSProducer) {
                if (this.isReconnectControllerClosed()) {
                    throw new AlreadyClosedException(JMSClientExceptionLogger.logClosedProducerLoggable());
                }
                throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
            }
        }
    }

    @Override
    public final void publicCheckClosed() throws jakarta.jms.JMSException {
        this.checkClosed();
    }

    @Override
    public int invoke(Request request) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setUnitOfOrder(String name) throws jakarta.jms.JMSException {
        this.checkClosed();
        if (this.peerInfo.getMajor() < 9) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedLoggable().getMessage());
        }
        this.unitOfOrderName = name;
    }

    @Override
    public void setUnitOfOrder() throws jakarta.jms.JMSException {
        this.setUnitOfOrder(this.session.getJMSID().toString());
    }

    @Override
    public String getUnitOfOrder() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.unitOfOrderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toFEProducer(Destination destination, Message message, MessageImpl messageImpl, int deliveryMode, long timeToDeliver, int priority, long timeToLive, boolean forwarding, CompletionListener jmsAppListener, weblogic.messaging.dispatcher.CompletionListener appListener) throws jakarta.jms.JMSException {
        PeerInfo pi;
        int dispatchMode;
        if (AsyncSendCallback.isMessageInAsyncSend(message)) {
            throw new IllegalStateException(JMSClientExceptionLogger.logAsyncSentMessageConcurrentSendLoggable("@" + message.hashCode()).getMessage());
        }
        boolean jmsAsyncOff = false;
        if (jmsAppListener != null && KernelStatus.isApplet()) {
            jmsAsyncOff = true;
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : In Applet Client,  turn off JMS 2.0 async send. destination=" + destination);
        }
        if (jmsAppListener != null && KernelStatus.isThinIIOPClient()) {
            jmsAsyncOff = true;
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : In Thin IIOP Client,  turn off JMS 2.0 async send. destination=" + destination);
        }
        JMSDispatcher dispatcher = this.session.getConnection().getFrontEndDispatcher();
        if (ONEWAYSENDENABLED) {
            this.oneWaySendMode = oneWaySendModeConf;
            this.oneWayWindowSize = oneWayWindowSizeConf;
        }
        boolean doOneWay = (this.oneWaySendMode == 1 || this.oneWaySendMode == 2 && ((DestinationImpl)destination).isTopic()) && !(destination instanceof DistributedDestinationImpl) && this.getUnitOfOrder() == null && messageImpl.getJMSDeliveryMode() == 1 && !((DestinationImpl)destination).isStale();
        doOneWay = doOneWay && ((DestinationImpl)destination).getDispatcherId().isSameServer(dispatcher.getId());
        doOneWay = doOneWay && jmsAppListener == null;
        JMSProducerSendResponse res = null;
        boolean messageHasId = false;
        AsyncSendCallback asyncSendCallback = null;
        if (appListener != null || jmsAppListener != null) {
            Object l = appListener == null ? jmsAppListener : appListener;
            asyncSendCallback = new AsyncSendCallback(this.destination == null ? (DestinationImpl)destination : this.destination, message, deliveryMode, timeToDeliver, priority, timeToLive, forwarding, l, jmsAsyncOff, this);
        }
        DestinationImpl destImpl = this.destination == null ? (DestinationImpl)destination : null;
        FEProducerSendRequest request = new FEProducerSendRequest(this.producerId, messageImpl, destImpl, this.sendTimeout, this.compressionThreshold, (destImpl == null || destImpl.isTopic()) && this.session.getConnection().isJMSSessionPooledInWrapper(), jmsAsyncOff ? null : asyncSendCallback);
        if (!this.session.isTransacted() && this.session.userTransactionsEnabled()) {
            dispatchMode = appListener != null ? 4 : (jmsAppListener != null & !jmsAsyncOff ? 6 : 0);
        } else if (this.session.isTransacted() || !doOneWay) {
            if (this.session.isTransacted()) {
                this.session.setPendingWork(true);
            }
            dispatchMode = appListener != null ? 5 : (jmsAppListener != null && !jmsAsyncOff ? 7 : 1);
        } else {
            this.producerFlowControl.disableFlowControl();
            if (this.count == Integer.MAX_VALUE) {
                this.count = 0;
            }
            if (++this.count % this.oneWayWindowSize == 1 || this.oneWayWindowSize <= 1 || this.totalConsecutiveOneWaySendMessageSize > ONEWAYSENDCONSECUTIVEMESSAGELIMIT) {
                this.totalConsecutiveOneWaySendMessageSize = 0;
                dispatchMode = appListener == null ? 2 : 5;
            } else {
                JMSMessageId id = messageImpl.getId();
                boolean bl = messageHasId = id != null;
                if (id == null) {
                    id = JMSMessageId.create();
                }
                res = new JMSProducerSendResponse(id);
                res.set90StyleMessageId();
                res.setDeliveryMode(1);
                res.setPriority(priority);
                res.setTimeToLive(timeToLive);
                res.setTimeToDeliver(timeToDeliver);
                res.setMessage(messageImpl);
                res.setRequest(request);
                request.setNoResponse(true);
                messageImpl.setId(id);
                if (messageImpl.getDeliveryTime() > 0L) {
                    res.setTimeToDeliver(messageImpl.getDeliveryTime());
                }
                dispatchMode = 3;
            }
        }
        messageImpl.setSerializeDestination(false);
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            String debugstr = jmsAppListener == null ? ", appListener=" + appListener : ", jmsAppListener=" + jmsAppListener + ", jmsAsyncOff=" + jmsAsyncOff;
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : Dispatching message to FRONTEND/FEProducer for destination: " + destination + debugstr + ", dispatch mode=" + dispatchMode + ", isJMSSessionPooledInWrapper=" + this.session.getConnection().isJMSSessionPooledInWrapper());
        }
        if (jmsAppListener != null && (dispatchMode == 7 || dispatchMode == 6) && (pi = this.getFEPeerInfo()).compareTo(PeerInfo.VERSION_1221) < 0) {
            throw new jakarta.jms.JMSException("Operation not supported by front-end server version [" + pi + "]: send message asynchronously");
        }
        if (dispatchMode == 0 || dispatchMode == 1 || dispatchMode == 2) {
            this.session.waitTillAllAsyncSendProcessed();
        } else if (jmsAppListener != null && !jmsAsyncOff) {
            this.session.blockAsyncSendIfOverPendingThreshold();
        }
        if (jmsAppListener != null) {
            this.session.enqueueAsyncSendCallback(asyncSendCallback);
        }
        Throwable sendCallThrowable = null;
        try {
            Response response;
            JMSID mysessionId;
            if (jmsAppListener != null) {
                asyncSendCallback.markAsyncSendStart();
            }
            if ((mysessionId = this.getSession().getJMSID()) == null) {
                throw new jakarta.jms.JMSException(JMSClientExceptionLogger.logSessionIsClosedLoggable().getMessage());
            }
            int mydispatchId = mysessionId.getCounter();
            switch (dispatchMode) {
                case 0: {
                    response = dispatcher.dispatchSyncTran(request);
                    break;
                }
                case 1: {
                    response = dispatcher.dispatchSyncNoTran(request);
                    break;
                }
                case 2: {
                    response = dispatcher.dispatchSyncNoTranWithId(request, mydispatchId);
                    break;
                }
                case 3: {
                    request.setResult(res);
                    dispatcher.dispatchNoReplyWithId(request, mydispatchId);
                    this.totalConsecutiveOneWaySendMessageSize += request.getDataLen();
                    response = res;
                    break;
                }
                case 4: {
                    dispatcher.dispatchAsync(request);
                    Object var26_25 = null;
                    return var26_25;
                }
                case 5: {
                    Transaction transaction = TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
                    try {
                        dispatcher.dispatchAsync(request);
                    }
                    finally {
                        if (transaction != null) {
                            TransactionHelper.getTransactionHelper().getTransactionManager().forceResume(transaction);
                        }
                    }
                    Object var27_30 = null;
                    return var27_30;
                }
                case 6: {
                    dispatcher.dispatchAsyncWithId(request, mydispatchId);
                    Object var27_31 = null;
                    return var27_31;
                }
                case 7: {
                    Transaction transaction = TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
                    try {
                        dispatcher.dispatchAsyncWithId(request, mydispatchId);
                    }
                    finally {
                        if (transaction != null) {
                            TransactionHelper.getTransactionHelper().getTransactionManager().forceResume(transaction);
                        }
                    }
                    Object var27_32 = null;
                    return var27_32;
                }
                default: {
                    throw new jakarta.jms.JMSException("JMSProducer: Unexpected dispatchMode=" + dispatchMode);
                }
            }
            this.wrappedSendReturn((JMSProducerSendResponse)response, destination, message, messageImpl, deliveryMode, timeToDeliver, priority, timeToLive, forwarding);
            if (appListener != null) {
                request.onCompletion(response);
            }
            Response response2 = response;
            return response2;
        }
        catch (Throwable e) {
            sendCallThrowable = e;
            if (dispatchMode == 3 && !messageHasId) {
                messageImpl.setId(null);
            }
            if (e instanceof jakarta.jms.JMSException) {
                throw (jakarta.jms.JMSException)e;
            }
            throw new JMSException(JMSClientExceptionLogger.logErrorSendingMessageLoggable(), e);
        }
        finally {
            messageImpl.setSerializeDestination(true);
            if (asyncSendCallback != null) {
                if (jmsAppListener != null) {
                    asyncSendCallback.setMessageSize(request.getDataLen(), messageImpl.size());
                    if (sendCallThrowable == null) {
                        asyncSendCallback.onSendCallSuccessReturn();
                    } else {
                        asyncSendCallback.onSendCallReturn();
                    }
                } else if (appListener != null && sendCallThrowable != null) {
                    request.onException(sendCallThrowable);
                }
            }
        }
    }

    JMSProducerSendResponse completeAsyncSend(Object response, FEProducerSendRequest request, DestinationImpl destination, Message messageState, MessageImpl message, int deliveryModeState, long timeToDeliverState, int priorityState, long timeToLiveState, boolean forwardingState) throws Exception {
        request.getMessage().setSerializeDestination(true);
        JMSProducerSendResponse sendResponse = (JMSProducerSendResponse)response;
        this.wrappedSendReturn(sendResponse, destination, messageState, message, deliveryModeState, timeToDeliverState, priorityState, timeToLiveState, forwardingState);
        sendResponse.setMessage(messageState);
        sendResponse.setAsyncFlowControlTime(this.producerFlowControl.getWLAsyncSendFlowControlTime());
        return sendResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAsyncSendPending() {
        Object object = this.asyncSendCountLock;
        synchronized (object) {
            return this.jmsAsyncSendCount > 0L || this.wlAsyncSendCount > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementWLAsyncSendCount() {
        Object object = this.asyncSendCountLock;
        synchronized (object) {
            ++this.wlAsyncSendCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementWLAsyncSendCount() {
        Object object = this.asyncSendCountLock;
        synchronized (object) {
            --this.wlAsyncSendCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementJMSAsyncSendCount() {
        Object object = this.asyncSendCountLock;
        synchronized (object) {
            ++this.jmsAsyncSendCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementJMSAsyncSendCount() {
        Object object = this.asyncSendCountLock;
        synchronized (object) {
            --this.jmsAsyncSendCount;
            this.asyncSendCountLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitTillAllJMSAsyncSendProcessed() throws jakarta.jms.JMSException {
        Object object = this.asyncSendCountLock;
        synchronized (object) {
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer.waitTillAllJMSAsyncSendProcessed(): jmsAsyncSendCount=" + this.jmsAsyncSendCount + ", this=" + this);
            }
            while (this.jmsAsyncSendCount != 0L) {
                try {
                    this.asyncSendCountLock.wait();
                    if (!JMSDebug.JMSMessagePath.isDebugEnabled()) continue;
                    JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer.waitTillAllJMSAsyncSendProcessed(): wait waked up: jmsAsyncSendCount=" + this.jmsAsyncSendCount + ", this=" + this);
                }
                catch (InterruptedException e) {
                    JMSClientExceptionLogger.logStackTrace(e);
                }
            }
        }
    }

    @Override
    public void forward(Destination destination, Message message) throws jakarta.jms.JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        this.forwardInternal(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void forward(Message message) throws jakarta.jms.JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestinationLoggable().getMessage());
        }
        this.forwardInternal(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void forward(Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestinationLoggable().getMessage());
        }
        this.forwardInternal(this.destination, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void forward(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestination2Loggable().getMessage());
        }
        this.forwardInternal(destination, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void setSequence(String name) throws jakarta.jms.JMSException {
        if (this.peerInfo.getMajor() < 9) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedLoggable().getMessage());
        }
        this.sequenceName = name;
    }

    @Override
    public String getSequence() throws jakarta.jms.JMSException {
        return this.sequenceName;
    }

    @Override
    public void reserveUnitOfOrderWithSequence() throws jakarta.jms.JMSException {
        this.processSequenceInternal(196608, this.destination, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void reserveSequence(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        this.processSequenceInternal(196608, destination, deliveryMode, priority, timeToLive);
    }

    @Override
    public void releaseSequenceAndUnitOfOrder(boolean fanout) throws jakarta.jms.JMSException {
        int opcode = fanout ? 65536 : 131072;
        this.processSequenceInternal(opcode, this.destination, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void releaseSequenceAndUnitOfOrder(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean fanout) throws jakarta.jms.JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        int opcode = fanout ? 65536 : 131072;
        this.processSequenceInternal(opcode, destination, deliveryMode, priority, timeToLive);
    }

    private void processSequenceInternal(int opcode, Destination destination, int deliveryMode, int priority, long timeToLive) throws jakarta.jms.JMSException {
        if (this.peerInfo.getMajor() < 9) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedLoggable().getMessage());
        }
        if (this.sequenceName == null) {
            throw new UnsupportedOperationException("null sequence not permitted");
        }
        HdrMessageImpl hdrMessage = new HdrMessageImpl();
        hdrMessage.setSAFSequenceName(this.sequenceName);
        hdrMessage.setControlOpcode(opcode);
        this.deliveryInternal(destination, hdrMessage, deliveryMode, priority, timeToLive, false, null);
    }

    void setWlProducerImpl(WLProducerImpl rp) {
        this.wlProducerImpl = rp;
    }

    void setDestinationFlags(byte destFlags) {
        this.destinationFlags = destFlags;
    }

    public void sendAsync(Message message, weblogic.messaging.dispatcher.CompletionListener listener) {
        try {
            this.sendWithListener(listener, message);
        }
        catch (jakarta.jms.JMSException e) {
            listener.onException(e);
        }
    }

    public void sendAsync(Message message, int deliveryMode, int priority, long timeToLive, weblogic.messaging.dispatcher.CompletionListener listener) {
        try {
            this.sendWithListener(listener, message, deliveryMode, priority, timeToLive);
        }
        catch (jakarta.jms.JMSException e) {
            listener.onException(e);
        }
    }

    public void sendAsync(Destination destination, Message message, weblogic.messaging.dispatcher.CompletionListener listener) {
        try {
            this.sendWithListener(listener, destination, message);
        }
        catch (jakarta.jms.JMSException e) {
            listener.onException(e);
        }
    }

    public void sendAsync(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, weblogic.messaging.dispatcher.CompletionListener listener) {
        try {
            this.sendWithListener(listener, destination, message, deliveryMode, priority, timeToLive);
        }
        catch (jakarta.jms.JMSException e) {
            listener.onException(e);
        }
    }

    @Override
    public long getDeliveryDelay() throws jakarta.jms.JMSException {
        this.checkClosed();
        return this.timeToDeliver;
    }

    @Override
    public void send(Message message, CompletionListener jmsAppListener) throws jakarta.jms.JMSException {
        if (jmsAppListener == null) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logCompletionListenerIsNullLoggable().getMessage());
        }
        this.sendWithListenerUnified(jmsAppListener, null, message);
    }

    @Override
    public void send(Destination destination, Message message, CompletionListener jmsAppListener) throws jakarta.jms.JMSException {
        if (jmsAppListener == null) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logCompletionListenerIsNullLoggable().getMessage());
        }
        this.sendWithListenerUnified(jmsAppListener, null, destination, message);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener jmsAppListener) throws jakarta.jms.JMSException {
        if (jmsAppListener == null) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logCompletionListenerIsNullLoggable().getMessage());
        }
        this.sendWithListenerUnified(jmsAppListener, null, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener jmsAppListener) throws jakarta.jms.JMSException {
        if (jmsAppListener == null) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logCompletionListenerIsNullLoggable().getMessage());
        }
        this.sendWithListenerUnified(jmsAppListener, null, destination, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void setDeliveryDelay(long delay) throws jakarta.jms.JMSException {
        this.setTimeToDeliver(delay);
    }

    static {
        try {
            if (System.getProperty("weblogic.jms.client.onewaysendconfigs") != null) {
                ONEWAYSENDENABLED = true;
                String conf = System.getProperty("weblogic.jms.client.onewaysendconfigs");
                StringTokenizer st = new StringTokenizer(conf);
                if (st.hasMoreTokens()) {
                    oneWaySendModeConf = JMSConnection.convertOneWaySendMode(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    oneWayWindowSizeConf = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    ONEWAYSENDCONSECUTIVEMESSAGELIMIT = Integer.parseInt(st.nextToken());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private class ProducerFlowControl {
        private boolean flowControlEnabled;
        private final int flowMinimum;
        private final int flowMaximum;
        private final double flowDecrease;
        private final int flowIncrease;
        private final long flowInterval;
        private double flowRateCurrent;
        private long backOffTime;
        private boolean needsFlowControl;
        private long currentTime;
        private long elapsedTime;
        private long lastTimeChanged;
        private long lastTimeLeave;
        private long wlAsyncSendFlowControlTime;
        private final ReentrantLock flowcontrolLock = new ReentrantLock();

        public ProducerFlowControl(JMSConnection con) {
            this.flowControlEnabled = con.isFlowControlEnabled();
            this.flowMinimum = con.getFlowMinimum();
            this.flowMaximum = con.getFlowMaximum();
            this.flowIncrease = con.getFlowIncrease();
            this.flowDecrease = con.getFlowDecrease();
            this.flowInterval = con.getFlowInterval();
            this.flowRateCurrent = this.flowMaximum;
            this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
        }

        void disableFlowControl() {
            if (this.flowControlEnabled) {
                this.flowControlEnabled = false;
            }
        }

        final void updateFlowControl(JMSProducerSendResponse sendResponse) {
            if (JMSProducer.this.hasAsyncSendPending()) {
                this.flowcontrolLock.lock();
                try {
                    this.updateFlowControlInternal(sendResponse);
                }
                finally {
                    this.flowcontrolLock.unlock();
                }
            } else {
                this.updateFlowControlInternal(sendResponse);
            }
        }

        private final void updateFlowControlInternal(JMSProducerSendResponse sendResponse) {
            if (!this.flowControlEnabled || sendResponse == null) {
                return;
            }
            if (sendResponse.getNeedsFlowControl()) {
                this.needsFlowControl = true;
                if (sendResponse.getFlowControlTime() == -1L) {
                    if (this.flowRateCurrent > (double)this.flowMaximum) {
                        this.flowRateCurrent = this.flowMaximum;
                    }
                    if (this.currentTime - this.lastTimeChanged >= this.flowInterval && this.flowRateCurrent > (double)this.flowMinimum) {
                        this.flowRateCurrent *= this.flowDecrease;
                        if (this.flowRateCurrent < (double)this.flowMinimum) {
                            this.flowRateCurrent = this.flowMinimum;
                        }
                        this.lastTimeChanged = this.currentTime;
                        this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
                    }
                } else {
                    this.backOffTime = sendResponse.getFlowControlTime();
                }
                this.lastTimeLeave = this.currentTime;
            } else {
                this.needsFlowControl = false;
                if (this.currentTime - this.lastTimeChanged >= this.flowInterval && this.flowRateCurrent < (double)this.flowMaximum) {
                    this.flowRateCurrent += (double)this.flowIncrease;
                    this.lastTimeChanged = this.currentTime;
                    this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
                }
            }
        }

        final void doFlowControl() {
            long sleepTime = this.getFlowControlSleepTime();
            if (sleepTime == 0L) {
                return;
            }
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + JMSProducer.this.producerId + ") : doFlowControl sleep(" + sleepTime + ")");
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private final long getFlowControlSleepTime() {
            if (JMSProducer.this.hasAsyncSendPending()) {
                this.flowcontrolLock.lock();
                try {
                    long l = this.getFlowControlSleepTimeInternal();
                    return l;
                }
                finally {
                    this.flowcontrolLock.unlock();
                }
            }
            return this.getFlowControlSleepTimeInternal();
        }

        private final long getFlowControlSleepTimeInternal() {
            if (!this.flowControlEnabled) {
                return 0L;
            }
            this.currentTime = System.currentTimeMillis();
            this.elapsedTime = this.currentTime - this.lastTimeLeave;
            long sleepTime = 0L;
            if (this.flowControlEnabled && (this.needsFlowControl || this.flowRateCurrent <= (double)this.flowMaximum) && this.elapsedTime <= this.backOffTime) {
                sleepTime = this.backOffTime - this.elapsedTime;
                this.currentTime = System.currentTimeMillis() + sleepTime;
            }
            return sleepTime;
        }

        final void markWLAsyncSendFlowControlTime() {
            this.wlAsyncSendFlowControlTime = this.getFlowControlSleepTime();
        }

        final long getWLAsyncSendFlowControlTime() {
            return this.wlAsyncSendFlowControlTime;
        }
    }
}

