/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSession;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.security.auth.Subject;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.JMSExceptionContext;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.client.LockedMap;
import weblogic.jms.client.ProviderInfo;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.client.XAConnectionInternalImpl;
import weblogic.jms.client.XASessionInternalImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.JMSWorkManager;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.PasswordStore;
import weblogic.jms.common.PeerVersionable;
import weblogic.jms.dispatcher.DispatcherPartition4rmic;
import weblogic.jms.dispatcher.DispatcherPartitionContext;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.SecurityDispatcherWrapper;
import weblogic.jms.frontend.FEConnectionCloseRequest;
import weblogic.jms.frontend.FEConnectionSetClientIdRequest;
import weblogic.jms.frontend.FEConnectionStartRequest;
import weblogic.jms.frontend.FEConnectionStopRequest;
import weblogic.jms.frontend.FERemoveSubscriptionRequest;
import weblogic.jms.frontend.FESessionCreateRequest;
import weblogic.jms.frontend.FESessionCreateResponse;
import weblogic.jms.frontend.FETemporaryDestinationDestroyRequest;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherStateChangeListener;
import weblogic.messaging.dispatcher.DispatcherWrapperState;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.NestedThrowable;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class JMSConnection
implements ConnectionInternal,
DispatcherStateChangeListener,
Externalizable,
Invocable,
Runnable,
Reconnectable,
Cloneable,
TimerListener {
    static final long serialVersionUID = 7025750175126041724L;
    private static final AbstractSubject KernelID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    public static final byte EXTVERSION61 = 1;
    public static final byte EXTVERSION70 = 3;
    public static final byte EXTVERSION81 = 4;
    public static final byte EXTVERSION90 = 5;
    public static final byte EXTVERSION910 = 6;
    public static final byte EXTVERSION920 = 7;
    public static final byte EXTVERSION1033 = 8;
    public static final byte EXTVERSION122140 = 9;
    private static final byte VERSION_MASK = 15;
    private static final byte TIMEOUT_MASK = 64;
    private static final byte EXTVERSION = 9;
    private static final byte COMPRESSION_MASK = 1;
    private static final byte UNIT_OF_ORDER_MASK = 2;
    private static final byte SUBJECT_MASK = 4;
    public static final int SYNCHRONOUS_PREFETCH_DISABLED = 0;
    public static final int SYNCHRONOUS_PREFETCH_ENABLED = 1;
    public static final int SYNCHRONOUS_PREFETCH_TOPIC_SUBSCRIBER_ONLY = 2;
    public static final int ONE_WAY_SEND_DISABLED = 0;
    public static final int ONE_WAY_SEND_ENABLED = 1;
    public static final int ONE_WAY_SEND_TOPIC_ONLY = 2;
    static final int TYPE_UNSPECIFIED = 0;
    static final int TYPE_QUEUE = 1;
    static final int TYPE_TOPIC = 2;
    private JMSID connectionId;
    private String clientId;
    private int clientIdPolicy = 0;
    private int subscriptionSharingPolicy = 0;
    private int type;
    private int deliveryMode;
    private int priority;
    private long timeToDeliver;
    private long timeToLive;
    private long sendTimeout;
    private long redeliveryDelay;
    private boolean userTransactionsEnabled;
    private boolean allowCloseInOnMessage;
    private long transactionTimeout;
    private boolean isLocal;
    private int messagesMaximum;
    private int overrunPolicy;
    private int acknowledgePolicy;
    private String wlsServerName;
    private String runtimeMBeanName;
    private transient int refCount;
    private boolean flowControl;
    private int flowMinimum;
    private int flowMaximum;
    private double flowDecrease;
    private int flowIncrease;
    private long flowInterval;
    private boolean xaServerEnabled;
    private String unitOfOrder;
    private int synchronousPrefetchMode = 0;
    private boolean stopped = true;
    private final Object sublock = new Object();
    private LockedMap sessions = new LockedMap("sessions", null);
    private LockedMap durableSubscribers = new LockedMap("durables", null);
    private JMSDispatcher dispatcher;
    private DispatcherWrapper dispatcherWrapper;
    private JMSExceptionContext exceptionContext;
    private boolean firedExceptoinListener;
    private PeerVersionable peerVersionable;
    private byte version = (byte)9;
    private PeerInfo peerInfo;
    private String dispatchPolicyName = JMSWorkManager.getJMSSessionOnMessageWMName();
    private int compressionThreshold = Integer.MAX_VALUE;
    private int pipelineGeneration = 0;
    private WLConnectionImpl wlConnectionImpl;
    private JMSConnection preDisconnectState;
    private JMSConnection replacementConnection;
    private JMSConnection originalConnection;
    private PasswordStore pwdStore;
    private Object uHandle;
    private Object pHandle;
    private boolean bReplacement;
    public int oneWaySendMode;
    public int oneWaySendWindowSize;
    private int reconnectPolicy = 7;
    private long reconnectBlockingMillis = 60000L;
    private long totalReconnectPeriodMillis = -1L;
    private boolean wantXAConnection;
    private volatile boolean isClosed;
    private static int INITIAL_RETRY_DELAY = 125;
    private long nextRetry = INITIAL_RETRY_DELAY;
    private static final long RETRY_DELAY_MAXIMUM = 300000L;
    private static final int RETRY_DELAY_LEFT_SHIFT = 1;
    private static final int RETRY_DELAY_MIN_INTERVAL = 5000;
    private volatile Timer timer;
    private static final String RECONNECT_ID = "weblogic.jms.Reconnect";
    private static final Object TIMER_WORKMANAGER_LOCK = new Object();
    private static WorkManager RECONNECT_WORK_MANAGER;
    private static TimerManager RECONNECT_TIMER_MANAGER;
    private static final boolean isT3Client;
    private final Object acknowledgePolicyLock = new Object();
    private DestinationImpl inboundDest;
    private Hashtable jndiEnv;
    private boolean isWrappedIC = false;
    private AbstractSubject subject = null;
    private transient boolean jmsSessionPooledInWrapper = false;
    transient DispatcherPartitionContext clientDispatcherPartitionContext;

    public JMSConnection(JMSID connectionId, String clientId, int clientIdPolicy, int subscriptionSharingPolicy, int deliveryMode, int priority, long timeToDeliver, long timeToLive, long sendTimeout, long redeliveryDelay, long transactionTimeout, boolean userTransactionsEnabled, boolean allowCloseInOnMessage, int messagesMaximum, int overrunPolicy, int acknowledgePolicy, boolean isLocal, DispatcherWrapper dispatcherWrapper, boolean flowControl, int flowMinimum, int flowMaximum, int flowInterval, int flowSteps, boolean xaServerEnabled, String unitOfOrder, PeerVersionable peerVersionable, String wlsServerName, String runtimeMBeanName, PeerInfo peerInfo, int compressionThreshold, int synchronousPrefetchMode, int oneWaySendMode, int oneWaySendWindowSize, int reconnectPolicy, long reconnectBlockingMillis, long totalReconnectPeriodMillis) {
        this.peerVersionable = peerVersionable;
        this.connectionId = connectionId;
        this.clientId = clientId;
        this.clientIdPolicy = clientIdPolicy;
        this.subscriptionSharingPolicy = subscriptionSharingPolicy;
        this.unitOfOrder = unitOfOrder;
        this.deliveryMode = deliveryMode;
        this.priority = priority;
        this.timeToDeliver = timeToDeliver;
        this.timeToLive = timeToLive;
        this.sendTimeout = sendTimeout;
        this.redeliveryDelay = redeliveryDelay;
        this.transactionTimeout = transactionTimeout;
        this.userTransactionsEnabled = userTransactionsEnabled;
        this.allowCloseInOnMessage = allowCloseInOnMessage;
        this.messagesMaximum = messagesMaximum;
        this.overrunPolicy = overrunPolicy;
        this.acknowledgePolicy = acknowledgePolicy;
        this.isLocal = isLocal;
        this.dispatcherWrapper = dispatcherWrapper;
        this.xaServerEnabled = xaServerEnabled;
        this.flowControl = flowControl;
        this.flowMinimum = flowMinimum;
        this.flowMaximum = flowMaximum;
        this.wlsServerName = wlsServerName;
        this.runtimeMBeanName = runtimeMBeanName;
        this.flowIncrease = (flowMaximum - flowMinimum) / flowSteps;
        if (this.flowIncrease < 1) {
            this.flowIncrease = 1;
        }
        this.flowDecrease = (double)flowMinimum / (double)flowMaximum;
        this.flowDecrease = Math.pow(this.flowDecrease, 1.0 / (double)flowSteps);
        this.flowInterval = flowInterval * 1000 / flowSteps;
        if (this.flowInterval < 1L) {
            this.flowInterval = 1L;
        }
        this.peerInfo = peerInfo;
        if (PeerInfo.VERSION_DIABLO.compareTo(peerInfo) <= 0) {
            this.pipelineGeneration = 0xF00000;
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("pipelineGeneration is " + JMSPushEntry.displayRecoverGeneration(this.pipelineGeneration));
        }
        this.compressionThreshold = compressionThreshold;
        this.synchronousPrefetchMode = synchronousPrefetchMode;
        this.oneWaySendMode = oneWaySendMode;
        this.oneWaySendWindowSize = oneWaySendWindowSize;
        this.internalSetReconnect(reconnectPolicy, reconnectBlockingMillis, totalReconnectPeriodMillis);
    }

    private void internalSetReconnect(int reconnectPolicy, long reconnectBlockingMillis, long totalReconnectPeriodMillis) {
        if (JMSConnection.isT3Client()) {
            this.reconnectPolicy = reconnectPolicy;
            this.reconnectBlockingMillis = reconnectBlockingMillis;
            this.totalReconnectPeriodMillis = totalReconnectPeriodMillis;
        } else {
            this.reconnectPolicy = 0;
            this.reconnectBlockingMillis = 0L;
            this.totalReconnectPeriodMillis = 0L;
        }
    }

    static boolean isT3Client() {
        return isT3Client;
    }

    final void setupDispatcher(Subject connSub, DispatcherPartitionContext clientDPC) throws DispatcherException {
        this.clientDispatcherPartitionContext = clientDPC;
        if (!(this.dispatcherWrapper.getRemoteDispatcher() instanceof DispatcherImpl) && !this.clientDispatcherPartitionContext.isLocal(this.dispatcherWrapper)) {
            DispatcherId newdId = new DispatcherId(this.dispatcherWrapper.getId(), this.connectionId.getCounter());
            this.dispatcherWrapper.setId(newdId);
        }
        this.dispatcher = this.clientDispatcherPartitionContext.dispatcherAdapterOrPartitionAdapter(this.dispatcherWrapper);
        if (connSub != null) {
            this.dispatcher = new SecurityDispatcherWrapper(connSub, this.dispatcher, this.clientDispatcherPartitionContext);
        }
        this.dispatcher.addDispatcherPeerGoneListener(this);
    }

    final void setType(int type) {
        this.type = type;
    }

    final int getType() {
        return this.type;
    }

    @Override
    public final ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool serverSessionPool, int messagesMaximum) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, messageSelector, serverSessionPool, messagesMaximum);
    }

    @Override
    public final ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int messagesMaximum) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation5Loggable().getMessage());
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logUnsupportedSharedConnectionConsumerLoggable());
    }

    @Override
    public final ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool pool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation5Loggable().getMessage());
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logUnsupportedSubscriptionLoggable());
    }

    @Override
    public final ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool pool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.type == 1) {
            throw new IllegalStateException(JMSClientExceptionLogger.logUnsupportedTopicOperation5Loggable().getMessage());
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logUnsupportedSharedDurableConnectionConsumerLoggable());
    }

    @Override
    public final QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (acknowledgeMode == 128) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoMulticastOnQueueSessionsLoggable());
        }
        SessionInternal rsession = this.createSessionInternal(transacted, acknowledgeMode, false, 2);
        return rsession;
    }

    @Override
    public final TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        SessionInternal rsession = this.createSessionInternal(transacted, acknowledgeMode, false, 1);
        return rsession;
    }

    @Override
    public final Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSessionInternal(transacted, acknowledgeMode, false, 0);
    }

    @Override
    public Session createSession() throws JMSException {
        return this.createSession(1);
    }

    @Override
    public Session createSession(int sessionMode) throws JMSException {
        if (sessionMode == 0) {
            return this.createSession(true, 0);
        }
        return this.createSession(false, sessionMode);
    }

    protected final SessionInternal createSessionInternal(boolean transacted, int acknowledgeMode, boolean createXaSession, int sessionType) throws JMSException {
        JMSSession session = this.setupJMSSession(transacted, acknowledgeMode, createXaSession, sessionType);
        WLSessionImpl recSess = createXaSession ? new XASessionInternalImpl((JMSXASession)session, (XAConnectionInternalImpl)this.wlConnectionImpl) : new WLSessionImpl(session, this.wlConnectionImpl);
        session.setWLSessionImpl(recSess);
        return recSess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSSession setupJMSSession(boolean transacted, int acknowledgeMode, boolean createXaSession, int sessionType) throws JMSException {
        JMSSession session;
        if (createXaSession) {
            transacted = false;
            acknowledgeMode = 2;
            session = new JMSXASession(this, transacted, this.isStopped());
        } else {
            session = new JMSSession(this, transacted, acknowledgeMode, this.isStopped());
        }
        session.setType(sessionType);
        if (this.xaServerEnabled && KernelStatus.isServer()) {
            session.setUserTransactionsEnabled(true);
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FESessionCreateRequest(this.connectionId, transacted, createXaSession, acknowledgeMode, null));
        session.setId(((FESessionCreateResponse)response).getSessionId());
        session.setRuntimeMBeanName(((FESessionCreateResponse)response).getRuntimeMBeanName());
        session.setUnitOfOrder(this.unitOfOrder);
        JMSConnection jMSConnection = this;
        synchronized (jMSConnection) {
            this.sessionAdd(session);
        }
        return session;
    }

    @Override
    public final JMSDispatcher getFrontEndDispatcher() throws JMSException {
        if (this.isClosed()) {
            Object object = this.wlConnectionImpl.getConnectionStateLock();
            synchronized (object) {
                if (this.isReconnectControllerClosed()) {
                    throw new IllegalStateException(JMSClientExceptionLogger.logClosedConnectionLoggable().getMessage());
                }
                throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
            }
        }
        return this.dispatcher;
    }

    private void sessionAdd(JMSSession session) throws JMSException {
        if (this.sessions.put(session.getJMSID(), session) != null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logDuplicateSessionLoggable());
        }
        if (this.isStopped()) {
            session.stop();
        } else {
            session.start();
        }
        InvocableManagerDelegate delegate = this.clientDispatcherPartitionContext.getInvocableManagerDelegate();
        delegate.invocableAdd(4, session);
    }

    final synchronized void sessionRemove(JMSID sessionId) throws JMSException {
        if (this.sessions.remove(sessionId) != null) {
            InvocableManagerDelegate delegate = this.clientDispatcherPartitionContext.getInvocableManagerDelegate();
            delegate.invocableRemove(4, sessionId);
        }
    }

    @Override
    public final ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool serverSessionPool, int messagesMaximum) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, messageSelector, serverSessionPool, messagesMaximum);
    }

    @Override
    public final synchronized String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientId;
    }

    final synchronized String getClientIDInternal() {
        return this.clientId;
    }

    @Override
    public final synchronized void setClientID(String clientId) throws JMSException {
        this.setClientIDInternal(clientId, this.clientIdPolicy);
    }

    @Override
    public final synchronized void setClientID(String clientId, String clientIdPolicy) throws IllegalArgumentException, JMSException {
        this.setClientIDInternal(clientId, WLConnectionImpl.validateAndConvertClientIdPolicy(clientIdPolicy));
    }

    public final synchronized void setClientIDInternal(String clientId, int clientIdPolicy) throws JMSException {
        if (this.clientId != null) {
            throw new IllegalStateException(JMSClientExceptionLogger.logClientIDSetLoggable(clientId, this.clientId).getMessage());
        }
        if (clientId == null) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNullClientIDLoggable());
        }
        if (clientId.length() == 0) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logZeroClientIDLoggable());
        }
        if (this.inboundDest != null && this.inboundDest.isOneCopyPerServer()) {
            String serverId = null;
            try {
                serverId = System.getProperty("weblogic.jms.ra.providers.wl.ServerID");
            }
            catch (Exception e) {
                throw new JMSException("Fail to get serverId which is necessary for inbound connection to achieve One-Copy-Per-Server distribution mode.");
            }
            if (serverId == null || serverId.length() == 0) {
                throw new JMSException("serverId cannot be null for inbound connection to achieve One-Copy-Per-Server distribution mode. Please use system property 'weblogic.jms.ra.providers.wl.ServerID' to set it.");
            }
            clientId = clientId + "." + serverId;
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionSetClientIdRequest(this.connectionId, clientId, clientIdPolicy));
        this.clientId = clientId;
        this.clientIdPolicy = clientIdPolicy;
    }

    @Override
    public String getClientIDPolicy() {
        return WLConnectionImpl.convertClientIdPolicy(this.clientIdPolicy);
    }

    @Override
    public String getSubscriptionSharingPolicy() {
        return JMSConnection.getSubscriptionSharingPolicyAsString(this.subscriptionSharingPolicy);
    }

    public int getSubscriptionSharingPolicyAsInt() {
        return this.subscriptionSharingPolicy;
    }

    @Override
    public void setSubscriptionSharingPolicy(String subscriptionSharingPolicy) throws JMSException, IllegalArgumentException {
        int subscriptionSharingPolicyInt;
        this.subscriptionSharingPolicy = subscriptionSharingPolicyInt = JMSConnection.getSubscriptionSharingPolicyAsInt(subscriptionSharingPolicy);
    }

    public int getClientIDPolicyInt() {
        return this.clientIdPolicy;
    }

    public static int getSubscriptionSharingPolicyAsInt(String policy) {
        if (policy.equals(JMSConstants.SUBSCRIPTION_EXCLUSIVE)) {
            return 0;
        }
        if (policy.equals(JMSConstants.SUBSCRIPTION_SHARABLE)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + policy);
    }

    public static String getSubscriptionSharingPolicyAsString(int policy) {
        switch (policy) {
            case 0: {
                return JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            }
            case 1: {
                return JMSConstants.SUBSCRIPTION_SHARABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + policy);
    }

    @Override
    public final ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this;
    }

    @Override
    public final synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionContext = new JMSExceptionContext(listener, this.isInbound());
    }

    void copyExceptionContext(JMSConnection old) {
        this.exceptionContext = old.exceptionContext;
    }

    synchronized boolean isStopped() {
        return this.stopped;
    }

    @Override
    public final synchronized void start() throws JMSException {
        JMSException savedException = null;
        this.checkClosed();
        if (!this.stopped) {
            return;
        }
        for (JMSSession session : this.sessions.values()) {
            try {
                session.start();
            }
            catch (JMSException jmse) {
                if (savedException != null) continue;
                savedException = jmse;
            }
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStartRequest(this.connectionId));
        this.stopped = false;
        if (savedException != null) {
            throw savedException;
        }
    }

    private synchronized void resume(JMSConnection pds) throws JMSException {
        for (JMSSession session : this.sessions.values()) {
            session.resume();
        }
        this.stopped = true;
        if (pds.stopped) {
            return;
        }
        Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStartRequest(this.connectionId));
        this.stopped = false;
    }

    @Override
    public final synchronized void stop() throws JMSException {
        this.checkClosed();
        this.isCloseAllowed("stop");
        JMSException savedException = null;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.isConnected()) {
            Response response = this.getFrontEndDispatcher().dispatchSync(new FEConnectionStopRequest(this.connectionId));
        }
        for (JMSSession session : this.sessions.values()) {
            try {
                session.stop();
            }
            catch (JMSException jmse) {
                if (savedException != null) continue;
                savedException = jmse;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
    }

    @Override
    public final void close() throws JMSException {
        this.mergedCloseAndOnException(null, true);
    }

    @Override
    public void isCloseAllowed(String operation) throws JMSException {
        Iterator iterator = this.sessions.cloneValuesIterator();
        while (iterator != null && iterator.hasNext()) {
            JMSSession session = (JMSSession)iterator.next();
            if (operation != null && operation.equals("close")) {
                session.checkOpPermissionForAsyncSend("Connection.close()");
            }
            if (this.allowCloseInOnMessage || session.isOperationAllowed()) continue;
            throw new IllegalStateException(JMSClientExceptionLogger.logInvalidCloseFromListenerLoggable(operation, "Connection").getMessage());
        }
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public final ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool serverSessionPool, int messagesMaximum) throws JMSException {
        this.checkClosed();
        return JMSEnvironment.getJMSEnvironment().createConnectionConsumer(destination, messageSelector, serverSessionPool, messagesMaximum, this.getFrontEndDispatcher(), this.getJMSID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupConnection(JMSException savedException, boolean throwOnServerDisc) throws JMSException {
        Externalizable externalizable = this;
        synchronized (externalizable) {
            Object object = this.wlConnectionImpl.getConnectionStateLock();
            synchronized (object) {
                this.markClosed();
            }
            this.stopped = true;
        }
        try {
            block24: {
                try {
                    if (this.isConnected()) {
                        externalizable = this.dispatcher.dispatchSync(new FEConnectionCloseRequest(this.connectionId));
                    }
                }
                catch (JMSException jmse) {
                    if (!throwOnServerDisc) break block24;
                    throw jmse;
                }
            }
            if (throwOnServerDisc && savedException != null) {
                throw savedException;
            }
        }
        finally {
            block26: {
                if (this.clientDispatcherPartitionContext != null) {
                    try {
                        InvocableManagerDelegate delegate = this.clientDispatcherPartitionContext.getInvocableManagerDelegate();
                        delegate.invocableRemove(3, this.getJMSID());
                        this.clientDispatcherPartitionContext.unexportLocalDispatcher();
                    }
                    catch (JMSException ignoreException) {
                        if (!JMSDebug.JMSDispatcherVerbose.isDebugEnabled()) break block26;
                        JMSDebug.JMSDispatcherVerbose.debug(ignoreException.getMessage(), ignoreException);
                    }
                }
            }
            try {
                DispatcherPartitionContext dpc = JMSEnvironment.getJMSEnvironment().lookupDispatcherPartitionContextById(this.clientDispatcherPartitionContext.getPartitionId());
                if (dpc != null) {
                    dpc.removeDispatcherReference(this.dispatcher);
                }
            }
            finally {
                this.dispatcher.removeDispatcherPeerGoneListener(this);
            }
        }
    }

    boolean isConnected() {
        return this.dispatcher.isLocal() || this.dispatcher.getDelegate() instanceof DispatcherWrapperState && !((DispatcherWrapperState)this.dispatcher.getDelegate()).getPeerGoneCache();
    }

    /*
     * Exception decompiling
     */
    private void mergedCloseAndOnException(JMSException exception, boolean throwOnServerDisc) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.utils.finalhelp.FinalAnalyzer.identifyFinally2(FinalAnalyzer.java:642)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.utils.finalhelp.FinalAnalyzer.identifyFinally(FinalAnalyzer.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.FinallyRewriter.identifyFinally(FinallyRewriter.java:40)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:548)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean updateState(boolean canReconnect) {
        int old = this.wlConnectionImpl.getState();
        int next = old == 1040 || old == 1028 ? (canReconnect && this.preDisconnectState != null && this.wlConnectionImpl.getReconnectPolicyInternal() != 0 ? 512 : -2304) : old;
        if (next == -2304) {
            JMSConnection.recurseSetNoRetry(this.sessions, this);
        }
        this.wlConnectionImpl.setRecursiveStateNotify(next);
        return 512 == next;
    }

    static void displayExceptionCauses(String banner, Throwable current) {
        String type = " exception  ";
        if (current == null) {
            System.err.println(banner + type + " null argument");
        }
        for (int lcv = 1; lcv < 40 && current != null; ++lcv) {
            NestedThrowable nest1;
            String extra = current instanceof LostServerException && ((LostServerException)current).isReplayLastException() ? " and isReplay" : "";
            System.err.println(banner + type + lcv + ", " + current.getClass() + extra);
            if (current instanceof NestedThrowable && (nest1 = (NestedThrowable)((Object)current)).getNested() != null) {
                if (null != current.getCause()) {
                    JMSConnection.displayExceptionCauses(banner + "[has funky getCause()" + lcv + "]", current.getCause());
                }
                current = nest1.getNested();
                type = " NestedThrowable.getNested() ";
                continue;
            }
            current = current.getCause();
            type = " with cause ";
        }
    }

    private void closeSessions(Iterator iterator) throws JMSException {
        JMSException savedException = null;
        while (iterator != null && iterator.hasNext()) {
            JMSSession session = (JMSSession)iterator.next();
            try {
                session.close();
            }
            catch (JMSException jmse) {
                if (savedException != null) continue;
                savedException = jmse;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
    }

    Timer clearTimerInfo() {
        Timer oldTimer = this.timer;
        this.timer = null;
        return oldTimer;
    }

    private Timer resetIntervalClearTimer() {
        this.nextRetry = INITIAL_RETRY_DELAY;
        return this.clearTimerInfo();
    }

    boolean scheduleReconnectTimer() {
        if (ReconnectController.TODOREMOVEDebug) {
            new Exception("DEBUG 1054").printStackTrace();
        }
        long now = System.currentTimeMillis();
        long currentInterval = this.nextRetry;
        if (this.wlConnectionImpl.getLastReconnectTimer() > 0L && this.wlConnectionImpl.getLastReconnectTimer() - now < currentInterval) {
            this.wlConnectionImpl.clearLastReconnectTimer();
            this.wlConnectionImpl.getConnectionStateLock().notifyAll();
            this.clearTimerInfo();
            return false;
        }
        this.nextRetry <<= 1;
        if (this.nextRetry > 300000L) {
            this.nextRetry = 300000L;
        } else if (this.nextRetry < 5000L) {
            this.nextRetry = 5000L;
        }
        if ((long)INITIAL_RETRY_DELAY == currentInterval) {
            JMSConnection.getReconnectWorkManager().schedule(this);
        } else {
            this.timer = this.getReconnectTimerManager(JMSConnection.getReconnectWorkManager()).schedule((TimerListener)this, currentInterval);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WorkManager getReconnectWorkManager() {
        Object object = TIMER_WORKMANAGER_LOCK;
        synchronized (object) {
            if (RECONNECT_WORK_MANAGER == null) {
                RECONNECT_WORK_MANAGER = WorkManagerFactory.getInstance().findOrCreate(RECONNECT_ID, 1, 5);
            }
            return RECONNECT_WORK_MANAGER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerManager getReconnectTimerManager(WorkManager reconnectWorkMgr) {
        Object object = TIMER_WORKMANAGER_LOCK;
        synchronized (object) {
            if (RECONNECT_TIMER_MANAGER == null) {
                RECONNECT_TIMER_MANAGER = TimerManagerFactory.getTimerManagerFactory().getTimerManager(RECONNECT_ID, reconnectWorkMgr);
            }
            return RECONNECT_TIMER_MANAGER;
        }
    }

    private boolean isWithinReconnectTime() {
        long now = System.currentTimeMillis();
        long config = this.wlConnectionImpl.getTotalReconnectPeriodMillis();
        return config == -1L || now - this.wlConnectionImpl.getFirstReconnectTime() <= config;
    }

    @Override
    public void timerExpired(Timer timer) {
        if (this.isWithinReconnectTime()) {
            this.wlConnectionImpl.processReconnectTimer(this);
        } else {
            this.setPreDisconnectState(null);
            this.recurseSetNoRetry(this.wlConnectionImpl);
            LostServerException lse = new LostServerException("Failed to reconnect to Server within the configured reconnect time of " + this.getTotalReconnectPeriodMillis() / 1000L + " seconds");
            if (this.exceptionContext != null) {
                JMSConnection.onException(lse, this.exceptionContext);
            } else if (ReconnectController.TODOREMOVEDebug) {
                JMSConnection.displayExceptionCauses("Failed to reconnect to Server within the configured reconnect time of " + this.getTotalReconnectPeriodMillis() / 1000L + " seconds", new LostServerException("Network or Server down"));
            }
        }
    }

    @Override
    public void run() {
        this.wlConnectionImpl.processReconnectTimer(this);
    }

    static final void onException(JMSException exception, JMSExceptionContext exceptionContext) {
        JMSConnection.onExceptionInternal(exception, exceptionContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean onExceptionInternal(JMSException exception, JMSExceptionContext exceptionContext, boolean deferIfInUse) {
        if (ReconnectController.TODOREMOVEDebug) {
            new Exception("DEBUG 1137").printStackTrace();
        }
        JMSContext savedContext = JMSContext.push(exceptionContext, true);
        try {
            if (deferIfInUse) {
                boolean bl = exceptionContext.invokeListenerIfItIsIdle(exception);
                return bl;
            }
            exceptionContext.blockTillIdleThenRunExclusively(exception);
        }
        catch (Exception e) {
            JMSClientExceptionLogger.logStackTrace(e);
        }
        finally {
            JMSContext.pop(savedContext, true);
        }
        return false;
    }

    @Override
    public final String getJMSVersion() {
        return ProviderInfo.getJMSVersion();
    }

    @Override
    public final int getJMSMajorVersion() {
        return ProviderInfo.getJMSMajorVersion();
    }

    @Override
    public final int getJMSMinorVersion() {
        return ProviderInfo.getJMSMinorVersion();
    }

    @Override
    public final String getJMSProviderName() {
        return ProviderInfo.getJMSProviderName();
    }

    @Override
    public final String getProviderVersion() {
        return ProviderInfo.getProviderVersion();
    }

    @Override
    public final int getProviderMajorVersion() {
        return ProviderInfo.getProviderMajorVersion();
    }

    @Override
    public final int getProviderMinorVersion() {
        return ProviderInfo.getProviderMinorVersion();
    }

    void setWlConnectionImpl(WLConnectionImpl wlConnectionImpl) {
        if (this.wlConnectionImpl == null || wlConnectionImpl.getConnectionStateLock() != this.wlConnectionImpl.getConnectionStateLock()) {
            this.sessions.setLock(wlConnectionImpl.getConnectionStateLock());
            this.durableSubscribers.setLock(wlConnectionImpl.getConnectionStateLock());
        }
        this.wlConnectionImpl = wlConnectionImpl;
    }

    JMSConnection getReplacementConnection() {
        return this.replacementConnection;
    }

    void setReplacementConnection(JMSConnection arg) {
        this.replacementConnection = arg;
    }

    JMSConnection getOriginalConnection() {
        return this.originalConnection;
    }

    void setOriginalConnection(JMSConnection arg) {
        this.originalConnection = arg;
    }

    void markReplacement() {
        this.bReplacement = true;
    }

    @Override
    public final Enumeration getJMSXPropertyNames() {
        return ProviderInfo.getJMSXPropertyNames();
    }

    @Override
    public int incrementRefCount() {
        return ++this.refCount;
    }

    @Override
    public int decrementRefCount() {
        return --this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChangeListener(DispatcherStateChangeListener arg, Throwable throwable) {
        if (arg != this) {
            return;
        }
        JMSConnection jMSConnection = this;
        synchronized (jMSConnection) {
            Object object = this.wlConnectionImpl.getConnectionStateLock();
            synchronized (object) {
                if (this.wlConnectionImpl.getPhysical() == this && this.wlConnectionImpl.getState() == 0) {
                    this.wlConnectionImpl.rememberReconnectState(this, 1028);
                }
            }
        }
    }

    @Override
    public boolean holdsLock() {
        if (Thread.holdsLock(this)) {
            return true;
        }
        WLConnectionImpl localImpl = this.wlConnectionImpl;
        if (localImpl == null) {
            return false;
        }
        Object connectionStateLock = localImpl.getConnectionStateLock();
        if (connectionStateLock == null) {
            return false;
        }
        return Thread.holdsLock(connectionStateLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispatcherPeerGone(Exception e, Dispatcher dispatcher) {
        LostServerException exception = new LostServerException(e);
        AbstractSubject currentSubject = SubjectManager.getSubjectManager().getCurrentSubject(KernelID);
        try {
            if (currentSubject.equals(KernelID)) {
                SubjectManager.getSubjectManager().pushSubject(KernelID, SubjectManager.getSubjectManager().getAnonymousSubject());
            }
            this.mergedCloseAndOnException(exception, false);
        }
        catch (JMSException jMSException) {
        }
        finally {
            if (currentSubject.equals(KernelID)) {
                SubjectManager.getSubjectManager().popSubject(KernelID);
            }
        }
    }

    private void markClosed() {
        this.isClosed = true;
    }

    @Override
    public ReconnectController getReconnectController() {
        return this.wlConnectionImpl;
    }

    JMSConnection getPreDisconnectState() {
        return this.preDisconnectState;
    }

    void setPreDisconnectState(JMSConnection arg) {
        this.preDisconnectState = arg;
    }

    @Override
    public Reconnectable getReconnectState(int policy) throws CloneNotSupportedException {
        JMSConnection clone = (JMSConnection)this.clone();
        clone.sessions = WLConnectionImpl.reconnectPolicyHas(2, policy) ? JMSConnection.recurseGetReconnectState(clone.sessions, policy) : JMSConnection.recurseSetNoRetry(clone.sessions, this);
        clone.preDisconnectState = null;
        this.preDisconnectState = clone;
        return clone;
    }

    static LockedMap recurseGetReconnectState(LockedMap oldMap, int reconnectPolicy) throws CloneNotSupportedException {
        Iterator iterator = oldMap.valuesIterator();
        LockedMap newMap = new LockedMap(oldMap.getName(), oldMap.getLock());
        while (iterator.hasNext()) {
            Reconnectable reconnectable = (Reconnectable)iterator.next();
            if (reconnectable.isReconnectControllerClosed() || (reconnectable = reconnectable.getReconnectState(reconnectPolicy)) == null) continue;
            newMap.put(reconnectable, reconnectable);
        }
        return newMap;
    }

    static LockedMap recurseSetNoRetry(LockedMap oldMap, JMSConnection jmsConnection) {
        boolean notifyAll = false;
        Iterator iterator = oldMap.valuesIterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof Reconnectable)) continue;
            ReconnectController rc = ((Reconnectable)next).getReconnectController();
            if (rc != null && rc.getWLConnectionImpl().getPhysical() == jmsConnection) {
                notifyAll = true;
                rc.setRecursiveState(-2304);
            }
            ((Reconnectable)next).forgetReconnectState();
        }
        if (notifyAll) {
            jmsConnection.wlConnectionImpl.getConnectionStateLock().notifyAll();
        }
        return new LockedMap(oldMap.getName(), oldMap.getLock());
    }

    void recurseSetNoRetry(WLConnectionImpl wlConnectionImpl) {
        JMSConnection.recurseSetNoRetry(this.sessions, this);
        wlConnectionImpl.setRecursiveStateNotify(-2304);
    }

    boolean hasTemporaryDestination() {
        Iterator sessionIterator = this.sessions.valuesIterator();
        while (sessionIterator.hasNext()) {
            if (!((JMSSession)sessionIterator.next()).hasTemporaryDestination()) continue;
            return true;
        }
        return false;
    }

    static void recursePreCreateReplacement(Reconnectable parent, LockedMap oldMap) throws JMSException {
        Iterator iterator = oldMap.cloneValuesIterator();
        while (iterator.hasNext()) {
            Reconnectable reconnectable = (Reconnectable)iterator.next();
            if (reconnectable.isReconnectControllerClosed()) continue;
            reconnectable.preCreateReplacement(parent);
        }
    }

    static void recursePostCreateReplacement(LockedMap oldMap) {
        Iterator iterator = oldMap.cloneValuesIterator();
        while (iterator.hasNext()) {
            Reconnectable reconnectable = (Reconnectable)iterator.next();
            if (reconnectable.isReconnectControllerClosed()) continue;
            reconnectable.postCreateReplacement();
        }
    }

    void rememberCredentials(String username, String password, boolean wantXAConnection) {
        this.wantXAConnection = wantXAConnection;
        try {
            this.pwdStore = new PasswordStore();
            this.uHandle = this.pwdStore.storePassword(username);
            this.pHandle = this.pwdStore.storePassword(password);
        }
        catch (GeneralSecurityException gsEx) {
            this.pwdStore = null;
            this.uHandle = username;
            this.pHandle = password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Reconnectable preCreateReplacement(Reconnectable parent) throws JMSException {
        String pwd;
        String uname;
        JMSConnection oldCon = this.preDisconnectState;
        JMSConnection origCon = this.getOriginalConnection();
        if (oldCon == null) {
            return null;
        }
        WLConnectionImpl wlConImpl = oldCon.wlConnectionImpl;
        Object object = wlConImpl.getConnectionStateLock();
        synchronized (object) {
            if (oldCon.pwdStore != null) {
                try {
                    uname = (String)oldCon.pwdStore.retrievePassword(oldCon.uHandle);
                    pwd = (String)oldCon.pwdStore.retrievePassword(oldCon.pHandle);
                }
                catch (GeneralSecurityException gsEx) {
                    throw new weblogic.jms.common.JMSException(gsEx);
                }
                catch (IOException ioEx) {
                    throw new weblogic.jms.common.JMSException(ioEx);
                }
            } else {
                uname = (String)oldCon.uHandle;
                pwd = (String)oldCon.pHandle;
            }
        }
        DispatcherPartitionContext dpc = JMSEnvironment.getJMSEnvironment().findDispatcherPartitionContextJMSException(oldCon.clientDispatcherPartitionContext.getPartitionId());
        JMSConnection newCon = ((JMSConnectionFactory)parent).setupJMSConnection(uname, pwd, oldCon.wantXAConnection, dpc, oldCon.type);
        try {
            newCon.setWlConnectionImpl(wlConImpl);
            if (oldCon.clientId != null && newCon.clientId == null) {
                newCon.setClientID(oldCon.clientId);
            }
            newCon.setAllowCloseInOnMessage(oldCon.allowCloseInOnMessage);
            newCon.setDispatchPolicy(oldCon.dispatchPolicyName);
            JMSConnection.recursePreCreateReplacement(newCon, oldCon.sessions);
            Object object2 = wlConImpl.getConnectionStateLock();
            synchronized (object2) {
                int state;
                block25: {
                    state = wlConImpl.getState();
                    if (state != 1536) break block25;
                    newCon.markReplacement();
                    JMSConnection connectionCopy = newCon;
                    if (origCon != null) {
                        connectionCopy.setOriginalConnection(origCon);
                        origCon.setReplacementConnection(connectionCopy);
                    } else {
                        connectionCopy.setOriginalConnection(this);
                    }
                    this.setReplacementConnection(connectionCopy);
                    newCon = null;
                    JMSConnection jMSConnection = connectionCopy;
                    return jMSConnection;
                }
                throw new LostServerException(wlConImpl.wrongStateString(state));
            }
        }
        finally {
            try {
                if (newCon != null) {
                    newCon.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    @Override
    public void postCreateReplacement() {
        Timer oldTimer;
        if (ReconnectController.TODOREMOVEDebug) {
            System.err.println("debug JMSConnection stale " + this.preDisconnectState.debugMaps());
        }
        if ((oldTimer = this.resetIntervalClearTimer()) != null) {
            oldTimer.cancel();
        }
        JMSConnection.recursePostCreateReplacement(this.preDisconnectState.sessions);
        JMSContext preDisconnectContext = this.preDisconnectState.wlConnectionImpl.getConnectionEstablishContext();
        this.getReplacementConnection().setWlConnectionImpl(this.preDisconnectState.wlConnectionImpl);
        JMSConnection preDisconnectStateLocal = this.preDisconnectState;
        preDisconnectStateLocal.forgetReconnectState();
        this.preDisconnectState = null;
        this.getReplacementConnection().wlConnectionImpl.setConnectionEstablishContext(preDisconnectContext);
        this.wlConnectionImpl.setPhysicalReconnectable(this.getReplacementConnection());
        if (ReconnectController.TODOREMOVEDebug) {
            System.err.println("debug JMSConnection reconnect " + this.getReplacementConnection().debugMaps());
        }
    }

    String debugMaps() {
        String accumulate = null;
        Iterator iterator = this.sessions.valuesIterator();
        while (iterator.hasNext()) {
            String cur = ((JMSSession)iterator.next()).debugMaps();
            if (accumulate == null) {
                accumulate = "< " + cur;
                continue;
            }
            accumulate = accumulate + "\n  " + cur;
        }
        return accumulate + "\n>";
    }

    public Object clone() throws CloneNotSupportedException {
        JMSConnection jmsConnection = (JMSConnection)super.clone();
        jmsConnection.sessions = (LockedMap)this.sessions.clone();
        jmsConnection.durableSubscribers = (LockedMap)this.durableSubscribers.clone();
        return jmsConnection;
    }

    @Override
    public boolean isReconnectControllerClosed() {
        return this.wlConnectionImpl.isClosed();
    }

    @Override
    public final synchronized ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        if (this.exceptionContext != null) {
            return this.exceptionContext.getExceptionListener();
        }
        return null;
    }

    public final synchronized JMSExceptionContext getJMSExceptionContext() throws JMSException {
        this.checkClosed();
        return this.exceptionContext;
    }

    @Override
    public final ClientRuntimeInfo getParentInfo() {
        return this;
    }

    @Override
    public final String getWLSServerName() {
        return this.wlsServerName;
    }

    @Override
    public final String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public final String toString() {
        return this.getRuntimeMBeanName();
    }

    final int getDeliveryMode() {
        return this.deliveryMode;
    }

    final int getPriority() {
        return this.priority;
    }

    final long getTimeToDeliver() {
        return this.timeToDeliver;
    }

    final long getTimeToLive() {
        return this.timeToLive;
    }

    final long getSendTimeout() {
        return this.sendTimeout;
    }

    final long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setAcknowledgePolicy(int acknowledgePolicy) {
        Object object = this.acknowledgePolicyLock;
        synchronized (object) {
            this.acknowledgePolicy = acknowledgePolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getAcknowledgePolicy() {
        Object object = this.acknowledgePolicyLock;
        synchronized (object) {
            return this.acknowledgePolicy;
        }
    }

    final int getOverrunPolicy() {
        return this.overrunPolicy;
    }

    @Override
    public final boolean isXAServerEnabled() {
        return this.xaServerEnabled;
    }

    final boolean isFlowControlEnabled() {
        return this.flowControl;
    }

    final int getFlowMinimum() {
        return this.flowMinimum;
    }

    final int getFlowMaximum() {
        return this.flowMaximum;
    }

    final int getFlowIncrease() {
        return this.flowIncrease;
    }

    final double getFlowDecrease() {
        return this.flowDecrease;
    }

    final long getFlowInterval() {
        return this.flowInterval;
    }

    final int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    @Override
    public final boolean getUserTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    public final boolean getAllowCloseInOnMessage() {
        return this.allowCloseInOnMessage;
    }

    @Override
    public final void setAllowCloseInOnMessage(boolean allowCloseInOnMessage) {
        this.allowCloseInOnMessage = allowCloseInOnMessage;
    }

    @Override
    public void setReconnectPolicy(String reconnectPolicy) {
        this.wlConnectionImpl.setReconnectPolicy(reconnectPolicy);
    }

    @Override
    public String getReconnectPolicy() {
        return this.wlConnectionImpl.getReconnectPolicy();
    }

    @Override
    public void setReconnectBlockingMillis(long timeout) {
        this.wlConnectionImpl.setReconnectBlockingMillis(timeout);
    }

    @Override
    public long getReconnectBlockingMillis() {
        return this.wlConnectionImpl.getReconnectBlockingMillis();
    }

    @Override
    public long getTotalReconnectPeriodMillis() {
        return this.wlConnectionImpl.getTotalReconnectPeriodMillis();
    }

    @Override
    public void setTotalReconnectPeriodMillis(long mil) {
        this.wlConnectionImpl.setTotalReconnectPeriodMillis(mil);
    }

    public int getPipelineGeneration() {
        return this.pipelineGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean markDurableSubscriber(String subscriptionName) {
        Object object = this.sublock;
        synchronized (object) {
            if (this.durableSubscribers.get(subscriptionName) != null) {
                return false;
            }
            return this.durableSubscribers.put(subscriptionName, new Object()) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDurableSubscriber(String subscriptionName, Object obj) {
        Object object = this.sublock;
        synchronized (object) {
            this.durableSubscribers.put(subscriptionName, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean removeDurableSubscriber(String subscriptionName) {
        Object object = this.sublock;
        synchronized (object) {
            return this.durableSubscribers.remove(subscriptionName) != null;
        }
    }

    final synchronized String getDispatchPolicy() {
        return this.dispatchPolicyName;
    }

    @Override
    public final synchronized void setDispatchPolicy(String name) {
        this.dispatchPolicyName = name;
    }

    @Override
    public final JMSID getJMSID() {
        return this.connectionId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    @Override
    public DispatcherPartition4rmic getDispatcherPartition4rmic() {
        return this.clientDispatcherPartitionContext;
    }

    final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    final int getSynchronousPrefetchMode() {
        return this.synchronousPrefetchMode;
    }

    final int getOneWaySendMode() {
        return this.oneWaySendMode;
    }

    final int getOneWaySendWindowSize() {
        return this.oneWaySendWindowSize;
    }

    @Override
    public final InvocableMonitor getInvocableMonitor() {
        return null;
    }

    final int getReconnectPolicyInternal() {
        if (PeerInfo.VERSION_901.compareTo(this.getFEPeerInfo()) > 0) {
            this.reconnectPolicy = 0;
        }
        return this.reconnectPolicy;
    }

    final long getReconnectBlockingMillisInternal() {
        return this.reconnectBlockingMillis;
    }

    final long getTotalReconnectPeriodMillisInternal() {
        return this.totalReconnectPeriodMillis;
    }

    public final void destroyTemporaryDestination(JMSServerId backEndId, JMSID destinationId) throws JMSException {
        this.checkClosed();
        Response response = this.dispatcher.dispatchSync(new FETemporaryDestinationDestroyRequest(this.getJMSID(), destinationId));
    }

    final void consumerRemove(String name) throws JMSException {
        PeerInfo pi;
        if (this.clientId == null && (pi = this.getFEPeerInfo()).compareTo(PeerInfo.VERSION_1221) < 0) {
            throw new JMSException("Operation not supported by front-end server version [" + pi + "]: unsubscribe durable subscription with name " + name + " and null client id");
        }
        Response response = this.dispatcher.dispatchSync(new FERemoveSubscriptionRequest(this.clientId, name));
    }

    final void consumerRemove(DestinationImpl topic, String name) throws JMSException {
        PeerInfo pi;
        if (this.clientId == null && (pi = this.getFEPeerInfo()).compareTo(PeerInfo.VERSION_1221) < 0) {
            throw new JMSException("Operation not supported by front-end server version [" + pi + "]: unsubscribe durable subscription with name " + name + " and null client id on Topic " + topic);
        }
        Response response = this.dispatcher.dispatchSync(new FERemoveSubscriptionRequest(this.clientId, name, this.clientIdPolicy, topic));
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() throws JMSException {
        this.getFrontEndDispatcher();
    }

    @Override
    public final void publicCheckClosed() throws JMSException {
        this.checkClosed();
    }

    public final byte getPeerVersion() {
        return this.version;
    }

    public JMSConnection() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int extension;
        byte version;
        byte mask = version = this.getVersion(out);
        if (version >= 4) {
            if (this.sendTimeout != 10L) {
                mask = (byte)(mask | 0x40);
            }
            if (version >= 5) {
                extension = 1 | this.pipelineGeneration;
                if (this.unitOfOrder != null) {
                    extension |= 2;
                }
                if (version >= 9 && this.subject != null) {
                    extension |= 4;
                }
            } else {
                extension = 0;
            }
        } else {
            extension = 0;
        }
        if (this.peerVersionable != null) {
            this.peerVersionable.setPeerVersion(version);
        }
        out.writeByte(mask);
        this.connectionId.writeExternal(out);
        if (this.clientId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.clientId);
        }
        out.writeInt(this.deliveryMode);
        out.writeInt(this.priority);
        out.writeInt(this.messagesMaximum);
        out.writeInt(this.overrunPolicy);
        out.writeLong(this.timeToDeliver);
        out.writeLong(this.timeToLive);
        out.writeLong(this.redeliveryDelay);
        out.writeLong(this.transactionTimeout);
        out.writeBoolean(this.userTransactionsEnabled);
        out.writeBoolean(this.allowCloseInOnMessage);
        out.writeInt(this.acknowledgePolicy);
        this.dispatcherWrapper.writeExternal(out);
        if (version >= 3) {
            out.writeBoolean(this.flowControl);
            if (this.flowControl) {
                out.writeInt(this.flowMinimum);
                out.writeInt(this.flowMaximum);
                out.writeInt(this.flowIncrease);
                out.writeDouble(this.flowDecrease);
                out.writeLong(this.flowInterval);
            }
            out.writeBoolean(this.xaServerEnabled);
        }
        if (version >= 4) {
            out.writeUTF(this.wlsServerName);
            out.writeUTF(this.runtimeMBeanName);
            if (this.sendTimeout != 10L) {
                out.writeLong(this.sendTimeout);
            }
        }
        if (version >= 5) {
            out.writeInt(extension);
            if ((extension & 1) != 0) {
                out.writeInt(this.compressionThreshold);
            }
            if ((extension & 2) != 0) {
                out.writeUTF(this.unitOfOrder);
            }
            if (version >= 6) {
                out.writeInt(this.synchronousPrefetchMode);
            }
            if (version >= 7) {
                out.writeInt(this.oneWaySendMode);
                out.writeInt(this.oneWaySendWindowSize);
                out.writeInt(this.reconnectPolicy);
                out.writeLong(this.reconnectBlockingMillis);
                out.writeLong(this.totalReconnectPeriodMillis);
            }
        }
        if (version >= 8) {
            out.writeInt(this.clientIdPolicy);
            out.writeInt(this.subscriptionSharingPolicy);
        }
        if (version >= 9 && (extension & 4) != 0) {
            out.writeObject(this.subject);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte mask = in.readByte();
        byte vrsn = (byte)(mask & 0xF);
        switch (vrsn) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.version = vrsn;
                break;
            }
            default: {
                throw JMSUtilities.versionIOException(vrsn, 1, 9);
            }
        }
        this.connectionId = new JMSID();
        this.connectionId.readExternal(in);
        if (in.readBoolean()) {
            this.clientId = in.readUTF();
        }
        this.deliveryMode = in.readInt();
        this.priority = in.readInt();
        this.messagesMaximum = in.readInt();
        this.overrunPolicy = in.readInt();
        this.timeToDeliver = in.readLong();
        this.timeToLive = in.readLong();
        this.redeliveryDelay = in.readLong();
        this.transactionTimeout = in.readLong();
        this.userTransactionsEnabled = in.readBoolean();
        this.allowCloseInOnMessage = in.readBoolean();
        this.acknowledgePolicy = in.readInt();
        this.dispatcherWrapper = new DispatcherWrapper();
        this.dispatcherWrapper.readExternal(in);
        if (vrsn >= 3) {
            this.flowControl = in.readBoolean();
            if (this.flowControl) {
                this.flowMinimum = in.readInt();
                this.flowMaximum = in.readInt();
                this.flowIncrease = in.readInt();
                this.flowDecrease = in.readDouble();
                this.flowInterval = in.readLong();
            }
            this.xaServerEnabled = in.readBoolean();
        }
        if (vrsn >= 4) {
            this.wlsServerName = in.readUTF();
            this.runtimeMBeanName = in.readUTF();
            this.sendTimeout = (mask & 0x40) != 0 ? in.readLong() : 10L;
        }
        if (vrsn >= 5) {
            int extension = in.readInt();
            this.pipelineGeneration = 0xF00000 & extension;
            if ((extension & 1) != 0) {
                this.compressionThreshold = in.readInt();
            }
            if ((extension & 2) != 0) {
                this.unitOfOrder = in.readUTF();
            }
            if (vrsn >= 6) {
                this.synchronousPrefetchMode = in.readInt();
            }
            if (vrsn >= 7) {
                this.oneWaySendMode = in.readInt();
                this.oneWaySendWindowSize = in.readInt();
                this.internalSetReconnect(in.readInt(), in.readLong(), in.readLong());
            }
            if (vrsn >= 8) {
                this.clientIdPolicy = in.readInt();
                this.subscriptionSharingPolicy = in.readInt();
            }
            if (vrsn >= 9 && (extension & 4) != 0) {
                this.subject = (AbstractSubject)in.readObject();
            }
        }
    }

    private int pushException(Request invocableRequest) {
        JMSPushExceptionRequest request = (JMSPushExceptionRequest)invocableRequest;
        try {
            this.mergedCloseAndOnException(request.getException(), false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        request.setState(Integer.MAX_VALUE);
        return request.getState();
    }

    @Override
    public final int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15363: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSuchMethodLoggable(request.getMethodId()));
    }

    private byte getVersion(Object oo) {
        PeerInfo tmp;
        PeerInfo pi = this.peerInfo;
        if (oo instanceof PeerInfoable && (tmp = ((PeerInfoable)oo).getPeerInfo()) != null) {
            pi = tmp;
        }
        if (pi != null) {
            if (pi.compareTo(PeerInfo.VERSION_122140) >= 0) {
                return 9;
            }
            if (pi.compareTo(PeerInfo.VERSION_1033) >= 0) {
                return 8;
            }
            if (pi.compareTo(PeerInfo.VERSION_920) >= 0) {
                return 7;
            }
            if (pi.compareTo(PeerInfo.VERSION_910) >= 0) {
                return 6;
            }
            if (pi.compareTo(PeerInfo.VERSION_901) >= 0) {
                return 6;
            }
            if (pi.compareTo(PeerInfo.VERSION_DIABLO) >= 0) {
                return 5;
            }
            if (pi.compareTo(PeerInfo.VERSION_81) >= 0) {
                return 4;
            }
            if (pi.compareTo(PeerInfo.VERSION_70) >= 0) {
                return 3;
            }
            return 1;
        }
        return 9;
    }

    @Override
    public void forgetReconnectState() {
        PasswordStore pwdStoreLocal;
        JMSConnection replacementConnectionLocal;
        JMSConnection preDisconnectStateLocal = this.preDisconnectState;
        if (preDisconnectStateLocal != null) {
            preDisconnectStateLocal.forgetReconnectState();
            this.preDisconnectState = null;
        }
        if ((replacementConnectionLocal = this.replacementConnection) != null) {
            replacementConnectionLocal.forgetReconnectState();
            this.setReplacementConnection(null);
        }
        if ((pwdStoreLocal = this.pwdStore) != null) {
            Object pHandleLocal = this.pHandle;
            Object uHandleLocal = this.uHandle;
            if (pHandleLocal != null) {
                pwdStoreLocal.removePassword(pHandleLocal);
            }
            if (uHandleLocal != null) {
                pwdStoreLocal.removePassword(uHandleLocal);
            }
            this.pwdStore = null;
        }
        this.pHandle = null;
        this.uHandle = null;
        this.wlConnectionImpl.setConnectionEstablishContext(null);
    }

    @Override
    public PeerInfo getFEPeerInfo() {
        return this.dispatcherWrapper.getPeerInfo();
    }

    public static int convertPrefetchMode(String synchronousPrefetchMode) {
        if (synchronousPrefetchMode == null || synchronousPrefetchMode.equals("disabled")) {
            return 0;
        }
        if (synchronousPrefetchMode.equals("enabled")) {
            return 1;
        }
        if (synchronousPrefetchMode.equals("topicSubscriberOnly")) {
            return 2;
        }
        return 0;
    }

    public static int convertOneWaySendMode(String oneWaySendMode) {
        if (oneWaySendMode == null || oneWaySendMode.equals("disabled")) {
            return 0;
        }
        if (oneWaySendMode.equals("enabled")) {
            return 1;
        }
        if (oneWaySendMode.equals("topicOnly")) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect() {
        JMSConnection replacement = null;
        Throwable connectionProblem = null;
        JMSContext connectContext = this.wlConnectionImpl.getConnectionEstablishContext();
        try {
            JMSContext restoreContext = connectContext != null ? JMSContext.push(connectContext, true) : null;
            try {
                try {
                    replacement = (JMSConnection)this.preCreateReplacement(this.wlConnectionImpl.getJmsConnectionFactory());
                    JMSConnection pds = this.preDisconnectState;
                    if (replacement != null && pds != null) {
                        replacement.resume(pds);
                    }
                }
                catch (JMSException jmse) {
                    if (ReconnectController.TODOREMOVEDebug) {
                        jmse.printStackTrace();
                    }
                    connectionProblem = jmse;
                }
                catch (Error error) {
                    if (ReconnectController.TODOREMOVEDebug) {
                        error.printStackTrace();
                    }
                    connectionProblem = error;
                    throw error;
                }
                catch (RuntimeException rte) {
                    if (ReconnectController.TODOREMOVEDebug) {
                        rte.printStackTrace();
                    }
                    connectionProblem = rte;
                    throw rte;
                }
            }
            finally {
                if (connectContext != null) {
                    JMSContext.pop(restoreContext, true);
                }
            }
            this.wlConnectionImpl.reconnectComplete(this, replacement, connectionProblem);
        }
        catch (Throwable throwable) {
            this.wlConnectionImpl.reconnectComplete(this, replacement, connectionProblem);
            throw throwable;
        }
    }

    boolean isInbound() {
        return this.inboundDest != null;
    }

    DestinationImpl getInboundDest() {
        return this.inboundDest;
    }

    @Override
    public void setInboundDest(Destination inboundDest) throws JMSException {
        if (inboundDest == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestinationLoggable().getMessage());
        }
        this.inboundDest = (DestinationImpl)inboundDest;
        this.clientIdPolicy = 1;
        this.subscriptionSharingPolicy = 1;
    }

    Hashtable getJndiEnv() {
        return this.jndiEnv;
    }

    void setJndiEnv(Hashtable jndiEnv) {
        this.jndiEnv = jndiEnv;
    }

    public void setWrappedIC(boolean value) {
        this.isWrappedIC = value;
    }

    public boolean isWrappedIC() {
        return this.isWrappedIC;
    }

    void markAsJMSSessionPooledInWrapper() {
        this.jmsSessionPooledInWrapper = true;
    }

    boolean isJMSSessionPooledInWrapper() {
        return this.jmsSessionPooledInWrapper;
    }

    @Override
    public final String getPartitionName() {
        return this.dispatcherWrapper.getConnectionPartitionName();
    }

    public AbstractSubject getSubject() {
        return this.subject;
    }

    public void setSubject(AbstractSubject subject) {
        this.subject = subject;
    }

    static {
        boolean thick = false;
        try {
            Class.forName("weblogic.rjvm.RJVM");
            thick = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isT3Client = thick;
    }
}

