/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import jakarta.jms.Message;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.frontend.FEProducerSendRequest;
import weblogic.messaging.dispatcher.CompletionListener;

public class AsyncSendCallback {
    private DestinationImpl mydestination;
    private Message messageState;
    private int deliveryModeState;
    private long timeToDeliverState;
    private int priorityState;
    private long timeToLiveState;
    private boolean forwardingState;
    private Object appListener;
    private boolean jmsAsyncOff = false;
    private JMSProducer jmsProducer;
    private boolean sendCallSuccessReturned = false;
    private boolean sendCallReturned = false;
    private boolean completed = false;
    private Throwable exception = null;
    private boolean completing = false;
    private boolean callbackCalled = false;
    private long timeoutTime = 0L;
    private long messageImplSize = 0L;
    private long messageSize = 0L;
    private JMSContext userContext;
    private static volatile Set asyncSendForeignMessages = null;

    public AsyncSendCallback(DestinationImpl destination, Message message, int deliveryMode, long timeToDeliver, int priority, long timeToLive, boolean forwarding, Object appListener, boolean jmsAsyncOff, JMSProducer jmsProducer) {
        this.mydestination = destination;
        this.messageState = message;
        this.deliveryModeState = deliveryMode;
        this.timeToDeliverState = timeToDeliver;
        this.priorityState = priority;
        this.timeToLiveState = timeToLive;
        this.forwardingState = forwarding;
        this.appListener = appListener;
        this.jmsAsyncOff = jmsAsyncOff;
        this.jmsProducer = jmsProducer;
        if (this.appListener instanceof CompletionListener) {
            jmsProducer.incrementWLAsyncSendCount();
        }
        this.userContext = new JMSContext();
    }

    public boolean isJMSAsyncSend() {
        return this.appListener instanceof jakarta.jms.CompletionListener;
    }

    void startTimeoutTimer() {
        if (this.timeoutTime != 0L) {
            return;
        }
        this.timeoutTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTimedout() {
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (this.completed || this.exception != null) {
                return false;
            }
        }
        if (this.timeoutTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= this.timeoutTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMessageSize(long size, long implSize) {
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (implSize > 0L) {
                this.messageImplSize = implSize;
            }
            if (size > 0L) {
                this.messageSize = size;
            }
            if (this.messageSize == 0L && this.messageImplSize > 0L) {
                this.messageSize = this.messageImplSize;
            }
        }
        if (this.appListener instanceof jakarta.jms.CompletionListener) {
            this.jmsProducer.getSession().incrementAsyncSendPendingSize(this);
        }
    }

    synchronized long getMessageSize() {
        return this.messageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSendCallSuccessReturn() {
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            this.sendCallSuccessReturned = true;
            this.sendCallReturned = true;
            if (this.jmsAsyncOff) {
                this.completed = true;
            }
        }
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug(this.toDebugString() + ", onSendCallSuccessReturn() called");
        }
        if (this.appListener instanceof jakarta.jms.CompletionListener) {
            this.jmsProducer.getSession().wakeupAsyncSendCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSendCallReturn() {
        boolean remove = false;
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (!this.sendCallSuccessReturned) {
                remove = true;
            }
        }
        if (remove) {
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug(this.toDebugString() + ", onSendCallReturn() called, send call unsuccessful");
            }
            this.markAsyncSendEnd();
            if (this.appListener instanceof jakarta.jms.CompletionListener) {
                this.jmsProducer.getSession().dequeueAsyncSendCallback(this);
            }
        }
        asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            this.sendCallReturned = true;
        }
        if (!remove && this.appListener instanceof jakarta.jms.CompletionListener) {
            this.jmsProducer.getSession().wakeupAsyncSendCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletion(Object response, FEProducerSendRequest request, DestinationImpl destination, MessageImpl messageImpl) {
        boolean mycompleting;
        block37: {
            if (this.jmsAsyncOff) {
                JMSClientExceptionLogger.logStackTrace(new RuntimeException(this.toDebugString() + ", processCompletion() unexpected call"));
                return;
            }
            mycompleting = false;
            AsyncSendCallback asyncSendCallback = this;
            synchronized (asyncSendCallback) {
                if (!this.completed && this.exception == null && !this.completing) {
                    this.completing = true;
                    mycompleting = true;
                }
            }
            if (mycompleting) {
                try {
                    JMSProducerSendResponse result = null;
                    try {
                        result = this.jmsProducer.completeAsyncSend(response, request, destination, this.messageState, messageImpl, this.deliveryModeState, this.timeToDeliverState, this.priorityState, this.timeToLiveState, this.forwardingState);
                    }
                    catch (Throwable throwable) {
                        this.processException(throwable);
                    }
                    boolean mycompleted = false;
                    AsyncSendCallback asyncSendCallback2 = this;
                    synchronized (asyncSendCallback2) {
                        if (this.exception == null) {
                            mycompleted = this.completed = true;
                        }
                    }
                    if (!mycompleted) break block37;
                    if (this.appListener instanceof CompletionListener) {
                        this.jmsProducer.decrementWLAsyncSendCount();
                        try (AutoCloseable cached = this.userContext.pushAll();){
                            ((CompletionListener)this.appListener).onCompletion(result);
                            break block37;
                        }
                        catch (Throwable ee) {
                            JMSClientExceptionLogger.logStackTrace(ee);
                        }
                        break block37;
                    }
                    this.jmsProducer.getSession().wakeupAsyncSendCallback();
                }
                finally {
                    asyncSendCallback = this;
                    synchronized (asyncSendCallback) {
                        this.completing = false;
                    }
                }
            }
        }
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug(this.toDebugString() + ", processCompletion() called, mycompleting=" + mycompleting + ", messageImpl.size=" + messageImpl.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processException(Throwable ex) {
        Throwable myexception = null;
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            if (!this.completed && this.exception == null) {
                myexception = this.exception = ex;
            }
        }
        if (myexception != null) {
            if (this.appListener instanceof CompletionListener) {
                this.jmsProducer.decrementWLAsyncSendCount();
                try (AutoCloseable cached = this.userContext.pushAll();){
                    ((CompletionListener)this.appListener).onException(myexception);
                }
                catch (Throwable ee) {
                    JMSClientExceptionLogger.logStackTrace(ee);
                }
            } else {
                this.jmsProducer.getSession().wakeupAsyncSendCallback();
            }
        }
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug(this.toDebugString() + ", processException(" + ex + ") called, myexception=" + myexception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callCompletionListener() {
        block40: {
            Throwable myexception;
            boolean mycompleted;
            AsyncSendCallback asyncSendCallback = this;
            synchronized (asyncSendCallback) {
                if (this.callbackCalled) {
                    return;
                }
                if (!this.completed && this.exception == null && this.isTimedout()) {
                    this.exception = new TimeoutException("Async send completion wait timed out. " + this.toDebugString());
                    this.exception.fillInStackTrace();
                }
                this.callbackCalled = true;
                mycompleted = this.completed;
                myexception = this.exception;
            }
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug(this.toDebugString() + ", callCompletionListener() called");
            }
            if (!(this.appListener instanceof jakarta.jms.CompletionListener)) {
                return;
            }
            assert (mycompleted || myexception != null);
            try {
                this.markAsyncSendEnd();
                if (myexception != null) {
                    Exception ex = myexception instanceof Exception ? (Exception)myexception : new Exception(myexception.getMessage(), myexception);
                    try (AutoCloseable cached = this.userContext.pushAll();){
                        ((jakarta.jms.CompletionListener)this.appListener).onException(this.messageState, ex);
                        break block40;
                    }
                    catch (Throwable ee) {
                        JMSClientExceptionLogger.logStackTrace(ee);
                    }
                    break block40;
                }
                if (!mycompleted) break block40;
                try (AutoCloseable cached = this.userContext.pushAll();){
                    ((jakarta.jms.CompletionListener)this.appListener).onCompletion(this.messageState);
                }
                catch (Throwable ee) {
                    JMSClientExceptionLogger.logStackTrace(ee);
                }
            }
            finally {
                this.jmsProducer.getSession().dequeueAsyncSendCallback(this);
            }
        }
    }

    void enqueued() {
        this.jmsProducer.incrementJMSAsyncSendCount();
    }

    void dequeued() {
        this.jmsProducer.decrementJMSAsyncSendCount();
    }

    synchronized boolean isCallbackPending() {
        return (this.completed || this.exception != null) && this.sendCallReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void markAsyncSendStart() {
        if (this.messageState instanceof MessageImpl) {
            ((MessageImpl)this.messageState).setInAsyncSend(true);
            return;
        }
        if (asyncSendForeignMessages == null) {
            Class<AsyncSendCallback> clazz = AsyncSendCallback.class;
            // MONITORENTER : weblogic.jms.client.AsyncSendCallback.class
            if (asyncSendForeignMessages == null) {
                asyncSendForeignMessages = Collections.synchronizedSet(new HashSet());
            }
            // MONITOREXIT : clazz
        }
        asyncSendForeignMessages.add(this.messageState);
    }

    private void markAsyncSendEnd() {
        if (this.messageState instanceof MessageImpl) {
            ((MessageImpl)this.messageState).setInAsyncSend(false);
        } else if (asyncSendForeignMessages != null) {
            asyncSendForeignMessages.remove(this.messageState);
        }
    }

    static boolean isMessageInAsyncSend(Message m) {
        if (m instanceof MessageImpl) {
            return ((MessageImpl)m).isInAsyncSend();
        }
        if (asyncSendForeignMessages == null) {
            return false;
        }
        return asyncSendForeignMessages.contains(new AsyncSendForeignMessage(m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toDebugString() {
        Throwable myexception;
        boolean mycompleted;
        AsyncSendCallback asyncSendCallback = this;
        synchronized (asyncSendCallback) {
            mycompleted = this.completed;
            myexception = this.exception;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("AsyncSendCallback[producer@" + this.jmsProducer.hashCode() + "[" + this.jmsProducer.getJMSID() + ", " + this.jmsProducer + "], destination=" + this.mydestination);
        if (mycompleted) {
            try {
                buf.append(", " + this.messageState.getJMSMessageID());
            }
            catch (Exception e) {
                buf.append(", [message@" + this.messageState.hashCode() + ":" + e.toString() + "]");
            }
        } else {
            buf.append(", [message@" + this.messageState.hashCode() + "]");
        }
        buf.append(", completed=" + mycompleted + ", exception=" + myexception + ", sendCallSuccessReturn=" + this.sendCallSuccessReturned + ", sendCallReturned=" + this.sendCallReturned + ", jmsAsyncOff=" + this.jmsAsyncOff + ", messageSize=" + this.messageSize + ", messageImplSize=" + this.messageImplSize + "]");
        return buf.toString();
    }

    private static final class AsyncSendForeignMessage {
        Message msg;

        public AsyncSendForeignMessage(Message m) {
            this.msg = m;
        }

        public int hashCode() {
            return this.msg.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o == this.msg;
        }
    }
}

