/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.Subject;
import weblogic.jms.WrappedInitialContextFactory;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.security.Security;

public class WrappedInitialContext
implements Context {
    private Context ctx;
    private Subject subject;
    private Hashtable env;

    WrappedInitialContext(Context ctx, Subject subject, Hashtable env) {
        try {
            ctx.removeFromEnvironment("osgi.service.jndi.bundleContext");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ctx = ctx;
        this.subject = subject;
        this.env = env;
    }

    @Override
    public Object addToEnvironment(String arg0, Object arg1) throws NamingException {
        try {
            final String name1 = arg0;
            final Object name2 = arg1;
            return Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    Object result = WrappedInitialContext.this.ctx.addToEnvironment(name1, name2);
                    return WrappedInitialContext.this.checkResult(result);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void bind(Name arg0, Object arg1) throws NamingException {
        try {
            final Name name1 = arg0;
            final Object name2 = arg1;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.bind(name1, name2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void bind(String arg0, Object arg1) throws NamingException {
        try {
            final String name1 = arg0;
            final Object name2 = arg1;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.bind(name1, name2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void close() throws NamingException {
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Name composeName(Name arg0, Name arg1) throws NamingException {
        try {
            final Name name1 = arg0;
            final Name name2 = arg1;
            return (Name)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    Name result = WrappedInitialContext.this.ctx.composeName(name1, name2);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public String composeName(String arg0, String arg1) throws NamingException {
        try {
            final String name1 = arg0;
            final String name2 = arg1;
            return (String)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    String result = WrappedInitialContext.this.ctx.composeName(name1, name2);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Context createSubcontext(Name arg0) throws NamingException {
        Object rtn = null;
        try {
            final Name name = arg0;
            return (Context)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return WrappedInitialContext.this.checkResult(WrappedInitialContext.this.ctx.createSubcontext(name));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Context createSubcontext(String arg0) throws NamingException {
        Object rtn = null;
        try {
            final String name = arg0;
            return (Context)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return WrappedInitialContext.this.checkResult(WrappedInitialContext.this.ctx.createSubcontext(name));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void destroySubcontext(Name arg0) throws NamingException {
        try {
            final Name name = arg0;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.destroySubcontext(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void destroySubcontext(String arg0) throws NamingException {
        try {
            final String name = arg0;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.destroySubcontext(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        try {
            return (Hashtable)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    Hashtable<?, ?> result = WrappedInitialContext.this.ctx.getEnvironment();
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        try {
            return (String)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    String result = WrappedInitialContext.this.ctx.getNameInNamespace();
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public NameParser getNameParser(Name arg0) throws NamingException {
        try {
            final Name name = arg0;
            return (NameParser)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    NameParser result = WrappedInitialContext.this.ctx.getNameParser(name);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public NameParser getNameParser(String arg0) throws NamingException {
        try {
            final String name = arg0;
            return (NameParser)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    NameParser result = WrappedInitialContext.this.ctx.getNameParser(name);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name arg0) throws NamingException {
        try {
            final Name name = arg0;
            return (NamingEnumeration)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    NamingEnumeration<NameClassPair> result = WrappedInitialContext.this.ctx.list(name);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String arg0) throws NamingException {
        try {
            final String name = arg0;
            return (NamingEnumeration)Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    NamingEnumeration<NameClassPair> result = WrappedInitialContext.this.ctx.list(name);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name arg0) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String arg0) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookup(Name arg0) throws NamingException {
        try {
            final Name name = arg0;
            return Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return WrappedInitialContext.this.checkResult(WrappedInitialContext.this.ctx.lookup(name));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Object lookup(String arg0) throws NamingException {
        try {
            final String name = arg0;
            return Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return WrappedInitialContext.this.checkResult(WrappedInitialContext.this.ctx.lookup(name));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Object lookupLink(Name arg0) throws NamingException {
        try {
            final Name name = arg0;
            return Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    Object result = WrappedInitialContext.this.ctx.lookupLink(name);
                    return WrappedInitialContext.this.checkResult(result);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Object lookupLink(String arg0) throws NamingException {
        try {
            final String name = arg0;
            return Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    Object result = WrappedInitialContext.this.ctx.lookupLink(name);
                    return WrappedInitialContext.this.checkResult(result);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void rebind(Name arg0, Object arg1) throws NamingException {
        try {
            final Name name1 = arg0;
            final Object name2 = arg1;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.rebind(name1, name2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void rebind(String arg0, Object arg1) throws NamingException {
        try {
            final String name1 = arg0;
            final Object name2 = arg1;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.rebind(name1, name2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Object removeFromEnvironment(String arg0) throws NamingException {
        try {
            final String name = arg0;
            return Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    Object result = WrappedInitialContext.this.ctx.removeFromEnvironment(name);
                    return WrappedInitialContext.this.checkResult(result);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void rename(Name arg0, Name arg1) throws NamingException {
        try {
            final Name name1 = arg0;
            final Name name2 = arg1;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.rename(name1, name2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void rename(String arg0, String arg1) throws NamingException {
        try {
            final String name1 = arg0;
            final String name2 = arg1;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.rename(name1, name2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void unbind(Name arg0) throws NamingException {
        try {
            final Name name = arg0;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.unbind(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public void unbind(String arg0) throws NamingException {
        try {
            final String name = arg0;
            Security.runAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    WrappedInitialContext.this.ctx.unbind(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WrappedInitialContextFactory.convertException(pae);
        }
    }

    private Object checkResult(Object result) throws OperationNotSupportedException {
        if (result != null && result instanceof Context) {
            result = new WrappedInitialContext((Context)result, this.subject, this.env);
        } else if (result != null && result instanceof JMSConnectionFactory) {
            JMSConnectionFactory cf = (JMSConnectionFactory)result;
            cf.setRA(true);
            cf.setSubject(this.subject);
            cf.setJNDIEnv(this.env);
        }
        return result;
    }
}

