/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.Subject;
import weblogic.deployment.jms.ForeignJMSServerAware;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.WLInitialContextFactory;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSOBSHelper;
import weblogic.jms.common.WrappedDestinationImpl;
import weblogic.kernel.KernelStatus;
import weblogic.security.Security;

public class WLInitialContext
implements Context {
    private Context ctx;
    private Subject subject;
    private Hashtable<?, ?> env;
    private static boolean isInstallClient;

    WLInitialContext(Context ctx, Subject subject, Hashtable<?, ?> env) {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("WLInitialContext:constructor ctx=" + ctx + ", subject=" + subject + ", env=" + JMSOBSHelper.filterProperties(env));
        }
        this.ctx = ctx;
        this.subject = subject;
        this.env = env;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("WLInitialContext:lookup name=" + name + ", ctx=" + this.ctx + ", subject=" + this.subject);
        }
        try {
            final String jndiName = name;
            return Security.runAs(this.subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws NamingException {
                    return WLInitialContext.this.checkResult(WLInitialContext.this.ctx.lookup(jndiName));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WLInitialContextFactory.convertException(pae);
        }
    }

    private Object checkResult(Object result) throws OperationNotSupportedException {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("WLInitialContext:checkResult result=" + result + ", result.getClass()=" + result.getClass().getName());
        }
        if (result instanceof ForeignJMSServerAware && ((ForeignJMSServerAware)result).isReferencedByFS()) {
            throw new OperationNotSupportedException(JMSClientExceptionLogger.logInvalidLookupForForeignServer());
        }
        if (result instanceof Context) {
            return new WLInitialContext((Context)result, this.subject, this.env);
        }
        if (result instanceof JMSConnectionFactory) {
            JMSConnectionFactory cf = (JMSConnectionFactory)result;
            cf.setOBSIC(true);
            cf.setSubject(this.subject);
            cf.setJNDIEnv(this.env);
            return cf;
        }
        if (result instanceof WrappedDestinationImpl || result instanceof DestinationImpl) {
            return result;
        }
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logInvalidLookupTypeLoggable(result.getClass().getName()).getMessage());
    }

    @Override
    public void close() throws NamingException {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("WLInitialContext:close ctx=" + this.ctx + ", subject=" + this.subject);
        }
        try {
            Security.runAs(this.subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws NamingException {
                    WLInitialContext.this.ctx.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw WLInitialContextFactory.convertException(pae);
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("lookup(Name name)").getMessage());
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("bind(Name name, Object obj)").getMessage());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("bind(String name, Object obj)").getMessage());
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("rebind(Name name, Object obj)").getMessage());
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("rebind(String name, Object obj)").getMessage());
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("unbind(Name name)").getMessage());
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("unbind(String name)").getMessage());
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("rename(Name oldName, Name newName)").getMessage());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("rename(String oldName, String newName)").getMessage());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("list(Name name)").getMessage());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (JMSDebug.JMSOBS.isDebugEnabled()) {
            JMSDebug.JMSOBS.debug("WLInitialContext:list name=" + name + ", ctx=" + this.ctx + ", subject=" + this.subject + ", KernelStatus.isServer()=" + KernelStatus.isServer() + ", isInstallClient=" + isInstallClient);
        }
        if (KernelStatus.isServer() || isInstallClient) {
            try {
                final String jndiName = name;
                return (NamingEnumeration)Security.runAs(this.subject, new PrivilegedExceptionAction<NamingEnumeration<NameClassPair>>(){

                    @Override
                    public NamingEnumeration<NameClassPair> run() throws NamingException {
                        return WLInitialContext.this.ctx.list(jndiName);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw WLInitialContextFactory.convertException(pae);
            }
        }
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logRestrictedAPILoggable("list(String name)").getMessage());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("listBindings(Name name)").getMessage());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("listBindings(String name)").getMessage());
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("destroySubcontext(Name name)").getMessage());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("destroySubcontext(String name)").getMessage());
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("createSubcontext(Name name)").getMessage());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("createSubcontext(String name)").getMessage());
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("lookupLink(Name name)").getMessage());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("lookupLink(String name)").getMessage());
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("getNameParser(Name name)").getMessage());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("getNameParser(String name)").getMessage());
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("composeName(Name name, Name prefix)").getMessage());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("composeName(String name, Name prefix)").getMessage());
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("addToEnvironment(String propName, Object propVal)").getMessage());
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("removeFromEnvironment(String propName)").getMessage());
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("getEnvironment()").getMessage());
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException(JMSClientExceptionLogger.logUnsupportedAPILoggable("getNameInNamespace()").getMessage());
    }

    static {
        if (KernelStatus.isServer()) {
            isInstallClient = false;
        } else {
            try {
                Class.forName("weblogic.rmi.cluster.ClusterableRemoteObject");
                isInstallClient = true;
            }
            catch (ClassNotFoundException cnfe) {
                isInstallClient = false;
            }
        }
    }
}

