/*
 * Decompiled with CFR 0.152.
 */
package weblogic.invocation;

import java.security.Principal;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextChangeListener;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;

class ReadOnlyComponentInvocationContextManager
extends ComponentInvocationContextManager {
    private ComponentInvocationContextManager cicm;
    private SecurityException se;

    ReadOnlyComponentInvocationContextManager(ComponentInvocationContextManager cicm) {
        this.cicm = cicm;
        this.se = new SecurityException("No subject provided during ComponentInvocationContextManager creation");
    }

    ReadOnlyComponentInvocationContextManager(ComponentInvocationContextManager cicm, SecurityException se) {
        this.cicm = cicm;
        this.se = se;
    }

    @Override
    public ComponentInvocationContext getCurrentComponentInvocationContext() {
        return this.cicm.getCurrentComponentInvocationContext();
    }

    @Override
    public ComponentInvocationContext createComponentInvocationContext(String applicationId, String moduleName, String componentName) {
        return this.cicm.createComponentInvocationContext(applicationId, moduleName, componentName);
    }

    @Override
    public ComponentInvocationContext createComponentInvocationContext(String partitionName, String applicationName, String applicationVersion, String moduleName, String componentName) {
        return this.cicm.createComponentInvocationContext(partitionName, applicationName, applicationVersion, moduleName, componentName);
    }

    @Override
    public void addInvocationContextChangeListener(ComponentInvocationContextChangeListener ic) {
        this.cicm.addInvocationContextChangeListener(ic);
    }

    @Override
    public void removeInvocationContextChangeListener(ComponentInvocationContextChangeListener ic) {
        this.cicm.removeInvocationContextChangeListener(ic);
    }

    @Override
    protected void checkIfKernel(Principal sub) {
        assert (false);
    }

    @Override
    public void pushComponentInvocationContext(ComponentInvocationContext ci) {
        ReadOnlyComponentInvocationContextManager.warnUnsecureCallers();
        this.cicm.pushComponentInvocationContext(ci);
    }

    @Override
    public void popComponentInvocationContext() {
        ReadOnlyComponentInvocationContextManager.warnUnsecureCallers();
        this.cicm.popComponentInvocationContext();
    }

    @Override
    public ManagedInvocationContext setCurrentComponentInvocationContext(ComponentInvocationContext cic) {
        ReadOnlyComponentInvocationContextManager.warnUnsecureCallers();
        return this.cicm.setCurrentComponentInvocationContext(cic);
    }
}

